/*
 * Decompiled with CFR 0.152.
 */
package popometer.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import popometer.FrmNavigator;
import popometer.YPopometerSession;
import popometer.bikeandfit.Einstellrad;
import popometer.bikeandfit.HSVWert;
import popometer.bikeandfit.Koerperberechnung;
import popometer.bikeandfit.Koerpermasse;
import popometer.bikeandfit.MagischesDreieck;
import popometer.bikeandfit.Parameter;
import popometer.bikeandfit.Treffer;
import popometer.bikeandfit.Trefferliste;
import popometer.dbobjects.YROKunde;
import popometer.forms.DlgFotos;
import popometer.graphics.Messpunkt;
import popometer.panels.PanBikeAndFitImage;
import popometer.panels.PanFotoImage;
import popometer.panels.PanMessung;
import projektY.base.YException;
import projektY.base.YUnimplementedException;
import projektY.base.YUserException;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDBOChangeEventListener;
import projektY.database.YDetailList;
import projektY.database.YRowObjectList;
import projektY.database.YRowValues;
import projektY.database.YSubRowList;
import projektY.swing.YJPanelManager;
import projektY.utils.YConfigFile;

public class PanKoerper
extends PanMessung {
    private File fotoCmdFile;
    private File fotoImageFile;
    private BufferedImage imgFoto;
    private VerwalteteParameter parameter;
    private AngezeigteKoerpermasse koerpermasse;
    private Image defaultImage;
    private PanFotoImage panFotoImage;
    private Koerperberechnung koerperberechnung;
    private DlgFotos dlgFotos;
    private JFileChooser openJpegDialog;
    private Point messbereichstart;
    private Point messbereichend;
    private YDetailList kundeneinsbed;
    private final int einsbereichIdSitzknochen;
    private ButtonGroup bgBlickrichtung;
    private ButtonGroup bgDreieckAnzeige;
    private ButtonGroup bgEinstellradAnzeige;
    private ButtonGroup bgMesspunktsuche;
    private JCheckBox cbHoehenmasse;
    private JComboBox cmbProfilSpeichern;
    private JComboBox cmbProfilVerwenden;
    private JButton cmdBFCRMUmrechnung;
    private JButton cmdBeispielbild;
    private JButton cmdDreieckBerechnen;
    private JButton cmdDreieckZuRad;
    private JButton cmdFotoSchiessen;
    private JButton cmdKalibrierungSpeichern;
    private JButton cmdKalibrierungWiederherstellen;
    private JButton cmdLetzteFotos;
    private JButton cmdMagischesDreieck;
    private JButton cmdMesspunktParameterSpeichern;
    private JButton cmdMesspunktParameterWiederherstellen;
    private JButton cmdMesspunktsuche;
    private JButton cmdMesspunktsuche2;
    private JButton cmdRadZuDreieck;
    private JTextField fldAbstandKalibrierungspunkte;
    private JTextField fldAbstandLenksaeule;
    private JTextField fldBminKorona;
    private JTextField fldDreieckHinten;
    private JTextField fldDreieckOben;
    private JTextField fldDreieckVorn;
    private JTextField fldDreieckWinkel;
    private JTextField fldEllenbogenhoehe;
    private JTextField fldHandhoehe;
    private JTextField fldHmaxKorona;
    private JTextField fldHminKorona;
    private JTextField fldHueftabstand;
    private JTextField fldHuefthoehe;
    private JTextField fldKniehoehe;
    public JTextField fldLOberarm;
    public JTextField fldLOberkoerper;
    public JTextField fldLOberschenkel;
    public JTextField fldLUnterarm;
    public JTextField fldLUnterschenkel;
    private JTextField fldLenkerhoehe;
    private JTextField fldLenkerversatz;
    private JTextField fldOffsetFussX;
    private JTextField fldOffsetFussY;
    private JTextField fldOffsetHandX;
    private JTextField fldOffsetHandY;
    private JTextField fldOffsetHuefteX;
    private JTextField fldOffsetHuefteY;
    private JTextField fldPedallaenge;
    private JTextField fldRahmenwinkel;
    private JTextField fldRmaxAussen;
    private JTextField fldRminInnen;
    private JTextField fldSchulterh\u00f6ehe;
    private JTextField fldSitzhoehe;
    private JTextField fldSitzversatz;
    private JTextField fldSminKorona;
    private JTextField fldVminInnen;
    private JTextField fldVminKorona;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel31;
    private JLabel jLabel32;
    private JLabel jLabel34;
    private JLabel jLabel35;
    private JLabel jLabel36;
    private JLabel jLabel37;
    private JLabel jLabel38;
    private JLabel jLabel39;
    private JLabel jLabel4;
    private JLabel jLabel41;
    private JLabel jLabel42;
    private JLabel jLabel43;
    private JLabel jLabel44;
    private JLabel jLabel45;
    private JLabel jLabel46;
    private JLabel jLabel47;
    private JLabel jLabel48;
    private JLabel jLabel49;
    private JLabel jLabel5;
    private JLabel jLabel50;
    private JLabel jLabel51;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel lblDreieck;
    public JLabel lblDreieckHinten;
    public JLabel lblDreieckOben;
    public JLabel lblDreieckVorn;
    public JLabel lblDreieckWinkel;
    private JLabel lblEinstellrad;
    private JLabel lblFehlermeldung;
    private JLabel lblGrad;
    private JLabel lblLenkerhoehe;
    private JLabel lblLenkerversatz;
    private JLabel lblProblem;
    public JLabel lblRahmenwinkel;
    private JLabel lblSitzhoehe;
    public JLabel lblSitzposition;
    private JLabel lblSitzversatz;
    private JLabel lblStatus;
    private JLabel lblStatusmeldung;
    private JPanel panBFStatus;
    private JPanel panDreieck;
    private JPanel panDreieckAnzeige;
    private JPanel panDreieckInnen;
    private JPanel panEinstellrad;
    private JPanel panEinstellradAnzeige;
    private JPanel panEinstellradInnen;
    private JPanel panFotoSchiessen;
    private JPanel panGeometrie;
    private JPanel panHoehenmasse;
    private JPanel panInnenpunkt;
    private JPanel panKalibrierung;
    private JPanel panKalibrierungHFill;
    private JPanel panKalibrierungSpeichern;
    private JPanel panKalibrierungVFill;
    private JPanel panKoerperMasse;
    private JPanel panKoerpermasse;
    private JPanel panKoronapunkt;
    private JPanel panMesspunkte;
    private JPanel panMesspunkteHFill;
    private JPanel panMesspunkteSpeichern;
    private JPanel panMesspunkteVFill;
    private JPanel panMesspunktsuche;
    private JPanel panMessung;
    private JPanel panMessungFueller;
    private JPanel panMldgProblem;
    private JPanel panMldgSitzposition;
    private JPanel panMldgStatus;
    private JRadioButton rbBlickLinks;
    private JRadioButton rbBlickRechts;
    private JRadioButton rbDreieckAbgelesen;
    private JRadioButton rbDreieckBerechnet;
    private JRadioButton rbEinstellradAbgelesen;
    private JRadioButton rbEinstellradBerechnet;
    private JRadioButton rbManuell;
    private JRadioButton rbNurFahrrad;
    private JRadioButton rbVollautomatisch;
    private JScrollPane scrlImage;
    private JScrollPane scrlMessung;
    private JTabbedPane tabBikeAndFit;
    private JTabbedPane tabEinrichtung;

    public PanKoerper(YPopometerSession session, YROKunde kunde, FrmNavigator frmNavigator) throws YException {
        super(session, kunde, frmNavigator);
        this.parameter = new VerwalteteParameter(session.getConfigFile());
        this.koerperberechnung = new Koerperberechnung(this.parameter);
        this.dlgFotos = null;
        this.panFotoImage = new PanBikeAndFitImage(this.koerperberechnung);
        this.panFotoImage.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PanKoerper.this.fotoMouseClicked(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                PanKoerper.this.fotoMousePressed(e);
            }
        });
        this.panFotoImage.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                PanKoerper.this.fotoMouseDragged(e);
            }
        });
        this.initComponents();
        this.parameter.setInput();
        this.koerpermasse = new AngezeigteKoerpermasse();
        YJPanelManager.createPanelManager(this.panKoerperMasse, kunde);
        this.fotoCmdFile = session.createFotoCmd();
        this.fotoImageFile = session.createBodyImage();
        this.defaultImage = Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("/popometer/pictures/fotobeispiel.jpeg"));
        this.changePicture(this.defaultImage);
        this.lblStatusmeldung.setText(BfStatus.BFSTATUS_BEREIT.toString());
        this.setFehlermeldung("");
        YRowObjectList einsatzbereiche = session.getRowObjectList("vs_einsatzbereiche");
        int iRow = einsatzbereiche.find("sitzknochenabstand", "messgroesse_teilbereich");
        if (iRow < 0) {
            iRow = einsatzbereiche.find("_sitzknochenabstand", "messgroesse_teilbereich");
        }
        if (iRow < 0) {
            throw new YException("Kein Einsatzteilbereich 'sitzknochenabstand' oder '_sitzknochenabstand'");
        }
        this.kundeneinsbed = kunde.getDetailList("vh_kundeneinsbed");
        this.einsbereichIdSitzknochen = einsatzbereiche.getAsInt(iRow, "einsbereich_id");
        this.panHoehenmasse.setVisible(session.getConfigFile().getEntry("HOEHENMASSE", "N").equals("J"));
        kunde.addChangeEventListener(new YDBOChangeEventListener(){

            @Override
            public void DBObjectChanged(YDBOChangeEvent evt) throws YException {
                if (evt.getType() == YDBOChangeEvent.ChangeEventType.UPDATE) {
                    PanKoerper.this.kundeUpdateEvent();
                }
            }
        });
    }

    private void kundeUpdateEvent() throws YException {
        if (this.kunde.getFieldValue("l_oberarm").isNull() || this.kunde.getFieldValue("l_unterarm").isNull() || this.kunde.getFieldValue("l_oberkoerper").isNull() || this.kunde.getFieldValue("l_oberschenkel").isNull() || this.kunde.getFieldValue("l_unterschenkel").isNull()) {
            this.cmdDreieckBerechnen.setEnabled(false);
        } else {
            this.cmdDreieckBerechnen.setEnabled(true);
        }
    }

    public void fotoMousePressed(MouseEvent e) {
        if (this.koerperberechnung.messpunkte.fotoMousePressed(e)) {
            this.panFotoImage.repaint();
        }
    }

    public void fotoMouseDragged(MouseEvent e) {
        if (this.koerperberechnung.messpunkte.fotoMouseDragged(e)) {
            this.panFotoImage.repaint();
        }
    }

    public void fotoMouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            Dimension offset = new Dimension();
            Messpunkt messpunkt = this.koerperberechnung.messpunkte.findeMesspunkt(offset, e);
            if (messpunkt == null) {
                return;
            }
            this.parameter.getFromInput();
            this.checkPixel(messpunkt.x, messpunkt.y, this.parameter, null, true);
            return;
        }
        boolean repaint = this.koerperberechnung.messpunkte.fotoMouseClicked(e);
        if (this.koerperberechnung.messpunkte.messpunktVerschoben) {
            this.koerperberechnung.messpunkte.messpunktVerschoben = false;
            try {
                StringBuffer fehler = new StringBuffer();
                BfStatus status = this.bikeAndFit(BfStart.BFSTART_BENENNEN, fehler);
                this.lblStatusmeldung.setText(status.toString());
                this.setFehlermeldung(fehler.toString());
            }
            catch (YException ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Fehler", 0);
            }
        }
        if (repaint) {
            this.panFotoImage.repaint();
        }
    }

    private void setFehlermeldung(String text) {
        this.lblFehlermeldung.setText(text);
        this.lblProblem.setVisible(text.length() > 0);
    }

    private boolean turboCheckPixel(int x, int y, Parameter parameter) {
        return true;
    }

    private boolean checkPixel(int mpX, int mpY, Parameter parameter, Treffer treffer, boolean dbglog) {
        int x = mpX;
        int y = mpY;
        int nDddVS0 = 0;
        int r = 0;
        int d = 0;
        int maxHKorona = parameter.maxHKorona < parameter.minHKorona ? parameter.maxHKorona + 360 : parameter.maxHKorona;
        HSVWert hsvRing0 = new HSVWert(parameter.minHKorona, maxHKorona);
        HSVWert hsvRing = new HSVWert(parameter.minHKorona, maxHKorona);
        int[] eH = new int[parameter.maxRAussen + 1];
        int[] eS = new int[parameter.maxRAussen + 1];
        int minHKorona = hsvRing.addCorr0(parameter.minHKorona);
        maxHKorona = hsvRing.addCorr0(maxHKorona);
        int[] eDdVS = new int[parameter.maxRAussen + 1];
        int[] eDddVS = new int[parameter.maxRAussen + 1];
        int iDddVSMin = -1;
        int rgb = this.imgFoto.getRGB(x, y);
        hsvRing0.setAsRGB(rgb);
        int ddVS0 = 0;
        eDddVS[0] = 0;
        eDddVS[1] = 0;
        int dddVSMin = 0;
        if (hsvRing0.getVAs256() < parameter.minVInnen) {
            return false;
        }
        eS[0] = hsvRing0.getS255();
        try {
            for (r = 1; r <= parameter.maxRAussen; ++r) {
                int ddVS;
                d = -r;
                x = r;
                y = 0;
                while (y <= x) {
                    hsvRing.addRGB(this.imgFoto.getRGB(mpX + x, mpY + y));
                    hsvRing.addRGB(this.imgFoto.getRGB(mpX + y, mpY + x));
                    if (x != 0) {
                        hsvRing.addRGB(this.imgFoto.getRGB(mpX - x, mpY + y));
                        hsvRing.addRGB(this.imgFoto.getRGB(mpX + y, mpY - x));
                    }
                    if (x != y) {
                        if (y != 0) {
                            hsvRing.addRGB(this.imgFoto.getRGB(mpX + x, mpY - y));
                            hsvRing.addRGB(this.imgFoto.getRGB(mpX - y, mpY + x));
                        }
                        if (x != 0 && y != 0) {
                            hsvRing.addRGB(this.imgFoto.getRGB(mpX - x, mpY - y));
                            hsvRing.addRGB(this.imgFoto.getRGB(mpX - y, mpY - x));
                        }
                    }
                    if ((d += 2 * ++y + 1) <= 0) continue;
                    d -= 2 * x + 2;
                    --x;
                }
                hsvRing.calcFromRGBSums();
                int dVS0 = hsvRing0.getV() - hsvRing0.getS();
                int dVS = hsvRing.getV() - hsvRing.getS();
                eDdVS[r] = ddVS = dVS - dVS0;
                eH[r] = hsvRing.getHAs1024();
                eS[r] = hsvRing.getS255();
                if (r > 1) {
                    int dddVS;
                    eDddVS[r] = dddVS = ddVS - ddVS0;
                    if (eDddVS[r] < dddVSMin) {
                        dddVSMin = eDddVS[r];
                        iDddVSMin = r;
                    }
                    if (ddVS >= 0) break;
                    if (dddVS == 0) {
                        if (++nDddVS0 > 2) {
                            return false;
                        }
                    } else {
                        nDddVS0 = 0;
                    }
                }
                if (ddVS > 0 && r > parameter.minRInnen) {
                    return false;
                }
                if (iDddVSMin < 0 ? hsvRing.getVAs256() < parameter.minVInnen : hsvRing.getVAs256() < parameter.minVKorona) {
                    return false;
                }
                ddVS0 = ddVS;
                hsvRing0.assign(hsvRing);
            }
            if (r > parameter.maxRAussen) {
                --r;
            }
            if (iDddVSMin < parameter.minRInnen) {
                return false;
            }
            int bKorona = r - iDddVSMin + 1;
            if (bKorona < parameter.minBKorona) {
                return false;
            }
            if (iDddVSMin > 2) {
                if (eDdVS[iDddVSMin + 1] > eDdVS[iDddVSMin + 2]) {
                    return false;
                }
                if (eDdVS[iDddVSMin - 1] > eDdVS[iDddVSMin - 2]) {
                    return false;
                }
            }
            int sSK = 0;
            for (d = iDddVSMin; d <= r; ++d) {
                sSK += eS[d];
            }
            if ((sSK /= bKorona) < parameter.minSKorona) {
                return false;
            }
            int sH = 0;
            for (d = iDddVSMin; d <= r; ++d) {
                sH += eH[d];
            }
            if ((sH = (int)Math.round((double)(sH / bKorona) * 359.0 / 1024.0)) < minHKorona || sH > maxHKorona) {
                return false;
            }
            treffer.set(mpX, mpY, iDddVSMin);
            return true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (dbglog) {
                System.out.printf("%s: mpX=%d, mpY=%d, x=%d, y=%d, r=%d, d=%d\n", e.toString(), mpX, mpY, x, y, r, d);
            }
            return false;
        }
    }

    private int messpunktsuche(boolean dbglog) {
        Treffer treffer = new Treffer();
        Trefferliste trefferListe = new Trefferliste();
        int rand = this.parameter.maxRAussen + 1;
        this.parameter.getFromInput();
        int sizeX = this.imgFoto.getWidth() - rand;
        int sizeY = this.imgFoto.getHeight() - rand;
        if (dbglog) {
            System.out.printf("Bildgr\u00f6\u00dfe: %d x %d\n", this.imgFoto.getWidth(), this.imgFoto.getHeight());
        }
        for (int x = rand; x < sizeX; ++x) {
            for (int y = rand; y < sizeY; ++y) {
                if (!this.checkPixel(x, y, this.parameter, treffer, dbglog)) continue;
                if (dbglog) {
                    System.out.printf("Gefunden: x=%d, y=%d\n", x, y);
                }
                trefferListe.add(treffer);
            }
        }
        this.koerperberechnung.messpunkte.resetAktiv();
        this.koerperberechnung.koerperpunkte.abgeleitet = false;
        this.koerperberechnung.messpunkte.init();
        int i = this.koerperberechnung.messpunkte.get().size();
        for (int it = 0; it < trefferListe.getCount() && --i >= 0; ++it) {
            Messpunkt m = this.koerperberechnung.messpunkte.get(i);
            treffer = trefferListe.getTreffer(it);
            m.move(treffer.getX(), treffer.getY());
        }
        this.panFotoImage.repaint();
        return trefferListe.getCount();
    }

    private int findPosNrSitzhaltung(StringBuffer bezSitzhaltung) throws YException {
        this.kunde.requestValuesToStore();
        YRowValues rvKundeneinsbed = this.kundeneinsbed.findRow(String.valueOf(this.einsbereichIdSitzknochen), "einsbereich_id");
        if (rvKundeneinsbed == null) {
            return 0;
        }
        String strEinsbedingungId = rvKundeneinsbed.getAsString("einsbedingung_id");
        YSubRowList srlEinsatzbedingungen = (YSubRowList)this.session.getRowObjectList("vs_einsatzbereiche").getSubRowList("einsatzbedingungen");
        YRowValues rvEinsatzbedingung = srlEinsatzbedingungen.findRow(strEinsbedingungId, "einsbedingung_id");
        if (rvEinsatzbedingung == null) {
            throw new YException("Nicht existierende Einsatzbedingung id=" + strEinsbedingungId);
        }
        bezSitzhaltung.setLength(0);
        bezSitzhaltung.append(rvEinsatzbedingung.getAsString("bezeichnung"));
        int i = bezSitzhaltung.lastIndexOf("cm ");
        if (i >= 0) {
            bezSitzhaltung.replace(0, i + 3, "");
        }
        return rvEinsatzbedingung.getAsInt("pos_nr");
    }

    private void berechneDreieck() {
        StringBuffer fehler = new StringBuffer();
        try {
            BfStatus status = this.bikeAndFit(BfStart.BFSTART_DREIECK, fehler);
            this.lblStatusmeldung.setText(status.toString());
        }
        catch (YException e) {
            fehler.append(e.toString());
        }
        this.setFehlermeldung(fehler.toString());
    }

    private void loescheMasse(boolean alleMasse) {
        if (alleMasse) {
            this.fldLOberarm.setText("");
            this.fldLOberkoerper.setText("");
            this.fldLOberschenkel.setText("");
            this.fldLUnterarm.setText("");
            this.fldLUnterschenkel.setText("");
            this.cmdDreieckBerechnen.setEnabled(false);
        }
        this.rbDreieckAbgelesen.setSelected(true);
        this.rbDreieckAbgelesenActionPerformed(null);
        this.rbDreieckBerechnet.setEnabled(false);
        this.lblRahmenwinkel.setVisible(false);
        this.lblSitzversatz.setVisible(false);
        this.lblSitzhoehe.setVisible(false);
        this.lblLenkerversatz.setVisible(false);
        this.lblLenkerhoehe.setVisible(false);
        this.panMldgSitzposition.setVisible(false);
        this.cmdMagischesDreieck.setEnabled(false);
    }

    private void zeigeDreieck(MagischesDreieck magischesDreieck) {
        this.lblDreieckOben.setText(String.format("%2.1f", magischesDreieck.getOben()));
        this.fldDreieckOben.setText(String.format("%2.1f", magischesDreieck.getOben()));
        this.lblDreieckHinten.setText(String.format("%2.1f", magischesDreieck.getHinten()));
        this.fldDreieckHinten.setText(String.format("%2.1f", magischesDreieck.getHinten()));
        this.lblDreieckVorn.setText(String.format("%2.1f", magischesDreieck.getVorn()));
        this.fldDreieckVorn.setText(String.format("%2.1f", magischesDreieck.getVorn()));
        this.lblDreieckWinkel.setText(String.format("%2.1f", magischesDreieck.getNeigungswinkel()));
        this.fldDreieckWinkel.setText(String.format("%2.1f", magischesDreieck.getNeigungswinkel()));
        this.lblRahmenwinkel.setText(String.format("%2.1f\u00b0", magischesDreieck.getRahmenwinkel()));
        this.rbDreieckBerechnet.setEnabled(true);
        this.rbDreieckBerechnet.setSelected(true);
        this.rbDreieckAbgelesenActionPerformed(null);
    }

    private void zeigeEinstellrad(Einstellrad einstellrad) {
        this.lblSitzhoehe.setText(String.format("%2.1f", einstellrad.getSitzhoehe()));
        this.fldSitzhoehe.setText(String.format("%2.1f", einstellrad.getSitzhoehe()));
        this.lblSitzversatz.setText(String.format("%2.1f", einstellrad.getSitzversatz()));
        this.fldSitzversatz.setText(String.format("%2.1f", einstellrad.getSitzversatz()));
        this.lblLenkerhoehe.setText(String.format("%2.1f", einstellrad.getLenkerhoehe()));
        this.fldLenkerhoehe.setText(String.format("%2.1f", einstellrad.getLenkerhoehe()));
        this.lblLenkerversatz.setText(String.format("%+2.1f", einstellrad.getLenkerversatz()));
        this.fldLenkerversatz.setText(String.format("%+2.1f", einstellrad.getLenkerversatz()));
        this.lblLenkerversatz.setVisible(true);
        this.rbEinstellradBerechnet.setEnabled(true);
        this.rbEinstellradBerechnet.setSelected(true);
        this.rbEinstellradAbgelesenActionPerformed(null);
    }

    private BfStatus bikeAndFit(BfStart startPunkt, StringBuffer fehler) throws YException {
        fehler.setLength(0);
        switch (startPunkt) {
            case BFSTART_SUCHE: {
                this.loescheMasse(true);
                int nGefunden = this.messpunktsuche(true);
                int nGesucht = this.rbNurFahrrad.isSelected() ? 5 : 8;
                switch (nGefunden) {
                    case 8: {
                        break;
                    }
                    case 5: {
                        if (nGesucht == 5) {
                            return BfStatus.BFSTATUS_GEFUNDEN;
                        }
                    }
                    default: {
                        fehler.append(String.format("%d statt %d Me\u00dfpunkte gefunden", nGefunden, nGesucht));
                        return nGefunden > 0 ? BfStatus.BFSTATUS_GEFUNDEN : BfStatus.BFSTATUS_BEREIT;
                    }
                }
            }
            case BFSTART_BENENNEN: {
                if (startPunkt == BfStart.BFSTART_BENENNEN) {
                    this.loescheMasse(true);
                }
                if (!this.koerperberechnung.messpunkte.benennen8(this.parameter.blickrichtungRechts)) {
                    this.koerperberechnung.koerperpunkte.abgeleitet = false;
                    this.panFotoImage.repaint();
                    fehler.append("Unklare Me\u00dfpunktverteilung");
                    return BfStatus.BFSTATUS_GEFUNDEN;
                }
                this.koerperberechnung.kalibrieren();
                this.koerperberechnung.koerperpunkteAbleiten();
                this.panFotoImage.repaint();
                this.koerpermasse.set(this.koerperberechnung.berechneKoerpermasse());
                if (this.koerpermasse.absurd()) {
                    this.koerperberechnung.koerperpunkte.abgeleitet = false;
                    this.panFotoImage.repaint();
                    fehler.append("Absurde K\u00f6rperma\u00dfe");
                    return BfStatus.BFSTATUS_GEFUNDEN;
                }
                this.koerpermasse.setInput();
            }
            case BFSTART_DREIECK: {
                StringBuffer bezSitzhaltung;
                int winkelsatzId;
                if (startPunkt == BfStart.BFSTART_DREIECK) {
                    this.loescheMasse(false);
                    if (!this.koerpermasse.getInput()) {
                        fehler.append("K\u00f6rperma\u00dfe unvollst\u00e4ndig");
                        return BfStatus.BFSTATUS_BEREIT;
                    }
                }
                if ((winkelsatzId = this.findPosNrSitzhaltung(bezSitzhaltung = new StringBuffer(40))) == 0) {
                    fehler.append("Sitzposition nicht eingegeben");
                    return BfStatus.BFSTATUS_KOERPER_BERECHNET;
                }
                MagischesDreieck magischesDreieck = this.koerperberechnung.magischesDreieck;
                magischesDreieck.berechnen(winkelsatzId, this.koerpermasse);
                this.zeigeDreieck(magischesDreieck);
                Einstellrad einstellrad = this.koerperberechnung.einstellrad;
                einstellrad.berechnen(magischesDreieck);
                this.zeigeEinstellrad(einstellrad);
                this.cmdMagischesDreieck.setEnabled(true);
                this.lblSitzposition.setText(bezSitzhaltung.toString());
                this.panMldgSitzposition.setVisible(true);
                return BfStatus.BFSTATUS_DREIECK_BERECHNET;
            }
        }
        return BfStatus.BFSTATUS_NULL;
    }

    @Override
    protected void neuerKunde() throws YException {
        this.changePicture(this.defaultImage);
        this.lblStatusmeldung.setText(BfStatus.BFSTATUS_BEREIT.toString());
        this.setFehlermeldung("");
    }

    private void initComponents() {
        this.bgMesspunktsuche = new ButtonGroup();
        this.bgBlickrichtung = new ButtonGroup();
        this.bgDreieckAnzeige = new ButtonGroup();
        this.bgEinstellradAnzeige = new ButtonGroup();
        this.scrlImage = new JScrollPane();
        this.scrlImage.setViewportView(this.panFotoImage);
        this.scrlMessung = new JScrollPane();
        this.tabBikeAndFit = new JTabbedPane();
        this.panMessung = new JPanel();
        this.panKoerperMasse = new JPanel();
        this.panKoerpermasse = new JPanel();
        this.jLabel2 = new JLabel();
        this.fldLUnterarm = new JTextField();
        this.jLabel3 = new JLabel();
        this.fldLOberarm = new JTextField();
        this.jLabel4 = new JLabel();
        this.fldLOberkoerper = new JTextField();
        this.jLabel5 = new JLabel();
        this.fldLOberschenkel = new JTextField();
        this.jLabel6 = new JLabel();
        this.fldLUnterschenkel = new JTextField();
        this.jPanel2 = new JPanel();
        this.panHoehenmasse = new JPanel();
        this.jLabel36 = new JLabel();
        this.fldSchulterh\u00f6ehe = new JTextField();
        this.jLabel37 = new JLabel();
        this.fldEllenbogenhoehe = new JTextField();
        this.jLabel35 = new JLabel();
        this.fldHuefthoehe = new JTextField();
        this.jLabel38 = new JLabel();
        this.fldHandhoehe = new JTextField();
        this.jLabel39 = new JLabel();
        this.fldKniehoehe = new JTextField();
        this.cmdBFCRMUmrechnung = new JButton();
        this.panEinstellrad = new JPanel();
        this.panEinstellradInnen = new JPanel();
        this.lblLenkerversatz = new JLabel();
        this.lblLenkerversatz.setVisible(false);
        this.fldLenkerversatz = new JTextField();
        this.lblLenkerhoehe = new JLabel();
        this.lblLenkerhoehe.setVisible(false);
        this.fldLenkerhoehe = new JTextField();
        this.lblSitzhoehe = new JLabel();
        this.lblSitzhoehe.setVisible(false);
        this.fldSitzhoehe = new JTextField();
        this.lblSitzversatz = new JLabel();
        this.lblSitzversatz.setVisible(false);
        this.fldSitzversatz = new JTextField();
        this.lblEinstellrad = new JLabel();
        this.cmdRadZuDreieck = new JButton();
        this.panEinstellradAnzeige = new JPanel();
        this.rbEinstellradAbgelesen = new JRadioButton();
        this.rbEinstellradBerechnet = new JRadioButton();
        this.panDreieck = new JPanel();
        this.panDreieckInnen = new JPanel();
        this.lblDreieckWinkel = new JLabel();
        this.lblDreieckWinkel.setVisible(false);
        this.fldDreieckWinkel = new JTextField();
        this.lblGrad = new JLabel();
        this.lblDreieckOben = new JLabel();
        this.lblDreieckOben.setVisible(false);
        this.fldDreieckOben = new JTextField();
        this.lblDreieckHinten = new JLabel();
        this.lblDreieckHinten.setVisible(false);
        this.fldDreieckHinten = new JTextField();
        this.lblDreieckVorn = new JLabel();
        this.lblDreieckVorn.setVisible(false);
        this.fldDreieckVorn = new JTextField();
        this.lblRahmenwinkel = new JLabel();
        this.lblRahmenwinkel.setVisible(false);
        this.jLabel43 = new JLabel();
        this.jLabel44 = new JLabel();
        this.cmdDreieckZuRad = new JButton();
        this.lblDreieck = new JLabel();
        this.panDreieckAnzeige = new JPanel();
        this.rbDreieckAbgelesen = new JRadioButton();
        this.rbDreieckBerechnet = new JRadioButton();
        this.panFotoSchiessen = new JPanel();
        this.cmdFotoSchiessen = new JButton();
        this.cmdBeispielbild = new JButton();
        this.cmdLetzteFotos = new JButton();
        this.cmbProfilVerwenden = new JComboBox();
        this.jPanel3 = new JPanel();
        this.panBFStatus = new JPanel();
        this.panMldgSitzposition = new JPanel();
        this.jLabel41 = new JLabel();
        this.lblSitzposition = new JLabel();
        this.panMldgStatus = new JPanel();
        this.lblStatus = new JLabel();
        this.lblStatusmeldung = new JLabel();
        this.panMldgProblem = new JPanel();
        this.lblProblem = new JLabel();
        this.lblFehlermeldung = new JLabel();
        this.panMessungFueller = new JPanel();
        this.cmdDreieckBerechnen = new JButton();
        this.jPanel1 = new JPanel();
        this.cmdMagischesDreieck = new JButton();
        this.tabEinrichtung = new JTabbedPane();
        this.panKalibrierung = new JPanel();
        this.cmdMesspunktsuche = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel18 = new JLabel();
        this.fldAbstandKalibrierungspunkte = new JTextField();
        this.fldOffsetHuefteX = new JTextField();
        this.fldOffsetHuefteY = new JTextField();
        this.fldOffsetHandX = new JTextField();
        this.fldOffsetHandY = new JTextField();
        this.jLabel20 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jLabel22 = new JLabel();
        this.jLabel23 = new JLabel();
        this.jLabel24 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jLabel25 = new JLabel();
        this.fldOffsetFussX = new JTextField();
        this.fldOffsetFussY = new JTextField();
        this.panKalibrierungSpeichern = new JPanel();
        this.cmdKalibrierungSpeichern = new JButton();
        this.cmdKalibrierungWiederherstellen = new JButton();
        this.jLabel26 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jLabel28 = new JLabel();
        this.fldHueftabstand = new JTextField();
        this.fldPedallaenge = new JTextField();
        this.jLabel29 = new JLabel();
        this.jLabel31 = new JLabel();
        this.rbBlickLinks = new JRadioButton();
        this.rbBlickRechts = new JRadioButton();
        this.panKalibrierungVFill = new JPanel();
        this.panKalibrierungHFill = new JPanel();
        this.cbHoehenmasse = new JCheckBox();
        this.jLabel49 = new JLabel();
        this.fldRahmenwinkel = new JTextField();
        this.jLabel50 = new JLabel();
        this.jLabel51 = new JLabel();
        this.fldAbstandLenksaeule = new JTextField();
        this.panMesspunkte = new JPanel();
        this.panMesspunktsuche = new JPanel();
        this.rbVollautomatisch = new JRadioButton();
        this.rbNurFahrrad = new JRadioButton();
        this.rbManuell = new JRadioButton();
        this.panMesspunkteSpeichern = new JPanel();
        this.cmdMesspunktParameterSpeichern = new JButton();
        this.cmdMesspunktParameterWiederherstellen = new JButton();
        this.cmdMesspunktsuche2 = new JButton();
        this.panInnenpunkt = new JPanel();
        this.jLabel32 = new JLabel();
        this.fldVminInnen = new JTextField();
        this.panKoronapunkt = new JPanel();
        this.jLabel7 = new JLabel();
        this.fldHminKorona = new JTextField();
        this.jLabel8 = new JLabel();
        this.fldHmaxKorona = new JTextField();
        this.jLabel9 = new JLabel();
        this.fldSminKorona = new JTextField();
        this.jLabel34 = new JLabel();
        this.fldVminKorona = new JTextField();
        this.panGeometrie = new JPanel();
        this.fldBminKorona = new JTextField();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.fldRminInnen = new JTextField();
        this.jLabel12 = new JLabel();
        this.fldRmaxAussen = new JTextField();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel42 = new JLabel();
        this.jLabel45 = new JLabel();
        this.cmbProfilSpeichern = new JComboBox();
        this.jLabel46 = new JLabel();
        this.jLabel47 = new JLabel();
        this.jLabel48 = new JLabel();
        this.panMesspunkteVFill = new JPanel();
        this.panMesspunkteHFill = new JPanel();
        this.setLayout(new BorderLayout());
        this.scrlImage.setBackground(new Color(255, 255, 255));
        this.add((Component)this.scrlImage, "Center");
        this.scrlMessung.setHorizontalScrollBarPolicy(31);
        this.scrlMessung.setVerticalScrollBarPolicy(22);
        this.tabBikeAndFit.setBackground(new Color(238, 238, 238));
        this.panMessung.setBorder(BorderFactory.createTitledBorder("Bike & Fit"));
        this.panMessung.setName("mySpecialPanel");
        this.panMessung.setLayout(new GridBagLayout());
        this.panKoerperMasse.setLayout(new GridBagLayout());
        this.panKoerpermasse.setBorder(BorderFactory.createTitledBorder("K\u00f6rperma\u00dfe [cm]:"));
        this.panKoerpermasse.setLayout(new GridBagLayout());
        this.jLabel2.setLabelFor(this.fldLUnterarm);
        this.jLabel2.setText("Unterarm:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKoerpermasse.add((Component)this.jLabel2, gridBagConstraints);
        this.fldLUnterarm.setHorizontalAlignment(4);
        this.fldLUnterarm.setMinimumSize(new Dimension(80, 19));
        this.fldLUnterarm.setName("l_unterarm");
        this.fldLUnterarm.setPreferredSize(new Dimension(40, 19));
        this.fldLUnterarm.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PanKoerper.this.fldLUnterarmFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        this.panKoerpermasse.add((Component)this.fldLUnterarm, gridBagConstraints);
        this.jLabel3.setLabelFor(this.fldLOberarm);
        this.jLabel3.setText("Oberarm:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.panKoerpermasse.add((Component)this.jLabel3, gridBagConstraints);
        this.fldLOberarm.setHorizontalAlignment(4);
        this.fldLOberarm.setName("l_oberarm");
        this.fldLOberarm.setPreferredSize(new Dimension(40, 19));
        this.fldLOberarm.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PanKoerper.this.fldLOberarmFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 4);
        this.panKoerpermasse.add((Component)this.fldLOberarm, gridBagConstraints);
        this.jLabel4.setLabelFor(this.fldLOberkoerper);
        this.jLabel4.setText("Oberk\u00f6rper+Sitz:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKoerpermasse.add((Component)this.jLabel4, gridBagConstraints);
        this.fldLOberkoerper.setHorizontalAlignment(4);
        this.fldLOberkoerper.setName("l_oberkoerper");
        this.fldLOberkoerper.setPreferredSize(new Dimension(40, 19));
        this.fldLOberkoerper.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PanKoerper.this.fldLOberkoerperFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        this.panKoerpermasse.add((Component)this.fldLOberkoerper, gridBagConstraints);
        this.jLabel5.setLabelFor(this.fldLOberschenkel);
        this.jLabel5.setText("Oberschenkel:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        this.panKoerpermasse.add((Component)this.jLabel5, gridBagConstraints);
        this.fldLOberschenkel.setHorizontalAlignment(4);
        this.fldLOberschenkel.setName("l_oberschenkel");
        this.fldLOberschenkel.setPreferredSize(new Dimension(40, 19));
        this.fldLOberschenkel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PanKoerper.this.fldLOberschenkelFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 4);
        this.panKoerpermasse.add((Component)this.fldLOberschenkel, gridBagConstraints);
        this.jLabel6.setLabelFor(this.fldLUnterschenkel);
        this.jLabel6.setText("Unterschenkel+Ferse:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panKoerpermasse.add((Component)this.jLabel6, gridBagConstraints);
        this.fldLUnterschenkel.setHorizontalAlignment(4);
        this.fldLUnterschenkel.setName("l_unterschenkel");
        this.fldLUnterschenkel.setPreferredSize(new Dimension(40, 19));
        this.fldLUnterschenkel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PanKoerper.this.fldLUnterschenkelFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.panKoerpermasse.add((Component)this.fldLUnterschenkel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panKoerpermasse.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.panKoerperMasse.add((Component)this.panKoerpermasse, gridBagConstraints);
        this.panHoehenmasse.setBorder(BorderFactory.createTitledBorder("H\u00f6henma\u00dfe [cm]: (Nicht erforderlich mit Velometrik-Einstellrad)"));
        this.panHoehenmasse.setLayout(new GridBagLayout());
        this.jLabel36.setText("Schulter:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panHoehenmasse.add((Component)this.jLabel36, gridBagConstraints);
        this.fldSchulterh\u00f6ehe.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.panHoehenmasse.add((Component)this.fldSchulterh\u00f6ehe, gridBagConstraints);
        this.jLabel37.setText("Ellenbogen:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panHoehenmasse.add((Component)this.jLabel37, gridBagConstraints);
        this.fldEllenbogenhoehe.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        this.panHoehenmasse.add((Component)this.fldEllenbogenhoehe, gridBagConstraints);
        this.jLabel35.setText("H\u00fcfte:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panHoehenmasse.add((Component)this.jLabel35, gridBagConstraints);
        this.fldHuefthoehe.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.panHoehenmasse.add((Component)this.fldHuefthoehe, gridBagConstraints);
        this.jLabel38.setText("Hand:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panHoehenmasse.add((Component)this.jLabel38, gridBagConstraints);
        this.fldHandhoehe.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        this.panHoehenmasse.add((Component)this.fldHandhoehe, gridBagConstraints);
        this.jLabel39.setText("Knie:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.panHoehenmasse.add((Component)this.jLabel39, gridBagConstraints);
        this.fldKniehoehe.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panHoehenmasse.add((Component)this.fldKniehoehe, gridBagConstraints);
        this.cmdBFCRMUmrechnung.setFont(new Font("Dialog", 0, 10));
        this.cmdBFCRMUmrechnung.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/rechner.gif")));
        this.cmdBFCRMUmrechnung.setToolTipText("Umrechnen in K\u00f6rperma\u00dfe =>");
        this.cmdBFCRMUmrechnung.setMargin(new Insets(0, 0, 0, 0));
        this.cmdBFCRMUmrechnung.setMaximumSize(new Dimension(28, 28));
        this.cmdBFCRMUmrechnung.setMinimumSize(new Dimension(28, 28));
        this.cmdBFCRMUmrechnung.setPreferredSize(new Dimension(28, 28));
        this.cmdBFCRMUmrechnung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdBFCRMUmrechnungActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.panHoehenmasse.add((Component)this.cmdBFCRMUmrechnung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.panKoerperMasse.add((Component)this.panHoehenmasse, gridBagConstraints);
        this.panEinstellrad.setBorder(BorderFactory.createTitledBorder("Velometrik Einstellrad"));
        this.panEinstellrad.setLayout(new GridBagLayout());
        this.panEinstellradInnen.setPreferredSize(new Dimension(220, 220));
        this.panEinstellradInnen.setLayout((LayoutManager)new AbsoluteLayout());
        this.lblLenkerversatz.setHorizontalAlignment(0);
        this.lblLenkerversatz.setText("+22,8");
        this.lblLenkerversatz.setToolTipText("Lenkerversatz");
        this.lblLenkerversatz.setPreferredSize(new Dimension(48, 15));
        this.panEinstellradInnen.add((Component)this.lblLenkerversatz, new AbsoluteConstraints(140, 27, 40, -1));
        this.fldLenkerversatz.setPreferredSize(new Dimension(48, 19));
        this.panEinstellradInnen.add((Component)this.fldLenkerversatz, new AbsoluteConstraints(140, 25, -1, -1));
        this.lblLenkerhoehe.setText("80");
        this.lblLenkerhoehe.setToolTipText("Lenkerh\u00f6he");
        this.lblLenkerhoehe.setPreferredSize(new Dimension(40, 15));
        this.panEinstellradInnen.add((Component)this.lblLenkerhoehe, new AbsoluteConstraints(170, 80, -1, -1));
        this.fldLenkerhoehe.setPreferredSize(new Dimension(40, 19));
        this.panEinstellradInnen.add((Component)this.fldLenkerhoehe, new AbsoluteConstraints(168, 78, -1, -1));
        this.lblSitzhoehe.setText("82");
        this.lblSitzhoehe.setToolTipText("Sitzh\u00f6he");
        this.lblSitzhoehe.setPreferredSize(new Dimension(40, 15));
        this.panEinstellradInnen.add((Component)this.lblSitzhoehe, new AbsoluteConstraints(92, 100, -1, -1));
        this.fldSitzhoehe.setPreferredSize(new Dimension(40, 19));
        this.panEinstellradInnen.add((Component)this.fldSitzhoehe, new AbsoluteConstraints(90, 98, -1, -1));
        this.lblSitzversatz.setHorizontalAlignment(0);
        this.lblSitzversatz.setText("0");
        this.lblSitzversatz.setToolTipText("Sitzversatz");
        this.lblSitzversatz.setPreferredSize(new Dimension(48, 15));
        this.panEinstellradInnen.add((Component)this.lblSitzversatz, new AbsoluteConstraints(40, 50, -1, -1));
        this.fldSitzversatz.setHorizontalAlignment(0);
        this.fldSitzversatz.setPreferredSize(new Dimension(48, 19));
        this.panEinstellradInnen.add((Component)this.fldSitzversatz, new AbsoluteConstraints(40, 50, -1, -1));
        this.lblEinstellrad.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/einstellrad.png")));
        this.panEinstellradInnen.add((Component)this.lblEinstellrad, new AbsoluteConstraints(10, 40, -1, -1));
        this.cmdRadZuDreieck.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/rechner.gif")));
        this.cmdRadZuDreieck.setToolTipText("<= Umrechnen f\u00fcr Magisches Dreieck");
        this.cmdRadZuDreieck.setMargin(new Insets(0, 0, 0, 0));
        this.cmdRadZuDreieck.setMaximumSize(new Dimension(28, 28));
        this.cmdRadZuDreieck.setMinimumSize(new Dimension(28, 28));
        this.cmdRadZuDreieck.setPreferredSize(new Dimension(28, 28));
        this.cmdRadZuDreieck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdRadZuDreieckActionPerformed(evt);
            }
        });
        this.panEinstellradInnen.add((Component)this.cmdRadZuDreieck, new AbsoluteConstraints(180, 180, -1, -1));
        this.panEinstellrad.add((Component)this.panEinstellradInnen, new GridBagConstraints());
        this.panEinstellradAnzeige.setLayout(new GridBagLayout());
        this.bgEinstellradAnzeige.add(this.rbEinstellradAbgelesen);
        this.rbEinstellradAbgelesen.setFont(new Font("Dialog", 0, 12));
        this.rbEinstellradAbgelesen.setSelected(true);
        this.rbEinstellradAbgelesen.setText("Abgelesen");
        this.rbEinstellradAbgelesen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.rbEinstellradAbgelesenActionPerformed(evt);
            }
        });
        this.panEinstellradAnzeige.add((Component)this.rbEinstellradAbgelesen, new GridBagConstraints());
        this.bgEinstellradAnzeige.add(this.rbEinstellradBerechnet);
        this.rbEinstellradBerechnet.setFont(new Font("Dialog", 0, 12));
        this.rbEinstellradBerechnet.setText("Berechnet");
        this.rbEinstellradBerechnet.setEnabled(false);
        this.rbEinstellradBerechnet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.rbEinstellradAbgelesenActionPerformed(evt);
            }
        });
        this.panEinstellradAnzeige.add((Component)this.rbEinstellradBerechnet, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.panEinstellrad.add((Component)this.panEinstellradAnzeige, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 22;
        this.panKoerperMasse.add((Component)this.panEinstellrad, gridBagConstraints);
        this.panDreieck.setBorder(BorderFactory.createTitledBorder("Magisches Dreieck"));
        this.panDreieck.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PanKoerper.this.panDreieckMouseClicked(evt);
            }
        });
        this.panDreieck.setLayout(new GridBagLayout());
        this.panDreieckInnen.setPreferredSize(new Dimension(220, 220));
        this.panDreieckInnen.setLayout((LayoutManager)new AbsoluteLayout());
        this.lblDreieckWinkel.setHorizontalAlignment(11);
        this.lblDreieckWinkel.setText("-15,8");
        this.lblDreieckWinkel.setPreferredSize(new Dimension(40, 15));
        this.panDreieckInnen.add((Component)this.lblDreieckWinkel, new AbsoluteConstraints(80, 20, -1, -1));
        this.fldDreieckWinkel.setHorizontalAlignment(4);
        this.fldDreieckWinkel.setPreferredSize(new Dimension(44, 19));
        this.panDreieckInnen.add((Component)this.fldDreieckWinkel, new AbsoluteConstraints(70, 20, -1, -1));
        this.lblGrad.setText("\u00b0");
        this.panDreieckInnen.add((Component)this.lblGrad, new AbsoluteConstraints(120, 20, 20, -1));
        this.lblDreieckOben.setHorizontalAlignment(4);
        this.lblDreieckOben.setText("77");
        this.lblDreieckOben.setPreferredSize(new Dimension(40, 15));
        this.panDreieckInnen.add((Component)this.lblDreieckOben, new AbsoluteConstraints(80, 60, -1, -1));
        this.fldDreieckOben.setHorizontalAlignment(4);
        this.fldDreieckOben.setPreferredSize(new Dimension(44, 19));
        this.panDreieckInnen.add((Component)this.fldDreieckOben, new AbsoluteConstraints(80, 60, -1, -1));
        this.lblDreieckHinten.setHorizontalAlignment(4);
        this.lblDreieckHinten.setText("97");
        this.lblDreieckHinten.setPreferredSize(new Dimension(40, 15));
        this.panDreieckInnen.add((Component)this.lblDreieckHinten, new AbsoluteConstraints(0, 120, 40, -1));
        this.fldDreieckHinten.setHorizontalAlignment(4);
        this.fldDreieckHinten.setPreferredSize(new Dimension(44, 19));
        this.panDreieckInnen.add((Component)this.fldDreieckHinten, new AbsoluteConstraints(8, 118, 40, -1));
        this.lblDreieckVorn.setText("84");
        this.lblDreieckVorn.setPreferredSize(new Dimension(40, 15));
        this.panDreieckInnen.add((Component)this.lblDreieckVorn, new AbsoluteConstraints(140, 120, -1, -1));
        this.fldDreieckVorn.setPreferredSize(new Dimension(44, 19));
        this.panDreieckInnen.add((Component)this.fldDreieckVorn, new AbsoluteConstraints(138, 118, -1, -1));
        this.lblRahmenwinkel.setHorizontalAlignment(11);
        this.lblRahmenwinkel.setText("-15,8\u00b0");
        this.lblRahmenwinkel.setPreferredSize(new Dimension(42, 18));
        this.panDreieckInnen.add((Component)this.lblRahmenwinkel, new AbsoluteConstraints(10, 190, 50, 20));
        this.jLabel43.setText("Lenker");
        this.panDreieckInnen.add((Component)this.jLabel43, new AbsoluteConstraints(160, 10, -1, -1));
        this.jLabel44.setText("Sattel");
        this.panDreieckInnen.add((Component)this.jLabel44, new AbsoluteConstraints(10, 10, -1, -1));
        this.cmdDreieckZuRad.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/rechner.gif")));
        this.cmdDreieckZuRad.setToolTipText("Umrechnen f\u00fcr Einstellrad =>");
        this.cmdDreieckZuRad.setMargin(new Insets(0, 0, 0, 0));
        this.cmdDreieckZuRad.setMaximumSize(new Dimension(28, 28));
        this.cmdDreieckZuRad.setMinimumSize(new Dimension(28, 28));
        this.cmdDreieckZuRad.setPreferredSize(new Dimension(28, 28));
        this.cmdDreieckZuRad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdDreieckZuRadActionPerformed(evt);
            }
        });
        this.panDreieckInnen.add((Component)this.cmdDreieckZuRad, new AbsoluteConstraints(180, 180, -1, -1));
        this.lblDreieck.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/velometer.png")));
        this.lblDreieck.setIconTextGap(0);
        this.panDreieckInnen.add((Component)this.lblDreieck, new AbsoluteConstraints(0, 12, -1, -1));
        this.panDreieck.add((Component)this.panDreieckInnen, new GridBagConstraints());
        this.bgDreieckAnzeige.add(this.rbDreieckAbgelesen);
        this.rbDreieckAbgelesen.setFont(new Font("Dialog", 0, 12));
        this.rbDreieckAbgelesen.setSelected(true);
        this.rbDreieckAbgelesen.setText("Abgelesen");
        this.rbDreieckAbgelesen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.rbDreieckAbgelesenActionPerformed(evt);
            }
        });
        this.panDreieckAnzeige.add(this.rbDreieckAbgelesen);
        this.bgDreieckAnzeige.add(this.rbDreieckBerechnet);
        this.rbDreieckBerechnet.setFont(new Font("Dialog", 0, 12));
        this.rbDreieckBerechnet.setText("Berechnet");
        this.rbDreieckBerechnet.setEnabled(false);
        this.rbDreieckBerechnet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.rbDreieckAbgelesenActionPerformed(evt);
            }
        });
        this.panDreieckAnzeige.add(this.rbDreieckBerechnet);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.panDreieck.add((Component)this.panDreieckAnzeige, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        this.panKoerperMasse.add((Component)this.panDreieck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.panMessung.add((Component)this.panKoerperMasse, gridBagConstraints);
        this.panFotoSchiessen.setLayout(new GridBagLayout());
        this.cmdFotoSchiessen.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/kamera.gif")));
        this.cmdFotoSchiessen.setToolTipText("Foto schiessen ...");
        this.cmdFotoSchiessen.setMaximumSize(new Dimension(28, 28));
        this.cmdFotoSchiessen.setMinimumSize(new Dimension(28, 28));
        this.cmdFotoSchiessen.setPreferredSize(new Dimension(28, 28));
        this.cmdFotoSchiessen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdFotoSchiessenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panFotoSchiessen.add((Component)this.cmdFotoSchiessen, gridBagConstraints);
        this.cmdBeispielbild.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/open.gif")));
        this.cmdBeispielbild.setToolTipText("Beispielfoto \u00f6ffnen");
        this.cmdBeispielbild.setMaximumSize(new Dimension(28, 28));
        this.cmdBeispielbild.setMinimumSize(new Dimension(28, 28));
        this.cmdBeispielbild.setPreferredSize(new Dimension(28, 28));
        this.cmdBeispielbild.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdBeispielbildActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panFotoSchiessen.add((Component)this.cmdBeispielbild, gridBagConstraints);
        this.cmdLetzteFotos.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/letztes-foto.gif")));
        this.cmdLetzteFotos.setToolTipText("Letzte Fotos ...");
        this.cmdLetzteFotos.setEnabled(false);
        this.cmdLetzteFotos.setMaximumSize(new Dimension(28, 28));
        this.cmdLetzteFotos.setMinimumSize(new Dimension(28, 28));
        this.cmdLetzteFotos.setPreferredSize(new Dimension(28, 28));
        this.cmdLetzteFotos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdLetzteFotosActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.panFotoSchiessen.add((Component)this.cmdLetzteFotos, gridBagConstraints);
        this.cmbProfilVerwenden.setModel(new DefaultComboBoxModel<String>(new String[]{"Standard Kamera-/Farbprofil", "Direkte Sonneneinstrahlung", "M\u00e4\u00dfiges Tageslicht", "Kunstlicht"}));
        this.cmbProfilVerwenden.setEnabled(false);
        this.cmbProfilVerwenden.setMaximumSize(new Dimension(Short.MAX_VALUE, 28));
        this.cmbProfilVerwenden.setMinimumSize(new Dimension(230, 28));
        this.cmbProfilVerwenden.setPreferredSize(new Dimension(230, 28));
        this.cmbProfilVerwenden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmbProfilVerwendenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panFotoSchiessen.add((Component)this.cmbProfilVerwenden, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panFotoSchiessen.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 14, 0, 12);
        this.panMessung.add((Component)this.panFotoSchiessen, gridBagConstraints);
        this.panBFStatus.setBorder(BorderFactory.createTitledBorder("Meldungen/Hinweise"));
        this.panBFStatus.setLayout(new GridLayout(3, 2, 5, 3));
        this.panMldgSitzposition.setVisible(false);
        this.panMldgSitzposition.setLayout(new GridLayout(1, 0));
        this.jLabel41.setText("Werte berechnet f\u00fcr Sitzposition:");
        this.panMldgSitzposition.add(this.jLabel41);
        this.lblSitzposition.setHorizontalAlignment(2);
        this.lblSitzposition.setText("<sitzposition>");
        this.panMldgSitzposition.add(this.lblSitzposition);
        this.panBFStatus.add(this.panMldgSitzposition);
        this.panMldgStatus.setLayout(new GridLayout(1, 0));
        this.lblStatus.setText("Status:");
        this.panMldgStatus.add(this.lblStatus);
        this.lblStatusmeldung.setText("Das ist der Berechnungsstatus.");
        this.panMldgStatus.add(this.lblStatusmeldung);
        this.panBFStatus.add(this.panMldgStatus);
        this.panMldgProblem.setLayout(new GridLayout(1, 0));
        this.lblProblem.setText("Problem:");
        this.lblProblem.setPreferredSize(new Dimension(240, 15));
        this.panMldgProblem.add(this.lblProblem);
        this.lblFehlermeldung.setForeground(new Color(255, 0, 0));
        this.lblFehlermeldung.setText("Das ist ein m\u00f6glicher Fehlertext.");
        this.lblFehlermeldung.setPreferredSize(new Dimension(240, 15));
        this.panMldgProblem.add(this.lblFehlermeldung);
        this.panBFStatus.add(this.panMldgProblem);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        this.panMessung.add((Component)this.panBFStatus, gridBagConstraints);
        this.panMessungFueller.setLayout(new GridBagLayout());
        this.cmdDreieckBerechnen.setText("(Neu) Berechnen");
        this.cmdDreieckBerechnen.setEnabled(false);
        this.cmdDreieckBerechnen.setMaximumSize(new Dimension(152, 32));
        this.cmdDreieckBerechnen.setMinimumSize(new Dimension(152, 32));
        this.cmdDreieckBerechnen.setPreferredSize(new Dimension(152, 32));
        this.cmdDreieckBerechnen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdDreieckBerechnenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.panMessungFueller.add((Component)this.cmdDreieckBerechnen, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panMessungFueller.add((Component)this.jPanel1, gridBagConstraints);
        this.cmdMagischesDreieck.setText("weiter");
        this.cmdMagischesDreieck.setToolTipText("Rahmen ermitteln");
        this.cmdMagischesDreieck.setEnabled(false);
        this.cmdMagischesDreieck.setMaximumSize(new Dimension(80, 32));
        this.cmdMagischesDreieck.setMinimumSize(new Dimension(80, 32));
        this.cmdMagischesDreieck.setPreferredSize(new Dimension(80, 32));
        this.cmdMagischesDreieck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdMagischesDreieckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.panMessungFueller.add((Component)this.cmdMagischesDreieck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 14, 0, 12);
        this.panMessung.add((Component)this.panMessungFueller, gridBagConstraints);
        this.tabBikeAndFit.addTab("Messung", this.panMessung);
        this.tabEinrichtung.setBackground(new Color(238, 238, 238));
        this.panKalibrierung.setBorder(BorderFactory.createTitledBorder(""));
        this.panKalibrierung.setLayout(new GridBagLayout());
        this.cmdMesspunktsuche.setText("Me\u00dfpunkte suchen");
        this.cmdMesspunktsuche.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdMesspunktsucheActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.panKalibrierung.add((Component)this.cmdMesspunktsuche, gridBagConstraints);
        this.jLabel1.setFont(new Font("Dialog", 0, 12));
        this.jLabel1.setText("Abstand der Kalibrierungspunkte");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.panKalibrierung.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel15.setText("Versatz Me\u00dfpunkt-K\u00f6rperpunkt bei Blickrichtung rechts:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.panKalibrierung.add((Component)this.jLabel15, gridBagConstraints);
        this.jLabel16.setFont(new Font("Dialog", 0, 12));
        this.jLabel16.setText("Sitz -> H\u00fcfte");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.panKalibrierung.add((Component)this.jLabel16, gridBagConstraints);
        this.jLabel18.setFont(new Font("Dialog", 0, 12));
        this.jLabel18.setText("Lenker -> Hand");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.panKalibrierung.add((Component)this.jLabel18, gridBagConstraints);
        this.fldAbstandKalibrierungspunkte.setHorizontalAlignment(4);
        this.fldAbstandKalibrierungspunkte.setText("70");
        this.fldAbstandKalibrierungspunkte.setPreferredSize(new Dimension(48, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        this.panKalibrierung.add((Component)this.fldAbstandKalibrierungspunkte, gridBagConstraints);
        this.fldOffsetHuefteX.setHorizontalAlignment(4);
        this.fldOffsetHuefteX.setText("5");
        this.fldOffsetHuefteX.setPreferredSize(new Dimension(48, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.panKalibrierung.add((Component)this.fldOffsetHuefteX, gridBagConstraints);
        this.fldOffsetHuefteY.setHorizontalAlignment(4);
        this.fldOffsetHuefteY.setText("15");
        this.fldOffsetHuefteY.setPreferredSize(new Dimension(48, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        this.panKalibrierung.add((Component)this.fldOffsetHuefteY, gridBagConstraints);
        this.fldOffsetHandX.setHorizontalAlignment(4);
        this.fldOffsetHandX.setText("0");
        this.fldOffsetHandX.setPreferredSize(new Dimension(48, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.panKalibrierung.add((Component)this.fldOffsetHandX, gridBagConstraints);
        this.fldOffsetHandY.setHorizontalAlignment(4);
        this.fldOffsetHandY.setText("0");
        this.fldOffsetHandY.setPreferredSize(new Dimension(48, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 13;
        this.panKalibrierung.add((Component)this.fldOffsetHandY, gridBagConstraints);
        this.jLabel20.setFont(new Font("Dialog", 0, 12));
        this.jLabel20.setText("(L\u00e4ngen in cm)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.panKalibrierung.add((Component)this.jLabel20, gridBagConstraints);
        this.jLabel21.setFont(new Font("Dialog", 0, 12));
        this.jLabel21.setText("horizontal:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.panKalibrierung.add((Component)this.jLabel21, gridBagConstraints);
        this.jLabel22.setFont(new Font("Dialog", 0, 12));
        this.jLabel22.setText("vertikal:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.panKalibrierung.add((Component)this.jLabel22, gridBagConstraints);
        this.jLabel23.setFont(new Font("Dialog", 0, 12));
        this.jLabel23.setText("horizontal:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.panKalibrierung.add((Component)this.jLabel23, gridBagConstraints);
        this.jLabel24.setFont(new Font("Dialog", 0, 12));
        this.jLabel24.setText("vertikal:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.panKalibrierung.add((Component)this.jLabel24, gridBagConstraints);
        this.jLabel17.setFont(new Font("Dialog", 0, 12));
        this.jLabel17.setText("Pedal -> Fu\u00df");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.panKalibrierung.add((Component)this.jLabel17, gridBagConstraints);
        this.jLabel19.setFont(new Font("Dialog", 0, 12));
        this.jLabel19.setText("horizontal:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.panKalibrierung.add((Component)this.jLabel19, gridBagConstraints);
        this.jLabel25.setFont(new Font("Dialog", 0, 12));
        this.jLabel25.setText("vertikal:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.panKalibrierung.add((Component)this.jLabel25, gridBagConstraints);
        this.fldOffsetFussX.setHorizontalAlignment(4);
        this.fldOffsetFussX.setText("2,5");
        this.fldOffsetFussX.setPreferredSize(new Dimension(48, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.panKalibrierung.add((Component)this.fldOffsetFussX, gridBagConstraints);
        this.fldOffsetFussY.setHorizontalAlignment(4);
        this.fldOffsetFussY.setText("3");
        this.fldOffsetFussY.setPreferredSize(new Dimension(48, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 13;
        this.panKalibrierung.add((Component)this.fldOffsetFussY, gridBagConstraints);
        this.cmdKalibrierungSpeichern.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/save.gif")));
        this.cmdKalibrierungSpeichern.setToolTipText("Einstellungen speichern");
        this.cmdKalibrierungSpeichern.setMaximumSize(new Dimension(25, 25));
        this.cmdKalibrierungSpeichern.setMinimumSize(new Dimension(25, 25));
        this.cmdKalibrierungSpeichern.setPreferredSize(new Dimension(25, 25));
        this.cmdKalibrierungSpeichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdKalibrierungSpeichernActionPerformed(evt);
            }
        });
        this.panKalibrierungSpeichern.add(this.cmdKalibrierungSpeichern);
        this.cmdKalibrierungWiederherstellen.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/undo.gif")));
        this.cmdKalibrierungWiederherstellen.setToolTipText("Zuletzt gespeichere Einstellungen wiederherstellen");
        this.cmdKalibrierungWiederherstellen.setMaximumSize(new Dimension(25, 25));
        this.cmdKalibrierungWiederherstellen.setMinimumSize(new Dimension(25, 25));
        this.cmdKalibrierungWiederherstellen.setPreferredSize(new Dimension(25, 25));
        this.cmdKalibrierungWiederherstellen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdKalibrierungWiederherstellenActionPerformed(evt);
            }
        });
        this.panKalibrierungSpeichern.add(this.cmdKalibrierungWiederherstellen);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.panKalibrierung.add((Component)this.panKalibrierungSpeichern, gridBagConstraints);
        this.jLabel26.setText("Berechnung des \"Magischen Dreiecks\":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.panKalibrierung.add((Component)this.jLabel26, gridBagConstraints);
        this.jLabel27.setFont(new Font("Dialog", 0, 12));
        this.jLabel27.setText("Abstand H\u00fcfte -> links oben:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.panKalibrierung.add((Component)this.jLabel27, gridBagConstraints);
        this.jLabel28.setFont(new Font("Dialog", 0, 12));
        this.jLabel28.setText("Pedall\u00e4nge:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.panKalibrierung.add((Component)this.jLabel28, gridBagConstraints);
        this.fldHueftabstand.setHorizontalAlignment(4);
        this.fldHueftabstand.setText("8");
        this.fldHueftabstand.setPreferredSize(new Dimension(48, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.panKalibrierung.add((Component)this.fldHueftabstand, gridBagConstraints);
        this.fldPedallaenge.setHorizontalAlignment(4);
        this.fldPedallaenge.setText("17");
        this.fldPedallaenge.setPreferredSize(new Dimension(48, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 13;
        this.panKalibrierung.add((Component)this.fldPedallaenge, gridBagConstraints);
        this.jLabel29.setText("Einstellrad:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.panKalibrierung.add((Component)this.jLabel29, gridBagConstraints);
        this.jLabel31.setText("Fahrer blickt nach:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.panKalibrierung.add((Component)this.jLabel31, gridBagConstraints);
        this.bgBlickrichtung.add(this.rbBlickLinks);
        this.rbBlickLinks.setFont(new Font("Dialog", 0, 12));
        this.rbBlickLinks.setText("links.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.panKalibrierung.add((Component)this.rbBlickLinks, gridBagConstraints);
        this.bgBlickrichtung.add(this.rbBlickRechts);
        this.rbBlickRechts.setFont(new Font("Dialog", 0, 12));
        this.rbBlickRechts.setSelected(true);
        this.rbBlickRechts.setText("rechts.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.panKalibrierung.add((Component)this.rbBlickRechts, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.panKalibrierung.add((Component)this.panKalibrierungVFill, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panKalibrierung.add((Component)this.panKalibrierungHFill, gridBagConstraints);
        this.cbHoehenmasse.setText("Benutze H\u00f6henma\u00dfe");
        this.cbHoehenmasse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cbHoehenmasseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.panKalibrierung.add((Component)this.cbHoehenmasse, gridBagConstraints);
        this.jLabel49.setFont(new Font("Dialog", 0, 12));
        this.jLabel49.setText("Rahmenwinkel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.panKalibrierung.add((Component)this.jLabel49, gridBagConstraints);
        this.fldRahmenwinkel.setHorizontalAlignment(4);
        this.fldRahmenwinkel.setText("72");
        this.fldRahmenwinkel.setPreferredSize(new Dimension(48, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        this.panKalibrierung.add((Component)this.fldRahmenwinkel, gridBagConstraints);
        this.jLabel50.setText("\u00b0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.panKalibrierung.add((Component)this.jLabel50, gridBagConstraints);
        this.jLabel51.setFont(new Font("Dialog", 0, 12));
        this.jLabel51.setText("Abstand Kurbelmitte-Lenks\u00e4ule");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.panKalibrierung.add((Component)this.jLabel51, gridBagConstraints);
        this.fldAbstandLenksaeule.setHorizontalAlignment(4);
        this.fldAbstandLenksaeule.setText("45,5");
        this.fldAbstandLenksaeule.setPreferredSize(new Dimension(48, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        this.panKalibrierung.add((Component)this.fldAbstandLenksaeule, gridBagConstraints);
        this.tabEinrichtung.addTab("Kalibrierung", this.panKalibrierung);
        this.panMesspunkte.setBorder(BorderFactory.createTitledBorder(""));
        this.panMesspunkte.setLayout(new GridBagLayout());
        this.bgMesspunktsuche.add(this.rbVollautomatisch);
        this.rbVollautomatisch.setFont(new Font("Dialog", 0, 12));
        this.rbVollautomatisch.setSelected(true);
        this.rbVollautomatisch.setText("Alle");
        this.panMesspunktsuche.add(this.rbVollautomatisch);
        this.bgMesspunktsuche.add(this.rbNurFahrrad);
        this.rbNurFahrrad.setFont(new Font("Dialog", 0, 12));
        this.rbNurFahrrad.setText("Nur die am Fahrrad");
        this.panMesspunktsuche.add(this.rbNurFahrrad);
        this.bgMesspunktsuche.add(this.rbManuell);
        this.rbManuell.setFont(new Font("Dialog", 0, 12));
        this.rbManuell.setText("Keiner");
        this.panMesspunktsuche.add(this.rbManuell);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        this.panMesspunkte.add((Component)this.panMesspunktsuche, gridBagConstraints);
        this.cmdMesspunktParameterSpeichern.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/save.gif")));
        this.cmdMesspunktParameterSpeichern.setToolTipText("Einstellungen speichern");
        this.cmdMesspunktParameterSpeichern.setMaximumSize(new Dimension(25, 25));
        this.cmdMesspunktParameterSpeichern.setMinimumSize(new Dimension(25, 25));
        this.cmdMesspunktParameterSpeichern.setPreferredSize(new Dimension(25, 25));
        this.cmdMesspunktParameterSpeichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdMesspunktParameterSpeichernActionPerformed(evt);
            }
        });
        this.panMesspunkteSpeichern.add(this.cmdMesspunktParameterSpeichern);
        this.cmdMesspunktParameterWiederherstellen.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/undo.gif")));
        this.cmdMesspunktParameterWiederherstellen.setToolTipText("Zuletzt gespeichere Einstellungen wiederherstellen");
        this.cmdMesspunktParameterWiederherstellen.setMaximumSize(new Dimension(25, 25));
        this.cmdMesspunktParameterWiederherstellen.setMinimumSize(new Dimension(25, 25));
        this.cmdMesspunktParameterWiederherstellen.setPreferredSize(new Dimension(25, 25));
        this.cmdMesspunktParameterWiederherstellen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdMesspunktParameterWiederherstellenActionPerformed(evt);
            }
        });
        this.panMesspunkteSpeichern.add(this.cmdMesspunktParameterWiederherstellen);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 14;
        this.panMesspunkte.add((Component)this.panMesspunkteSpeichern, gridBagConstraints);
        this.cmdMesspunktsuche2.setText("Me\u00dfpunkte suchen");
        this.cmdMesspunktsuche2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdMesspunktsucheActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.panMesspunkte.add((Component)this.cmdMesspunktsuche2, gridBagConstraints);
        this.panInnenpunkt.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.panInnenpunkt.setLayout(new GridBagLayout());
        this.jLabel32.setFont(new Font("Dialog", 0, 12));
        this.jLabel32.setText("V(k.o.) min [%]:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.panInnenpunkt.add((Component)this.jLabel32, gridBagConstraints);
        this.fldVminInnen.setHorizontalAlignment(11);
        this.fldVminInnen.setText("90");
        this.fldVminInnen.setPreferredSize(new Dimension(30, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.panInnenpunkt.add((Component)this.fldVminInnen, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        this.panMesspunkte.add((Component)this.panInnenpunkt, gridBagConstraints);
        this.panKoronapunkt.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.panKoronapunkt.setLayout(new GridBagLayout());
        this.jLabel7.setFont(new Font("Dialog", 0, 12));
        this.jLabel7.setText("H(\u00f8) von [\u00b0]:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.panKoronapunkt.add((Component)this.jLabel7, gridBagConstraints);
        this.fldHminKorona.setHorizontalAlignment(11);
        this.fldHminKorona.setText("335");
        this.fldHminKorona.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panKoronapunkt.add((Component)this.fldHminKorona, gridBagConstraints);
        this.jLabel8.setFont(new Font("Dialog", 0, 12));
        this.jLabel8.setText("bis [\u00b0]:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.panKoronapunkt.add((Component)this.jLabel8, gridBagConstraints);
        this.fldHmaxKorona.setHorizontalAlignment(11);
        this.fldHmaxKorona.setText("359");
        this.fldHmaxKorona.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panKoronapunkt.add((Component)this.fldHmaxKorona, gridBagConstraints);
        this.jLabel9.setFont(new Font("Dialog", 0, 12));
        this.jLabel9.setText("S(\u00f8) min [%]:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panKoronapunkt.add((Component)this.jLabel9, gridBagConstraints);
        this.fldSminKorona.setHorizontalAlignment(11);
        this.fldSminKorona.setText("50");
        this.fldSminKorona.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.panKoronapunkt.add((Component)this.fldSminKorona, gridBagConstraints);
        this.jLabel34.setFont(new Font("Dialog", 0, 12));
        this.jLabel34.setText("V(k.o.) min [%]:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.panKoronapunkt.add((Component)this.jLabel34, gridBagConstraints);
        this.fldVminKorona.setHorizontalAlignment(11);
        this.fldVminKorona.setText("3");
        this.fldVminKorona.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panKoronapunkt.add((Component)this.fldVminKorona, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        this.panMesspunkte.add((Component)this.panKoronapunkt, gridBagConstraints);
        this.panGeometrie.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.panGeometrie.setLayout(new GridBagLayout());
        this.fldBminKorona.setHorizontalAlignment(11);
        this.fldBminKorona.setText("3");
        this.fldBminKorona.setPreferredSize(new Dimension(30, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.panGeometrie.add((Component)this.fldBminKorona, gridBagConstraints);
        this.jLabel10.setFont(new Font("Dialog", 0, 12));
        this.jLabel10.setText("Min. Koronabreite:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panGeometrie.add((Component)this.jLabel10, gridBagConstraints);
        this.jLabel11.setFont(new Font("Dialog", 0, 12));
        this.jLabel11.setText("Min. Innenradius:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panGeometrie.add((Component)this.jLabel11, gridBagConstraints);
        this.fldRminInnen.setHorizontalAlignment(11);
        this.fldRminInnen.setText("3");
        this.fldRminInnen.setPreferredSize(new Dimension(30, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.panGeometrie.add((Component)this.fldRminInnen, gridBagConstraints);
        this.jLabel12.setFont(new Font("Dialog", 0, 12));
        this.jLabel12.setText("Max. Aussenradius:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.panGeometrie.add((Component)this.jLabel12, gridBagConstraints);
        this.fldRmaxAussen.setHorizontalAlignment(11);
        this.fldRmaxAussen.setText("12");
        this.fldRmaxAussen.setPreferredSize(new Dimension(30, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.panGeometrie.add((Component)this.fldRmaxAussen, gridBagConstraints);
        this.jLabel13.setFont(new Font("Dialog", 0, 12));
        this.jLabel13.setText("(Alle Angaben ab Mittelpunkt)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.panGeometrie.add((Component)this.jLabel13, gridBagConstraints);
        this.jLabel14.setFont(new Font("Dialog", 0, 12));
        this.jLabel14.setText("(Abbruchkriterium)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.panGeometrie.add((Component)this.jLabel14, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.panMesspunkte.add((Component)this.panGeometrie, gridBagConstraints);
        this.jLabel42.setText("Automatisch gesuchte Me\u00dfpunkte:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.panMesspunkte.add((Component)this.jLabel42, gridBagConstraints);
        this.jLabel45.setText("Speichern als Kamera-/Farbprofil:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 8);
        this.panMesspunkte.add((Component)this.jLabel45, gridBagConstraints);
        this.cmbProfilSpeichern.setEditable(true);
        this.cmbProfilSpeichern.setFont(new Font("Dialog", 0, 12));
        this.cmbProfilSpeichern.setModel(new DefaultComboBoxModel<String>(new String[]{"Standard", "Direkte Sonneneinstrahlung", "M\u00e4\u00dfiges Tageslicht", "Kunstlicht"}));
        this.cmbProfilSpeichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmbProfilSpeichernActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panMesspunkte.add((Component)this.cmbProfilSpeichern, gridBagConstraints);
        this.jLabel46.setText("LED Innenbereich:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.panMesspunkte.add((Component)this.jLabel46, gridBagConstraints);
        this.jLabel47.setText("LED Korona:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.panMesspunkte.add((Component)this.jLabel47, gridBagConstraints);
        this.jLabel48.setText("LED Me\u00dfpunktgeometrie:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.panMesspunkte.add((Component)this.jLabel48, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.panMesspunkte.add((Component)this.panMesspunkteVFill, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panMesspunkte.add((Component)this.panMesspunkteHFill, gridBagConstraints);
        this.tabEinrichtung.addTab("LED-Me\u00dfpunktsuche", this.panMesspunkte);
        this.tabBikeAndFit.addTab("Einrichtung", this.tabEinrichtung);
        this.scrlMessung.setViewportView(this.tabBikeAndFit);
        this.add((Component)this.scrlMessung, "After");
    }

    private void cmdMagischesDreieckActionPerformed(ActionEvent evt) {
        try {
            Image image = this.panFotoImage.getImage();
            BufferedImage bfImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            Graphics2D gfx = bfImage.createGraphics();
            gfx.drawImage(image, 0, 0, null);
            gfx.dispose();
            this.panFotoImage.paint((Graphics2D)bfImage.getGraphics(), bfImage.getWidth(), bfImage.getHeight());
            String bodyImagePath = this.session.getConfigFile().findValue("BFIMAGE");
            if (bodyImagePath.isEmpty()) {
                throw new YUserException("Die Konfigurationsvariable 'BFIMAGE' ist nicht gesetzt.");
            }
            File bfImageFile = new File(bodyImagePath);
            try {
                ImageIO.write((RenderedImage)bfImage, "jpg", bfImageFile);
            }
            catch (IOException e) {
                throw new YException(e.toString());
            }
            this.frmNavigator.setEinsbedingung("koerpermasse", this.koerperberechnung.magischesDreieck.getHinten());
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmdFotoSchiessenActionPerformed(ActionEvent evt) {
        try {
            int a;
            this.kunde.requestValuesToStore();
            int iRow = this.kundeneinsbed.find(String.valueOf(this.einsbereichIdSitzknochen), "einsbereich_id");
            if (iRow < 0 && (a = JOptionPane.showConfirmDialog(this, "Das \"Magische Dreieck\" kann nur mit der Sitzhaltung berechnet werden,\ndie beim Sitzknochenabstand erfa\u00dft wird.", "Warnung", 2)) == 2) {
                return;
            }
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
        if (!this.fotoCmdFile.exists()) {
            JOptionPane.showMessageDialog(this, "Die Kommandodatei '" + this.fotoCmdFile.getPath() + "' zum Fotografieren existiert nicht.", "Fehler", 0);
            return;
        }
        if (!this.fotoCmdFile.canExecute()) {
            JOptionPane.showMessageDialog(this, "Die Kommandodatei '" + this.fotoCmdFile.getPath() + "' zum Fotografieren ist nicht ausf\u00fchrbar.", "Fehler", 0);
            return;
        }
        this.loescheMasse(true);
        this.cmdFotoSchiessen.setEnabled(false);
        this.cmdLetzteFotos.setEnabled(false);
        try {
            Image image;
            if (this.dlgFotos == null) {
                this.dlgFotos = new DlgFotos((Frame)this.frmNavigator, this.fotoCmdFile.getPath(), this.fotoImageFile);
            }
            if ((image = this.dlgFotos.execute(evt.getSource() == this.cmdFotoSchiessen)) != null) {
                this.changePicture(image);
                StringBuffer fehler = new StringBuffer();
                try {
                    BfStatus status = this.bikeAndFit(BfStart.BFSTART_SUCHE, fehler);
                    this.lblStatusmeldung.setText(status.toString());
                    this.setFehlermeldung(fehler.toString());
                }
                catch (YException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Fehler", 0);
                }
            }
        }
        finally {
            this.cmdLetzteFotos.setEnabled(true);
            this.cmdFotoSchiessen.setEnabled(true);
        }
    }

    private void changePicture(Image bodyImage) {
        this.imgFoto = this.panFotoImage.setImage(bodyImage);
        this.loescheMasse(true);
        this.koerperberechnung.messpunkte.init();
        this.panFotoImage.repaint();
    }

    private void cmdMesspunktParameterSpeichernActionPerformed(ActionEvent evt) {
        this.parameter.getFromInput();
        this.parameter.saveToConfig(Parametergruppe.MESSPUNKTSUCHE);
    }

    private void cmdMesspunktParameterWiederherstellenActionPerformed(ActionEvent evt) {
        this.parameter.getFromConfig(Parametergruppe.MESSPUNKTSUCHE);
        this.parameter.setInput(Parametergruppe.MESSPUNKTSUCHE);
    }

    private void fldLUnterarmFocusLost(FocusEvent evt) {
        this.berechneDreieck();
    }

    private void fldLOberarmFocusLost(FocusEvent evt) {
        this.berechneDreieck();
    }

    private void fldLOberkoerperFocusLost(FocusEvent evt) {
        this.berechneDreieck();
    }

    private void fldLOberschenkelFocusLost(FocusEvent evt) {
        this.berechneDreieck();
    }

    private void fldLUnterschenkelFocusLost(FocusEvent evt) {
        this.berechneDreieck();
    }

    private void cmdDreieckBerechnenActionPerformed(ActionEvent evt) {
        this.berechneDreieck();
    }

    private void cmdMesspunktsucheActionPerformed(ActionEvent evt) {
        StringBuffer fehler = new StringBuffer();
        try {
            BfStatus status = this.bikeAndFit(BfStart.BFSTART_SUCHE, fehler);
            this.lblStatusmeldung.setText(status.toString());
            this.setFehlermeldung(fehler.toString());
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Fehler", 0);
        }
    }

    private void cmdKalibrierungSpeichernActionPerformed(ActionEvent evt) {
        this.parameter.getFromInput();
        this.parameter.saveToConfig(Parametergruppe.KALIBRIERUNG);
    }

    private void cmdKalibrierungWiederherstellenActionPerformed(ActionEvent evt) {
        this.parameter.getFromConfig(Parametergruppe.KALIBRIERUNG);
        this.parameter.setInput(Parametergruppe.KALIBRIERUNG);
    }

    private void cmdBeispielbildActionPerformed(ActionEvent evt) {
        int rc;
        File startDir = new File(System.getProperty("user.home"), ".popometer/bodyimg");
        if (this.openJpegDialog == null) {
            this.openJpegDialog = new JFileChooser();
            this.openJpegDialog.setDialogType(0);
            this.openJpegDialog.setFileSelectionMode(0);
            this.openJpegDialog.setMultiSelectionEnabled(false);
            FileFilter jpegFilter = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    String fname = f.getName().toUpperCase();
                    if (f.isDirectory()) {
                        return true;
                    }
                    return fname.endsWith(".JPG") || fname.endsWith(".JPEG");
                }

                @Override
                public String getDescription() {
                    return "JPEG-Dateien";
                }
            };
            this.openJpegDialog.addChoosableFileFilter(jpegFilter);
            this.openJpegDialog.setFileFilter(jpegFilter);
            if (startDir.isDirectory()) {
                this.openJpegDialog.setCurrentDirectory(startDir);
            }
        }
        if ((rc = this.openJpegDialog.showOpenDialog(this)) != 0) {
            return;
        }
        File jpegFile = this.openJpegDialog.getSelectedFile();
        Image image = Toolkit.getDefaultToolkit().createImage(jpegFile.getAbsolutePath());
        this.changePicture(image);
        StringBuffer fehler = new StringBuffer();
        try {
            BfStatus status = this.bikeAndFit(BfStart.BFSTART_SUCHE, fehler);
            this.lblStatusmeldung.setText(status.toString());
            this.setFehlermeldung(fehler.toString());
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Fehler", 0);
        }
    }

    private void cmdLetzteFotosActionPerformed(ActionEvent evt) {
        if (this.dlgFotos == null) {
            JOptionPane.showMessageDialog(this, "Es gibt noch keine Fotos", "Hinweis", 1);
            return;
        }
        this.cmdFotoSchiessenActionPerformed(evt);
    }

    private void cmbProfilSpeichernActionPerformed(ActionEvent evt) {
        try {
            throw new YUnimplementedException(this, "Verwaltung von Farbprofilen");
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
            return;
        }
    }

    private void cmbProfilVerwendenActionPerformed(ActionEvent evt) {
        try {
            throw new YUnimplementedException(this, "Verwaltung von Farbprofilen");
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
            return;
        }
    }

    private void cmdBFCRMUmrechnungActionPerformed(ActionEvent evt) {
        try {
            throw new YUnimplementedException(this, "Umrechnung der K\u00f6rperh\u00f6hen");
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
            return;
        }
    }

    private void cbHoehenmasseActionPerformed(ActionEvent evt) {
        this.parameter.benutzeHoehenmasse = this.cbHoehenmasse.isSelected();
        this.panHoehenmasse.setVisible(this.parameter.benutzeHoehenmasse);
    }

    private void panDreieckMouseClicked(MouseEvent evt) {
        System.out.print("Click auf Magisches Dreieck.");
    }

    private void rbDreieckAbgelesenActionPerformed(ActionEvent evt) {
        boolean abgelesen = this.rbDreieckAbgelesen.isSelected();
        boolean berechnet = this.rbDreieckBerechnet.isSelected();
        this.lblDreieckWinkel.setVisible(berechnet);
        this.lblDreieckOben.setVisible(berechnet);
        this.lblDreieckVorn.setVisible(berechnet);
        this.lblDreieckHinten.setVisible(berechnet);
        this.lblRahmenwinkel.setVisible(berechnet);
        this.fldDreieckWinkel.setVisible(abgelesen);
        this.fldDreieckOben.setVisible(abgelesen);
        this.fldDreieckVorn.setVisible(abgelesen);
        this.fldDreieckHinten.setVisible(abgelesen);
        this.cmdDreieckZuRad.setVisible(abgelesen);
    }

    private void cmdDreieckZuRadActionPerformed(ActionEvent evt) {
        MagischesDreieck magischesDreieck = new MagischesDreieck(this.parameter);
        Einstellrad einstellrad = new Einstellrad(this.parameter);
        String oben = this.fldDreieckOben.getText().replace(',', '.');
        String hinten = this.fldDreieckHinten.getText().replace(',', '.');
        String vorn = this.fldDreieckVorn.getText().replace(',', '.');
        String neigungswinkel = this.fldDreieckWinkel.getText().replace(',', '.');
        if (oben.isEmpty() || hinten.isEmpty() || vorn.isEmpty() || neigungswinkel.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Alle Werte des 'Magischen Dreiecks' m\u00fcssen angegeben werden.", "Hinweis", 2);
            return;
        }
        try {
            magischesDreieck.set(Double.parseDouble(oben), Double.parseDouble(hinten), Double.parseDouble(vorn), Double.parseDouble(neigungswinkel));
            einstellrad.berechnen(magischesDreieck);
            this.zeigeEinstellrad(einstellrad);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Ung\u00fcltige Zahlenangabe: '" + e.getMessage() + "'", "Fehler", 0);
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void rbEinstellradAbgelesenActionPerformed(ActionEvent evt) {
        boolean abgelesen = this.rbEinstellradAbgelesen.isSelected();
        boolean berechnet = this.rbEinstellradBerechnet.isSelected();
        this.lblSitzversatz.setVisible(berechnet);
        this.lblSitzhoehe.setVisible(berechnet);
        this.lblLenkerversatz.setVisible(berechnet);
        this.lblLenkerhoehe.setVisible(berechnet);
        this.fldSitzversatz.setVisible(abgelesen);
        this.fldSitzhoehe.setVisible(abgelesen);
        this.fldLenkerversatz.setVisible(abgelesen);
        this.fldLenkerhoehe.setVisible(abgelesen);
        this.cmdRadZuDreieck.setVisible(abgelesen);
    }

    private void cmdRadZuDreieckActionPerformed(ActionEvent evt) {
        Einstellrad einstellrad = new Einstellrad(this.parameter);
        MagischesDreieck magischesDreieck = new MagischesDreieck(this.parameter);
        String sitzversatz = this.fldSitzversatz.getText().replace(',', '.');
        String sitzhoehe = this.fldSitzhoehe.getText().replace(',', '.');
        String lenkerversatz = this.fldLenkerversatz.getText().replace(',', '.');
        String lenkerhoehe = this.fldLenkerhoehe.getText().replace(',', '.');
        if (sitzversatz.isEmpty() || sitzhoehe.isEmpty() || lenkerversatz.isEmpty() || lenkerhoehe.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Alle Werte des Einstellrades m\u00fcssen angegeben werden.", "Hinweis", 2);
            return;
        }
        try {
            einstellrad.set(Double.parseDouble(sitzhoehe), Double.parseDouble(sitzversatz), Double.parseDouble(lenkerhoehe), Double.parseDouble(lenkerversatz));
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Ung\u00fcltige Zahlenangabe: '" + e.getMessage() + "'", "Fehler", 0);
        }
        magischesDreieck.berechnen(einstellrad);
        this.zeigeDreieck(magischesDreieck);
    }

    private static enum BfStatus {
        BFSTATUS_NULL,
        BFSTATUS_BEREIT,
        BFSTATUS_GEFUNDEN,
        BFSTATUS_BENANNT,
        BFSTATUS_KALIBRIERT,
        BFSTATUS_KOERPER_BERECHNET,
        BFSTATUS_DREIECK_BERECHNET;


        public String toString() {
            switch (this) {
                case BFSTATUS_BEREIT: {
                    return "Bereit";
                }
                case BFSTATUS_GEFUNDEN: {
                    return "Me\u00dfpunkte gefunden";
                }
                case BFSTATUS_BENANNT: {
                    return "Me\u00dfpunkte benannt";
                }
                case BFSTATUS_KALIBRIERT: {
                    return "Kalibriert";
                }
                case BFSTATUS_KOERPER_BERECHNET: {
                    return "K\u00f6rperma\u00dfe berechnet";
                }
                case BFSTATUS_DREIECK_BERECHNET: {
                    return "\"Magisches Dreieck\" berechnet";
                }
            }
            return "";
        }
    }

    private static enum BfStart {
        BFSTART_SUCHE,
        BFSTART_BENENNEN,
        BFSTART_DREIECK;

    }

    private class AngezeigteKoerpermasse
    extends Koerpermasse {
        JTextField[] fldLaengen;

        public AngezeigteKoerpermasse() {
            this.fldLaengen = new JTextField[]{PanKoerper.this.fldLUnterarm, PanKoerper.this.fldLOberarm, PanKoerper.this.fldLOberkoerper, PanKoerper.this.fldLOberschenkel, PanKoerper.this.fldLUnterschenkel};
        }

        public void set(Koerpermasse koerpermasse) {
            this.oa = koerpermasse.oa;
            this.ok = koerpermasse.ok;
            this.os = koerpermasse.os;
            this.ua = koerpermasse.ua;
            this.usf = koerpermasse.usf;
        }

        public boolean getInput() throws YUserException {
            for (JTextField fldLaenge : this.fldLaengen) {
                if (fldLaenge.getText().length() != 0) continue;
                PanKoerper.this.cmdDreieckBerechnen.setEnabled(false);
                return false;
            }
            PanKoerper.this.cmdDreieckBerechnen.setEnabled(true);
            boolean iLUnterarm = false;
            boolean iLOberarm = true;
            int iLOberkoerper = 2;
            int iLOberschenkel = 3;
            int iLUnterschenkel = 4;
            int[] massIdx = new int[]{0, 1, 2, 3, 4};
            NumberFormat fmt = NumberFormat.getNumberInstance(PanKoerper.this.session.getLocale());
            int iErr = 0;
            try {
                block10: for (int idx : massIdx) {
                    String text = this.fldLaengen[idx].getText();
                    if (!Pattern.matches("[0-9]+", text) && !Pattern.matches("[0-9]+[.,][0-9]*", text)) {
                        iErr = idx;
                        throw new YUserException("Ung\u00fcltige Zahl: " + this.fldLaengen[iErr].getText());
                    }
                    float l = fmt.parse(text).floatValue();
                    switch (idx) {
                        case 0: {
                            this.ua = l;
                            continue block10;
                        }
                        case 1: {
                            this.oa = l;
                            continue block10;
                        }
                        case 2: {
                            this.ok = l;
                            continue block10;
                        }
                        case 3: {
                            this.os = l;
                            continue block10;
                        }
                        case 4: {
                            this.usf = l;
                        }
                    }
                }
            }
            catch (ParseException e) {
                throw new YUserException("Ung\u00fcltige Zahl: " + this.fldLaengen[iErr].getText());
            }
            return true;
        }

        public void setInput() {
            PanKoerper.this.fldLUnterarm.setText(String.format("%3.1f", Float.valueOf(this.ua)));
            PanKoerper.this.fldLOberarm.setText(String.format("%3.1f", Float.valueOf(this.oa)));
            PanKoerper.this.fldLOberkoerper.setText(String.format("%3.1f", Float.valueOf(this.ok)));
            PanKoerper.this.fldLOberschenkel.setText(String.format("%3.1f", Float.valueOf(this.os)));
            PanKoerper.this.fldLUnterschenkel.setText(String.format("%3.1f", Float.valueOf(this.usf)));
            PanKoerper.this.cmdDreieckBerechnen.setEnabled(true);
        }
    }

    private class VerwalteteParameter
    extends Parameter {
        private YConfigFile configFile;
        public boolean benutzeHoehenmasse;

        public VerwalteteParameter(YConfigFile configFile) {
            this.configFile = configFile;
            this.getFromConfig();
        }

        public void getFromConfig(Parametergruppe gruppe) {
            try {
                switch (gruppe) {
                    case KALIBRIERUNG: {
                        this.blickrichtungRechts = this.configFile.getEntry("blickrichtung", "rechts").equals("rechts");
                        this.abstandKalibrierungspunkte = this.configFile.entryExists("abstandKalibrierungspunkte") ? Float.parseFloat(this.configFile.getEntry("abstandKalibrierungspunkte", "70")) : Float.parseFloat(this.configFile.getEntry("abstandSitzGriff", "70"));
                        this.offsetHuefteX = Float.parseFloat(this.configFile.getEntry("offsetHuefteX", "5"));
                        this.offsetHuefteY = Float.parseFloat(this.configFile.getEntry("offsetHuefteY", "15"));
                        this.offsetFussX = Float.parseFloat(this.configFile.getEntry("offsetFussX", "2.5"));
                        this.offsetFussY = Float.parseFloat(this.configFile.getEntry("offsetFussY", "3"));
                        this.offsetHandX = Float.parseFloat(this.configFile.getEntry("offsetHandX", "0"));
                        this.offsetHandY = Float.parseFloat(this.configFile.getEntry("offsetHandY", "0"));
                        this.hueftabstand = Float.parseFloat(this.configFile.getEntry("hueftabstand", "8"));
                        this.kurbellaenge = Float.parseFloat(this.configFile.getEntry("pedallaenge", "17"));
                        this.rahmenwinkel = Float.parseFloat(this.configFile.getEntry("rahmenwinkel", "72"));
                        this.abstandLenksaeule = Float.parseFloat(this.configFile.getEntry("abstandLenksaeule", "45.5"));
                        break;
                    }
                    case MESSPUNKTSUCHE: {
                        switch (Integer.parseInt(this.configFile.getEntry("autosuche", "5"))) {
                            case 0: {
                                this.autosuche = 0;
                                break;
                            }
                            case 6: {
                                this.autosuche = 8;
                                break;
                            }
                            default: {
                                this.autosuche = 5;
                            }
                        }
                        this.minVInnenConf = Integer.parseInt(this.configFile.getEntry("minVInnen", "90"));
                        this.minVKoronaConf = Integer.parseInt(this.configFile.getEntry("minVKorona", "3"));
                        this.minSKoronaConf = Integer.parseInt(this.configFile.getEntry("minSKorona", "35"));
                        this.minHKorona = Integer.parseInt(this.configFile.getEntry("minHKorona", "335"));
                        this.maxHKorona = Integer.parseInt(this.configFile.getEntry("maxHKorona", "348"));
                        this.minRInnen = Integer.parseInt(this.configFile.getEntry("minRInnen", "3"));
                        this.minBKorona = Integer.parseInt(this.configFile.getEntry("minBKorona", "3"));
                        this.maxRAussen = Integer.parseInt(this.configFile.getEntry("maxRAussen", "12"));
                        this.minVInnen = HSVWert.svlTo255(this.minVInnenConf);
                        this.minVKorona = HSVWert.svlTo255(this.minVKoronaConf);
                        this.minSKorona = HSVWert.svlTo255(this.minSKoronaConf);
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void getFromConfig() {
            for (Parametergruppe gruppe : Parametergruppe.values()) {
                this.getFromConfig(gruppe);
            }
            this.benutzeHoehenmasse = this.configFile.getEntry("HOEHENMASSE", "N").equals("J");
        }

        public void saveToConfig(Parametergruppe gruppe) {
            switch (gruppe) {
                case KALIBRIERUNG: {
                    this.configFile.setEntry("blickrichtung", this.blickrichtungRechts ? "rechts" : "links");
                    this.configFile.setEntry("abstandKalibrierungspunkte", String.valueOf(this.abstandKalibrierungspunkte));
                    this.configFile.setEntry("offsetHuefteX", String.valueOf(this.offsetHuefteX));
                    this.configFile.setEntry("offsetHuefteY", String.valueOf(this.offsetHuefteY));
                    this.configFile.setEntry("offsetFussX", String.valueOf(this.offsetFussX));
                    this.configFile.setEntry("offsetFussY", String.valueOf(this.offsetFussY));
                    this.configFile.setEntry("offsetHandX", String.valueOf(this.offsetHandX));
                    this.configFile.setEntry("offsetHandY", String.valueOf(this.offsetHandY));
                    this.configFile.setEntry("hueftabstand", String.valueOf(this.hueftabstand));
                    this.configFile.setEntry("pedallaenge", String.valueOf(this.kurbellaenge));
                    this.configFile.setEntry("rahmenwinkel", String.valueOf(this.rahmenwinkel));
                    this.configFile.setEntry("abstandLenksaeule", String.valueOf(this.abstandLenksaeule));
                    break;
                }
                case MESSPUNKTSUCHE: {
                    switch (this.autosuche) {
                        case 0: {
                            this.configFile.setEntry("autosuche", "0");
                            break;
                        }
                        case 6: {
                            this.configFile.setEntry("autosuche", "6");
                            break;
                        }
                        default: {
                            this.configFile.setEntry("autosuche", "3");
                        }
                    }
                    this.configFile.setEntry("minVInnen", String.valueOf(this.minVInnenConf));
                    this.configFile.setEntry("minVKorona", String.valueOf(this.minVKoronaConf));
                    this.configFile.setEntry("minSKorona", String.valueOf(this.minSKoronaConf));
                    this.configFile.setEntry("minHKorona", String.valueOf(this.minHKorona));
                    this.configFile.setEntry("maxHKorona", String.valueOf(this.maxHKorona));
                    this.configFile.setEntry("minRInnen", String.valueOf(this.minRInnen));
                    this.configFile.setEntry("minBKorona", String.valueOf(this.minBKorona));
                    this.configFile.setEntry("maxRAussen", String.valueOf(this.maxRAussen));
                    break;
                }
            }
        }

        public void saveToConfig() {
            for (Parametergruppe gruppe : Parametergruppe.values()) {
                this.saveToConfig(gruppe);
            }
            this.configFile.setEntry("HOEHENMASSE", this.benutzeHoehenmasse ? "J" : "N");
        }

        public void getFromInput() {
            float[] werte = new float[11];
            try {
                int i = 0;
                for (JTextField f : new JTextField[]{PanKoerper.this.fldAbstandKalibrierungspunkte, PanKoerper.this.fldOffsetFussX, PanKoerper.this.fldOffsetFussY, PanKoerper.this.fldOffsetHandX, PanKoerper.this.fldOffsetHandY, PanKoerper.this.fldOffsetHuefteX, PanKoerper.this.fldOffsetHuefteY, PanKoerper.this.fldHueftabstand, PanKoerper.this.fldPedallaenge, PanKoerper.this.fldRahmenwinkel, PanKoerper.this.fldAbstandLenksaeule}) {
                    werte[i++] = Float.parseFloat(f.getText().replace(',', '.'));
                }
                this.abstandKalibrierungspunkte = werte[0];
                this.offsetFussX = werte[1];
                this.offsetFussY = werte[2];
                this.offsetHandX = werte[3];
                this.offsetHandY = werte[4];
                this.offsetHuefteX = werte[5];
                this.offsetHuefteY = werte[6];
                this.hueftabstand = werte[7];
                this.kurbellaenge = werte[8];
                this.rahmenwinkel = werte[9];
                this.abstandLenksaeule = werte[10];
                this.blickrichtungRechts = PanKoerper.this.rbBlickRechts.isSelected();
                this.autosuche = PanKoerper.this.rbManuell.isSelected() ? 0 : (PanKoerper.this.rbVollautomatisch.isSelected() ? 6 : 3);
                this.minVInnenConf = Integer.parseInt(PanKoerper.this.fldVminInnen.getText());
                this.minVKoronaConf = Integer.parseInt(PanKoerper.this.fldVminKorona.getText());
                this.minSKoronaConf = Integer.parseInt(PanKoerper.this.fldSminKorona.getText());
                this.minHKorona = Integer.parseInt(PanKoerper.this.fldHminKorona.getText());
                this.maxHKorona = Integer.parseInt(PanKoerper.this.fldHmaxKorona.getText());
                this.minRInnen = Integer.parseInt(PanKoerper.this.fldRminInnen.getText());
                this.minBKorona = Integer.parseInt(PanKoerper.this.fldBminKorona.getText());
                this.maxRAussen = Integer.parseInt(PanKoerper.this.fldRmaxAussen.getText());
                this.minVInnen = HSVWert.svlTo255(this.minVInnenConf);
                this.minVKorona = HSVWert.svlTo255(this.minVKoronaConf);
                this.minSKorona = HSVWert.svlTo255(this.minSKoronaConf);
                this.benutzeHoehenmasse = PanKoerper.this.cbHoehenmasse.isSelected();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void setInput(Parametergruppe gruppe) {
            switch (gruppe) {
                case KALIBRIERUNG: {
                    if (this.blickrichtungRechts) {
                        PanKoerper.this.rbBlickRechts.setSelected(true);
                    } else {
                        PanKoerper.this.rbBlickLinks.setSelected(true);
                    }
                    Object[][] kalib = new Object[][]{{PanKoerper.this.fldAbstandKalibrierungspunkte, Float.valueOf(this.abstandKalibrierungspunkte)}, {PanKoerper.this.fldRahmenwinkel, Float.valueOf(this.rahmenwinkel)}, {PanKoerper.this.fldOffsetFussX, Float.valueOf(this.offsetFussX)}, {PanKoerper.this.fldOffsetFussY, Float.valueOf(this.offsetFussY)}, {PanKoerper.this.fldOffsetHandX, Float.valueOf(this.offsetHandX)}, {PanKoerper.this.fldOffsetHandY, Float.valueOf(this.offsetHandY)}, {PanKoerper.this.fldOffsetHuefteX, Float.valueOf(this.offsetHuefteX)}, {PanKoerper.this.fldOffsetHuefteY, Float.valueOf(this.offsetHuefteY)}, {PanKoerper.this.fldHueftabstand, Float.valueOf(this.hueftabstand)}, {PanKoerper.this.fldPedallaenge, Float.valueOf(this.kurbellaenge)}, {PanKoerper.this.fldAbstandLenksaeule, Float.valueOf(this.abstandLenksaeule)}};
                    for (int i = 0; i < kalib.length; ++i) {
                        ((JTextField)kalib[i][0]).setText(String.valueOf(kalib[i][1]).replace('.', ','));
                    }
                    break;
                }
                case MESSPUNKTSUCHE: {
                    switch (this.autosuche) {
                        case 0: {
                            PanKoerper.this.rbManuell.setSelected(true);
                            break;
                        }
                        case 6: {
                            PanKoerper.this.rbVollautomatisch.setSelected(true);
                            break;
                        }
                        default: {
                            PanKoerper.this.rbNurFahrrad.setSelected(true);
                        }
                    }
                    PanKoerper.this.fldVminInnen.setText(String.valueOf(this.minVInnenConf));
                    PanKoerper.this.fldVminKorona.setText(String.valueOf(this.minVKoronaConf));
                    PanKoerper.this.fldSminKorona.setText(String.valueOf(this.minSKoronaConf));
                    PanKoerper.this.fldHminKorona.setText(String.valueOf(this.minHKorona));
                    PanKoerper.this.fldHmaxKorona.setText(String.valueOf(this.maxHKorona));
                    PanKoerper.this.fldRminInnen.setText(String.valueOf(this.minRInnen));
                    PanKoerper.this.fldBminKorona.setText(String.valueOf(this.minBKorona));
                    PanKoerper.this.fldRmaxAussen.setText(String.valueOf(this.maxRAussen));
                    break;
                }
            }
        }

        public void setInput() {
            for (Parametergruppe gruppe : Parametergruppe.values()) {
                this.setInput(gruppe);
            }
            PanKoerper.this.cbHoehenmasse.setSelected(this.benutzeHoehenmasse);
        }
    }

    public static enum Parametergruppe {
        KALIBRIERUNG,
        MESSPUNKTSUCHE;

    }
}

