/*
 * Decompiled with CFR 0.152.
 */
package popometer.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import popometer.FrmNavigator;
import popometer.YPopometerSession;
import popometer.dbobjects.YROAnfrage;
import popometer.dbobjects.YROKunde;
import projektY.base.YException;
import projektY.database.YColumnDefinition;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDatabaseList;
import projektY.database.YDatabaseObject;
import projektY.database.YEvaluationList;
import projektY.database.YFieldValue;
import projektY.database.YSession;
import projektY.swing.YJPanelManager;
import projektY.swing.YJTableManager;

public class PanKundendaten
extends JPanel {
    private YPopometerSession session;
    private FrmNavigator navigator;
    private YEvaluationList evKundenliste;
    private YROKunde kunde;
    private YROAnfrage anfrage;
    private YEvaluationList evLetzteAnfrage;
    private int iRowKundeSelected;
    private JComboBox cmbAnfrageStatus;
    private JComboBox cmbLand;
    private JButton cmdKundeCancel;
    private JButton cmdKundeClear;
    private JButton cmdKundeDelete;
    private JButton cmdKundePost;
    private JButton cmdLetzteAnfrage;
    private JButton cmdStatus;
    private JButton cmdSuchen;
    private JButton cmdWiederHerstellen;
    private JTextField fldEmail;
    private JTextField fldKundennr;
    private JTextField fldName;
    private JTextField fldOrt;
    private JTextField fldPlz;
    private JTextField fldStrNr;
    private JTextField fldSucheKundennr;
    private JTextField fldSucheName;
    private JTextField fldSucheVorname;
    private JTextField fldTelefon;
    private JTextField fldVorname;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar1;
    private JLabel lblBestelldatum;
    private JLabel lblBestellstatus;
    private JLabel lblKundenNr;
    private JLabel lblLetzteAnfrage;
    private JLabel lblMoreResults;
    private JLabel lblNachname;
    private JLabel lblVorbestellt;
    private JLabel lblVorname;
    private JLabel lblWillkommen;
    private JPanel panButtons;
    private JPanel panGefKunden;
    private JPanel panKundendaten;
    private JPanel panKundensuche;
    private JPanel panLetzteAnfrage;
    private JPanel panLinks;
    private JPanel panRechts;
    private JPanel panSpace;
    private JPanel panWillkommen;
    private JScrollPane scrlKundenliste;
    private JTable tblKundenliste;

    public PanKundendaten(YPopometerSession session, YROKunde kunde, YROAnfrage anfrage, FrmNavigator navigator) throws YException {
        this.session = session;
        this.navigator = navigator;
        this.initComponents();
        this.evKundenliste = new YEvaluationList((YSession)session, 4, 50);
        this.evKundenliste.addDBField("kunde_id", YColumnDefinition.FieldType.INT);
        this.evKundenliste.addDBField("name", YColumnDefinition.FieldType.STRING).setLabel("Name");
        this.evKundenliste.addDBField("vorname", YColumnDefinition.FieldType.STRING).setLabel("Vorname");
        this.evKundenliste.addDBField("ort", YColumnDefinition.FieldType.STRING).setLabel("Ort");
        this.evKundenliste.setSqlSelect("SELECT kunde_id, vorname, name, ort FROM vh_kunden");
        this.evKundenliste.setOrder(new String[]{"name", "vorname"});
        this.evKundenliste.addFilter("name", "name LIKE :value:||'%'", YColumnDefinition.FieldType.STRING);
        this.evKundenliste.addFilter("vorname", "vorname LIKE :value:||'%'", YColumnDefinition.FieldType.STRING);
        this.evKundenliste.addFilter("kundennr", "kundennr=:value:", YColumnDefinition.FieldType.STRING);
        this.evKundenliste.setDispFields(new String[]{"vorname", "name", "ort"});
        this.evKundenliste.finalize();
        this.evKundenliste.setMaxRows(50);
        this.evLetzteAnfrage = new YEvaluationList((YSession)session, 2, 1);
        this.evLetzteAnfrage.addDBField("anfrage_id", YColumnDefinition.FieldType.INT);
        this.evLetzteAnfrage.addDBField("datum", YColumnDefinition.FieldType.DATE);
        this.evLetzteAnfrage.setSqlSelect("SELECT anfrage_id, datum FROM vh_anfragen");
        this.evLetzteAnfrage.addFilter("kunde_id", "kunde_id=:value:", YColumnDefinition.FieldType.INT);
        this.evLetzteAnfrage.addFilter("kunde_id_datum", "datum=(SELECT MAX(datum) FROM vh_anfragen WHERE kunde_id=:value:)", YColumnDefinition.FieldType.INT);
        this.evLetzteAnfrage.setOrder(new String[]{"anfrage_id"}, true);
        this.evLetzteAnfrage.finalize();
        YEvaluationList evBenutzer = new YEvaluationList((YSession)session, 2);
        evBenutzer.addDBField("vorname", YColumnDefinition.FieldType.STRING);
        evBenutzer.addDBField("name", YColumnDefinition.FieldType.STRING);
        evBenutzer.setSqlSelect("SELECT vorname, name FROM vh_personen WHERE pers_id=GetBenutzerId()");
        evBenutzer.finalize();
        evBenutzer.fetch();
        if (evBenutzer.getRowCount() > 0) {
            this.lblWillkommen.setText("Ergonomic Expert " + evBenutzer.getAsString(0, "vorname") + " " + evBenutzer.getAsString(0, "name"));
        } else {
            this.lblWillkommen.setText("Ergonomic Expert");
        }
        this.kunde = kunde;
        this.anfrage = anfrage;
        YJPanelManager.createPanelManager((JPanel)this.panKundendaten, (YDatabaseObject)kunde);
        YJPanelManager.createPanelManager((JPanel)this.panLetzteAnfrage, (YDatabaseObject)anfrage);
        this.cmbAnfrageStatus.setEnabled(false);
        ResourceBundle bundle = ResourceBundle.getBundle("popometer/resourcen/de");
        this.panKundensuche.setBorder(BorderFactory.createTitledBorder(bundle.getString("Kundensuche")));
        YJTableManager.createTableManager((JTable)this.tblKundenliste, (YDatabaseList)this.evKundenliste, (boolean)true);
        this.tblKundenliste.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                PanKundendaten.this.tblKundenlisteSelectionChanged(e);
            }
        });
        this.lblMoreResults.setVisible(false);
    }

    public boolean hasChanged() throws YException {
        return this.kunde.hasChanged();
    }

    private void tblKundenlisteSelectionChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        try {
            int a;
            int iRow = this.evKundenliste.getActiveRow();
            if (iRow < 0) {
                this.iRowKundeSelected = -1;
                return;
            }
            if (this.kunde.hasChanged() && (a = JOptionPane.showConfirmDialog(this, "\u00c4nderungen an '" + this.kunde.toString() + "' speichern ?", "\u00c4nderungen", 0)) == 0) {
                this.kunde.post();
                if (this.iRowKundeSelected >= 0) {
                    iRow = this.iRowKundeSelected;
                    this.evKundenliste.setAsString(iRow, "vorname", this.kunde.getAsString("vorname"));
                    this.evKundenliste.setAsString(iRow, "name", this.kunde.getAsString("name"));
                    this.evKundenliste.setAsString(iRow, "ort", this.kunde.getAsString("ort"));
                    this.evKundenliste.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, iRow, iRow));
                }
            }
            int kundeId = this.evKundenliste.getAsInt(iRow, "kunde_id");
            this.kunde.fetch(kundeId);
            this.iRowKundeSelected = iRow;
            this.cmdLetzteAnfrage.setEnabled(true);
            this.lblLetzteAnfrage.setText("<-- Click");
            this.cmdWiederHerstellen.setEnabled(false);
            this.letzteAnfrageLoeschen();
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.panLinks = new JPanel();
        this.panWillkommen = new JPanel();
        this.lblWillkommen = new JLabel();
        this.panKundensuche = new JPanel();
        this.lblKundenNr = new JLabel();
        this.lblVorname = new JLabel();
        this.lblNachname = new JLabel();
        this.fldSucheKundennr = new JTextField();
        this.fldSucheVorname = new JTextField();
        this.fldSucheName = new JTextField();
        this.cmdSuchen = new JButton();
        this.jLabel12 = new JLabel();
        this.lblMoreResults = new JLabel();
        this.panGefKunden = new JPanel();
        this.scrlKundenliste = new JScrollPane();
        this.tblKundenliste = new JTable();
        this.jPanel3 = new JPanel();
        this.panRechts = new JPanel();
        this.panKundendaten = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.fldKundennr = new JTextField();
        this.fldVorname = new JTextField();
        this.fldName = new JTextField();
        this.fldTelefon = new JTextField();
        this.fldEmail = new JTextField();
        this.fldStrNr = new JTextField();
        this.fldPlz = new JTextField();
        this.fldOrt = new JTextField();
        this.cmbLand = new JComboBox();
        this.jToolBar1 = new JToolBar();
        this.cmdKundeClear = new JButton();
        this.cmdKundeDelete = new JButton();
        this.cmdKundePost = new JButton();
        this.cmdKundeCancel = new JButton();
        this.panButtons = new JPanel();
        this.jPanel2 = new JPanel();
        this.panLetzteAnfrage = new JPanel();
        this.cmdLetzteAnfrage = new JButton();
        this.jLabel1 = new JLabel();
        this.lblLetzteAnfrage = new JLabel();
        this.cmdWiederHerstellen = new JButton();
        this.jLabel13 = new JLabel();
        this.lblVorbestellt = new JLabel();
        this.jLabel11 = new JLabel();
        this.lblBestelldatum = new JLabel();
        this.lblBestellstatus = new JLabel();
        this.cmbAnfrageStatus = new JComboBox();
        this.cmdStatus = new JButton();
        this.panSpace = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.panLinks.setLayout(new GridBagLayout());
        this.panWillkommen.setBorder(BorderFactory.createTitledBorder("Willkommen"));
        this.panWillkommen.setLayout(new GridBagLayout());
        this.lblWillkommen.setText("Hallo Herr Mustermann");
        this.panWillkommen.add((Component)this.lblWillkommen, new GridBagConstraints());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.panLinks.add((Component)this.panWillkommen, gridBagConstraints);
        this.panKundensuche.setBorder(BorderFactory.createTitledBorder("Kundensuche"));
        this.panKundensuche.setLayout(new GridBagLayout());
        this.lblKundenNr.setText("Kundennummer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundensuche.add((Component)this.lblKundenNr, gridBagConstraints);
        this.lblVorname.setText("Vorname:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundensuche.add((Component)this.lblVorname, gridBagConstraints);
        this.lblNachname.setText("Nachname:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundensuche.add((Component)this.lblNachname, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundensuche.add((Component)this.fldSucheKundennr, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundensuche.add((Component)this.fldSucheVorname, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundensuche.add((Component)this.fldSucheName, gridBagConstraints);
        this.cmdSuchen.setText("Suchen");
        this.cmdSuchen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanKundendaten.this.cmdSuchenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundensuche.add((Component)this.cmdSuchen, gridBagConstraints);
        this.jLabel12.setText("(max. 50 Treffer)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panKundensuche.add((Component)this.jLabel12, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.panLinks.add((Component)this.panKundensuche, gridBagConstraints);
        this.lblMoreResults.setText("Es wurden noch mehr Kunden gefunden.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.panLinks.add((Component)this.lblMoreResults, gridBagConstraints);
        this.panGefKunden.setBorder(BorderFactory.createTitledBorder("Gefundene Kunden"));
        this.panGefKunden.setPreferredSize(new Dimension(460, 280));
        this.panGefKunden.setLayout(new GridBagLayout());
        this.scrlKundenliste.setBackground(new Color(255, 255, 255));
        this.scrlKundenliste.setBorder(null);
        this.tblKundenliste.getSelectionModel().setSelectionMode(0);
        this.scrlKundenliste.setViewportView(this.tblKundenliste);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panGefKunden.add((Component)this.scrlKundenliste, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.panLinks.add((Component)this.panGefKunden, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.panLinks.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.panLinks, gridBagConstraints);
        this.panRechts.setLayout(new GridBagLayout());
        this.panKundendaten.setBorder(BorderFactory.createTitledBorder("Kundendaten"));
        this.panKundendaten.setLayout(new GridBagLayout());
        this.jLabel2.setText("Kundennummer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundendaten.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("Vorname:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundendaten.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("Nachname:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundendaten.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText("Telefon:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundendaten.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText("E-Mail:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundendaten.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setText("Stra\u00dfe/Nr:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundendaten.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel8.setText("Postleitzahl:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundendaten.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel9.setText("Ort:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundendaten.add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel10.setText("Land:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundendaten.add((Component)this.jLabel10, gridBagConstraints);
        this.fldKundennr.setFont(new Font("SansSerif", 0, 12));
        this.fldKundennr.setName("kundennr");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundendaten.add((Component)this.fldKundennr, gridBagConstraints);
        this.fldVorname.setFont(new Font("SansSerif", 0, 12));
        this.fldVorname.setName("vorname");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundendaten.add((Component)this.fldVorname, gridBagConstraints);
        this.fldName.setFont(new Font("SansSerif", 0, 12));
        this.fldName.setName("name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundendaten.add((Component)this.fldName, gridBagConstraints);
        this.fldTelefon.setFont(new Font("SansSerif", 0, 12));
        this.fldTelefon.setName("telefon");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundendaten.add((Component)this.fldTelefon, gridBagConstraints);
        this.fldEmail.setFont(new Font("SansSerif", 0, 12));
        this.fldEmail.setName("email");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundendaten.add((Component)this.fldEmail, gridBagConstraints);
        this.fldStrNr.setFont(new Font("SansSerif", 0, 12));
        this.fldStrNr.setName("str_nr");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundendaten.add((Component)this.fldStrNr, gridBagConstraints);
        this.fldPlz.setFont(new Font("SansSerif", 0, 12));
        this.fldPlz.setName("plz");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundendaten.add((Component)this.fldPlz, gridBagConstraints);
        this.fldOrt.setFont(new Font("SansSerif", 0, 12));
        this.fldOrt.setName("ort");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundendaten.add((Component)this.fldOrt, gridBagConstraints);
        this.cmbLand.setFont(this.cmbLand.getFont());
        this.cmbLand.setName("land_kz");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundendaten.add((Component)this.cmbLand, gridBagConstraints);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setBorderPainted(false);
        this.jToolBar1.setMargin(new Insets(5, 5, 5, 0));
        this.jToolBar1.setMaximumSize(new Dimension(28, 28));
        this.jToolBar1.setMinimumSize(new Dimension(1000, 1000));
        this.jToolBar1.setOpaque(false);
        this.jToolBar1.setPreferredSize(new Dimension(40, 40));
        this.cmdKundeClear.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/new.gif")));
        this.cmdKundeClear.setToolTipText("Neuer Kunde");
        this.cmdKundeClear.setFocusable(false);
        this.cmdKundeClear.setHorizontalTextPosition(0);
        this.cmdKundeClear.setVerticalTextPosition(3);
        this.cmdKundeClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanKundendaten.this.cmdKundeClearActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdKundeClear);
        this.cmdKundeDelete.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/muelleimer.png")));
        this.cmdKundeDelete.setToolTipText("Kunde l\u00f6schen");
        this.cmdKundeDelete.setFocusable(false);
        this.cmdKundeDelete.setHorizontalTextPosition(0);
        this.cmdKundeDelete.setVerticalTextPosition(3);
        this.cmdKundeDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanKundendaten.this.cmdKundeDeleteActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdKundeDelete);
        this.cmdKundePost.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/save.gif")));
        this.cmdKundePost.setToolTipText("Speichern");
        this.cmdKundePost.setFocusable(false);
        this.cmdKundePost.setHorizontalTextPosition(0);
        this.cmdKundePost.setVerticalTextPosition(3);
        this.cmdKundePost.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanKundendaten.this.cmdKundePostActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdKundePost);
        this.cmdKundeCancel.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/undo.gif")));
        this.cmdKundeCancel.setToolTipText("Verwerfen");
        this.cmdKundeCancel.setFocusable(false);
        this.cmdKundeCancel.setHorizontalTextPosition(0);
        this.cmdKundeCancel.setVerticalTextPosition(3);
        this.cmdKundeCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanKundendaten.this.cmdKundeCancelActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdKundeCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panKundendaten.add((Component)this.jToolBar1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.panRechts.add((Component)this.panKundendaten, gridBagConstraints);
        this.panButtons.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.panButtons.add((Component)this.jPanel2, gridBagConstraints);
        this.panLetzteAnfrage.setBorder(BorderFactory.createTitledBorder("Letzte Anfragen"));
        this.panLetzteAnfrage.setLayout(new GridBagLayout());
        this.cmdLetzteAnfrage.setText("Letzte Anfrage am:");
        this.cmdLetzteAnfrage.setEnabled(false);
        this.cmdLetzteAnfrage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanKundendaten.this.cmdLetzteAnfrageActionPerformed(evt);
            }
        });
        this.panLetzteAnfrage.add((Component)this.cmdLetzteAnfrage, new GridBagConstraints());
        this.jLabel1.setText("Anfragestatus:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.panLetzteAnfrage.add((Component)this.jLabel1, gridBagConstraints);
        this.lblLetzteAnfrage.setHorizontalAlignment(0);
        this.lblLetzteAnfrage.setText("<--- Click");
        this.lblLetzteAnfrage.setPreferredSize(new Dimension(120, 14));
        this.panLetzteAnfrage.add((Component)this.lblLetzteAnfrage, new GridBagConstraints());
        this.cmdWiederHerstellen.setText("Wieder herstellen");
        this.cmdWiederHerstellen.setEnabled(false);
        this.cmdWiederHerstellen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanKundendaten.this.cmdWiederHerstellenActionPerformed(evt);
            }
        });
        this.panLetzteAnfrage.add((Component)this.cmdWiederHerstellen, new GridBagConstraints());
        this.jLabel13.setText("Bestellt:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.panLetzteAnfrage.add((Component)this.jLabel13, gridBagConstraints);
        this.lblVorbestellt.setName("vorbestellt");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panLetzteAnfrage.add((Component)this.lblVorbestellt, gridBagConstraints);
        this.jLabel11.setText("Bestelldatum:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.panLetzteAnfrage.add((Component)this.jLabel11, gridBagConstraints);
        this.lblBestelldatum.setName("bestelldatum");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panLetzteAnfrage.add((Component)this.lblBestelldatum, gridBagConstraints);
        this.lblBestellstatus.setName("bestellstatus");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.panLetzteAnfrage.add((Component)this.lblBestellstatus, gridBagConstraints);
        this.cmbAnfrageStatus.setEnabled(false);
        this.cmbAnfrageStatus.setName("status");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.panLetzteAnfrage.add((Component)this.cmbAnfrageStatus, gridBagConstraints);
        this.cmdStatus.setText("\u00c4ndern");
        this.cmdStatus.setEnabled(false);
        this.cmdStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanKundendaten.this.cmdStatusActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panLetzteAnfrage.add((Component)this.cmdStatus, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.panButtons.add((Component)this.panLetzteAnfrage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panButtons.add((Component)this.panSpace, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panRechts.add((Component)this.panButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.panRechts, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void letzteAnfrageLoeschen() {
        this.lblVorbestellt.setText("(Produktbezeichnung)");
        this.lblBestelldatum.setText("");
        this.lblBestellstatus.setText("");
        this.cmbAnfrageStatus.setSelectedItem(null);
        this.cmbAnfrageStatus.setEnabled(false);
        this.cmdStatus.setEnabled(false);
    }

    private void cmdSuchenActionPerformed(ActionEvent evt) {
        try {
            this.evKundenliste.clearFilterValues();
            if (this.fldSucheKundennr.getText().length() > 0) {
                this.evKundenliste.setFilterValue("kundennr", this.fldSucheKundennr.getText());
            }
            if (this.fldSucheName.getText().length() > 0) {
                this.evKundenliste.setFilterValue("name", this.fldSucheName.getText());
            }
            if (this.fldSucheVorname.getText().length() > 0) {
                this.evKundenliste.setFilterValue("vorname", this.fldSucheVorname.getText());
            }
            this.lblMoreResults.setVisible(false);
            this.evKundenliste.fetch();
            this.lblMoreResults.setVisible(this.evKundenliste.hasMoreRows());
            this.cmdLetzteAnfrage.setEnabled(false);
            this.lblLetzteAnfrage.setText("<-- Click");
            this.cmdWiederHerstellen.setEnabled(false);
            this.letzteAnfrageLoeschen();
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdKundeClearActionPerformed(ActionEvent evt) {
        try {
            this.kunde.clear();
            this.iRowKundeSelected = -1;
            this.cmdLetzteAnfrage.setEnabled(false);
            this.lblLetzteAnfrage.setText("<-- Click");
            this.cmdWiederHerstellen.setEnabled(false);
            this.letzteAnfrageLoeschen();
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdKundeDeleteActionPerformed(ActionEvent evt) {
        try {
            YFieldValue fieldValue = this.kunde.getPkFieldValue();
            if (fieldValue.wasNull()) {
                this.kunde.clear();
            } else {
                int a = JOptionPane.showConfirmDialog(this, this.kunde.toString() + " l\u00f6schen ?", "Best\u00e4tigung", 0);
                if (a == 1) {
                    return;
                }
                this.kunde.delete();
            }
            if (this.iRowKundeSelected >= 0) {
                int iRow = this.iRowKundeSelected;
                this.evKundenliste.removeRow(iRow);
            }
            this.cmdLetzteAnfrage.setEnabled(false);
            this.lblLetzteAnfrage.setText("<-- Click");
            this.cmdWiederHerstellen.setEnabled(false);
            this.letzteAnfrageLoeschen();
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdKundeCancelActionPerformed(ActionEvent evt) {
        try {
            this.kunde.revert();
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdKundePostActionPerformed(ActionEvent evt) {
        int iRow = this.tblKundenliste.getSelectedRow();
        try {
            this.kunde.post();
            if (iRow < 0) {
                return;
            }
            if (this.kunde.getPkFieldValueAsInt() != this.evKundenliste.getAsInt(iRow, "kunde_id")) {
                return;
            }
            this.evKundenliste.setAsString(iRow, "vorname", this.kunde.getAsString("vorname"));
            this.evKundenliste.setAsString(iRow, "name", this.kunde.getAsString("name"));
            this.evKundenliste.setAsString(iRow, "ort", this.kunde.getAsString("ort"));
            this.evKundenliste.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, iRow, iRow));
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdLetzteAnfrageActionPerformed(ActionEvent evt) {
        try {
            int kunde_id = this.kunde.getAsInt("kunde_id", 0);
            this.evLetzteAnfrage.setFilterValue("kunde_id", String.valueOf(kunde_id));
            this.evLetzteAnfrage.setFilterValue("kunde_id_datum", String.valueOf(kunde_id));
            this.evLetzteAnfrage.fetch();
            if (this.evLetzteAnfrage.getRowCount() == 0) {
                JOptionPane.showMessageDialog(this, "Es wurde noch keine Anfrage gespeichert.");
            } else {
                this.lblLetzteAnfrage.setText(this.evLetzteAnfrage.getAsString(0, "datum"));
                this.cmdWiederHerstellen.setEnabled(true);
            }
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdWiederHerstellenActionPerformed(ActionEvent evt) {
        try {
            if (!this.navigator.zeigeAnfrage(this.evLetzteAnfrage.getAsInt(0, "anfrage_id", 0))) {
                JOptionPane.showMessageDialog(this, "Einige Bedingungen aufgrund Konfigurations\u00e4nderung nicht gesetzt.", "Hinweis", 1);
            }
            boolean bestellungVorhanden = !this.anfrage.getFieldValue("bestelldatum").isNull();
            this.cmbAnfrageStatus.setEnabled(bestellungVorhanden);
            this.cmdStatus.setEnabled(bestellungVorhanden);
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdStatusActionPerformed(ActionEvent evt) {
        try {
            this.anfrage.requestValuesToStore();
            if (!this.anfrage.getFieldValue("status").hasChanged()) {
                JOptionPane.showMessageDialog(this, "Der Status wurde nicht ge\u00e4ndert.");
                return;
            }
            this.anfrage.post();
            JOptionPane.showMessageDialog(this, "Der Status wurde ge\u00e4ndert.");
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }
}

