/*
 * Decompiled with CFR 0.152.
 */
package popometer.swing;

import java.awt.Component;
import java.awt.Frame;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableCellRenderer;
import projektY.base.YException;
import projektY.base.YUserException;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDBOChangeEventListener;
import projektY.database.YRowObject;
import projektY.database.YSession;

public abstract class YJRowPanel
extends JPanel
implements YDBOChangeEventListener {
    protected YSession session;
    protected Frame frame;
    protected AlignRightCellRenderer alignRightCellRenderer;
    private YRowObject rowObject;
    private String label;

    public YJRowPanel(Frame frame, YRowObject rowObject, String label) throws YException {
        this.frame = frame;
        this.rowObject = rowObject;
        this.session = rowObject.getSession();
        rowObject.addChangeEventListener((YDBOChangeEventListener)this);
        this.label = label;
        this.alignRightCellRenderer = new AlignRightCellRenderer();
    }

    public YJRowPanel(Frame frame, YRowObject rowObject) throws YException {
        this(frame, rowObject, "");
    }

    protected YJRowPanel() {
    }

    public String getLabel() {
        return this.label;
    }

    public abstract void storeFields() throws YException;

    public abstract void loadFields() throws YException;

    public void panActivated() {
    }

    public void panDeactivated() {
    }

    public void panClosing() {
    }

    public boolean hasChanged() throws YException {
        return this.rowObject.hasChanged();
    }

    protected void beforePost() throws YException {
    }

    protected void afterPost() throws YException {
    }

    public void post() throws YException {
        this.beforePost();
        this.rowObject.post();
        this.afterPost();
    }

    public void delete() throws YException {
        this.rowObject.delete();
    }

    public void clear() throws YException {
        this.rowObject.clear();
    }

    public void revert() throws YException {
        this.rowObject.revert();
    }

    public void requery() throws YException {
        int a;
        this.storeFields();
        if (this.rowObject.hasChanged() && (a = JOptionPane.showConfirmDialog(this.frame, "Ihre \u00c4nderungen an '" + this.rowObject.toString() + "' gehen beim Aktualisieren verloren.\n" + "M\u00f6chten Sie jetzt abbrechen um zu speichern ?\n" + "(Danach k\u00f6nnen Sie das Aktualisieren wiederholen.)", "Aktualisieren abbrechen ?", 0)) == 0) {
            return;
        }
        this.rowObject.requery();
    }

    protected String format(float f) {
        NumberFormat fmt = NumberFormat.getNumberInstance(this.session.getLocale());
        return fmt.format(f);
    }

    protected float parseFloat(String value) throws YException {
        try {
            NumberFormat fmt = NumberFormat.getNumberInstance(this.session.getLocale());
            Number num = fmt.parse(value);
            return num.floatValue();
        }
        catch (ParseException e) {
            throw new YUserException("Ung\u00fcltige Gleitkommazahl: " + value);
        }
    }

    public YRowObject getRowObject() {
        return this.rowObject;
    }

    protected void enableSubPanel(JPanel panel, boolean enabled) {
        int n = panel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = panel.getComponent(i);
            String className = component.getClass().getName();
            if (className.endsWith("JPanel")) {
                this.enableSubPanel((JPanel)component, enabled);
                continue;
            }
            if (className.endsWith("JScrollPane")) {
                JScrollPane scrollPane = (JScrollPane)component;
                if ((component = scrollPane.getViewport().getView()) == null) continue;
                component.setEnabled(enabled);
                continue;
            }
            component.setEnabled(enabled);
        }
    }

    public void DBObjectChanged(YDBOChangeEvent evt) throws YException {
        this.loadFields();
    }

    public static class AlignRightCellRenderer
    extends DefaultTableCellRenderer {
        public AlignRightCellRenderer() {
            this.setHorizontalAlignment(4);
        }
    }
}

