/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.base.YUserException;
import projektY.database.YColumnDefinition;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDBOChangeEventListener;
import projektY.database.YDBORowRequestListener;
import projektY.database.YFieldValue;
import projektY.database.YRowDefinition;
import projektY.database.YRowObject;
import projektY.database.YRowValues;
import projektY.database.YSQLDml;
import projektY.database.YSQLQuery;
import projektY.database.YSession;

public abstract class YDatabaseObject {
    String name = null;
    protected YSession session;
    protected String sqlSelect;
    protected YRowDefinition rowDefinition;
    protected String tableName;
    protected String tableAlias;
    private boolean readOnly;
    private String label;
    boolean finalized;
    protected YSQLQuery sqlQuery;
    protected YSQLDml sqlDml;
    private Vector<YDBORowRequestListener> rowRequestListeners;
    private Vector<YDBOChangeEventListener> changeEventListeners;
    int changeLevel;
    protected Vector<AssignRule> assignRules;

    protected YDatabaseObject(YSession session, int maxColumns, boolean readOnly) {
        this.session = session;
        this.readOnly = readOnly;
        this.rowDefinition = new YRowDefinition(this, maxColumns);
        this.sqlQuery = new YSQLQuery(session.getDatabase());
        this.sqlDml = new YSQLDml(session.getDatabase());
        this.changeEventListeners = new Vector(20);
        this.rowRequestListeners = new Vector(20);
        this.changeLevel = 0;
        this.label = this.getClass().getName();
    }

    protected YDatabaseObject(YSession session, int maxColumns) {
        this(session, maxColumns, false);
    }

    protected void setName(String name) throws YException {
        if (this.finalized) {
            throw new YProgramException(this, "Verbotene Namens\u00e4nderung nach finalizeDefinition().");
        }
        this.name = name;
    }

    public String getName() throws YException {
        if (this.name == null) {
            throw new YProgramException(this, "F\u00fcr das Objekt wurde kein Name definiert.");
        }
        return this.name;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    protected void addAssignRule(String className, String[][] assignment) throws YProgramException {
        this.assignRules.addElement(new AssignRule(className, assignment));
    }

    public void addChangeEventListener(YDBOChangeEventListener listener) throws YException {
        for (int i = 0; i < this.changeEventListeners.size(); ++i) {
            boolean istDerselbe;
            YDBOChangeEventListener l = this.changeEventListeners.get(i);
            boolean bl = istDerselbe = l == listener;
            if (!istDerselbe) continue;
            return;
        }
        this.changeEventListeners.add(listener);
    }

    public void addRowRequestListener(YDBORowRequestListener listener) {
        this.rowRequestListeners.add(listener);
    }

    public YDBOChangeEventListener removeChangeEventListener(YDBOChangeEventListener listener) {
        if (this.changeEventListeners.remove(listener)) {
            return listener;
        }
        return null;
    }

    public YDBORowRequestListener removeRowRequestListener(YDBORowRequestListener listener) {
        if (this.rowRequestListeners.remove(listener)) {
            return listener;
        }
        return null;
    }

    public void fireChanged(YDBOChangeEvent changeEvent) throws YException {
        if (this.changeLevel > 0) {
            return;
        }
        for (int iListener = 0; iListener < this.changeEventListeners.size(); ++iListener) {
            this.changeEventListeners.get(iListener).DBObjectChanged(changeEvent);
        }
    }

    void requestRowValues(YRowValues rowValues) throws YException {
        for (int iListener = 0; iListener < this.rowRequestListeners.size(); ++iListener) {
            this.rowRequestListeners.get(iListener).requestRowValues(rowValues);
        }
    }

    protected final void setSQLSelect(String sqlSelect) {
        this.sqlSelect = sqlSelect;
    }

    protected final void setViewName(String viewName) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT " + viewName + ".* FROM " + viewName);
        this.sqlSelect = new String(sql);
    }

    protected final void setSqlSelectByViewName(String viewName) {
        this.sqlSelect = "SELECT " + viewName + ".* FROM " + viewName;
    }

    protected void setTableName(String tableName, String tableAlias) {
        this.tableName = tableName;
        this.tableAlias = tableAlias;
    }

    protected void setTableName(String tableName) {
        this.tableName = tableName;
        this.tableAlias = "";
    }

    public String getTableName() {
        return this.tableName;
    }

    public YDatabaseObject setLabel(String label) {
        this.label = label;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    protected String generateSqlSelect() throws YProgramException {
        if (this.tableName != null) {
            this.tableAlias = "";
            return "SELECT * FROM " + this.tableName;
        }
        throw new YProgramException(this, "SELECT kann nicht erzeugt werden:\nTabellenname nicht gesetzt.");
    }

    void checkFinalized() throws YProgramException {
        if (this.tableName == null && !this.isReadOnly()) {
            throw new YProgramException(this, "Der Name der (Haupt-)Tabelle wurde nicht festgelegt.");
        }
        if (this.sqlSelect == null) {
            this.sqlSelect = this.generateSqlSelect();
        }
        if (this.name == null) {
            this.name = this.tableName;
        }
    }

    protected final void finalizeDefinition() throws YProgramException {
        this.checkFinalized();
        this.finalized = true;
    }

    protected void getQueryResult(YFieldValue fieldValue) throws YException {
        StringBuffer result = new StringBuffer();
        String fieldName = fieldValue.getColumnDefinition().getName();
        boolean wasNull = true;
        if (fieldValue.isAlias()) {
            return;
        }
        if (fieldValue.columnDefinition.isCheck()) {
            return;
        }
        switch (fieldValue.getColumnDefinition().getFieldType()) {
            case BOOLEAN: {
                result.append(this.sqlQuery.getBoolean(fieldName) ? "true" : "false");
                wasNull = this.sqlQuery.wasNull();
                break;
            }
            case DOUBLE: {
                String numFormat;
                NumberFormat fmt = NumberFormat.getNumberInstance(this.session.getLocale());
                if (fmt instanceof DecimalFormat && (numFormat = fieldValue.getColumnDefinition().getNumFormat()) != null) {
                    ((DecimalFormat)fmt).applyPattern(numFormat);
                }
                result.append(fmt.format(this.sqlQuery.getDouble(fieldName)));
                wasNull = this.sqlQuery.wasNull();
                break;
            }
            case FLOAT: {
                String numFormat;
                NumberFormat fmt = NumberFormat.getNumberInstance(this.session.getLocale());
                if (fmt instanceof DecimalFormat && (numFormat = fieldValue.getColumnDefinition().getNumFormat()) != null) {
                    ((DecimalFormat)fmt).applyPattern(numFormat);
                }
                result.append(fmt.format(this.sqlQuery.getFloat(fieldName)));
                wasNull = this.sqlQuery.wasNull();
                break;
            }
            case INT: {
                result.append(this.sqlQuery.getInt(fieldName));
                wasNull = this.sqlQuery.wasNull();
                break;
            }
            case LONG: {
                result.append(this.sqlQuery.getLong(fieldName));
                wasNull = this.sqlQuery.wasNull();
                break;
            }
            case SHORT: {
                result.append(this.sqlQuery.getShort(fieldName));
                wasNull = this.sqlQuery.wasNull();
                break;
            }
            case STRING: {
                String string = this.sqlQuery.getString(fieldName);
                if (string != null) {
                    int i2;
                    int i;
                    char[] charArray = string.toCharArray();
                    for (i = i2 = charArray.length - 1; i >= 0 && charArray[i] == ' '; --i) {
                    }
                    if (i < i2) {
                        result.append(string.toString().substring(0, i + 1));
                    } else {
                        result.append(string);
                    }
                }
                wasNull = this.sqlQuery.wasNull();
                break;
            }
            case DATE: {
                Date date = this.sqlQuery.getDate(fieldName);
                if (date != null) {
                    DateFormat df = DateFormat.getDateInstance(2, this.session.getLocale());
                    result.append(df.format(date));
                }
                wasNull = this.sqlQuery.wasNull();
                break;
            }
            case TIME: {
                Time time = this.sqlQuery.getTime(fieldName);
                if (time != null) {
                    DateFormat df = DateFormat.getTimeInstance(3, this.session.getLocale());
                    result.append(df.format(time));
                }
                wasNull = this.sqlQuery.wasNull();
                break;
            }
            case TIMESTAMP: {
                Timestamp timestamp = this.sqlQuery.getTimestamp(fieldName);
                break;
            }
            default: {
                wasNull = true;
            }
        }
        if (wasNull) {
            fieldValue.gotValue("");
        } else {
            fieldValue.gotValue(new String(result));
        }
    }

    protected String sqlValue(String value, YColumnDefinition.FieldType fieldType) throws YException {
        if (value == null) {
            return "null";
        }
        if (value.length() == 0) {
            return "null";
        }
        switch (fieldType) {
            case BOOLEAN: {
                if (value.equals("true")) {
                    return this.session.getDatabase().getTrue();
                }
                if (value.equals("false")) {
                    return this.session.getDatabase().getFalse();
                }
                throw new YException("Ung\u00fcltiger boolscher String: " + value);
            }
            case DOUBLE: 
            case FLOAT: {
                try {
                    NumberFormat fmt = NumberFormat.getNumberInstance(this.session.getLocale());
                    Number num = fmt.parse(value);
                    return num.toString();
                }
                catch (ParseException e) {
                    throw new YUserException("Ung\u00fcltige Gleitkommazahl: " + value);
                }
            }
            case INT: 
            case LONG: 
            case SHORT: {
                return value;
            }
            case STRING: {
                return this.session.getDatabase().sqlString(value);
            }
            case DATE: {
                DateFormat df = DateFormat.getDateInstance(3, this.session.getLocale());
                GregorianCalendar calendar = this.session.getCal();
                ParsePosition pos = new ParsePosition(0);
                Date date = df.parse(value, pos);
                if (date == null || pos.getIndex() < value.length()) {
                    throw new YUserException("Ung\u00fcltiges Datum: " + value);
                }
                calendar.setTime(date);
                int day = calendar.get(5);
                int month = calendar.get(2) + 1;
                int year = calendar.get(1);
                return this.session.getDatabase().sqlDate(day, month, year);
            }
            case TIME: {
                DateFormat df = DateFormat.getTimeInstance(3, this.session.getLocale());
                GregorianCalendar calendar = this.session.getCal();
                ParsePosition pos = new ParsePosition(0);
                calendar.setTime(df.parse(value, pos));
                if (pos.getIndex() < value.length()) {
                    throw new YUserException("Ung\u00fcltige Uhrzeit: " + value);
                }
                int hour = calendar.get(11);
                int minute = calendar.get(12);
                int second = calendar.get(13);
                return this.session.getDatabase().sqlTime(hour, minute, second);
            }
        }
        throw new YProgramException(this, "Nicht unterst\u00fctzter Datentyp " + fieldType.toString());
    }

    protected String sqlValue(YFieldValue fieldValue) throws YException {
        try {
            return this.sqlValue(fieldValue.getValue(), fieldValue.getColumnDefinition().getFieldType());
        }
        catch (YProgramException e) {
            throw new YProgramException(this, e.getMessage() + ", Feld: " + fieldValue.getColumnDefinition().getName());
        }
    }

    protected float parseFloat(YFieldValue fieldValue) throws YException {
        try {
            NumberFormat fmt = NumberFormat.getNumberInstance(this.session.getLocale());
            Number num = fmt.parse(fieldValue.getValue());
            return num.floatValue();
        }
        catch (ParseException e) {
            throw new YException("Ung\u00fcltige Gleitkommazahl: " + fieldValue.getValue());
        }
    }

    protected Calendar parseDateTime(YFieldValue dateValue, YFieldValue timeValue) throws YException {
        DateFormat df;
        String value;
        GregorianCalendar calendar = this.session.getCal();
        if (timeValue != null) {
            String[] hourMinutes = timeValue.getValue().split(":");
            if (hourMinutes.length != 2) {
                throw new YException("Ung\u00fcltige Uhrzeit: " + timeValue);
            }
            try {
                int hours = Integer.parseInt(hourMinutes[0]);
                int minutes = Integer.parseInt(hourMinutes[1]);
                if (hours > 24 || minutes > 59 || hours == 24 && minutes > 0 || hours < 0 || minutes < 0) {
                    throw new YException("Ung\u00fcltige Uhrzeit: " + timeValue);
                }
            }
            catch (NumberFormatException e) {
                throw new YException("Ung\u00fcltige Uhrzeit: " + timeValue);
            }
        }
        if (dateValue == null) {
            if (timeValue == null) {
                return null;
            }
            value = timeValue.getValue();
            df = DateFormat.getTimeInstance(3, this.session.getLocale());
        } else if (timeValue == null) {
            value = dateValue.getValue();
            df = DateFormat.getDateInstance(3, this.session.getLocale());
        } else {
            value = dateValue.getValue() + " " + timeValue.getValue();
            df = DateFormat.getDateTimeInstance(3, 3, this.session.getLocale());
        }
        ParsePosition pos = new ParsePosition(0);
        Date dateTime = df.parse(value, pos);
        if (pos.getIndex() < value.length()) {
            throw new YException("Ung\u00fcltiges Datum/Uhrzeit: " + value);
        }
        calendar = this.session.getCal();
        calendar.setTime(dateTime);
        return calendar;
    }

    protected String format(float f) {
        NumberFormat fmt = NumberFormat.getNumberInstance(this.session.getLocale());
        return fmt.format(f);
    }

    protected YFieldValue modifyFieldValue(YFieldValue fieldValue, float value) throws YException {
        String numFormat;
        YColumnDefinition columnDefinition = fieldValue.getColumnDefinition();
        YColumnDefinition.FieldType fieldType = columnDefinition.getFieldType();
        NumberFormat fmt = NumberFormat.getNumberInstance(this.session.getLocale());
        if (fieldType != YColumnDefinition.FieldType.FLOAT && fieldType != YColumnDefinition.FieldType.DOUBLE) {
            throw new YProgramException(this, "Falscher Datentyp f\u00fcr modifyFieldValue(YFieldValue, float)");
        }
        if (fmt instanceof DecimalFormat && (numFormat = fieldValue.getColumnDefinition().getNumFormat()) != null) {
            ((DecimalFormat)fmt).applyPattern(numFormat);
        }
        fieldValue.modifyValue(fmt.format(value));
        return fieldValue;
    }

    public YRowValues assign(YRowValues rowValues, YRowObject rowObject) throws YException {
        int i;
        String className = rowObject.getClass().getName();
        AssignRule assignRule = null;
        for (i = 0; i < this.assignRules.size(); ++i) {
            assignRule = this.assignRules.get(i);
            if (className.endsWith(assignRule.className)) break;
        }
        if (i == this.assignRules.size()) {
            throw new YProgramException(this, "Keine Zuweisungsregel f\u00fcr " + className + " gefunden.");
        }
        block1: for (i = 0; i < assignRule.assignment.length; ++i) {
            int l = assignRule.assignment[i].length;
            for (int j = 1; j < l; ++j) {
                YFieldValue fieldValue0 = rowObject.getFieldValue(assignRule.assignment[i][j]);
                if (j + 1 != l && fieldValue0.isNull()) continue;
                YFieldValue fieldValue = rowValues.getFieldValue(assignRule.assignment[i][0]);
                if (fieldValue.getColumnDefinition().isReadOnly()) {
                    fieldValue.setROValue(fieldValue0.getValue());
                    continue block1;
                }
                fieldValue.modifyValue(fieldValue0.getValue());
                continue block1;
            }
        }
        return rowValues;
    }

    public YSession getSession() {
        return this.session;
    }

    public String getColumnLabel(String columnName) throws YException {
        return this.rowDefinition.getColumnDefinition(columnName).getLabel();
    }

    public int getFieldValueIndex(String fieldName) throws YException {
        return this.rowDefinition.getFieldValueIndex(fieldName);
    }

    public int getColumnCount() {
        return this.rowDefinition.getNColumns();
    }

    public YColumnDefinition getColumnDefinition(String fieldName) throws YException {
        return this.rowDefinition.getColumnDefinition(fieldName);
    }

    public YRowDefinition getRowDefinition() {
        return this.rowDefinition;
    }

    public class AssignRule {
        String className;
        String[][] assignment;

        public AssignRule(String className, String[][] assignment) throws YProgramException {
            for (int i = 0; i < assignment.length; ++i) {
                if (assignment[i].length >= 2) continue;
                throw new YProgramException(this, "Anzahl Feldnamen<2 in Zuweisungsregel.");
            }
            this.className = className;
            this.assignment = assignment;
        }
    }
}

