/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;

public abstract class YFieldValue {
    protected YColumnDefinition columnDefinition;

    public YFieldValue(YColumnDefinition columnDefinition) {
        this.columnDefinition = columnDefinition;
    }

    public YColumnDefinition getColumnDefinition() {
        return this.columnDefinition;
    }

    abstract boolean isAlias();

    abstract boolean isLookUp();

    public abstract String getValue();

    public int getValueAsInt() throws YException {
        String value = this.getValue();
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            if (value.length() == 0) {
                throw new YProgramException(this, "NULL im Feld " + this.columnDefinition.getName() + " ist nicht erlaubt.");
            }
            throw new YProgramException(this, "'" + value + "' ist kein g\u00fcltiger Integer-Wert.");
        }
    }

    public int getValueAsInt(int ifNull) throws YException {
        if (this.isNull()) {
            return ifNull;
        }
        return this.getValueAsInt();
    }

    public boolean getValueAsBool() throws YException {
        String value = this.getValue();
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        throw new YProgramException(this, "'" + value + "' ist kein g\u00fcltiger Boolean-Wert.");
    }

    public boolean getValueAsBool(boolean ifNull) throws YException {
        if (this.isNull()) {
            return ifNull;
        }
        return this.getValueAsBool();
    }

    public int getValue0AsInt() throws YException {
        String value = this.getValue0();
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new YProgramException(this, "'" + value + "' ist kein g\u00fcltiger Integer-Wert.");
        }
    }

    public int getValue0AsInt(int ifNull) throws YException {
        if (this.wasNull()) {
            return ifNull;
        }
        return this.getValue0AsInt();
    }

    public boolean getValue0AsBool() throws YException {
        String value = this.getValue0();
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        throw new YProgramException(this, "'" + value + "' ist kein g\u00fcltiger Boolean-Wert.");
    }

    public boolean getValue0AsBool(boolean ifNull) throws YException {
        if (this.wasNull()) {
            return ifNull;
        }
        return this.getValue0AsBool();
    }

    public abstract float getValueAsFloat() throws YException;

    public abstract String toString();

    public abstract String getValue0();

    abstract void gotValue(String var1);

    public abstract void setROValue(String var1) throws YException;

    public abstract void gotROValue(String var1) throws YException;

    public abstract void modifyValue(String var1) throws YException;

    public void modifyValue(int value) throws YException {
        this.modifyValue(String.valueOf(value));
    }

    public void modifyValue(boolean value) throws YException {
        this.modifyValue(value ? "true" : "false");
    }

    abstract void cloneFrom(YFieldValue var1) throws YException;

    abstract boolean setPosted();

    public abstract void revert() throws YException;

    public abstract boolean hasChanged();

    public abstract void setNull() throws YException;

    public abstract void modifyToNull() throws YException;

    abstract boolean setDefaultIfNull() throws YException;

    abstract void setAutoId(int var1) throws YException;

    abstract void revertAuto() throws YException;

    public abstract boolean isNull();

    public abstract boolean wasNull();
}

