/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YDetailList;
import projektY.database.YRowObject;
import projektY.database.YRowValues;
import projektY.database.YSession;

public class YQualifiedDetailList
extends YDetailList {
    private YQualifiedDetailList(YSession session, int maxColumns) {
        super(session, maxColumns);
        this.onRemove = YDetailList.OnRemove.UNLINK;
    }

    protected YQualifiedDetailList(YSession session, int maxColumns, YRowObject masterRowObject) {
        this(session, maxColumns);
        this.masterRowObject = masterRowObject;
    }

    protected YQualifiedDetailList(YSession session, int maxColumns, int masterId) throws YException {
        this(session, maxColumns);
        if (masterId <= 0) {
            throw new YException("Die masterId einer eigenst\u00e4ndigen Detailliste mu\u00df > 0 sein.");
        }
        this.rowObjectId = masterId;
    }

    void checkFinalized() throws YProgramException {
        super.checkFinalized();
        assert (this.onRemove == YDetailList.OnRemove.UNLINK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int qualify(int rowObjId) throws YException {
        block6: {
            try {
                assert (this.finalized);
                StringBuffer sql = new StringBuffer();
                sql.append(this.sqlSelect);
                sql.append(" WHERE " + this.rowPkDefinition.getName());
                sql.append("=");
                sql.append(rowObjId);
                this.sqlQuery.execute(sql.toString());
                if (this.sqlQuery.next()) {
                    YRowValues rowValues = this.createRowValues();
                    for (int i = 0; i < this.rowDefinition.getNColumns(); ++i) {
                        this.getQueryResult(rowValues.getFieldValue(i));
                    }
                    rowValues.getFieldValue(this.rowObjectFkDefinition).modifyValue(Integer.toString(this.rowObjectId));
                    this.addRowValues(rowValues);
                    break block6;
                }
                throw new YException("Das Objekt id=" + Integer.toString(rowObjId) + " Tabelle=" + this.tableName + " existiert nicht.");
            }
            finally {
                this.sqlQuery.close();
            }
        }
        return this.getRowCount() - 1;
    }

    public void disQualify(int rowObjId) throws YException {
        int nRows = this.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            int objId = this.getRowValues(iRow).getAsInt(this.rowObjectFkDefinition.getName());
            if (objId != rowObjId) continue;
            this.clearDispValues(iRow);
        }
        throw new YProgramException(this, "Das Objekt mit der objId=" + rowObjId + " ist nicht in der Liste.");
    }
}

