/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;
import projektY.database.YNullValueException;
import projektY.database.YRowObject;
import projektY.database.YRowObjectList;
import projektY.database.YRowValues;
import projektY.database.YSession;
import projektY.database.YSubRowListImplementation;
import projektY.database.YSubRowListManager;

public class YSubRowList
extends YRowObjectList
implements YSubRowListImplementation {
    private YColumnDefinition masterFkDefinition;
    private YSubRowListManager subListManager;
    private String masterFilter;

    public YSubRowList(YSession session, int maxColumns, YRowObjectList rowObjectList) throws YException {
        super(session, maxColumns);
        this.subListManager = new YSubRowListManager(rowObjectList, this);
    }

    public YSubRowList(int maxColumns, YRowObjectList rowObjectList) throws YException {
        super(rowObjectList.getSession(), maxColumns);
        this.subListManager = new YSubRowListManager(rowObjectList, this);
    }

    public void addMasterFkField(String fieldName) throws YException {
        this.masterFkDefinition = this.addDBField(fieldName, YColumnDefinition.FieldType.INT);
    }

    public YColumnDefinition getMasterFkDefinition() {
        return this.masterFkDefinition;
    }

    public void setOrder(String[] order, boolean desc) throws YProgramException {
        this.subListManager.checkOrder(order);
        super.setOrder(order, desc);
    }

    void checkFinalized() throws YProgramException {
        super.checkFinalized();
        this.subListManager.checkOrder(this.masterFkDefinition);
    }

    public void setMasterFilter(String tableName, String pkName, String filter) {
        this.masterFilter = this.subListManager.createMasterFilter(tableName, this.tableAlias, pkName, filter, this.andWhere);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YSubRowList fetch() throws YException {
        String andWhere = this.andWhere;
        try {
            if (this.masterFilter != null) {
                this.setAndWhere(this.masterFilter);
            }
            super.fetch();
            this.subListManager.linkRows();
            YSubRowList ySubRowList = this;
            return ySubRowList;
        }
        finally {
            this.setAndWhere(andWhere);
        }
    }

    public void setSubWindow(int detailRowId) throws YException {
        this.subListManager.setSubWindow(detailRowId);
    }

    public int unsetSubWindow() throws YException {
        return this.subListManager.unsetSubWindow();
    }

    public YRowValues appendInSubWindow(YRowObject rowObject) throws YException {
        return this.append(rowObject);
    }

    public YRowValues append(YRowObject rowObject) throws YException {
        return this.subListManager.append(rowObject);
    }

    public int appendRow() throws YException {
        YRowValues rowValues = this.createRowValues();
        return this.subListManager.appendRowValues(rowValues);
    }

    public int getRowCount() throws YException {
        return this.subListManager.getRowCount();
    }

    public YRowValues getRowValues(int iRow) throws YException {
        return this.subListManager.getRowValues(iRow);
    }

    protected YRowValues removeRowValues(int iRow) throws YException {
        return this.subListManager.removeRowValues(iRow);
    }

    protected YRowValues getRowValues4Set(int iRow) throws YException {
        return this.subListManager.getRowValues4Set(iRow);
    }

    public boolean setPosted() throws YException {
        boolean hasChanged = super.setPosted();
        int detailRowId = this.unsetSubWindow();
        if (detailRowId > 0) {
            this.setSubWindow(detailRowId);
        }
        return hasChanged;
    }

    int getRowListRowId() {
        return this.subListManager.getRowListRowId();
    }

    public boolean hasSubWindow() {
        return this.subListManager.hasSubWindow();
    }

    public int moveUp(int iRow) throws YException {
        if (iRow == 0) {
            return 0;
        }
        return super.moveUp(this.subListManager.subIndexToAbsolute(iRow)) - this.subListManager.getIRow0();
    }

    public int moveDown(int iRow) throws YException {
        if (iRow >= this.getRowCount() - 1) {
            return iRow;
        }
        return super.moveDown(this.subListManager.subIndexToAbsolute(iRow)) - this.subListManager.getIRow0();
    }

    int getRowListId() {
        return this.subListManager.getRowListRowId();
    }

    public void revert() throws YException {
        int detailRowId = this.unsetSubWindow();
        this.subListManager.revertAll();
        if (detailRowId > 0) {
            this.setSubWindow(detailRowId);
        }
    }

    public void resetMarks() throws YException {
        super.resetMarks();
    }

    public YRowValues createRowValues() throws YException {
        return super.createRowValues();
    }

    public YRowValues addRowValues(int iAbsRow, YRowValues rowValues) throws YException {
        super.addRowValues(iAbsRow, rowValues);
        return rowValues;
    }

    public void checkNotNull() throws YNullValueException, YException {
        super.checkNotNull();
    }
}

