/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;
import projektY.database.YDBOChangeEvent;
import projektY.database.YRowObject;
import projektY.database.YRowObjectList;
import projektY.database.YRowValues;
import projektY.database.YSubRowListImplementation;

public class YSubRowListManager {
    private YRowObjectList rowObjectList;
    private int rolRowId;
    private YSubRowListImplementation subList;
    private int iRow0;
    private int iRowN;

    public YSubRowListManager(YRowObjectList rowObjectList, YSubRowListImplementation subList) {
        this.rowObjectList = rowObjectList;
        this.subList = subList;
        this.rolRowId = 0;
        this.iRow0 = -1;
        this.iRowN = -2;
    }

    void checkOrder(String[] order) throws YProgramException {
        if (this.subList.isFinalized()) {
            String masterFkName = this.subList.getMasterFkDefinition().getName();
            if (order.length == 0 || !order[0].equals(masterFkName)) {
                throw new YProgramException(this, "Eine SubListe mu\u00df mit dem richtigen Alias nach dem Fremdschl\u00fcssel zur Hauptliste sortiert sein.");
            }
        }
    }

    void checkOrder(YColumnDefinition masterFkDefinition) throws YProgramException {
        String[] order = this.subList.getOrder();
        String masterFkName = masterFkDefinition.getName();
        if (order == null) {
            this.subList.setOrder(new String[]{masterFkName});
        } else if (order.length == 0 || !order[0].equals(masterFkName)) {
            throw new YProgramException(this, "Eine Sub-Detailliste mu\u00df nach dem Fremdschl\u00fcssel zur Detailliste sortiert sein.");
        }
    }

    public String createMasterFilter(String tableName, String tableAlias, String pkName, String filter, String andWhere) {
        if (filter.length() > 0) {
            StringBuffer masterFilter = new StringBuffer(100);
            masterFilter.append("(" + (tableAlias.length() == 0 ? "" : tableAlias + ".") + this.subList.getMasterFkDefinition().getName() + " IN (SELECT " + pkName + " FROM " + tableName + " WHERE " + filter + "))");
            if (andWhere != null) {
                masterFilter.append(" AND " + andWhere);
            }
            return masterFilter.toString();
        }
        return null;
    }

    YRowObjectList getRowObjectList() {
        return this.rowObjectList;
    }

    void linkRows() throws YException {
        int nSubRows = this.subList.getAbsRowCount();
        int nMasterRows = this.rowObjectList.getAbsRowCount();
        for (int iSubRow = 0; iSubRow < nSubRows; ++iSubRow) {
            int iMasterRow;
            YRowValues subRowValues = this.subList.getAbsRowValues(iSubRow);
            int masterId = subRowValues.getFieldValue(this.subList.getMasterFkDefinition()).getValueAsInt();
            for (iMasterRow = 0; iMasterRow < nMasterRows; ++iMasterRow) {
                YRowValues masterRowValues = this.rowObjectList.getAbsRowValues(iMasterRow);
                if (masterRowValues.getPkFieldValue().getValueAsInt() != masterId) continue;
                subRowValues.masterRowId = masterRowValues.getRowId();
                break;
            }
            if (iMasterRow < nMasterRows) continue;
            String masterPkName = this.rowObjectList.getRowDefinition().getPkColumnDefinition().getName();
            throw new YProgramException(this, masterPkName + "=" + masterId + " in Masterliste nicht gefunden.");
        }
    }

    void setSubWindow(int masterRowId) throws YException {
        boolean found = false;
        this.subList.setActiveRow(-1);
        this.rolRowId = 0;
        for (int iRow = 0; iRow < this.subList.getAbsRowCount(); ++iRow) {
            YRowValues rowValues = this.subList.getAbsRowValues(iRow);
            if (rowValues.masterRowId != masterRowId) continue;
            found = true;
            int nRows = 1;
            while (iRow + nRows < this.subList.getAbsRowCount()) {
                rowValues = this.subList.getAbsRowValues(iRow + nRows);
                if (rowValues.masterRowId != masterRowId) break;
                ++nRows;
            }
            this.iRow0 = iRow;
            this.iRowN = iRow + nRows - 1;
            break;
        }
        if (!found) {
            this.iRow0 = -1;
            this.iRowN = -2;
        }
        this.rolRowId = masterRowId;
        this.subList.fireChanged(new YDBOChangeEvent());
        if (this.iRowN > this.iRow0) {
            this.subList.setActiveRow(0);
        }
    }

    int unsetSubWindow() throws YException {
        int oldDetailRowId = this.rolRowId;
        this.subList.setActiveRow(-1);
        this.iRow0 = -1;
        this.iRowN = -2;
        this.rolRowId = 0;
        this.subList.fireChanged(new YDBOChangeEvent());
        return oldDetailRowId;
    }

    int appendRowValues(YRowValues rowValues2append) throws YException {
        if (this.rolRowId == 0) {
            throw new YProgramException(this, "Kein Fenster (setSubWindow()) eingestellt.");
        }
        rowValues2append.masterRowId = this.rolRowId;
        int iRow = this.iRowN >= 0 ? this.iRowN + 1 : this.subList.getAbsRowCount();
        this.subList.addRowValues(iRow, rowValues2append);
        if (this.iRow0 < 0) {
            this.iRow0 = iRow;
        }
        this.iRowN = iRow;
        this.subList.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.INSERT, this.iRowN - this.iRow0, rowValues2append));
        this.subList.setActiveRow(this.iRowN - this.iRow0);
        return this.iRowN - this.iRow0;
    }

    YRowValues append(YRowObject rowObject) throws YException {
        if (this.rolRowId == 0) {
            throw new YProgramException(this, "Kein Fenster (setSubWindow()) eingestellt.");
        }
        YRowValues rowValues2append = this.subList.createRowValues();
        this.subList.assign(rowValues2append, rowObject);
        this.appendRowValues(rowValues2append);
        return rowValues2append;
    }

    int getRowCount() throws YException {
        if (this.rolRowId == 0) {
            throw new YProgramException(this, "Fenster (setSubWindow( )) nicht oder nicht korrekt gesetzt.");
        }
        return this.iRowN - this.iRow0 + 1;
    }

    int subIndexToAbsolute(int subIndex) throws YProgramException {
        if (this.iRow0 < 0 || this.iRow0 + subIndex > this.iRowN) {
            throw new YProgramException(this, "Zeile au\u00dferhalb des gesetzen Fensters oder Fenster nicht gesetzt.");
        }
        return this.iRow0 + subIndex;
    }

    YRowValues getRowValues(int iRow) throws YException {
        try {
            return this.subList.getAbsRowValues(this.subIndexToAbsolute(iRow));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new YProgramException(this, "Ung\u00fcltiger Index: " + e.getMessage());
        }
    }

    YRowValues removeRowValues(int iRow) throws YException {
        return this.subList.removeAbsRowValues(this.subIndexToAbsolute(iRow));
    }

    YRowValues getRowValues4Set(int iRow) throws ArrayIndexOutOfBoundsException, YException {
        try {
            if (this.rolRowId == 0) {
                throw new YProgramException(this, "Fenster (setSubWindow( )) nicht oder nicht korrekt gesetzt.");
            }
            int iRowW = iRow + this.iRow0;
            if (iRowW == this.iRowN + 1) {
                if (iRowW < 0) {
                    iRowW = 0;
                    this.iRow0 = 0;
                }
                YRowValues rowValues = this.subList.createRowValues();
                rowValues.masterRowId = this.rolRowId;
                this.subList.addRowValues(iRowW, rowValues);
                this.iRowN = iRowW;
                return rowValues;
            }
            return this.subList.getAbsRowValues(iRowW);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new YProgramException(this, "Ung\u00fcltiger Index: " + e.getMessage());
        }
    }

    int getRowListRowId() {
        return this.rolRowId;
    }

    boolean hasSubWindow() {
        return this.rolRowId > 0;
    }

    int getIRow0() {
        return this.iRow0;
    }

    int getIRowN() {
        return this.iRowN;
    }

    public void revertAll() throws YException {
        int nRows = this.subList.getAbsRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            YRowValues rowValues = this.subList.getAbsRowValues(iRow);
            if (rowValues.getFieldValue(this.subList.getRowPkDefinition()).wasNull()) {
                this.subList.removeAbsRowValues(iRow);
                --iRow;
                --nRows;
                continue;
            }
            rowValues.revert();
        }
    }
}

