/*
 * Decompiled with CFR 0.152.
 */
package projektY.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import projektY.base.YException;
import projektY.swing.Utils;
import projektY.utils.YConfigFile;

public class DlgConnect
extends JDialog {
    private YConfigFile configFile;
    static final String urlPattern = "jdbc:postgresql://[Server]:[Port]/[Datenbank]";
    private boolean OK;
    AbstractAction actClose;
    private JButton cmdCancel;
    private JButton cmdLogin;
    private JButton cmdStore;
    private JTextField fldDriver;
    private JPasswordField fldPassword;
    private JTextField fldURL;
    private JTextField fldUser;
    private JLabel lblDriver;
    private JLabel lblPassword;
    private JLabel lblURL;
    private JLabel lblUser;
    private JPanel panAnmeldedaten;
    private JTabbedPane panConnect;
    private JPanel panConnection;
    private JPanel panLogin;
    private JPanel panVerbindungsdaten;

    public DlgConnect(Frame parent, String title, YConfigFile configFile, boolean modal) {
        super(parent, title, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.cmdLogin);
        this.actClose = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                DlgConnect.this.cmdCancelActionPerformed(evt);
            }
        };
        this.cmdCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "schliessen");
        this.cmdCancel.getActionMap().put("schliessen", this.actClose);
        this.configFile = configFile;
        if (configFile != null) {
            String JDBCDriver = configFile.findValue("JDBCDriver");
            String DBURL = configFile.findValue("DBURL");
            if (JDBCDriver.length() > 0) {
                this.fldDriver.setText(JDBCDriver);
            }
            if (DBURL.length() > 0) {
                this.fldURL.setText(DBURL);
            }
            this.cmdStore.setEnabled(true);
        } else {
            this.cmdStore.setEnabled(false);
        }
    }

    public DlgConnect(Frame parent, String title, boolean modal) {
        this(parent, title, null, modal);
    }

    public DlgConnect(Frame frame) {
        this(frame, "", true);
    }

    public DlgConnect() {
        this((Frame)null, "", true);
    }

    public boolean execute() {
        Utils.centerWindow(this);
        if (this.fldUser.getText().length() == 0) {
            this.fldUser.requestFocusInWindow();
        } else {
            this.fldPassword.requestFocusInWindow();
        }
        this.setVisible(true);
        return this.OK;
    }

    public void setDriver(String driver) {
        this.fldDriver.setText(driver);
    }

    public String getDriver() {
        return this.fldDriver.getText();
    }

    public void setURL(String URL2) {
        this.fldURL.setText(URL2);
    }

    public String getURL() {
        return this.fldURL.getText();
    }

    public void setUser(String user) {
        this.fldUser.setText(user);
    }

    public String getUser() {
        return this.fldUser.getText();
    }

    public String getPassword() {
        return new String(this.fldPassword.getPassword());
    }

    private void initComponents() {
        this.panConnect = new JTabbedPane();
        this.panLogin = new JPanel();
        this.panAnmeldedaten = new JPanel();
        this.fldPassword = new JPasswordField();
        this.lblPassword = new JLabel();
        this.fldUser = new JTextField();
        this.lblUser = new JLabel();
        this.cmdLogin = new JButton();
        this.cmdCancel = new JButton();
        this.panConnection = new JPanel();
        this.panVerbindungsdaten = new JPanel();
        this.lblURL = new JLabel();
        this.fldURL = new JTextField();
        this.lblDriver = new JLabel();
        this.fldDriver = new JTextField();
        this.cmdStore = new JButton();
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.panConnect.setFont(new Font("Dialog", 0, 12));
        this.panConnect.setMinimumSize(new Dimension(177, 300));
        this.panLogin.setLayout(new GridBagLayout());
        this.panAnmeldedaten.setBorder(BorderFactory.createTitledBorder("Ihre Anmeldedaten"));
        this.panAnmeldedaten.setLayout(new GridBagLayout());
        this.fldPassword.setFont(new Font("SansSerif", 0, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panAnmeldedaten.add((Component)this.fldPassword, gridBagConstraints);
        this.lblPassword.setFont(new Font("Dialog", 0, 12));
        this.lblPassword.setText("Passwort:");
        this.lblPassword.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panAnmeldedaten.add((Component)this.lblPassword, gridBagConstraints);
        this.fldUser.setFont(new Font("SansSerif", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panAnmeldedaten.add((Component)this.fldUser, gridBagConstraints);
        this.lblUser.setFont(new Font("Dialog", 0, 12));
        this.lblUser.setText("Bearbeiter:");
        this.lblUser.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panAnmeldedaten.add((Component)this.lblUser, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panLogin.add((Component)this.panAnmeldedaten, gridBagConstraints);
        this.cmdLogin.setFont(new Font("Dialog", 0, 12));
        this.cmdLogin.setMnemonic('L');
        this.cmdLogin.setText("Login");
        this.cmdLogin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgConnect.this.cmdLoginActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 2, 3, 0);
        this.panLogin.add((Component)this.cmdLogin, gridBagConstraints);
        this.cmdCancel.setFont(new Font("Dialog", 0, 12));
        this.cmdCancel.setMnemonic('A');
        this.cmdCancel.setText("Abbruch");
        this.cmdCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgConnect.this.cmdCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 3, 2);
        this.panLogin.add((Component)this.cmdCancel, gridBagConstraints);
        this.panConnect.addTab("Login", this.panLogin);
        this.panConnection.setLayout(new GridBagLayout());
        this.panVerbindungsdaten.setBorder(BorderFactory.createTitledBorder("Ihre Verbindungsdaten"));
        this.panVerbindungsdaten.setLayout(new GridBagLayout());
        this.lblURL.setFont(new Font("Dialog", 0, 12));
        this.lblURL.setText("JDBC URL:");
        this.lblURL.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panVerbindungsdaten.add((Component)this.lblURL, gridBagConstraints);
        this.fldURL.setFont(new Font("SansSerif", 0, 12));
        this.fldURL.setText(urlPattern);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panVerbindungsdaten.add((Component)this.fldURL, gridBagConstraints);
        this.lblDriver.setFont(new Font("Dialog", 0, 12));
        this.lblDriver.setText("JDBC Treiber:");
        this.lblDriver.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panVerbindungsdaten.add((Component)this.lblDriver, gridBagConstraints);
        this.fldDriver.setFont(new Font("SansSerif", 0, 12));
        this.fldDriver.setText("org.postgresql.Driver");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panVerbindungsdaten.add((Component)this.fldDriver, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panConnection.add((Component)this.panVerbindungsdaten, gridBagConstraints);
        this.cmdStore.setFont(new Font("Dialog", 0, 12));
        this.cmdStore.setMnemonic('S');
        this.cmdStore.setText("Speichern");
        this.cmdStore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgConnect.this.cmdStoreActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 2, 2, 0);
        this.panConnection.add((Component)this.cmdStore, gridBagConstraints);
        this.panConnect.addTab("Verbindung", this.panConnection);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.panConnect, gridBagConstraints);
        this.pack();
    }

    private void cmdStoreActionPerformed(ActionEvent evt) {
        try {
            this.configFile.setEntry("JDBCDriver", this.fldDriver.getText());
            this.configFile.setEntry("DBURL", this.fldURL.getText());
            this.configFile.write();
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdLoginActionPerformed(ActionEvent evt) {
        if (this.fldURL.getText().equals(urlPattern)) {
            JOptionPane.showMessageDialog(this, "Die URL der Datenbank mu\u00df angegeben werden.", "Hinweis", 2);
            this.panConnect.setSelectedComponent(this.panConnection);
            this.fldURL.requestFocusInWindow();
            return;
        }
        this.OK = true;
        this.dispose();
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.OK = false;
        this.dispose();
    }
}

