/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Locale;
import projektY.base.YException;
import projektY.database.YDatabase;
import projektY.database.YFieldValue;

public abstract class YPGDatabase
extends YDatabase {
    private String passwdUser = null;

    public YPGDatabase(String driver, String URL2, Locale locale) throws YException {
        super(driver, URL2, locale);
    }

    public void begin() throws YException {
        super.begin();
        try {
            this.sqlDml.execute("BEGIN");
        }
        catch (YException e) {
            this.inTransaction = false;
            throw e;
        }
    }

    public String getTrue() {
        return "TRUE";
    }

    public String getFalse() {
        return "FALSE";
    }

    public static final String cryptMd5(char[] passwd, String user) throws YException {
        if (passwd.length == 0) {
            return "";
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] md5Password = messageDigest.digest((new String(passwd) + user).getBytes());
            StringBuffer md5String = new StringBuffer(3 + md5Password.length * 2);
            md5String.append("md5");
            for (int i = 0; i < md5Password.length; ++i) {
                md5String.append(String.format("%02x", md5Password[i]));
            }
            return md5String.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new YException(ex.toString());
        }
    }

    protected void createUser(String user, char[] passwd) throws YException {
        if (this.initializedTransaction) {
            this.begin();
        }
        this.sqlDml.execute("CREATE USER \"" + user + "\" WITH ENCRYPTED PASSWORD '" + YPGDatabase.cryptMd5(passwd, user) + "'");
    }

    protected void alterPasswd(String user, char[] passwd) throws YException {
        if (this.initializedTransaction) {
            this.begin();
        }
        this.sqlDml.execute("ALTER USER \"" + user + "\" ENCRYPTED PASSWORD '" + YPGDatabase.cryptMd5(passwd, user) + "'");
    }

    protected void grantAdmin(String user) throws YException {
        if (this.initializedTransaction) {
            this.begin();
        }
        this.sqlDml.execute("ALTER USER \"" + user + "\" CREATEUSER");
    }

    protected void revokeAdmin(String user) throws YException {
        if (this.initializedTransaction) {
            this.begin();
        }
        this.sqlDml.execute("ALTER USER \"" + user + "\" NOCREATEUSER");
    }

    protected void dropUser(String user) throws YException {
        if (this.initializedTransaction) {
            this.begin();
        }
        this.sqlDml.execute("DROP USER IF EXISTS " + user);
    }

    protected void grantRole(String role, String user) throws YException {
        if (this.initializedTransaction) {
            this.begin();
        }
        this.sqlDml.execute("GRANT " + role + " TO \"" + user + "\"");
    }

    protected void revokeRole(String role, String user) throws YException {
        if (this.initializedTransaction) {
            this.begin();
        }
        this.sqlDml.execute("REVOKE " + role + " FROM \"" + user + "\"");
    }

    public boolean isFkViolation(SQLException ex) {
        try {
            return Integer.parseInt(ex.getSQLState()) == 23503;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean isUniqueViolation(SQLException ex) {
        try {
            return Integer.parseInt(ex.getSQLState()) == 23505;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void setPasswdUser(String passwdUser) throws YException {
        this.passwdUser = passwdUser;
    }

    public void modifyPasswdField(YFieldValue pwdFv, char[] passwd) throws YException {
        pwdFv.modifyValue(YPGDatabase.cryptMd5(passwd, this.passwdUser == null ? this.getUser() : this.passwdUser));
    }
}

