/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import java.util.Vector;
import projektY.base.YException;
import projektY.base.YLookUpDomain;
import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDatabaseData;
import projektY.database.YFieldValue;
import projektY.database.YLookUpDBColumnDefinition;
import projektY.database.YLookUpDomainColumnDefinition;
import projektY.database.YRowObject;
import projektY.database.YRowValues;
import projektY.database.YSession;

public abstract class YDatabaseList
extends YDatabaseData {
    protected String[] order;
    protected boolean orderDesc;
    protected int[] dispIndicees;
    protected int dispColCount;
    protected int[] xdispIndicees;
    protected int xdispColCount;
    protected Vector<YRowValues> rows = new Vector(30, 20);
    protected int maxRows = 0;
    protected boolean moreRows = false;
    private int nextRowId;
    protected int activeRow;

    protected YDatabaseList(YSession session, int maxColumns, boolean readOnly) throws YProgramException {
        super(session, maxColumns, readOnly);
        this.assignRules = new Vector(2, 2);
        this.dispColCount = 0;
        this.nextRowId = 1;
        this.activeRow = -1;
    }

    protected YDatabaseList(YSession session, int maxColumns) throws YProgramException {
        this(session, maxColumns, false);
    }

    protected YDatabaseList(YSession session) throws YProgramException {
        this(session, 0, false);
    }

    public YColumnDefinition addDBField(String fieldName, YColumnDefinition.FieldType fieldType) throws YProgramException {
        return this.rowDefinition.addColumnDefinition(fieldName, fieldType, false, false);
    }

    public YColumnDefinition addROField(String fieldName, YColumnDefinition.FieldType fieldType) throws YProgramException {
        return this.rowDefinition.addColumnDefinition(fieldName, fieldType, false, true);
    }

    public YLookUpDBColumnDefinition addLookUpDBField(String fieldName, YDatabaseList lookUpList, String valueFieldName, String altFieldName) throws YException {
        return this.rowDefinition.addLookUpDBColumnDefinition(fieldName, lookUpList, valueFieldName, altFieldName);
    }

    public YLookUpDBColumnDefinition addLookUpDBField(String fieldName, YDatabaseList lookUpList, String valueFieldName) throws YException {
        return this.rowDefinition.addLookUpDBColumnDefinition(fieldName, lookUpList, valueFieldName);
    }

    public YLookUpDomainColumnDefinition addLookUpDomainField(String fieldName, YColumnDefinition.FieldType fieldType, YLookUpDomain domain) throws YException {
        return this.rowDefinition.addLookUpDomainDefinition(fieldName, fieldType, domain);
    }

    public YLookUpDomainColumnDefinition addLookUpDomainField(String fieldName, YLookUpDomain domain) throws YException {
        return this.rowDefinition.addLookUpDomainDefinition(fieldName, domain);
    }

    protected void checkFinalized() throws YProgramException {
        super.checkFinalized();
        if (this.dispIndicees == null) {
            this.dispColCount = this.rowDefinition.getNColumns() - 1;
            if (this.dispColCount < 0) {
                throw new YProgramException(this, "F\u00fcr die Datenbankliste wurden keine Spalten definiert.");
            }
            this.dispIndicees = new int[this.dispColCount];
            try {
                int iDispValue = 0;
                for (int iCol = 0; iCol < this.dispColCount; ++iCol) {
                    if (this.rowDefinition.getColumnDefinition(iCol).isPrimaryKey()) continue;
                    this.dispIndicees[iDispValue++] = this.rowDefinition.getFieldValueIndex(this.rowDefinition.getColumnDefinition(iCol).getName());
                }
            }
            catch (YException e) {
                throw new YProgramException(this, e.getMessage());
            }
        }
    }

    public void setOrder(String[] order, boolean desc) throws YProgramException {
        this.order = order;
        this.orderDesc = desc;
    }

    public final void setOrder(String[] order) throws YProgramException {
        this.setOrder(order, false);
    }

    public String[] getOrder() {
        return this.order;
    }

    protected void setToStringFields(String[] fieldNames, String concatWith) throws YException {
        this.rowDefinition.setToStringFields(fieldNames, concatWith);
    }

    protected void setToStringFields(String[] fieldNames, boolean concat) throws YException {
        this.rowDefinition.setToStringFields(fieldNames, concat);
    }

    protected void setToStringFields(String[] fieldNames) throws YException {
        this.setToStringFields(fieldNames, false);
    }

    protected void setToStringField(String fieldName) throws YException {
        this.setToStringFields(new String[]{fieldName}, false);
    }

    public void setDispFields(String[] insideTable, String[] outsideTable) throws YException {
        this.dispIndicees = new int[insideTable.length];
        this.dispColCount = 0;
        while (this.dispColCount < insideTable.length) {
            this.dispIndicees[this.dispColCount] = this.rowDefinition.getFieldValueIndex(insideTable[this.dispColCount]);
            ++this.dispColCount;
        }
        if (outsideTable != null) {
            this.xdispIndicees = new int[outsideTable.length];
            this.xdispColCount = 0;
            while (this.xdispColCount < outsideTable.length) {
                this.xdispIndicees[this.xdispColCount] = this.rowDefinition.getFieldValueIndex(outsideTable[this.xdispColCount]);
                ++this.xdispColCount;
            }
        }
    }

    public void setDispFields(String[] fieldNames) throws YException {
        this.setDispFields(fieldNames, null);
    }

    public int getDispColCount() throws YException {
        return this.dispColCount;
    }

    public YFieldValue getDispValue(int iRow, int iCol) throws YException {
        try {
            return this.getRowValues(iRow).getFieldValue(this.dispIndicees[iCol]);
        }
        catch (NullPointerException e) {
            throw new YProgramException(this, "Die Felder f\u00fcr die Anzeige wurden nicht gesetzt.");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new YProgramException(this, "Ung\u00fcltiger Index: " + e.getMessage());
        }
    }

    public String getDispString(int iRow, int iCol) throws YException {
        try {
            return this.getRowValues(iRow).getFieldValue(this.dispIndicees[iCol]).toString();
        }
        catch (NullPointerException e) {
            throw new YProgramException(this, "Die Felder f\u00fcr die Anzeige wurden nicht gesetzt.");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new YProgramException(this, "Ung\u00fcltiger Index: " + e.getMessage());
        }
    }

    public YColumnDefinition getDispColumnDefinition(int iCol) throws YException {
        try {
            for (int i = 0; i < this.rowDefinition.getNColumns(); ++i) {
                if (this.dispIndicees[iCol] != this.rowDefinition.columnDefinitions.get(i).getFieldValueIndex()) continue;
                return this.rowDefinition.columnDefinitions.get(i);
            }
            throw new YProgramException(this, "Ung\u00fcltiger Index: " + iCol);
        }
        catch (NullPointerException e) {
            throw new YProgramException(this, "Die Felder f\u00fcr die Anzeige wurden nicht gesetzt.");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new YProgramException(this, "Ung\u00fcltiger Index: " + iCol);
        }
    }

    public int setActiveRow(int iRow) throws YException {
        if (this.activeRow != iRow) {
            if (iRow < 0) {
                this.activeRow = -1;
                this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.ROWSELECTED, -1, null));
            } else {
                this.activeRow = iRow;
                this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.ROWSELECTED, iRow, this.getRowValues(this.activeRow)));
            }
        }
        return this.activeRow;
    }

    public int getActiveRow() {
        return this.activeRow;
    }

    public boolean hasActiveRow() {
        return this.activeRow >= 0;
    }

    public boolean isRowEditable(int iRow) throws YException {
        return false;
    }

    public int unsetActiveRow() throws YException {
        if (this.activeRow != -1) {
            this.activeRow = -1;
            this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.ROWSELECTED, -1, null));
        }
        return -1;
    }

    protected void clearRowValues() throws YException {
        this.rows.clear();
        this.fireChanged(new YDBOChangeEvent());
    }

    protected YRowValues createRowValues() throws YException {
        YRowValues rowValues = this.rowDefinition.createRowValues(this.nextRowId);
        ++this.nextRowId;
        return rowValues;
    }

    protected YRowValues addRowValues(YRowValues rowValues) throws YException {
        this.rows.addElement(rowValues);
        this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.INSERT, this.rows.size() - 1, rowValues));
        return rowValues;
    }

    protected YRowValues addRowValues(int iRow, YRowValues rowValues) throws YException {
        this.rows.add(iRow, rowValues);
        return rowValues;
    }

    public YRowValues getRowValues(int iRow) throws YException {
        try {
            return this.rows.get(iRow);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new YProgramException(this, "Ung\u00fcltiger Zeilenindex beim Aufruf von getRowValues(): " + e.getMessage());
        }
    }

    public YRowValues getActiveRowValues() throws YException {
        if (this.activeRow < 0) {
            return null;
        }
        return this.getRowValues(this.activeRow);
    }

    public YRowValues getAbsRowValues(int iRow) throws YException {
        try {
            return this.rows.get(iRow);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new YProgramException(this, "Ung\u00fcltiger Zeilenindex bei getAbsRowValues()");
        }
    }

    public final YRowValues removeAbsRowValues(int iRow) throws YException {
        try {
            YRowValues rowValues = this.rows.remove(iRow);
            this.activeRow = -1;
            this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.DELETE, iRow, rowValues));
            return rowValues;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new YProgramException(this, "Ung\u00fcltiger Zeilenindex beim Aufruf von removeRowValues(): " + e.getMessage());
        }
    }

    protected YRowValues removeRowValues(int iRow) throws YException {
        YRowValues rowValues = this.removeAbsRowValues(iRow);
        this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.DELETE, iRow, rowValues));
        return rowValues;
    }

    public YFieldValue getFieldValue(int iRow, String fieldName) throws YException {
        try {
            return this.getRowValues(iRow).getFieldValue(fieldName);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new YProgramException(this, "Ung\u00fcltiger Index: " + e.getMessage());
        }
    }

    public String getAsString(int iRow, String fieldName) throws YException {
        return this.getFieldValue(iRow, fieldName).getValue();
    }

    public int getAsInt(int iRow, String fieldName) throws YException {
        return this.getFieldValue(iRow, fieldName).getValueAsInt();
    }

    public int getAsInt(int iRow, String fieldName, int ifNull) throws YException {
        return this.getFieldValue(iRow, fieldName).getValueAsInt(ifNull);
    }

    public float getAsFloat(int iRow, String fieldName) throws YException {
        YFieldValue fv = this.getFieldValue(iRow, fieldName);
        try {
            return this.parseFloat(fv);
        }
        catch (NumberFormatException e) {
            throw new YProgramException(this, "'" + fv.getValue() + "' ist kein g\u00fcltiger Gleitkommawert.");
        }
    }

    public float getAsFloat(int iRow, String fieldName, float ifNull) throws YException {
        YFieldValue fv = this.getFieldValue(iRow, fieldName);
        if (fv.isNull()) {
            return ifNull;
        }
        try {
            return this.parseFloat(fv);
        }
        catch (NumberFormatException e) {
            throw new YProgramException(this, "'" + fv.getValue() + "' ist kein g\u00fcltiger Gleitkommawert.");
        }
    }

    public boolean getAsBool(int iRow, String fieldName) throws YException {
        return this.getFieldValue(iRow, fieldName).getValueAsBool();
    }

    public boolean getAsBool(int iRow, String fieldName, boolean ifNull) throws YException {
        return this.getFieldValue(iRow, fieldName).getValueAsBool(ifNull);
    }

    protected YRowValues getRowValues4Set(int iRow) throws YException {
        try {
            if (iRow == this.rows.size()) {
                YRowValues rowValues = this.createRowValues();
                this.rows.add(rowValues);
                this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.INSERT, iRow, rowValues));
                return rowValues;
            }
            return this.rows.get(iRow);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new YProgramException(this, "Ung\u00fcltiger Index: " + e.getMessage());
        }
    }

    protected YRowValues append(YRowObject rowObject) throws YException {
        YRowValues rowValues = this.createRowValues();
        this.rows.add(this.assign(rowValues, rowObject));
        int iRow = this.rows.size() - 1;
        this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.INSERT, iRow, rowValues));
        return rowValues;
    }

    protected int appendRow() throws YException {
        YRowValues rowValues = this.createRowValues();
        this.rows.add(rowValues);
        int iRow = this.rows.size() - 1;
        this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.INSERT, iRow, rowValues));
        return iRow;
    }

    public YRowValues findRow(String value, String fieldName) throws YException {
        int fieldIndex = this.rowDefinition.getFieldValueIndex(fieldName);
        for (int iRow = 0; iRow < this.rows.size(); ++iRow) {
            YRowValues rowValues = this.rows.get(iRow);
            if (!rowValues.getFieldValue(fieldIndex).getValue().equals(value)) continue;
            return rowValues;
        }
        return null;
    }

    public int find(String value, String fieldName) throws YException {
        int fieldIndex = this.rowDefinition.getFieldValueIndex(fieldName);
        for (int iRow = 0; iRow < this.rows.size(); ++iRow) {
            YRowValues rowValues = this.rows.get(iRow);
            if (!rowValues.getFieldValue(fieldIndex).getValue().equals(value)) continue;
            return iRow;
        }
        return -1;
    }

    public void setAsString(int iRow, String fieldName, String value) throws YException {
        this.getRowValues4Set(iRow).setAsString(fieldName, value);
    }

    public void setAsInt(int iRow, String fieldName, int value) throws YException {
        this.getRowValues4Set(iRow).setAsInt(fieldName, value);
    }

    public void setAsBool(int iRow, String fieldName, boolean value) throws YException {
        this.getRowValues4Set(iRow).setAsBool(fieldName, value);
    }

    public void setAsFloat(int iRow, String fieldName, float value) throws YException {
        this.modifyFieldValue(this.getRowValues4Set(iRow).getFieldValue(fieldName), value);
    }

    public void setNull(int iRow, String fieldName) throws YException {
        this.modifyToNull(iRow, fieldName);
    }

    public void modifyToNull(int iRow, String fieldName) throws YException {
        this.getRowValues4Set(iRow).getFieldValue(fieldName).modifyToNull();
    }

    public void setFromRow(int iRow, String fieldName, Object rowValues, String rowFieldName) throws YException {
        try {
            if (rowValues == null) {
                this.modifyToNull(iRow, fieldName);
            } else {
                this.setAsString(iRow, fieldName, ((YRowValues)rowValues).getAsString(rowFieldName));
            }
        }
        catch (ClassCastException e) {
            throw new YProgramException(this, rowValues.getClass().getName() + " kann nicht in YRowValues konvertiert werden.");
        }
    }

    public void setDispString(int iRow, int iCol, String value) throws YException {
        try {
            YRowValues rowValues = this.getRowValues4Set(iRow);
            YFieldValue fieldValue = rowValues.getFieldValue(this.dispIndicees[iCol]);
            if (fieldValue.getColumnDefinition().isReadOnly()) {
                if (value == null || value.length() == 0) {
                    fieldValue.setROValue(value);
                } else if (!value.equals(fieldValue.getValue())) {
                    throw new YProgramException(this, fieldValue.getColumnDefinition().getName() + " ist schreibgesch\u00fctzt.");
                }
            } else {
                fieldValue.modifyValue(value);
            }
            this.fireChanged(new YDBOChangeEvent(iRow, rowValues, iCol));
        }
        catch (NullPointerException e) {
            throw new YProgramException(this, "Die Felder f\u00fcr die Anzeige wurden nicht gesetzt.");
        }
    }

    public void clearSelectParamValues() throws YProgramException {
        if (this.paramSelect == null) {
            throw new YProgramException(this, "Diese Klasse verwendet kein parametrisiertes SELECT.");
        }
        this.paramSelect.clearParamValues();
    }

    public void setSelectParamValue(String paramName, String paramValue) throws YProgramException {
        if (this.paramSelect == null) {
            throw new YProgramException(this, "Diese Klasse verwendet kein parametrisiertes SELECT.");
        }
        this.paramSelect.setParamValue(paramName, paramValue);
    }

    public void clearDispValues(int iRow) throws YException, YProgramException {
        try {
            YFieldValue fieldValue;
            int iCol;
            YRowValues rowValues = this.getRowValues(iRow);
            for (iCol = 0; iCol < this.dispColCount; ++iCol) {
                fieldValue = rowValues.getFieldValue(this.dispIndicees[iCol]);
                if (fieldValue.getColumnDefinition().isReadOnly()) {
                    fieldValue.setROValue("");
                    continue;
                }
                fieldValue.modifyValue("");
            }
            if (this.xdispColCount > 0) {
                for (iCol = 0; iCol < this.xdispColCount; ++iCol) {
                    fieldValue = rowValues.getFieldValue(this.xdispIndicees[iCol]);
                    if (fieldValue.getColumnDefinition().isReadOnly()) {
                        fieldValue.setROValue("");
                        continue;
                    }
                    fieldValue.modifyValue("");
                }
            }
            this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, iRow, rowValues));
        }
        catch (NullPointerException e) {
            throw new YProgramException(this, "Die Felder f\u00fcr die Anzeige wurden nicht gesetzt.");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new YProgramException(this, "Ung\u00fcltiger Index: " + e.getMessage());
        }
    }

    public void clearDispValues() throws YException, YProgramException {
        ++this.changeLevel;
        int nRows = this.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            this.clearDispValues(iRow);
        }
        --this.changeLevel;
        this.fireChanged(new YDBOChangeEvent());
    }

    protected void unsetPosted() throws YException {
        for (int iRow = 0; iRow < this.rows.size(); ++iRow) {
            YRowValues rowValues = this.rows.get(iRow);
            rowValues.resetMarks();
        }
    }

    protected boolean setPosted() throws YException {
        int nRows = this.rows.size();
        boolean rowsChanged = false;
        for (int iRow = 0; iRow < nRows; ++iRow) {
            YRowValues row = this.rows.get(iRow);
            if (row.hasDeleteMark()) {
                this.rows.remove(iRow);
                --iRow;
                --nRows;
                rowsChanged = true;
                this.activeRow = -1;
                continue;
            }
            rowsChanged |= row.setPosted();
        }
        return rowsChanged;
    }

    public int moveUp(int iRow) throws YException {
        if (iRow == 0) {
            return 0;
        }
        try {
            YRowValues row = this.rows.remove(iRow);
            this.rows.insertElementAt(row, iRow - 1);
            this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.INTERCHANGE, iRow - 1, iRow));
            return iRow - 1;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new YProgramException(this, "Ung\u00fcltiger Index bei moveUp().");
        }
    }

    public int moveDown(int iRow) throws YException {
        if (iRow == this.rows.size() - 1) {
            return iRow;
        }
        try {
            YRowValues row = this.rows.remove(iRow);
            this.rows.insertElementAt(row, iRow + 1);
            this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.INTERCHANGE, iRow, iRow + 1));
            return iRow + 1;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new YProgramException(this, "Ung\u00fcltiger Index bei moveDown().");
        }
    }

    public int getRowCount() throws YException {
        return this.rows.size();
    }

    public final int getAbsRowCount() throws YException {
        return this.rows.size();
    }

    public void removeRow(int iRow) throws YException {
        try {
            YRowValues rowValues = this.rows.get(iRow);
            this.rows.remove(iRow);
            if (iRow >= this.activeRow) {
                this.activeRow = -1;
            }
            this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.DELETE, iRow, rowValues));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new YProgramException(this, "Ung\u00fcltiger Index bei removeRow().");
        }
    }

    public abstract YDatabaseList fetch() throws YException;

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public boolean hasMoreRows() {
        return this.moreRows;
    }
}

