/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import projektY.base.YException;
import projektY.base.YLookUpValue;
import projektY.base.YProgramException;
import projektY.database.YAliasFieldValue;
import projektY.database.YCheckColumnDefinition;
import projektY.database.YCheckFieldValue;
import projektY.database.YColumnDefinition;
import projektY.database.YDBFieldValue;
import projektY.database.YDatabaseData;
import projektY.database.YDatabaseList;
import projektY.database.YFieldValue;
import projektY.database.YListFkColumnDefinition;
import projektY.database.YListFkFieldValue;
import projektY.database.YLookUpColumnDefinition;
import projektY.database.YLookUpFieldValue;
import projektY.database.YRowDefinition;
import projektY.database.YRowFkColumnDefinition;
import projektY.database.YRowFkFieldValue;
import projektY.database.YRowObject;

public class YRowValues {
    private YDatabaseData databaseObject;
    private YRowObject rowObject;
    private YDatabaseList databaseList;
    YRowDefinition rowDefinition;
    YFieldValue[] fieldValues;
    YFieldValue[] toStringValues;
    private int rowId;
    int masterRowId;
    private boolean deleteMark;
    private boolean postMark;
    private boolean checked;
    YColumnDefinition coldefChanged;

    public YRowValues(YRowDefinition rowDefinition, int rowId) {
        this.rowDefinition = rowDefinition;
        this.fieldValues = new YFieldValue[rowDefinition.getMaxColumns()];
        this.toStringValues = null;
        this.rowId = rowId;
        this.masterRowId = 0;
        this.deleteMark = false;
        this.postMark = false;
        this.checked = false;
    }

    private YRowValues(YDatabaseData databaseObject, int rowId) {
        this.databaseObject = databaseObject;
        this.rowDefinition = databaseObject.rowDefinition;
        this.fieldValues = new YFieldValue[this.rowDefinition.getMaxColumns()];
        this.toStringValues = null;
        this.rowId = rowId;
        this.masterRowId = 0;
        this.deleteMark = false;
        this.postMark = false;
        this.checked = false;
    }

    public YRowValues(YRowObject rowObject) {
        this(rowObject, 1);
        this.rowObject = rowObject;
        this.databaseList = null;
    }

    public YRowValues(YDatabaseList databaseList, int rowId) {
        this((YDatabaseData)databaseList, rowId);
        this.rowObject = null;
        this.databaseList = databaseList;
    }

    public void createDBFieldValue(YColumnDefinition columnDefinition) {
        this.fieldValues[columnDefinition.getFieldValueIndex()] = new YDBFieldValue(columnDefinition);
    }

    public void createFkFieldValue(YRowFkColumnDefinition rowFkColumnDefinition) throws YProgramException {
        this.fieldValues[rowFkColumnDefinition.getFieldValueIndex()] = new YRowFkFieldValue(rowFkColumnDefinition);
    }

    public void createFkFieldValue(YListFkColumnDefinition listFkColumnDefinition) throws YProgramException {
        this.fieldValues[listFkColumnDefinition.getFieldValueIndex()] = new YListFkFieldValue(listFkColumnDefinition);
    }

    public void createLookUpFieldValue(YLookUpColumnDefinition lookUpColumnDefinition) throws YProgramException {
        this.fieldValues[lookUpColumnDefinition.getFieldValueIndex()] = new YLookUpFieldValue(lookUpColumnDefinition);
    }

    public void createCheckFieldValue(YCheckColumnDefinition checkColumnDefinition) throws YProgramException {
        this.fieldValues[checkColumnDefinition.getFieldValueIndex()] = new YCheckFieldValue(checkColumnDefinition, this);
    }

    public void createAliasFieldValue(YColumnDefinition columnDefinition, YFieldValue linkedValue) {
        this.fieldValues[columnDefinition.getFieldValueIndex()] = new YAliasFieldValue(columnDefinition, linkedValue);
    }

    public int getRowId() {
        return this.rowId;
    }

    public YFieldValue getFieldValue(int fieldValueIndex) throws YProgramException {
        try {
            return this.fieldValues[fieldValueIndex];
        }
        catch (IndexOutOfBoundsException e) {
            throw new YProgramException(this, "Zugriff auf nicht vorhandenen YFieldValue Index=" + fieldValueIndex);
        }
    }

    public YFieldValue getFieldValue(YColumnDefinition columnDefinition) throws YProgramException {
        int fieldValueIndex = columnDefinition.getFieldValueIndex();
        if (fieldValueIndex < 0 || fieldValueIndex >= this.rowDefinition.getNColumns()) {
            throw new YProgramException(this, "Die Spalte " + columnDefinition.getName() + " befindet sich au\u00dferhalb der Zeile.");
        }
        return this.fieldValues[columnDefinition.getFieldValueIndex()];
    }

    public YFieldValue getFieldValue(String fieldName) throws YException {
        int fieldIndex = this.rowDefinition.getFieldValueIndex(fieldName);
        return this.fieldValues[fieldIndex];
    }

    public YFieldValue getPkFieldValue() throws YProgramException {
        return this.getFieldValue(this.rowDefinition.getPkColumnDefinition());
    }

    public void setAsString(int fieldValueIndex, String value) throws YException {
        try {
            this.fieldValues[fieldValueIndex].modifyValue(value);
        }
        catch (NullPointerException e) {
            throw new YProgramException(this, "Zugriff auf nicht initialisierten YFieldValue.");
        }
        catch (IndexOutOfBoundsException e) {
            throw new YProgramException(this, "Zugriff auf nicht vorhandenen YFieldValue Index=" + fieldValueIndex);
        }
    }

    public void setAsString(String fieldName, String value) throws YException {
        int fieldIndex = this.rowDefinition.getFieldValueIndex(fieldName);
        this.setAsString(fieldIndex, value);
    }

    private void modifyToNull(String fieldName) throws YException {
        this.setAsString(fieldName, "");
    }

    public void setAsInt(String fieldName, int value) throws YException {
        int fieldIndex = this.rowDefinition.getFieldValueIndex(fieldName);
        this.setAsString(fieldIndex, Integer.toString(value));
    }

    public void setAsBool(String fieldName, boolean value) throws YException {
        int fieldIndex = this.rowDefinition.getFieldValueIndex(fieldName);
        this.setAsString(fieldIndex, value ? "true" : "false");
    }

    public void setFromRow(String fieldName, Object rowValues, String rowFieldName) throws YException {
        try {
            if (rowValues == null) {
                this.modifyToNull(fieldName);
            } else {
                this.setAsString(fieldName, ((YRowValues)rowValues).getAsString(rowFieldName));
            }
        }
        catch (ClassCastException e) {
            throw new YProgramException(this, rowValues.getClass().getName() + " kann nicht in YRowValues konvertiert werden.");
        }
    }

    public void setFromLookUpValue(String fieldName, Object lookUpValue) throws YException {
        try {
            if (lookUpValue == null) {
                this.modifyToNull(fieldName);
            } else {
                this.setAsString(fieldName, ((YLookUpValue)lookUpValue).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new YProgramException(this, lookUpValue.getClass().getName() + " kann nicht in YLookUpValue konvertiert werden.");
        }
    }

    public String getAsString(int fieldValueIndex) throws YException {
        try {
            return this.fieldValues[fieldValueIndex].getValue();
        }
        catch (NullPointerException e) {
            throw new YProgramException(this, "Zugriff auf nicht initialisierten YFieldValue.");
        }
        catch (IndexOutOfBoundsException e) {
            throw new YProgramException(this, "Zugriff auf nicht vorhandenen YFieldValue Index=" + fieldValueIndex);
        }
    }

    public String getAsString(String fieldName) throws YException {
        int fieldIndex = this.rowDefinition.getFieldValueIndex(fieldName);
        return this.getAsString(fieldIndex);
    }

    public int getAsInt(String fieldName) throws YException {
        int fieldIndex = this.rowDefinition.getFieldValueIndex(fieldName);
        try {
            return Integer.parseInt(this.getAsString(fieldIndex));
        }
        catch (NumberFormatException e) {
            throw new YException("Kein g\u00fcltiger Integer in Spalte '" + fieldName + "'");
        }
    }

    public int getAsInt(String fieldName, int ifNull) throws YException {
        YFieldValue fv = this.fieldValues[this.rowDefinition.getFieldValueIndex(fieldName)];
        if (fv.isNull()) {
            return ifNull;
        }
        try {
            return Integer.parseInt(fv.getValue());
        }
        catch (NumberFormatException e) {
            throw new YException("'" + fv.getValue() + "' ist kein g\u00fcltiger Integerwert.");
        }
    }

    public boolean getAsBool(String fieldName) throws YException {
        return this.getFieldValue(fieldName).getValueAsBool();
    }

    public boolean getAsBool(String fieldName, boolean ifNull) throws YException {
        return this.getFieldValue(fieldName).getValueAsBool(ifNull);
    }

    public String toString() {
        if (this.toStringValues == null || this.toStringValues.length == 0) {
            return "<undefined>";
        }
        if (this.toStringValues.length == 1) {
            if (this.toStringValues[0].isNull()) {
                return "<leer>";
            }
            return this.toStringValues[0].getValue();
        }
        if (this.rowDefinition.concatToString) {
            StringBuffer s = new StringBuffer();
            for (int i = 0; i < this.toStringValues.length; ++i) {
                if (this.toStringValues[i].isNull()) continue;
                if (s.length() > 0) {
                    s.append(this.rowDefinition.concatString);
                }
                s.append(this.toStringValues[i].getValue());
            }
            return s.length() == 0 ? "<leer>" : s.toString();
        }
        for (int i = 0; i < this.toStringValues.length; ++i) {
            if (this.toStringValues[i].isNull()) continue;
            return this.toStringValues[i].getValue();
        }
        return "<leer>";
    }

    public void clear() throws YException {
        for (int i = 0; i < this.rowDefinition.getNColumns(); ++i) {
            this.getFieldValue(i).gotValue("");
        }
    }

    public void modifyToNull() throws YException {
        for (int i = 0; i < this.rowDefinition.getNColumns(); ++i) {
            YFieldValue fieldValue = this.getFieldValue(i);
            if (fieldValue.getColumnDefinition().isReadOnly()) continue;
            fieldValue.modifyToNull();
        }
    }

    public void modifyThisToNull() throws YException {
        for (int i = 0; i < this.rowDefinition.getNColumns(); ++i) {
            YFieldValue fieldValue = this.getFieldValue(i);
            if (fieldValue.getColumnDefinition().isReadOnly() || fieldValue.getColumnDefinition().isAlias()) continue;
            fieldValue.modifyToNull();
        }
    }

    public void revert() throws YException {
        for (int i = 0; i < this.fieldValues.length; ++i) {
            if (this.fieldValues[i] == null) continue;
            this.fieldValues[i].revert();
        }
    }

    public boolean hasNonPkValues() {
        for (int i = 0; i < this.rowDefinition.getNColumns(); ++i) {
            YFieldValue fieldValue = this.fieldValues[i];
            if (fieldValue.isAlias() || fieldValue.getColumnDefinition().isPrimaryKey() || fieldValue.getValue().length() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasVisibleNotNullValues() throws YProgramException {
        int nCols = this.rowDefinition.getNColumns();
        int nVisible = 0;
        for (int iCol = 0; iCol < nCols; ++iCol) {
            YFieldValue fieldValue = this.fieldValues[iCol];
            if (!fieldValue.getColumnDefinition().visible) continue;
            if (!fieldValue.isNull()) {
                return true;
            }
            ++nVisible;
        }
        if (nVisible == 0) {
            throw new YProgramException(this, "Es gibt keine sichtbaren Felder.");
        }
        return false;
    }

    boolean hasValuesToStore() {
        for (int i = 0; i < this.rowDefinition.getNColumns(); ++i) {
            YFieldValue fieldValue = this.fieldValues[i];
            if (fieldValue.isAlias() || fieldValue.getColumnDefinition().isPrimaryKey() || fieldValue.getColumnDefinition().isReadOnly() || fieldValue.getValue().length() <= 0) continue;
            return true;
        }
        return false;
    }

    public void setDeleteMark() {
        this.deleteMark = true;
    }

    public boolean hasDeleteMark() {
        return this.deleteMark;
    }

    public void setPostMark() {
        this.postMark = true;
    }

    public boolean hasPostMark() {
        return this.postMark;
    }

    public void resetMarks() throws YException {
        this.postMark = false;
        this.deleteMark = false;
        for (int iCol = 0; iCol < this.rowDefinition.getNColumns(); ++iCol) {
            this.fieldValues[iCol].revertAuto();
        }
    }

    public boolean setPosted(boolean incldingAlias) throws YException {
        boolean defaultsSet = false;
        if (this.postMark || this.deleteMark) {
            for (int iCol = 0; iCol < this.rowDefinition.getNColumns(); ++iCol) {
                if (!incldingAlias && this.fieldValues[iCol].isAlias()) continue;
                if (this.deleteMark) {
                    YFieldValue fieldValue = this.fieldValues[iCol];
                    if (fieldValue.getColumnDefinition().isReadOnly()) {
                        fieldValue.setROValue("");
                    } else {
                        fieldValue.modifyToNull();
                    }
                }
                defaultsSet |= this.fieldValues[iCol].setPosted();
            }
            this.postMark = false;
            this.deleteMark = false;
        } else {
            for (int iCol = 0; iCol < this.rowDefinition.getNColumns(); ++iCol) {
                this.fieldValues[iCol].revertAuto();
            }
        }
        return defaultsSet;
    }

    public boolean setPosted() throws YException {
        return this.setPosted(false);
    }

    protected void setChecked(boolean checked) {
        this.checked = checked;
    }

    protected boolean isChecked() {
        return this.checked;
    }

    public boolean hasChanged() {
        for (int iCol = 0; iCol < this.rowDefinition.getNColumns(); ++iCol) {
            if (this.fieldValues[iCol].isAlias() || !this.fieldValues[iCol].hasChanged()) continue;
            this.coldefChanged = this.fieldValues[iCol].getColumnDefinition();
            return true;
        }
        this.coldefChanged = null;
        return false;
    }

    public boolean hasAnyChanged() {
        for (int iCol = 0; iCol < this.rowDefinition.getNColumns(); ++iCol) {
            if (!this.fieldValues[iCol].hasChanged()) continue;
            this.coldefChanged = this.fieldValues[iCol].getColumnDefinition();
            return true;
        }
        this.coldefChanged = null;
        return false;
    }

    public YColumnDefinition getColdefChanged() {
        return this.coldefChanged;
    }

    public boolean isRowDefinitionEqualTo(YRowDefinition rowDefinition) {
        return this.rowDefinition == rowDefinition;
    }
}

