/*
 * Decompiled with CFR 0.152.
 */
package projektY.html;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.base.YUserException;
import projektY.html.YHTMLGenerator;

public class YHTMLParser {
    private LineNumberReader in;
    private PrintStream out;
    private Vector<YHTMLItem> items = new Vector(50, 20);

    public YHTMLParser(InputStream vorlage) throws YException {
        this.compile(vorlage);
    }

    private void compile(InputStream vorlage) throws YException {
        this.in = new LineNumberReader(new InputStreamReader(vorlage));
        Pattern patTag = Pattern.compile("<!--/?Y[A-Z]+/?.*?-->");
        Pattern patAttribut = Pattern.compile("[a-z]+=([^\" ]+|\"[^\"]*\")");
        Stack<YHTMLTag> htmlTags = new Stack<YHTMLTag>();
        try {
            this.items.clear();
            StringBuffer htmlText = new StringBuffer(2000);
            int sampleLevel = 0;
            while (true) {
                String line;
                if ((line = this.in.readLine()) == null) {
                    if (htmlText.length() > 0) {
                        this.items.add(new YHTMLText(htmlText.toString()));
                    }
                    return;
                }
                int startScanLine = 0;
                Matcher matcherTag = patTag.matcher(line);
                while (startScanLine < line.length() && matcherTag.find(startScanLine)) {
                    boolean isStartTag;
                    String tagAttribute;
                    String tagName;
                    if (matcherTag.start() > startScanLine && sampleLevel == 0) {
                        htmlText.append(line.substring(startScanLine, matcherTag.start()));
                    }
                    if (htmlText.length() > 0) {
                        this.items.add(new YHTMLText(htmlText.toString()));
                        htmlText.setLength(0);
                    }
                    startScanLine = matcherTag.end();
                    String tag = line.substring(matcherTag.start() + 4, matcherTag.end() - 3);
                    tag = tag.replaceAll(" *= *", "=");
                    int iPosLine = (tag = tag.replaceFirst(" *$", "")).indexOf(32);
                    if (iPosLine > 0) {
                        tagName = tag.substring(0, iPosLine);
                        tagAttribute = tag.substring(iPosLine + 1);
                    } else {
                        tagName = tag;
                        tagAttribute = "";
                    }
                    boolean isEndTag = tagName.startsWith("/");
                    boolean bl = isStartTag = !isEndTag;
                    if (isStartTag) {
                        isEndTag = tagName.endsWith("/");
                        if (isEndTag) {
                            tagName = tagName.substring(0, tagName.length() - 1);
                        }
                    } else {
                        tagName = tagName.substring(1);
                    }
                    YHTMLTagAttributes attributes = new YHTMLTagAttributes();
                    Matcher matcherAttribut = patAttribut.matcher(tagAttribute);
                    int startScanAttriute = 0;
                    while (startScanAttriute < tagAttribute.length() && matcherAttribut.find(startScanAttriute)) {
                        startScanAttriute = matcherAttribut.end() + 1;
                        String[] attribWert = tagAttribute.substring(matcherAttribut.start(), matcherAttribut.end()).split("=");
                        if (attribWert.length > 2) {
                            for (int i = 2; i < attribWert.length; ++i) {
                                attribWert[1] = attribWert[1] + "=" + attribWert[i];
                            }
                        }
                        attributes.add(new YHTMLTagAttibute(attribWert[0], attribWert[1]));
                    }
                    YHTMLTag htmlTag = new YHTMLTag(tagName, isStartTag, isEndTag, this.items.size(), attributes);
                    boolean isStandardTag = false;
                    if (tagName.equals("YYY") || tagName.equals("YTABLE") || tagName.equals("YTH") || tagName.equals("YTR") || tagName.equals("YOPTION") || tagName.equals("YLOOP")) {
                        if (isStartTag && isEndTag) {
                            throw new YException(this.in.getLineNumber() + ": " + tagName + " kann nicht gleichzeitig Start und Ende sein.");
                        }
                        isStandardTag = true;
                    }
                    if (tagName.equals("YTEXT") || tagName.equals("YTD")) {
                        if (!isStartTag || !isEndTag) {
                            throw new YException(this.in.getLineNumber() + ": " + tagName + " mu\u00df gleichzeitig Start und Ende sein.");
                        }
                        isStandardTag = true;
                    }
                    if (!(isStandardTag || isStartTag && isEndTag)) {
                        throw new YException(this.in.getLineNumber() + ": " + "Nicht-Standard-Tag " + tagName + " mu\u00df gleichzeitig Start und Ende sein.");
                    }
                    if (htmlTag.isStartTag() && !htmlTag.isEndTag()) {
                        htmlTags.push(htmlTag);
                    } else if (htmlTag.isEndTag() && !htmlTag.isStartTag()) {
                        if (htmlTags.isEmpty()) {
                            throw new YException(this.in.getLineNumber() + ": Starttag zu " + htmlTag.getName() + "/ fehlt.");
                        }
                        YHTMLTag startTag = (YHTMLTag)htmlTags.pop();
                        if (!startTag.getName().equals(htmlTag.getName())) {
                            throw new YException(this.in.getLineNumber() + ": Verschachtelungsfehler: " + htmlTag.getName() + "/ pa\u00dft nicht zu " + startTag.getName());
                        }
                        htmlTag.setStartItemIndex(startTag.getItemIndex());
                        startTag.setEndItemIndex(htmlTag.getItemIndex());
                    }
                    if (isStartTag && tagName.equals("YYY")) {
                        ++sampleLevel;
                    }
                    if (sampleLevel == 0) {
                        this.items.add(htmlTag);
                    }
                    if (!isEndTag || !tagName.equals("YYY")) continue;
                    --sampleLevel;
                }
                if (startScanLine == 0) {
                    if (sampleLevel != 0) continue;
                    htmlText.append(line);
                    htmlText.append('\n');
                    continue;
                }
                if (sampleLevel != 0) continue;
                if (line.length() > startScanLine) {
                    htmlText.append(line.substring(startScanLine));
                }
                htmlText.append('\n');
            }
        }
        catch (IOException e) {
            throw new YException("I/O-Fehler: " + e.toString());
        }
    }

    public final void run(YHTMLGenerator generator) throws YException {
        this.out = new PrintStream(generator.getOutputStream());
        for (int iItem = 0; iItem < this.items.size(); ++iItem) {
            YHTMLItem item = this.items.get(iItem);
            if (item.isHtmlText()) {
                YHTMLText text = (YHTMLText)item;
                this.out.write(text.getText().getBytes(), 0, text.getText().getBytes().length);
                continue;
            }
            YHTMLTag tag = (YHTMLTag)item;
            String tagName = tag.getName();
            YHTMLTagAttributes attributes = tag.getAttributes();
            if (tagName.equals("YTEXT")) {
                generator.insertText(attributes);
                continue;
            }
            if (tagName.equals("YTABLE")) {
                if (tag.isStartTag()) {
                    if (generator.startTable(attributes)) continue;
                    iItem = tag.getEndItemIndex();
                    continue;
                }
                if (!tag.isEndTag()) continue;
                generator.endTable();
                continue;
            }
            if (tagName.equals("YTH")) {
                if (tag.isStartTag()) {
                    if (generator.startTH(attributes)) continue;
                    iItem = tag.getEndItemIndex();
                    continue;
                }
                if (!tag.isEndTag) continue;
                generator.endTH();
                continue;
            }
            if (tagName.equals("YTR")) {
                if (tag.isStartTag()) {
                    if (generator.nextRow(attributes)) continue;
                    iItem = tag.getEndItemIndex();
                    continue;
                }
                if (!tag.isEndTag()) continue;
                iItem = tag.getStartItemIndex() - 1;
                continue;
            }
            if (tagName.equals("YTD")) {
                generator.insertTD(attributes);
                continue;
            }
            if (tagName.equals("YOPTION")) {
                if (generator.checkOption(attributes)) continue;
                iItem = tag.getEndItemIndex();
                continue;
            }
            if (tagName.equals("YLOOP")) {
                if (tag.isStartTag()) {
                    if (generator.nextLoop(attributes)) continue;
                    iItem = tag.getEndItemIndex();
                    continue;
                }
                if (!tag.isEndTag()) continue;
                iItem = tag.getStartItemIndex() - 1;
                continue;
            }
            generator.handleTag(tag);
        }
    }

    class YHTMLText
    extends YHTMLItem {
        private String text;

        private YHTMLText(String text) throws YException {
            this.text = text;
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) <= '\u007f') continue;
                throw new YUserException("Ung\u00fcltiges HTML-Zeichen '" + text.charAt(i) + "' in der HTML-Vorlage.");
            }
        }

        final boolean isHtmlTag() {
            return false;
        }

        final boolean isHtmlText() {
            return true;
        }

        private String getText() {
            return this.text;
        }
    }

    public class YHTMLTag
    extends YHTMLItem {
        private String name;
        private boolean isStartTag;
        private boolean isEndTag;
        private int itemIndex;
        private int startItemIndex;
        private int endItemIndex;
        private YHTMLTagAttributes attributes;

        private YHTMLTag(String name, boolean isStartTag, boolean isEndTag, int itemIndex, YHTMLTagAttributes attributes) throws YProgramException {
            this.name = name;
            this.isStartTag = isStartTag;
            this.isEndTag = isEndTag;
            if (!isStartTag && !isEndTag) {
                throw new YProgramException(this, "YHTMLTag ist weder Start- noch Endtag.");
            }
            this.itemIndex = itemIndex;
            this.startItemIndex = -1;
            this.endItemIndex = -1;
            this.attributes = attributes;
        }

        final boolean isHtmlTag() {
            return true;
        }

        final boolean isHtmlText() {
            return false;
        }

        public final String getName() {
            return this.name;
        }

        public final boolean isStartTag() {
            return this.isStartTag;
        }

        public final boolean isEndTag() {
            return this.isEndTag;
        }

        private int getItemIndex() {
            return this.itemIndex;
        }

        private void setStartItemIndex(int startItemIndex) throws YProgramException {
            if (this.isStartTag) {
                throw new YProgramException(this, "Ein Starttag kann keinen Index f\u00fcr ein zugeh\u00f6riges Starttag haben.");
            }
            if (!this.isEndTag) {
                throw new YProgramException(this, "Nur ein Endtag kann einen Index f\u00fcr ein zugeh\u00f6riges Starttag haben.");
            }
            this.startItemIndex = startItemIndex;
        }

        private int getStartItemIndex() throws YProgramException {
            if (this.startItemIndex == -1) {
                throw new YProgramException(this, "Abruf eines nicht definierten startItemIndex");
            }
            return this.startItemIndex;
        }

        private void setEndItemIndex(int endItemIndex) throws YProgramException {
            if (this.isEndTag) {
                throw new YProgramException(this, "Ein Endtag kann keinen Index f\u00fcr ein zugeh\u00f6riges Endtag haben.");
            }
            if (!this.isStartTag) {
                throw new YProgramException(this, "Nur ein Starttag kann einen Index f\u00fcr ein zugeh\u00f6riges Endtag haben.");
            }
            this.endItemIndex = endItemIndex;
        }

        private int getEndItemIndex() throws YProgramException {
            if (this.endItemIndex == -1) {
                throw new YProgramException(this, YHTMLParser.this.in.getLineNumber() + ": Abruf eines nicht definierten endItemIndex");
            }
            return this.endItemIndex;
        }

        public final YHTMLTagAttributes getAttributes() {
            return this.attributes;
        }
    }

    public class YHTMLTagAttributes {
        private Vector<YHTMLTagAttibute> attributes = new Vector(10);

        private YHTMLTagAttributes() {
        }

        private void add(YHTMLTagAttibute attribute) {
            this.attributes.add(attribute);
        }

        public final int getCount() {
            return this.attributes.size();
        }

        public final String getAttributeValue(String name) {
            for (int iAttr = 0; iAttr < this.attributes.size(); ++iAttr) {
                if (!this.attributes.get(iAttr).getName().equals(name)) continue;
                return this.attributes.get(iAttr).getValue();
            }
            return null;
        }
    }

    public class YHTMLTagAttibute {
        private String name;
        private String value;

        private YHTMLTagAttibute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public final String getName() {
            return this.name;
        }

        public final String getValue() {
            return this.value;
        }
    }

    public abstract class YHTMLItem {
        abstract boolean isHtmlTag();

        abstract boolean isHtmlText();
    }
}

