/*
 * Decompiled with CFR 0.152.
 */
package popometer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import popometer.YPopometerDatabase;
import popometer.YPopometerSession;
import popometer.dbobjects.YDLAnfrageeinsbed;
import popometer.dbobjects.YEVAnfrageeinsbed;
import popometer.dbobjects.YEVAusfuehrungen;
import popometer.dbobjects.YQLBilder;
import popometer.dbobjects.YRLEinsatzbereiche;
import popometer.dbobjects.YROAnfrage;
import popometer.dbobjects.YROAusfuehrung;
import popometer.dbobjects.YROEinsatzbereich;
import popometer.dbobjects.YROHaendler;
import popometer.dbobjects.YROKunde;
import popometer.forms.DlgEigenesPasswort;
import popometer.forms.DlgInfo;
import popometer.panels.PanAuswertungen;
import popometer.panels.PanBestellungen;
import popometer.panels.PanEinsatzbereich;
import popometer.panels.PanErgebnis;
import popometer.panels.PanKundendaten;
import popometer.panels.PanStammdaten;
import popometer.panels.PanVerkaeufer;
import projektY.base.YException;
import projektY.base.YUserException;
import projektY.utils.YConfigFile;

public class FrmNavigator
extends JFrame {
    private YConfigFile configFile;
    private YPopometerSession session;
    private YROHaendler haendler;
    private YROKunde kunde;
    private PanKundendaten panKundendaten;
    private PanAuswertungen panAuswertungen;
    private PanBestellungen panBestellungen;
    private PanStammdaten panStammdaten;
    private PanVerkaeufer panVerkaeufer;
    private PanEinsatzbereich[] panEinsatzbereich;
    private YEVAusfuehrungen produkte;
    private PanErgebnis panErgebnis;
    private YEVAnfrageeinsbed evAnfrageeinsbed;
    private YROAnfrage anfrage;
    private Vector<Integer> einsbedingungIds;
    private int rolle;
    private JButton cmdAnfrageSpeichern;
    private JButton cmdErgebnis;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JLabel lblLogo;
    private JMenuItem mniBeenden;
    private JMenuItem mniClearCache;
    private JMenuItem mniInfo;
    private JMenuItem mniPasswort;
    private JMenuItem mniTimeout;
    private JMenu mnuDatei;
    private JMenu mnuEinrichten;
    private JMenu mnuHilfe;
    private JMenuBar mnuMain;
    private JPanel panKontakt;
    private JTabbedPane panMain;

    public FrmNavigator(YPopometerSession session, YConfigFile configFile) throws YException {
        this.session = session;
        this.initComponents();
        this.configFile = configFile;
        this.rolle = session.getRolle();
        if (this.rolle == 2) {
            Object[] optionen = new Object[]{"H\u00e4ndler", "Verk\u00e4ufer"};
            int o = JOptionPane.showOptionDialog(this, "Bitte w\u00e4hlen Sie die gew\u00fcnschte Art der Anmeldung.", "Anmelden als ...", 1, 3, null, optionen, optionen[0]);
            if (o == -1) {
                throw new YUserException("Die Anmeldung wurde abgebrochen.");
            }
            this.rolle = 2 + o;
        }
        if (this.rolle == 2) {
            this.haendler = new YROHaendler(session);
            this.panBestellungen = new PanBestellungen(this, session);
            this.panMain.addTab("Bestellungen", this.panBestellungen);
            this.panStammdaten = new PanStammdaten(this, this.haendler);
            this.panMain.addTab("Stammdaten", this.panStammdaten);
            this.panVerkaeufer = new PanVerkaeufer(session, this.haendler);
            this.panMain.addTab("(Weitere) Verk\u00e4ufer", this.panVerkaeufer);
            this.panAuswertungen = new PanAuswertungen(this, session);
            this.panMain.addTab("Auswertungen", this.panAuswertungen);
            this.cmdErgebnis.setVisible(false);
            this.cmdAnfrageSpeichern.setVisible(false);
        } else {
            this.mnuMain.remove(this.mnuEinrichten);
            this.produkte = new YEVAusfuehrungen(session);
            this.anfrage = new YROAnfrage(session);
            this.evAnfrageeinsbed = new YEVAnfrageeinsbed(session);
            this.panErgebnis = new PanErgebnis(session, this.produkte);
            this.kunde = new YROKunde(session);
            this.panKundendaten = new PanKundendaten(session, this.kunde, this.anfrage, this);
            this.panMain.addTab("Kundendaten", this.panKundendaten);
            YRLEinsatzbereiche einsatzbereiche = new YRLEinsatzbereiche(session);
            einsatzbereiche.fetch();
            int nEinsb = einsatzbereiche.getRowCount();
            this.panEinsatzbereich = new PanEinsatzbereich[nEinsb];
            for (int iEinsb = 0; iEinsb < nEinsb; ++iEinsb) {
                this.panEinsatzbereich[iEinsb] = new PanEinsatzbereich(session, einsatzbereiche.getAsInt(iEinsb, "einsbereich_id"));
                this.panMain.addTab(einsatzbereiche.getRowValues(iEinsb).toString(), this.panEinsatzbereich[iEinsb]);
            }
            this.lblLogo.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/logo-sq-lab.png")));
            this.cmdErgebnis.setVisible(true);
            this.einsbedingungIds = new Vector(nEinsb + 20);
        }
        if (configFile != null && configFile.findValue("MAXIMIZED").equals("true")) {
            this.setExtendedState(6);
        }
    }

    public boolean zeigeAnfrage(int anfrageId) throws YException {
        boolean alleGesetzt = true;
        this.anfrage.fetch(anfrageId);
        YDLAnfrageeinsbed anfrageeinsbed = this.anfrage.getAnfrageeinsbed();
        for (int i = 0; i < this.panEinsatzbereich.length; ++i) {
            alleGesetzt &= this.panEinsatzbereich[i].setEinsbedingungen(anfrageeinsbed);
        }
        return alleGesetzt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitPopometer(boolean force) {
        block23: {
            try {
                if (this.rolle == 3) {
                    if (!this.panKundendaten.hasChanged()) break block23;
                    if (force) {
                        JOptionPane.showMessageDialog(this, "Ge\u00e4nderte Kundendaten gehen verloren.", "Ungesicherte \u00c4nderungen", 2);
                        break block23;
                    }
                    JOptionPane.showMessageDialog(this, "Ge\u00e4nderte Kundendaten bitte speichern oder verwerfen.", "Ungesicherte \u00c4nderungen", 1);
                    this.panMain.setSelectedComponent(this.panKundendaten);
                    return;
                }
                if (this.panBestellungen.hasBestellpos()) {
                    if (force) {
                        JOptionPane.showMessageDialog(this, "Die Eintr\u00e4ge in der Bestellung gehen verloren.", "Ungesicherte \u00c4nderungen", 2);
                    } else {
                        int a = JOptionPane.showConfirmDialog(this, "Es gibt nicht abgeschickte Eintr\u00e4ge in der Bestellungen.\nBestellung nochmal anschauen ?", "Ungesicherte \u00c4nderungen", 0, 3);
                        if (a == 0) {
                            this.panMain.setSelectedComponent(this.panBestellungen);
                            this.panBestellungen.setSelectedPanel(0);
                            return;
                        }
                    }
                }
                if (this.panBestellungen.hasStatusChanged()) {
                    if (force) {
                        JOptionPane.showMessageDialog(this, "Die Status\u00e4nderungen bei den Bestellungen gehen verloren.", "Ungesicherte \u00c4nderungen", 2);
                    } else {
                        JOptionPane.showMessageDialog(this, "Die Status\u00e4nderungen bei den Bestellungen bitte speichern oder zur\u00fccknehmen.", "Ungesicherte \u00c4nderungen", 1);
                        this.panMain.setSelectedComponent(this.panBestellungen);
                        this.panBestellungen.setSelectedPanel(1);
                        return;
                    }
                }
                if (this.panStammdaten.hasChanged()) {
                    if (force) {
                        JOptionPane.showMessageDialog(this, "Die \u00c4nderungen an den Stammdaten gehen verloren.", "Ungesicherte \u00c4nderungen", 2);
                    } else {
                        JOptionPane.showMessageDialog(this, "Die \u00c4nderungen an den Stammdaten bitte speichern oder verwerfen.", "Ungesicherte \u00c4nderungen", 1);
                        this.panMain.setSelectedComponent(this.panStammdaten);
                        return;
                    }
                }
                if (!this.panVerkaeufer.hasChanged()) break block23;
                if (force) {
                    JOptionPane.showMessageDialog(this, "Die \u00c4nderungen bei den Verk\u00e4ufern gehen verloren.", "Ungesicherte \u00c4nderungen", 2);
                    break block23;
                }
                JOptionPane.showMessageDialog(this, "Die \u00c4nderungen bei den Verk\u00e4ufern bitte speichern oder verwerfen.", "Ungesicherte \u00c4nderungen", 1);
                this.panMain.setSelectedComponent(this.panVerkaeufer);
                return;
            }
            catch (YException e) {
                JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
            }
        }
        try {
            if (this.configFile != null) {
                int extendedState = this.getExtendedState();
                if ((extendedState & 6) == 6) {
                    this.configFile.setEntry("MAXIMIZED", "true");
                } else {
                    this.configFile.setEntry("MAXIMIZED", "false");
                }
                this.configFile.write();
            }
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
        finally {
            this.session.getDatabase().disconnect();
            System.exit(0);
        }
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.lblLogo = new JLabel();
        this.cmdErgebnis = new JButton();
        this.cmdAnfrageSpeichern = new JButton();
        this.panMain = new JTabbedPane();
        this.panKontakt = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.mnuMain = new JMenuBar();
        this.mnuDatei = new JMenu();
        this.mniPasswort = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.mniBeenden = new JMenuItem();
        this.mnuEinrichten = new JMenu();
        this.mniTimeout = new JMenuItem();
        this.mniClearCache = new JMenuItem();
        this.mnuHilfe = new JMenu();
        this.mniInfo = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FrmNavigator.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.jPanel2.add((Component)this.lblLogo, gridBagConstraints);
        this.cmdErgebnis.setText("Produktsuche");
        this.cmdErgebnis.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmNavigator.this.cmdErgebnisActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel2.add((Component)this.cmdErgebnis, gridBagConstraints);
        this.cmdAnfrageSpeichern.setText("Anfrage speichern");
        this.cmdAnfrageSpeichern.setEnabled(false);
        this.cmdAnfrageSpeichern.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmNavigator.this.cmdAnfrageSpeichernActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel2.add((Component)this.cmdAnfrageSpeichern, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.panMain, gridBagConstraints);
        this.panKontakt.setBackground(new Color(204, 204, 204));
        this.panKontakt.setBorder(BorderFactory.createTitledBorder(null, "Und wer hats gemacht ...?", 2, 5, new Font("DejaVu Sans", 0, 0)));
        this.jLabel1.setText("SQlab GmbH | Frundsbergstr. 27-29 | D-82064 Strasslach ");
        this.jLabel1.setVerticalAlignment(3);
        this.panKontakt.add(this.jLabel1);
        this.jLabel4.setText("| Tel: +49 8170 9983-0 ");
        this.panKontakt.add(this.jLabel4);
        this.jLabel3.setText("| Fax: +49 8170 9983-18");
        this.panKontakt.add(this.jLabel3);
        this.jLabel2.setText(" | info@sq-lab.com");
        this.panKontakt.add(this.jLabel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.panKontakt, gridBagConstraints);
        this.mnuDatei.setMnemonic('D');
        this.mnuDatei.setText("Datei");
        this.mniPasswort.setMnemonic('P');
        this.mniPasswort.setText("Passwort \u00e4ndern ...");
        this.mniPasswort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmNavigator.this.mniPasswortActionPerformed(evt);
            }
        });
        this.mnuDatei.add(this.mniPasswort);
        this.mnuDatei.add(this.jSeparator1);
        this.mniBeenden.setAccelerator(KeyStroke.getKeyStroke(69, 8));
        this.mniBeenden.setMnemonic('e');
        this.mniBeenden.setText("Beenden");
        this.mniBeenden.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmNavigator.this.mniBeendenActionPerformed(evt);
            }
        });
        this.mnuDatei.add(this.mniBeenden);
        this.mnuMain.add(this.mnuDatei);
        this.mnuEinrichten.setMnemonic('E');
        this.mnuEinrichten.setText("Einrichten");
        this.mniTimeout.setText("Connection Timeout setzen ...");
        this.mniTimeout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmNavigator.this.mniTimeoutActionPerformed(evt);
            }
        });
        this.mnuEinrichten.add(this.mniTimeout);
        this.mniClearCache.setText("Image Cache l\u00f6schen ...");
        this.mniClearCache.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmNavigator.this.mniClearCacheActionPerformed(evt);
            }
        });
        this.mnuEinrichten.add(this.mniClearCache);
        this.mnuMain.add(this.mnuEinrichten);
        this.mnuHilfe.setMnemonic('?');
        this.mnuHilfe.setText("?");
        this.mniInfo.setMnemonic('n');
        this.mniInfo.setText("Info");
        this.mniInfo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmNavigator.this.mniInfoActionPerformed(evt);
            }
        });
        this.mnuHilfe.add(this.mniInfo);
        this.mnuMain.add(this.mnuHilfe);
        this.setJMenuBar(this.mnuMain);
        this.pack();
    }

    private void mniBeendenActionPerformed(ActionEvent evt) {
        this.exitPopometer(false);
    }

    private void cmdErgebnisActionPerformed(ActionEvent evt) {
        try {
            this.einsbedingungIds.clear();
            int nPanels = this.panEinsatzbereich.length;
            for (int iPanel = 0; iPanel < nPanels; ++iPanel) {
                if (this.panEinsatzbereich[iPanel].getEinsbedingungIds(this.einsbedingungIds)) continue;
                YROEinsatzbereich einsatzbereich = this.panEinsatzbereich[iPanel].getEinsatzbereich();
                JOptionPane.showMessageDialog(this, "Bitte noch die Auswahl f\u00fcr '" + einsatzbereich.toString() + "' vornehmen.", "Hinweis", -1);
                this.panMain.setSelectedComponent(this.panEinsatzbereich[iPanel]);
                return;
            }
            if (this.panMain.indexOfComponent(this.panErgebnis) == -1) {
                this.panMain.addTab("Geeignete Produkte", this.panErgebnis);
            }
            this.panErgebnis.holeProdukte(this.einsbedingungIds);
            this.panMain.setSelectedComponent(this.panErgebnis);
            this.cmdAnfrageSpeichern.setEnabled(true);
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.exitPopometer(true);
    }

    private void mniInfoActionPerformed(ActionEvent evt) {
        DlgInfo dlgInfo = new DlgInfo((Frame)this, this.session);
        dlgInfo.setVisible(true);
    }

    private void cmdAnfrageSpeichernActionPerformed(ActionEvent evt) {
        int kunde_id = 0;
        boolean update = false;
        int anfrageStatus = 1;
        try {
            int a;
            YROAusfuehrung bestellung = this.panErgebnis.getBestellung();
            if (bestellung == null) {
                a = JOptionPane.showConfirmDialog(this, "Soll ein Produkt bestellt werden ?", "", 0);
                if (a == 0) {
                    this.panMain.setSelectedComponent(this.panErgebnis);
                    return;
                }
            } else if (this.panErgebnis.isNachbestellung()) {
                anfrageStatus = 5;
            }
            if (this.kunde.requestValuesToStore()) {
                if (this.kunde.hasChanged()) {
                    JOptionPane.showMessageDialog(this, "Bitte speichern Sie zuerst die Kundendaten !");
                    this.panMain.setSelectedComponent(this.panKundendaten);
                    return;
                }
                kunde_id = this.kunde.getPkFieldValueAsInt();
            } else {
                a = bestellung != null && anfrageStatus == 1 ? JOptionPane.showConfirmDialog(this, "Eine Vorbestellung erfordert die zugeh\u00f6rigen Kundendaten.\nKundendaten erfassen oder suchen ?", "", 0) : JOptionPane.showConfirmDialog(this, "Kundendaten erfassen oder suchen ?", "", 0);
                if (a == 0) {
                    this.panMain.setSelectedComponent(this.panKundendaten);
                    return;
                }
                if (bestellung != null && anfrageStatus == 1) {
                    return;
                }
            }
            if (kunde_id == 0 && this.anfrage.getAsInt("kunde_id", 0) == 0 && !this.anfrage.getPkFieldValue().isNull()) {
                a = JOptionPane.showConfirmDialog(this, "Betrifft diese Anfrage einen weiteren anonymen Kunden ?", "", 1);
                if (a == 2) {
                    return;
                }
                if (a == 1) {
                    update = true;
                }
            } else if (kunde_id == this.anfrage.getAsInt("kunde_id", 0) && this.anfrage.getAsString("datum").equals(this.session.stringToday()) && !this.anfrage.getFieldValue("bestellung_id").isNull() && (a = JOptionPane.showConfirmDialog(this, "Soll die letzte Anfrage inklusive Bestellung ge\u00e4ndert werden ?\nBei 'nein' wird eine weitere Anfrage mit der Bstellung gespeichert.", "", 0)) == 0) {
                update = true;
            }
            if ((a = JOptionPane.showConfirmDialog(this, "Kunde: " + (kunde_id == 0 ? "(anonym)" : this.kunde.toString()) + "\n" + (bestellung == null ? "(keine Bestellung)" : "Bestellen: " + bestellung.toString()), update ? "Letzte Anfrage aktualisieren" : "Neue Anfrage speichern", 2)) == 2) {
                return;
            }
            if (!update) {
                this.anfrage.clear();
            }
            this.anfrage.setAsInt("status", anfrageStatus);
            YDLAnfrageeinsbed anfrageeinsbed = this.anfrage.getAnfrageeinsbed();
            this.anfrage.setAsInt("prodart_id", 1);
            if (kunde_id > 0) {
                this.anfrage.setAsInt("kunde_id", kunde_id);
            }
            this.anfrage.setAsString("datum", this.session.stringToday());
            this.anfrage.setAsInt("ausfuehrung_id", this.panErgebnis.getBestellung().getPkFieldValueAsInt());
            if (bestellung == null) {
                this.anfrage.setAsInt("produkt_id", this.panErgebnis.getTopProdukt().getAsInt("produkt_id"));
                this.anfrage.setAsInt("ausfuehrung_id", this.panErgebnis.getTopProdukt().getAsInt("ausfuehrung_id"));
            } else {
                this.anfrage.setAsInt("produkt_id", bestellung.getAsInt("produkt_id"));
                this.anfrage.setAsInt("ausfuehrung_id", bestellung.getAsInt("ausfuehrung_id"));
                this.anfrage.setAsInt("vorbestellt_id", bestellung.getAsInt("ausfuehrung_id"));
            }
            this.evAnfrageeinsbed.setFilterValues("einsbedingung_id", this.einsbedingungIds.toArray());
            this.evAnfrageeinsbed.fetch();
            int n = this.evAnfrageeinsbed.getRowCount();
            for (int i = 0; i < n; ++i) {
                anfrageeinsbed.setAsString(i, "einsbereich_id", this.evAnfrageeinsbed.getAsString(i, "einsbereich_id"));
                anfrageeinsbed.setAsString(i, "einsatzbereich", this.evAnfrageeinsbed.getAsString(i, "einsatzbereich"));
                anfrageeinsbed.setAsString(i, "einsbedingung_id", this.evAnfrageeinsbed.getAsString(i, "einsbedingung_id"));
                anfrageeinsbed.setAsString(i, "bedingung", this.evAnfrageeinsbed.getAsString(i, "bedingung"));
            }
            this.anfrage.post();
            this.cmdAnfrageSpeichern.setEnabled(false);
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void mniPasswortActionPerformed(ActionEvent evt) {
        DlgEigenesPasswort dlgPasswort = new DlgEigenesPasswort((Frame)this, this.session);
        dlgPasswort.setVisible(true);
    }

    private void mniTimeoutActionPerformed(ActionEvent evt) {
        String timeout0 = this.session.getConfigFile().findValue("TIMEOUT");
        String timeout = JOptionPane.showInputDialog(this, "Setzen Sie hier die Zeit (in Minuten), nach der eine Neuanmeldung erforderlich wird.\nBenutzen Sie diese Funktion um das Risiko unberechtigter Zugriffe zu minimieren.", timeout0);
        if (timeout == null) {
            return;
        }
        if (timeout.equals(timeout0)) {
            return;
        }
        try {
            int intTimeout = timeout.length() == 0 ? 0 : Integer.parseInt(timeout);
            ((YPopometerDatabase)this.session.getDatabase()).setTimeout(intTimeout * 60);
            this.session.getConfigFile().setEntry("TIMEOUT", timeout);
            if (intTimeout == 0) {
                JOptionPane.showMessageDialog(this, "Das Timeout wurde ausgeschaltet.");
            } else {
                JOptionPane.showMessageDialog(this, "Das Timeout wurde neu gesetzt.");
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Ung\u00fcltige Zahl: " + timeout, "Fehler", 0);
        }
    }

    private void mniClearCacheActionPerformed(ActionEvent evt) {
        int a = JOptionPane.showConfirmDialog(this, "Nach dem L\u00f6schen werden die Bilder erneut vom Server geholt.\nBenutzen Sie diese Funktion, wenn Bilder z.T. verst\u00fcmmelt dargestellt werden.", "Hinweis", 2, 1);
        if (a == 2) {
            return;
        }
        try {
            YQLBilder bilder = this.session.getBilder();
            YConfigFile configFile = this.session.getConfigFile();
            String cacheDir = configFile.findValue("CACHEDIR");
            if (!cacheDir.endsWith("/")) {
                cacheDir = cacheDir + "/";
            }
            String imageDir = cacheDir + "images";
            String thumbDir = imageDir + "/thumbs";
            int nDeleted = 0;
            for (int iRow = 0; iRow < bilder.getRowCount(); ++iRow) {
                bilder.setAsBool(iRow, "aktuell", false);
                bilder.setAsBool(iRow, "aktuell_thumb", false);
                String imageName = bilder.getAsString(iRow, "name") + ".jpg";
                File imageFile = new File(imageDir, imageName);
                if (imageFile.delete()) {
                    ++nDeleted;
                }
                if (!(imageFile = new File(thumbDir, imageName)).delete()) continue;
                ++nDeleted;
            }
            JOptionPane.showMessageDialog(this, nDeleted + " Dateien wurden gel\u00f6scht.");
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }
}

