/*
 * Decompiled with CFR 0.152.
 */
package popometer;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import popometer.FrmNavigator;
import popometer.SplashScreen;
import popometer.YPopometerDatabase;
import popometer.YPopometerSession;
import popometer.swing.DlgPasswd;
import projektY.base.YException;
import projektY.swing.DlgConnect;
import projektY.swing.Utils;
import projektY.utils.YConfigFile;

public class Main {
    private static YConfigFile yConfigFile;
    private static YPopometerSession session;
    private static DlgConnect dlgConnect;

    public static void main(String[] args) {
        JFrame loginFenster = new JFrame();
        loginFenster.setIconImage(Main.getImage());
        try {
            UIManager.setLookAndFeel("SQlabLookAndFeel.SQlabLookAndFeel");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage() + "\nDas Programm kann trotzdem ausgef\u00fchrt werden.", " Hinweis", 2);
        }
        try {
            String[] pathExtensions;
            File configFile;
            File popometerHome = new File(System.getProperty("user.home"), ".popometer");
            if (popometerHome.exists()) {
                if (!popometerHome.isDirectory()) {
                    throw new YException(popometerHome.getAbsolutePath() + " ist kein Verzeichnis.\n" + "Bitte l\u00f6schen Sie diese Datei und starten Sie danach neu.");
                }
            } else if (!popometerHome.mkdir()) {
                throw new YException("Das Verzeichnis kann nicht angelegt werden.");
            }
            if (!(configFile = new File(popometerHome, "/popometer.conf")).exists()) {
                InputStream is = new Main().getClass().getResourceAsStream("/popometer/resourcen/popometer.conf");
                if (is != null) {
                    try {
                        int b;
                        configFile.createNewFile();
                        FileOutputStream os = new FileOutputStream(configFile);
                        while ((b = is.read()) > 0) {
                            os.write(b);
                        }
                        os.close();
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(null, "Fehler bei der \u00dcbernahme der Anfangskonfiguration:\n" + e1.getMessage() + "\nVor dem Login mu\u00df deshalb die DBURL eingetragen werden.", "Fehler", 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Die Anfangskonfiguration fehlt im Softwarepaket.\nVor dem Login mu\u00df deshalb die DBURL eingetragen werden.", "Fehler", 0);
                }
            }
            yConfigFile = new YConfigFile(popometerHome.getAbsolutePath() + "/popometer.conf");
            String cacheDirPathName = yConfigFile.findValue("CACHEDIR");
            boolean cachNameSet = false;
            boolean cacheCreated = false;
            if (cacheDirPathName.length() == 0) {
                cacheDirPathName = popometerHome.getAbsolutePath() + "/cache";
            }
            for (String pathExtension : pathExtensions = new String[]{"", "/images", "/images/thumbs"}) {
                File cacheDir = new File(cacheDirPathName + pathExtension);
                if (cacheDir.exists()) {
                    if (!cacheDir.isDirectory()) {
                        throw new YException("Cache kann nicht angelegt werden:\n" + cacheDirPathName + " existiert bereits und ist kein Verzeichnis.");
                    }
                    cacheCreated = cachNameSet;
                    continue;
                }
                if (!cacheDir.mkdir()) {
                    throw new YException("Cache kann nicht angelegt werden:\n" + cacheDirPathName);
                }
                cacheCreated = true;
            }
            if (cacheCreated) {
                yConfigFile.setEntry("CACHEDIR", cacheDirPathName);
                yConfigFile.write();
            }
        }
        catch (YException e1) {
            JOptionPane.showMessageDialog(null, e1.getMessage(), " Fehler", 0);
            System.exit(1);
        }
        String lastLogin = yConfigFile.findValue("LAST_LOGIN");
        dlgConnect = new DlgConnect((Frame)loginFenster, "SQ-Lab Popometer Anmeldung", yConfigFile, true);
        dlgConnect.setUser(lastLogin);
        if (!dlgConnect.execute()) {
            System.exit(0);
        }
        try {
            SplashScreen splashScreen = new SplashScreen();
            splashScreen.showFor(3);
            YPopometerDatabase database = new YPopometerDatabase(dlgConnect.getDriver(), dlgConnect.getURL(), Locale.getDefault());
            if (args.length > 0 && args[0].equals("-l")) {
                database.setSqlLog(true);
            }
            session = new YPopometerSession(yConfigFile, database, dlgConnect.getUser(), dlgConnect.getPassword());
            yConfigFile.setEntry("LAST_LOGIN", dlgConnect.getUser());
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    try {
                        FrmNavigator frmNavigator = new FrmNavigator(session, yConfigFile);
                        frmNavigator.setTitle("Popometer - angemeldet als: " + dlgConnect.getUser());
                        frmNavigator.setSize(800, 600);
                        Utils.centerWindow((Window)frmNavigator);
                        frmNavigator.setIconImage(Main.getImage());
                        YPopometerDatabase database = (YPopometerDatabase)session.getDatabase();
                        database.setPasswdRequestListener(new DlgPasswd(frmNavigator));
                        String strTimeout = yConfigFile.findValue("TIMEOUT");
                        int intTimeout = 20;
                        if (strTimeout.length() > 0) {
                            try {
                                intTimeout = Integer.parseInt(strTimeout);
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                        database.setTimeout(intTimeout * 60);
                        frmNavigator.setVisible(true);
                    }
                    catch (YException ex) {
                        JOptionPane.showMessageDialog(null, ex.getMessage(), " Fehler", 0);
                        System.exit(1);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, e.toString(), " Fehler", 0);
                        System.exit(1);
                    }
                }
            });
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), " Fehler", 0);
            System.exit(1);
        }
    }

    protected static Image getImage() {
        URL imgURL = Main.class.getResource("pictures/popometer.png");
        if (imgURL != null) {
            return new ImageIcon(imgURL).getImage();
        }
        return null;
    }
}

