/*
 * Decompiled with CFR 0.152.
 */
package popometer;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import popometer.YPopometerDatabase;
import popometer.dbobjects.YQLBilder;
import popometer.dbobjects.YQLConfig;
import popometer.dbobjects.YRLLaender;
import popometer.forms.DlgBenutzersuche;
import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YDatabase;
import projektY.database.YSQLQuery;
import projektY.database.YSession;
import projektY.utils.YConfigFile;

public class YPopometerSession
extends YSession {
    private YConfigFile configFile;
    private YPopometerDatabase database;
    private YRLLaender laender;
    private YQLConfig dbConfig;
    private YQLBilder bilder;
    private boolean isAdmin;
    private boolean checkedAdmin;
    private int rolle;

    public YPopometerSession(YConfigFile configFile, YPopometerDatabase database, String yuser, String ypassword) throws YException {
        super((YDatabase)database, yuser, ypassword);
        this.configFile = configFile;
        this.database = database;
        this.rolle = database.login(null);
        this.checkedAdmin = false;
        while (this.rolle == 1) {
            DlgBenutzersuche dlgBenutzersuche = new DlgBenutzersuche(null, this);
            dlgBenutzersuche.setVisible(true);
            String loginName = dlgBenutzersuche.getUser();
            if (loginName == null) {
                database.disconnect();
                System.exit(0);
            }
            this.rolle = database.login(loginName);
        }
        this.dbConfig = new YQLConfig(this);
        this.laender = new YRLLaender(this);
        this.laender.fetch();
        this.bilder = new YQLBilder(this);
        this.bilder.fetch();
    }

    public int getRolle() {
        return this.rolle;
    }

    public YConfigFile getConfigFile() {
        return this.configFile;
    }

    protected boolean isAdmin() throws YException {
        if (!this.checkedAdmin) {
            YSQLQuery sqlQuery = new YSQLQuery((YDatabase)this.database);
            sqlQuery.execute("SELECT rolname, rolsuper FROM pg_roles WHERE rolname = '" + this.getUser() + "' AND rolsuper = TRUE");
            this.isAdmin = sqlQuery.next();
            this.checkedAdmin = true;
            sqlQuery.close();
        }
        return this.isAdmin;
    }

    public boolean hasPermission(int berechtigung) throws YException {
        if (!this.isAdmin()) {
            // empty if block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterPassword(char[] pwdAlt, char[] pwdNeu) throws YException {
        YPopometerDatabase popometerDatabase = null;
        try {
            popometerDatabase = new YPopometerDatabase(this.database.getDriver(), this.database.getURL(), Locale.getDefault());
            popometerDatabase.connect(this.database.getUser(), new String(pwdAlt));
            popometerDatabase.alterPassword(pwdNeu);
        }
        finally {
            if (popometerDatabase != null && popometerDatabase.isConnected()) {
                popometerDatabase.disconnect();
            }
        }
    }

    public YRLLaender getLaender() {
        return this.laender;
    }

    public YQLBilder getBilder() {
        return this.bilder;
    }

    private Image createImage(String imageName, boolean isThumb) throws YException {
        URL url;
        StringBuffer filePathName;
        Image image;
        block20: {
            image = null;
            filePathName = new StringBuffer(80);
            boolean mustDownload = false;
            if (imageName.length() == 0) {
                url = ((Object)((Object)this)).getClass().getResource("/popometer/pictures/kein_bild.png");
            } else {
                StringBuffer neturl = new StringBuffer(this.dbConfig.findWert("IMAGEURL"));
                if (!neturl.toString().endsWith("/")) {
                    neturl.append('/');
                }
                if (isThumb) {
                    neturl.append("thumbs/");
                }
                neturl.append(imageName);
                neturl.append(".jpg");
                filePathName.append(this.configFile.findValue("CACHEDIR"));
                if (!filePathName.toString().endsWith("/")) {
                    filePathName.append('/');
                }
                filePathName.append("images/");
                if (isThumb) {
                    filePathName.append("thumbs/");
                }
                filePathName.append(imageName);
                filePathName.append(".jpg");
                File file = new File(filePathName.toString());
                try {
                    url = new URL(neturl.toString());
                }
                catch (MalformedURLException e) {
                    throw new YProgramException((Object)this, "Ung\u00fcltige URL f\u00fcr Bild: " + neturl.toString());
                }
                try {
                    boolean bl = mustDownload = !this.bilder.isAktuell(imageName, isThumb);
                    if (mustDownload && file.exists()) {
                        HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
                        httpUrlConnection.setRequestMethod("HEAD");
                        Map<String, List<String>> headerFields = httpUrlConnection.getHeaderFields();
                        List<String> values = headerFields.get("Last-Modified");
                        if (values == null) {
                            url = ((Object)((Object)this)).getClass().getResource("/popometer/pictures/logo-sq-lab.png");
                            mustDownload = false;
                        } else {
                            int month;
                            String lastModified = values.get(0).toString();
                            if (!lastModified.matches("^[MTWFS].*GMT$")) {
                                throw new YException("Ung\u00fcltiges HTML-Datum: " + lastModified);
                            }
                            Calendar calLastModified = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                            String[] dateItems = lastModified.split(" ");
                            String[] hms = dateItems[4].split(":");
                            int year = Integer.parseInt(dateItems[3]);
                            String[] htmlMonth = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
                            for (month = 0; month < htmlMonth.length && !dateItems[2].equals(htmlMonth[month]); ++month) {
                            }
                            if (month >= htmlMonth.length) {
                                throw new YException("Ung\u00fcltiger HTML-Monat: " + dateItems[2]);
                            }
                            int day = Integer.parseInt(dateItems[1]);
                            int hour = Integer.parseInt(hms[0]);
                            int minutes = Integer.parseInt(hms[1]);
                            int seconds = Integer.parseInt(hms[2]);
                            calLastModified.set(year, month, day, hour, minutes, seconds);
                            boolean bl2 = mustDownload = calLastModified.getTimeInMillis() > file.lastModified();
                        }
                    }
                    if (mustDownload) {
                        int l;
                        FileOutputStream output = new FileOutputStream(file);
                        InputStream input = url.openStream();
                        byte[] buf = new byte[100];
                        while ((l = input.read(buf)) != -1) {
                            ((OutputStream)output).write(buf, 0, l);
                        }
                        input.close();
                        ((OutputStream)output).close();
                    } else if (!file.exists()) {
                        url = ((Object)((Object)this)).getClass().getResource("/popometer/pictures/logo-sq-lab.png");
                    }
                    this.bilder.setAktuell(imageName, isThumb);
                }
                catch (IOException e) {
                    url = ((Object)((Object)this)).getClass().getResource("/popometer/pictures/logo-sq-lab.png");
                    if (!file.exists()) break block20;
                    file.delete();
                }
            }
        }
        image = filePathName.length() == 0 ? Toolkit.getDefaultToolkit().createImage(url) : Toolkit.getDefaultToolkit().createImage(filePathName.toString());
        return image;
    }

    public Image createImage(String imageName) throws YException {
        return this.createImage(imageName, false);
    }

    public Image createThumbImage(String imageName) throws YException {
        return this.createImage(imageName, true);
    }
}

