/*
 * Decompiled with CFR 0.152.
 */
package popometer.panels;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import popometer.YPopometerSession;
import popometer.dbobjects.YDLAnfrageeinsbed;
import popometer.dbobjects.YPDLEinsatzteilbereiche;
import popometer.dbobjects.YROEinsatzbereich;
import popometer.dbobjects.YSPDLEinsatzbedingungen;
import projektY.base.YException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanEinsatzbereich
extends JPanel {
    private YROEinsatzbereich einsatzbereich;
    private boolean eindeutig;
    private YPDLEinsatzteilbereiche einsatzteilbereiche;
    private JPanel panEinsatzteilbereiche;
    private ButtonGroup bgrpEinsatzteilbereiche;
    int nTeilbereiche;
    private JRadioButton[] rbEinsatzteilbereiche;
    private YSPDLEinsatzbedingungen einsatzbedingungen;
    private JPanel panEinsbedContainer;
    private ButtonGroup bgrpEinsatzbedingungen;
    private JToggleButton[] tbEinsatzbedingungen;
    private int[] einsbedingungIds;
    private JPanel panSpace;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JPanel panErlaeuterung;
    private JPanel panLinks;
    private JPanel panRechts;
    private JScrollPane scrlErlaeuterung;
    private JTextArea txtErlaeuterung;

    public PanEinsatzbereich(YPopometerSession session, int einsbereichId) throws YException {
        GridBagConstraints gridBagConstraints;
        int iRow;
        int nRows;
        this.initComponents();
        this.einsatzbereich = new YROEinsatzbereich(session);
        this.einsatzbereich.fetch(einsbereichId);
        this.eindeutig = this.einsatzbereich.getAsBool("eindeutig");
        this.txtErlaeuterung.setText(this.einsatzbereich.getAsString("erlaeuterung"));
        this.txtErlaeuterung.setCaretPosition(0);
        this.einsatzteilbereiche = this.einsatzbereich.getEinsatzteilbereiche();
        this.einsatzbedingungen = this.einsatzteilbereiche.getEinsatzbedingungen();
        this.rbEinsatzteilbereiche = new JRadioButton[this.einsatzteilbereiche.getRowCount()];
        this.tbEinsatzbedingungen = new JToggleButton[this.einsatzbedingungen.getAbsRowCount()];
        this.einsbedingungIds = new int[this.einsatzbedingungen.getAbsRowCount()];
        this.nTeilbereiche = this.einsatzteilbereiche.getRowCount();
        int gridyPanel = 0;
        int iTb = 0;
        if (this.nTeilbereiche > 1) {
            this.panEinsatzteilbereiche = new JPanel();
            this.panEinsatzteilbereiche.setBorder(BorderFactory.createTitledBorder(this.einsatzbereich.getAsString("bezeichnung")));
            this.panEinsatzteilbereiche.setLayout(new GridBagLayout());
            nRows = this.einsatzteilbereiche.getRowCount();
            this.bgrpEinsatzteilbereiche = new ButtonGroup();
            ActionListener listenEinsatzteilbereiche = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PanEinsatzbereich.this.einsatzteilbereichActionPerformed(e);
                }
            };
            iRow = 0;
            while (iRow < nRows) {
                JRadioButton radioButton = new JRadioButton(this.einsatzteilbereiche.getRowValues(iRow).toString());
                radioButton.addActionListener(listenEinsatzteilbereiche);
                this.bgrpEinsatzteilbereiche.add(radioButton);
                this.rbEinsatzteilbereiche[iRow] = radioButton;
                if (iRow == 0) {
                    radioButton.setSelected(true);
                }
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = iRow++;
                gridBagConstraints.anchor = 17;
                this.panEinsatzteilbereiche.add((Component)radioButton, gridBagConstraints);
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = gridyPanel++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            this.panLinks.add((Component)this.panEinsatzteilbereiche, gridBagConstraints);
        }
        this.panEinsbedContainer = new JPanel();
        this.panEinsbedContainer.setLayout(new CardLayout());
        if (this.eindeutig) {
            this.bgrpEinsatzbedingungen = new ButtonGroup();
        }
        for (int iTeilbereich = 0; iTeilbereich < this.nTeilbereiche; ++iTeilbereich) {
            JPanel panEinsatzbedingungen = new JPanel();
            panEinsatzbedingungen.setBorder(BorderFactory.createTitledBorder(this.einsatzteilbereiche.getRowValues(iTeilbereich).toString()));
            panEinsatzbedingungen.setLayout(new GridBagLayout());
            this.einsatzbedingungen.setSubWindow(this.einsatzteilbereiche.getRowId(iTeilbereich));
            nRows = this.einsatzbedingungen.getRowCount();
            iRow = 0;
            while (iRow < nRows) {
                JToggleButton toggleButton;
                if (this.eindeutig) {
                    toggleButton = new JRadioButton(this.einsatzbedingungen.getRowValues(iRow).toString());
                    this.bgrpEinsatzbedingungen.add(toggleButton);
                } else {
                    toggleButton = new JCheckBox(this.einsatzbedingungen.getRowValues(iRow).toString());
                }
                this.einsbedingungIds[iTb] = this.einsatzbedingungen.getRowValues(iRow).getPkFieldValue().getValueAsInt();
                this.tbEinsatzbedingungen[iTb++] = toggleButton;
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = iRow++;
                gridBagConstraints.anchor = 17;
                panEinsatzbedingungen.add((Component)toggleButton, gridBagConstraints);
            }
            this.panEinsbedContainer.add((Component)panEinsatzbedingungen, this.einsatzteilbereiche.getRowValues(iTeilbereich).toString());
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridyPanel++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panLinks.add((Component)this.panEinsbedContainer, gridBagConstraints);
        this.panSpace = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridyPanel;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panLinks.add((Component)this.panSpace, gridBagConstraints);
    }

    private void einsatzteilbereichActionPerformed(ActionEvent e) {
        JRadioButton radioButton = (JRadioButton)e.getSource();
        try {
            int nRows = this.rbEinsatzteilbereiche.length;
            for (int iRow = 0; iRow < nRows; ++iRow) {
                if (this.rbEinsatzteilbereiche[iRow] != radioButton) continue;
                String einsatzteilbereich = this.einsatzteilbereiche.getAsString(iRow, "bezeichnung");
                ((CardLayout)this.panEinsbedContainer.getLayout()).show(this.panEinsbedContainer, einsatzteilbereich);
                return;
            }
        }
        catch (YException ex) {
            JOptionPane.showMessageDialog(null, ex.toString(), "Fehler", 0);
        }
    }

    public YROEinsatzbereich getEinsatzbereich() {
        return this.einsatzbereich;
    }

    public boolean getEinsbedingungIds(Vector<Integer> einsbedingungIds) throws YException {
        int nEb = this.tbEinsatzbedingungen.length;
        if (this.eindeutig) {
            for (int iEb = 0; iEb < nEb; ++iEb) {
                if (!this.tbEinsatzbedingungen[iEb].isSelected()) continue;
                einsbedingungIds.add(this.einsbedingungIds[iEb]);
                return true;
            }
            return false;
        }
        for (int iEb = 0; iEb < nEb; ++iEb) {
            if (!this.tbEinsatzbedingungen[iEb].isSelected()) continue;
            einsbedingungIds.add(this.einsbedingungIds[iEb]);
        }
        return true;
    }

    public boolean setEinsbedingungen(YDLAnfrageeinsbed anfrageeinsbed) throws YException {
        int iRow;
        int iEb;
        int nRows = anfrageeinsbed.getRowCount();
        int einsbereichId = this.einsatzbereich.getPkFieldValueAsInt();
        int nEb = this.tbEinsatzbedingungen.length;
        boolean alleGefunden = true;
        for (iEb = 0; iEb < nEb; ++iEb) {
            this.tbEinsatzbedingungen[iEb].setSelected(false);
        }
        for (iRow = 0; iRow < nRows; ++iRow) {
            if (anfrageeinsbed.getAsInt(iRow, "einsbereich_id") != einsbereichId) continue;
            int einsbedingungId = anfrageeinsbed.getAsInt(iRow, "einsbedingung_id");
            String strEinsatzbedingung = anfrageeinsbed.getAsString(iRow, "bedingung");
            for (iEb = 0; iEb < nEb; ++iEb) {
                if (this.einsbedingungIds[iEb] != einsbedingungId) continue;
                if (this.tbEinsatzbedingungen[iEb].getText().equals(strEinsatzbedingung)) {
                    this.tbEinsatzbedingungen[iEb].setSelected(true);
                    continue;
                }
                alleGefunden = false;
            }
            if (this.nTeilbereiche <= 1 || (iRow = this.einsatzbedingungen.find(String.valueOf(einsbedingungId), "einsbedingung_id")) < 0) break;
            int einsteilbereichId = this.einsatzbedingungen.getAbsRowValues(iRow).getAsInt("einsteilbereich_id");
            iRow = this.einsatzteilbereiche.find(String.valueOf(einsteilbereichId), "einsteilbereich_id");
            this.rbEinsatzteilbereiche[iRow].setSelected(true);
            String strEinsatzteilbereich = this.einsatzteilbereiche.getAsString(iRow, "bezeichnung");
            ((CardLayout)this.panEinsbedContainer.getLayout()).show(this.panEinsbedContainer, strEinsatzteilbereich);
            break;
        }
        return (iRow < nRows || !this.eindeutig) && alleGefunden;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.panRechts = new JPanel();
        this.panErlaeuterung = new JPanel();
        this.scrlErlaeuterung = new JScrollPane();
        this.txtErlaeuterung = new JTextArea();
        this.panLinks = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.panRechts.setLayout(new GridBagLayout());
        this.panErlaeuterung.setBorder(BorderFactory.createTitledBorder("Erl\u00e4uterung"));
        this.panErlaeuterung.setLayout(new GridBagLayout());
        this.txtErlaeuterung.setColumns(20);
        this.txtErlaeuterung.setEditable(false);
        this.txtErlaeuterung.setLineWrap(true);
        this.txtErlaeuterung.setRows(5);
        this.txtErlaeuterung.setWrapStyleWord(true);
        this.scrlErlaeuterung.setViewportView(this.txtErlaeuterung);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panErlaeuterung.add((Component)this.scrlErlaeuterung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.panRechts.add((Component)this.panErlaeuterung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.panRechts, gridBagConstraints);
        this.panLinks.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.panLinks, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }
}

