/*
 * Decompiled with CFR 0.152.
 */
package popometer.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import popometer.JNimbusTable;
import popometer.YPopometerSession;
import popometer.dbobjects.YEVAusfuehrungen;
import popometer.dbobjects.YROAusfuehrung;
import projektY.base.YException;
import projektY.database.YColumnDefinition;
import projektY.database.YDatabaseList;
import projektY.database.YEvaluationList;
import projektY.database.YSession;
import projektY.swing.YJTableManager;
import projektY.swing.YTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanErgebnis
extends JPanel {
    private YPopometerSession session;
    private YEVAusfuehrungen ausfuehrungen;
    private YROAusfuehrung[] topProdukte;
    private YEvaluationList produktBewertung;
    private YTableModel tmTopProdukte;
    private JNimbusTable tblTopProdukte;
    private boolean tblTopProdukteChanging;
    private JNimbusTable tblDetails;
    private ImageViewer imageViewer;
    private static final int IMAGE_WIDTH = 300;
    private ButtonGroup bgBestellen;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JLabel lblBild;
    private JPanel panBeschreibung;
    private JPanel panBestellen;
    private JPanel panBild;
    private JPanel panDetails;
    private JPanel panLinks;
    private JPanel panRechts;
    private JPanel panSpacer;
    private JPanel panTopProdukte;
    private JRadioButton rbNachbestellen;
    private JRadioButton rbVorbestellen;
    private JScrollPane scrlBeschreibung;
    private JTextArea txtBeschreibung;

    public PanErgebnis(YPopometerSession session, YEVAusfuehrungen ausfuehrungen) throws YException {
        this.initComponents();
        this.session = session;
        this.imageViewer = new ImageViewer();
        this.imageViewer.setPreferredSize(new Dimension(300, 100));
        this.panBild.add(this.imageViewer);
        this.ausfuehrungen = ausfuehrungen;
        ausfuehrungen.setDispFields(new String[]{"bewertung", "bezeichnung", "vorbestellen"});
        this.tblTopProdukte = new JNimbusTable();
        this.tblTopProdukteChanging = false;
        this.tmTopProdukte = YJTableManager.createTableManager((JTable)this.tblTopProdukte, (YDatabaseList)this.ausfuehrungen).getTableModel();
        this.tmTopProdukte.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (e.getColumn() != 2) {
                    return;
                }
                if (PanErgebnis.this.tblTopProdukteChanging) {
                    return;
                }
                PanErgebnis.this.tblTopProdukteChanging = true;
                int iRow = e.getFirstRow();
                for (int i = 0; i < PanErgebnis.this.tmTopProdukte.getRowCount(); ++i) {
                    if (i == iRow) continue;
                    PanErgebnis.this.tmTopProdukte.setValueAt((Object)Boolean.FALSE, i, 2);
                }
                PanErgebnis.this.tblTopProdukteChanging = false;
            }
        });
        this.tblTopProdukte.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                PanErgebnis.this.tblTopProdukteRowSelected(e);
            }
        });
        this.panTopProdukte.add((Component)this.tblTopProdukte, "Center");
        this.tblDetails = new JNimbusTable();
        this.tblDetails.setModel(new DefaultTableModel(0, 3){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        });
        this.tblDetails.setColumnAlignRight(2);
        this.panDetails.add((Component)this.tblDetails, "First");
        this.topProdukte = new YROAusfuehrung[5];
        for (int i = 0; i < 5; ++i) {
            this.topProdukte[i] = new YROAusfuehrung(session);
        }
        this.produktBewertung = new YEvaluationList((YSession)session, 3);
        this.produktBewertung.addDBField("bereich", YColumnDefinition.FieldType.STRING);
        this.produktBewertung.addDBField("bedingung", YColumnDefinition.FieldType.STRING);
        this.produktBewertung.addDBField("bewertung", YColumnDefinition.FieldType.SHORT);
        this.produktBewertung.setSqlSelect("SELECT e.bezeichnung AS bereich, b.bedingung, w.bewertung FROM bewertungen w JOIN vs_einsatzbedingungen b ON (b.einsbedingung_id = w.einsbedingung_id) JOIN vs_einsatzteilbereiche t ON (t.einsteilbereich_id = b.einsteilbereich_id) JOIN vs_einsatzbereiche e ON (e.einsbereich_id = t.einsbereich_id)");
        this.produktBewertung.addFilter("ausfuehrung_id", "w.ausfuehrung_id=:value:", YColumnDefinition.FieldType.INT);
        this.produktBewertung.addFilter("einsbedingung_id", "w.einsbedingung_id IN (:value:)", YColumnDefinition.FieldType.INT);
        this.produktBewertung.setOrder(new String[]{"e.pos_nr", "b.pos_nr"});
        this.produktBewertung.setDispFields(new String[]{"bereich", "bedingung", "bewertung"});
    }

    private void zeigeProdukt(int iProdukt) throws YException {
        int iCol;
        int iRow;
        this.imageViewer.setImage(this.topProdukte[iProdukt].getAsString("bildname"));
        this.produktBewertung.setFilterValue("ausfuehrung_id", this.topProdukte[iProdukt].getAsString("ausfuehrung_id"));
        this.produktBewertung.fetch();
        DefaultTableModel tmDetails = (DefaultTableModel)this.tblDetails.getModel();
        tmDetails.setRowCount(this.produktBewertung.getRowCount());
        for (iRow = 0; iRow < this.produktBewertung.getRowCount(); ++iRow) {
            for (iCol = 0; iCol < this.produktBewertung.getDispColCount(); ++iCol) {
                tmDetails.setValueAt(this.produktBewertung.getDispString(iRow, iCol), iRow, iCol);
            }
        }
        TableColumnModel columnModel = this.tblDetails.getColumnModel();
        for (iCol = 0; iCol < this.tblDetails.getColumnCount(); ++iCol) {
            int max = 0;
            for (iRow = 0; iRow < this.tblDetails.getRowCount(); ++iRow) {
                TableCellRenderer rend = this.tblDetails.getCellRenderer(iRow, iCol);
                Object value = this.tblDetails.getValueAt(iRow, iCol);
                Component comp = rend.getTableCellRendererComponent(this.tblDetails, value, false, false, iRow, iCol);
                max = Math.max(comp.getPreferredSize().width, max);
            }
            TableColumn column = columnModel.getColumn(iCol);
            column.setPreferredWidth(max);
        }
        this.txtBeschreibung.setText(this.topProdukte[iProdukt].getAsString("beschreibung"));
    }

    public void holeProdukte(Vector<Integer> einsbedingungIds) throws YException {
        Object[] objEinsbedingungIds = einsbedingungIds.toArray();
        int n = einsbedingungIds.size();
        this.ausfuehrungen.setSqlSelect("SELECT b.ausfuehrung_id, SUM(b.bewertung)/" + einsbedingungIds.size() + ".0 AS bewertung, a.bezeichnung" + " FROM bewertungen b" + " JOIN ausfuehrungen a ON (a.ausfuehrung_id=b.ausfuehrung_id)");
        this.ausfuehrungen.setFilterValues("einsbedingung_id", objEinsbedingungIds);
        this.tblTopProdukteChanging = true;
        this.ausfuehrungen.fetch();
        this.tblTopProdukteChanging = false;
        n = Math.min(this.topProdukte.length, this.ausfuehrungen.getRowCount());
        for (int i = 0; i < n; ++i) {
            this.topProdukte[i].fetch(this.ausfuehrungen.getAsInt(i, "ausfuehrung_id"));
        }
        this.produktBewertung.setFilterValues("einsbedingung_id", objEinsbedingungIds);
        if (n > 0) {
            this.tblTopProdukte.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public YROAusfuehrung getBestellung() throws YException {
        for (int iRow = 0; iRow < this.ausfuehrungen.getRowCount(); ++iRow) {
            Object vormerkung = this.tmTopProdukte.getValueAt(iRow, 2);
            if (vormerkung == null || !((Boolean)vormerkung).booleanValue()) continue;
            return this.topProdukte[iRow];
        }
        return null;
    }

    public boolean isNachbestellung() {
        return this.rbNachbestellen.isSelected();
    }

    public YROAusfuehrung getTopProdukt() {
        return this.topProdukte[0];
    }

    private void tblTopProdukteRowSelected(ListSelectionEvent e) {
        try {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int iRow = this.tblTopProdukte.getSelectedRow();
            if (iRow >= 0) {
                this.zeigeProdukt(iRow);
            }
        }
        catch (YException ex) {
            JOptionPane.showMessageDialog(this, ex.toString(), "Fehler", 0);
        }
    }

    private void initComponents() {
        this.bgBestellen = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.panLinks = new JPanel();
        this.panTopProdukte = new JPanel();
        this.panBestellen = new JPanel();
        this.rbVorbestellen = new JRadioButton();
        this.rbNachbestellen = new JRadioButton();
        this.panBild = new JPanel();
        this.lblBild = new JLabel();
        this.panDetails = new JPanel();
        this.panSpacer = new JPanel();
        this.panRechts = new JPanel();
        this.panBeschreibung = new JPanel();
        this.scrlBeschreibung = new JScrollPane();
        this.txtBeschreibung = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.panLinks.setLayout(new GridBagLayout());
        this.panTopProdukte.setBorder(BorderFactory.createTitledBorder("Produkt zum Bestellen vormerken:"));
        this.panTopProdukte.setLayout(new BorderLayout());
        this.bgBestellen.add(this.rbVorbestellen);
        this.rbVorbestellen.setSelected(true);
        this.rbVorbestellen.setText("Vorbestellen");
        this.panBestellen.add(this.rbVorbestellen);
        this.bgBestellen.add(this.rbNachbestellen);
        this.rbNachbestellen.setText("Nachbestellen");
        this.panBestellen.add(this.rbNachbestellen);
        this.panTopProdukte.add((Component)this.panBestellen, "South");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panLinks.add((Component)this.panTopProdukte, gridBagConstraints);
        this.panBild.setBorder(BorderFactory.createTitledBorder("Abbildung"));
        this.panBild.add(this.lblBild);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panLinks.add((Component)this.panBild, gridBagConstraints);
        this.panDetails.setBorder(BorderFactory.createTitledBorder("Detailergebnisse"));
        this.panDetails.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panLinks.add((Component)this.panDetails, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panLinks.add((Component)this.panSpacer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.panLinks, gridBagConstraints);
        this.panRechts.setLayout(new GridBagLayout());
        this.panBeschreibung.setBorder(BorderFactory.createTitledBorder("Beschreibung"));
        this.panBeschreibung.setLayout(new BorderLayout());
        this.txtBeschreibung.setColumns(20);
        this.txtBeschreibung.setEditable(false);
        this.txtBeschreibung.setLineWrap(true);
        this.txtBeschreibung.setRows(5);
        this.txtBeschreibung.setWrapStyleWord(true);
        this.scrlBeschreibung.setViewportView(this.txtBeschreibung);
        this.panBeschreibung.add((Component)this.scrlBeschreibung, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.panRechts.add((Component)this.panBeschreibung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.panRechts, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private class ImageViewer
    extends JPanel {
        Image image;
        boolean bildGeladen;
        int w;
        int h;

        private ImageViewer() {
        }

        public void setImage(String bildName) throws YException {
            this.image = PanErgebnis.this.session.createImage(bildName);
            this.w = 0;
            this.h = 0;
            this.bildGeladen = false;
            this.w = this.image.getWidth(this);
            this.h = this.image.getHeight(this);
            this.repaint();
        }

        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if ((infoflags & 1) != 0) {
                this.w = width;
            }
            if ((infoflags & 2) != 0) {
                this.h = height;
            }
            if ((infoflags & 0x20) != 0) {
                if (!this.bildGeladen) {
                    Dimension preferredSize = this.getPreferredSize();
                    float f = 300.0f / (float)this.w;
                    this.h = (int)((float)this.h * f) + 1;
                    if (this.h != preferredSize.height) {
                        preferredSize.height = this.h;
                        this.setPreferredSize(preferredSize);
                        this.revalidate();
                    }
                    this.bildGeladen = true;
                }
                this.repaint();
                return false;
            }
            return true;
        }

        public void paint(Graphics g) {
            if (this.image != null && this.bildGeladen) {
                g.drawImage(this.image, 0, 0, 300, this.h, this);
            }
        }
    }
}

