/*
 * Decompiled with CFR 0.152.
 */
package popometer.dbobjects;

import popometer.YPopometerSession;
import popometer.dbobjects.YROKunde;
import projektY.base.YException;
import projektY.database.YColumnDefinition;
import projektY.database.YDetailList;
import projektY.database.YSession;

public class YDLAnfragen
extends YDetailList {
    public YDLAnfragen(YPopometerSession session, YROKunde kunde) throws YException {
        super((YSession)session, 8, kunde);
        this.addPkField("anfrageprodukt_id").setReadOnly();
        this.addRowObjectFkField("kunde_id").setReadOnly();
        this.addDBField("datum", YColumnDefinition.FieldType.DATE).setLabel("Datum").setReadOnly();
        this.addDBField("vorname", YColumnDefinition.FieldType.STRING).setLabel("Egonomic").setReadOnly();
        this.addDBField("name", YColumnDefinition.FieldType.STRING).setLabel("Expert").setReadOnly();
        this.addDBField("bezeichnung", YColumnDefinition.FieldType.STRING).setLabel("Prokukt").setReadOnly();
        this.addDBField("verkauft", YColumnDefinition.FieldType.BOOLEAN).setLabel("Gekauft").setReadOnly();
        this.addDBField("bestellt", YColumnDefinition.FieldType.BOOLEAN).setLabel("(Nach-)bestellt").setReadOnly();
        this.setParamSelect("SELECT * FROM (SELECT a.anfrage_id, a.datum AS sort_datum, count(a.anfrage_id) OVER (PARTITION BY a.anfrage_id) AS lfd_nr, CASE WHEN rank() OVER (PARTITION BY a.anfrage_id ORDER BY p.anfrageprodukt_id) = 1 THEN a.datum ELSE NULL END AS datum, p.anfrageprodukt_id, a.kunde_id, v.vorname, v.name, p.bezeichnung, p.verkauft, (p.bestellung_id IS NOT NULL) AS bestellt FROM vh_anfragen a JOIN vh_personen v ON (a.pers_id=v.pers_id) JOIN vh_anfrageprodukte p ON (a.anfrage_id=p.anfrage_id) WHERE (kunde_id=:kunde_id(INT):) ) AS anfragen WHERE lfd_nr <= 3 ");
        this.setName("vh_anfrageprodukte");
        this.setReadOnly(true);
        this.setOrder(new String[]{"sort_datum DESC", "anfrage_id DESC", "anfrageprodukt_id"});
        this.setToStringFields(new String[]{"datum", "bezeichnung"});
        this.setMaxRows(20);
        this.finalizeDefinition();
        this.setDispFields(new String[]{"datum", "vorname", "name", "bezeichnung", "verkauft", "bestellt"});
    }

    @Override
    protected String createSelectWhere(int objId) throws YException {
        this.paramSelect.setParamValue("kunde_id", String.valueOf(objId));
        return this.paramSelect.createSQL(this);
    }
}

