/*
 * Decompiled with CFR 0.152.
 */
package popometer.dbobjects;

import java.util.Vector;
import popometer.AfterPostListener;
import popometer.YPopometerSession;
import popometer.dbobjects.YDLAnfragen;
import popometer.dbobjects.YDLKundeneinsbed;
import projektY.base.YException;
import projektY.database.YColumnDefinition;
import projektY.database.YDatabaseList;
import projektY.database.YRowObject;
import projektY.database.YSession;

public class YROKunde
extends YRowObject {
    private Vector<AfterPostListener> afterPostListeners;
    private boolean externalChanges;

    public YROKunde(YPopometerSession session) throws YException {
        super((YSession)session, 26);
        this.setLabel("Kundendaten");
        this.addPkField("kunde_id", false);
        this.addROField("haendler_id", YColumnDefinition.FieldType.INT);
        this.addDBField("name", YColumnDefinition.FieldType.STRING).setLabel("Name").setNotNull(true);
        this.addDBField("vorname", YColumnDefinition.FieldType.STRING);
        this.addROField("anschr_id", YColumnDefinition.FieldType.INT);
        this.addROField("kontdat_id", YColumnDefinition.FieldType.INT);
        this.addDBField("kundennr", YColumnDefinition.FieldType.STRING);
        this.addDBField("str_nr", YColumnDefinition.FieldType.STRING);
        this.addDBField("plz", YColumnDefinition.FieldType.STRING);
        this.addDBField("ort", YColumnDefinition.FieldType.STRING);
        this.addLookUpDBField("land_kz", (YDatabaseList)session.getLaender(), "land_kz");
        this.addDBField("telefon", YColumnDefinition.FieldType.STRING);
        this.addDBField("fax", YColumnDefinition.FieldType.STRING);
        this.addDBField("mobil", YColumnDefinition.FieldType.STRING);
        this.addDBField("email", YColumnDefinition.FieldType.STRING);
        this.addDBField("l_sitzknochen", YColumnDefinition.FieldType.FLOAT);
        this.addDBField("l_hand", YColumnDefinition.FieldType.FLOAT);
        this.addDBField("l_fuss", YColumnDefinition.FieldType.FLOAT);
        this.addDBField("l_unterarm", YColumnDefinition.FieldType.FLOAT);
        this.addDBField("l_oberarm", YColumnDefinition.FieldType.FLOAT);
        this.addDBField("l_oberkoerper", YColumnDefinition.FieldType.FLOAT);
        this.addDBField("l_unterschenkel", YColumnDefinition.FieldType.FLOAT);
        this.addDBField("l_oberschenkel", YColumnDefinition.FieldType.FLOAT);
        this.addDBField("gewicht", YColumnDefinition.FieldType.FLOAT);
        this.addDBField("img_sitzknochen", YColumnDefinition.FieldType.STRING);
        this.addDBField("img_gelenke", YColumnDefinition.FieldType.STRING);
        this.setTableName("vh_kunden");
        this.setToStringFields(new String[]{"vorname", "name"}, true);
        this.addDetailList(new YDLKundeneinsbed(session, this));
        this.addDetailList(new YDLAnfragen(session, this));
        this.finalizeDefinition();
        this.afterPostListeners = new Vector(20);
        this.externalChanges = false;
    }

    public String toString() {
        try {
            if (!this.getFieldValue("name").isNull() || !this.getFieldValue("vorname").isNull()) {
                return super.toString();
            }
        }
        catch (YException ex) {
            return "Interner Fehler";
        }
        return "Neuer Kunde";
    }

    public void addAfterPostListener(AfterPostListener beforePostListener) {
        this.afterPostListeners.add(beforePostListener);
    }

    public YRowObject fetch(int kundeId) throws YException {
        this.externalChanges = false;
        super.fetch(kundeId);
        return this;
    }

    public void post() throws YException {
        super.post();
        for (int i = 0; i < this.afterPostListeners.size(); ++i) {
            this.afterPostListeners.get(i).afterPost();
        }
        this.externalChanges = false;
    }

    public void setExternalChanges() {
        this.externalChanges = true;
    }

    public boolean hasChanged() throws YException {
        if (super.hasChanged()) {
            return true;
        }
        return this.externalChanges;
    }
}

