/*
 * Decompiled with CFR 0.152.
 */
package popometer;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Vector;
import popometer.PasswdRequestListener;
import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.base.YUserException;
import projektY.database.YFieldValue;
import projektY.database.YPGDatabase;
import projektY.database.YSQLQuery;

public class YPopometerDatabase
extends YPGDatabase {
    TimeoutManager timeoutManager = null;
    private PasswdRequestListener passwdRequestListener;
    private String lastUser;
    private String lastLoginName;
    private String[][] viewToTable = new String[][]{{"vh_haendler", "haendler"}, {"vh_personen", "personen"}, {"vh_kunden", "kunden"}, {"vh_anfragen", "anfragen"}, {"vh_bestellungen", "bestellungen"}, {"vh_bestellpos", "bestellpos"}, {"vh_anfrageprodukte", "anfrageprodukte"}, {"vh_kundeneinsbed", "kundeneinsbed"}, {"vh_verkaeufer", "dummy"}};

    public YPopometerDatabase(String driver, String URL2, Locale locale) throws YException {
        super(driver, URL2, locale);
    }

    @Override
    public void setTimeout(int sekunden) {
        if (this.timeoutManager == null) {
            this.timeoutManager = new TimeoutManager(this, sekunden);
            this.timeoutManager.start();
        } else {
            this.timeoutManager.setTimeout(sekunden);
            if (sekunden <= 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.timeoutManager = null;
            }
        }
    }

    @Override
    public String getTrue() {
        return "'t'";
    }

    @Override
    public String getFalse() {
        return "'f'";
    }

    @Override
    public int nextId(String tableName) throws YException {
        if (!this.inTransaction) {
            if (!this.initializedTransaction) {
                throw new YException("Zur Bereitstellung von next_id mu\u00df sich die Datenbank in einer Transaktion befinden.");
            }
            this.begin();
        }
        for (int i = 0; i < this.viewToTable.length; ++i) {
            if (!this.viewToTable[i][0].equals(tableName)) continue;
            tableName = this.viewToTable[i][1];
            break;
        }
        if (tableName.equals("dummy")) {
            return 0;
        }
        this.sqlQuery.execute("SELECT nextval('seq_" + tableName + "') AS next_id");
        if (this.sqlQuery.next()) {
            return this.sqlQuery.getInt("next_id");
        }
        throw new YException("next_id f\u00fcr Tabelle " + tableName + " konnte nicht ermittelt werden.");
    }

    @Override
    public void connect(String user, String password) throws YException {
        super.connect(user, password);
        this.lastUser = user;
    }

    int login(String loginName) throws YException {
        YSQLQuery sqlQuery = new YSQLQuery(this);
        int rolle = 0;
        if (loginName == null) {
            sqlQuery.execute("SELECT Login() AS rolle");
        } else {
            sqlQuery.execute("SELECT Login('" + loginName + "') AS rolle");
        }
        if (sqlQuery.next()) {
            rolle = sqlQuery.getInt("rolle");
        }
        this.lastLoginName = loginName;
        return rolle;
    }

    int getFunktionen() throws YException {
        try {
            this.sqlQuery.execute("SELECT GetFunktionen() AS funktionen");
            if (this.sqlQuery.next()) {
                int n = this.sqlQuery.getInt("funktionen");
                return n;
            }
            throw new YException("Kein Ergebnis bei SELECT GetFunktionen().");
        }
        finally {
            this.sqlQuery.close();
        }
    }

    void alterPassword(char[] pwdNeu) throws YException {
        super.alterPasswd(this.getUser(), pwdNeu);
    }

    @Override
    public void modifyPasswdField(YFieldValue pwdFv, char[] passwd) throws YException {
        pwdFv.modifyValue(new String(passwd));
    }

    public void setPasswdRequestListener(PasswdRequestListener passwdRequestListener) {
        this.passwdRequestListener = passwdRequestListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean ensureConnection(Connection dbconn0) throws YException {
        boolean tryReconnect = false;
        boolean reconnected = false;
        YPopometerDatabase yPopometerDatabase = this;
        synchronized (yPopometerDatabase) {
            if (this.isConnected()) {
                try {
                    if (this.getConnection().isClosed()) {
                        tryReconnect = true;
                    }
                }
                catch (SQLException e) {
                    tryReconnect = true;
                }
            } else {
                tryReconnect = true;
            }
            if (tryReconnect) {
                int i;
                if (this.passwdRequestListener == null) {
                    throw new YProgramException(this, "PasswortRequestListener ist nicht definiert.");
                }
                Vector<Character> passwd = new Vector<Character>(40);
                if (!this.passwdRequestListener.requestPassword(passwd, this.lastUser)) {
                    throw new YUserException("Wiederherstellen der Verbindung ist nicht m\u00f6glich.\nDas Passwort wurde nicht angegeben.");
                }
                char[] pwdArray = new char[passwd.size()];
                for (i = 0; i < pwdArray.length; ++i) {
                    pwdArray[i] = passwd.get(i).charValue();
                }
                this.connect(this.lastUser, new String(pwdArray));
                passwd.clear();
                for (i = 0; i < pwdArray.length; ++i) {
                    pwdArray[i] = '\u0000';
                }
                this.login(this.lastLoginName);
                reconnected = true;
            }
            if (this.timeoutManager != null) {
                this.timeoutManager.interrupt();
            }
        }
        return reconnected || dbconn0 != this.getConnection();
    }

    private class TimeoutManager
    extends Thread {
        private int sekunden;
        private final YPopometerDatabase database;

        public TimeoutManager(YPopometerDatabase database, int sekunden) {
            this.database = database;
            this.sekunden = sekunden;
        }

        public void setTimeout(int sekunden) {
            this.sekunden = sekunden;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                if (this.sekunden <= 0) {
                    if (YPopometerDatabase.this.sqlLog) {
                        System.out.println("Timeout beendet");
                    }
                    return;
                }
                try {
                    if (YPopometerDatabase.this.sqlLog) {
                        System.out.println("Timeout gestartet");
                    }
                    Thread.sleep(this.sekunden * 1000);
                    YPopometerDatabase yPopometerDatabase = this.database;
                    synchronized (yPopometerDatabase) {
                        if (YPopometerDatabase.this.sqlLog) {
                            System.out.println("Timeout erreicht");
                        }
                        if (this.database.isInTransaction()) {
                            continue;
                        }
                        if (this.database.isConnected()) {
                            this.database.disconnect();
                            if (YPopometerDatabase.this.sqlLog) {
                                System.out.println("disconnect() ausgef\u00fchrt");
                            }
                        }
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    if (!YPopometerDatabase.this.sqlLog) continue;
                    System.out.print("Timeout zur\u00fcckgesetzt ... ");
                    continue;
                }
                break;
            }
        }
    }
}

