/*
 * Decompiled with CFR 0.152.
 */
package popometer.forms;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import projektY.base.YException;
import projektY.database.YEvaluationList;
import projektY.swing.Utils;

public class DlgExport
extends JDialog {
    YEvaluationList evAnfragen;
    YEvaluationList evTopProdukte;
    YEvaluationList evTopEinsatzbereiche;
    YEvaluationList evTopVerkaeufer;
    File directory;
    JFileChooser fileChooser;
    private JCheckBox cbAnfragen;
    private JCheckBox cbTopEinsatzbereiche;
    private JCheckBox cbTopProdukte;
    private JCheckBox cbTopVerkaeufer;
    private JButton cmdClose;
    private JButton cmdDirectory;
    private JButton cmdStart;
    private JTextField fldAnfragen;
    private JTextField fldTopEinsatzbereiche;
    private JTextField fldTopProdukte;
    private JTextField fldTopVerkaeufer;
    private JLabel jLabel2;
    private JLabel lblDirectory;
    private JPanel panExport;

    public DlgExport(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.directory = new File(System.getProperty("user.dir"));
        this.fileChooser = new JFileChooser();
        this.fileChooser.setDialogTitle("Ausgabeverzeichnis");
        this.fileChooser.setDialogType(1);
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setSelectedFile(this.directory);
        this.fileChooser.setApproveButtonText("Ausw\u00e4hlen");
        this.lblDirectory.setText(this.directory.getAbsolutePath());
        this.pack();
        Utils.centerWindow((Window)this);
    }

    public void execute(YEvaluationList evAnfragen, YEvaluationList evTopProdukte, YEvaluationList evTopEinsatzbereiche, YEvaluationList evTopVerkaeufer) {
        this.evAnfragen = evAnfragen;
        this.evTopProdukte = evTopProdukte;
        this.evTopEinsatzbereiche = evTopEinsatzbereiche;
        this.evTopVerkaeufer = evTopVerkaeufer;
        this.setVisible(true);
    }

    private void initComponents() {
        this.panExport = new JPanel();
        this.cbAnfragen = new JCheckBox();
        this.cbTopProdukte = new JCheckBox();
        this.cbTopEinsatzbereiche = new JCheckBox();
        this.cbTopVerkaeufer = new JCheckBox();
        this.fldTopEinsatzbereiche = new JTextField();
        this.fldTopProdukte = new JTextField();
        this.fldAnfragen = new JTextField();
        this.jLabel2 = new JLabel();
        this.fldTopVerkaeufer = new JTextField();
        this.lblDirectory = new JLabel();
        this.cmdDirectory = new JButton();
        this.cmdStart = new JButton();
        this.cmdClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Export");
        this.panExport.setBackground(new Color(255, 255, 255));
        this.panExport.setBorder(BorderFactory.createTitledBorder("Ausgabedateien festlegen"));
        this.cbAnfragen.setSelected(true);
        this.cbAnfragen.setText("Anfragen");
        this.cbAnfragen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgExport.this.cbAnfragenActionPerformed(evt);
            }
        });
        this.cbTopProdukte.setSelected(true);
        this.cbTopProdukte.setText("Top-Produkte");
        this.cbTopEinsatzbereiche.setSelected(true);
        this.cbTopEinsatzbereiche.setText("Top-Einsatzbereiche");
        this.cbTopVerkaeufer.setSelected(true);
        this.cbTopVerkaeufer.setText("Top-Verk\u00e4ufer");
        this.fldTopEinsatzbereiche.setText("top_einsatzbereiche.csv");
        this.fldTopProdukte.setText("top_produkte.csv");
        this.fldAnfragen.setText("anfragen.csv");
        this.jLabel2.setText("Verzeichnis:");
        this.fldTopVerkaeufer.setText("top_verkaeufer.csv");
        this.lblDirectory.setText("<verzeichnis>");
        this.cmdDirectory.setText("...");
        this.cmdDirectory.setToolTipText("Verzeichnis festlegen ...");
        this.cmdDirectory.setMargin(new Insets(2, 6, 2, 6));
        this.cmdDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgExport.this.cmdDirectoryActionPerformed(evt);
            }
        });
        this.cmdStart.setText("Start !");
        this.cmdStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgExport.this.cmdStartActionPerformed(evt);
            }
        });
        this.cmdClose.setText("Schliessen");
        this.cmdClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgExport.this.cmdCloseActionPerformed(evt);
            }
        });
        GroupLayout panExportLayout = new GroupLayout(this.panExport);
        this.panExport.setLayout(panExportLayout);
        panExportLayout.setHorizontalGroup(panExportLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panExportLayout.createSequentialGroup().addContainerGap().addGroup(panExportLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panExportLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panExportLayout.createSequentialGroup().addComponent(this.jLabel2).addContainerGap()).addGroup(panExportLayout.createSequentialGroup().addGroup(panExportLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panExportLayout.createSequentialGroup().addComponent(this.cbTopVerkaeufer).addGap(39, 39, 39).addComponent(this.fldTopVerkaeufer, -1, 195, Short.MAX_VALUE)).addGroup(panExportLayout.createSequentialGroup().addComponent(this.cbTopEinsatzbereiche).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldTopEinsatzbereiche, -1, 195, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, panExportLayout.createSequentialGroup().addGroup(panExportLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbAnfragen).addComponent(this.cbTopProdukte)).addGap(43, 43, 43).addGroup(panExportLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldAnfragen, -1, 195, Short.MAX_VALUE).addComponent(this.fldTopProdukte, -1, 195, Short.MAX_VALUE).addGroup(panExportLayout.createSequentialGroup().addComponent(this.lblDirectory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 78, Short.MAX_VALUE).addComponent(this.cmdDirectory))))).addContainerGap())).addGroup(GroupLayout.Alignment.TRAILING, panExportLayout.createSequentialGroup().addComponent(this.cmdStart).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdClose).addContainerGap()))));
        panExportLayout.setVerticalGroup(panExportLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panExportLayout.createSequentialGroup().addContainerGap().addGroup(panExportLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.lblDirectory).addComponent(this.cmdDirectory)).addGap(19, 19, 19).addGroup(panExportLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbAnfragen).addComponent(this.fldAnfragen, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panExportLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbTopProdukte).addComponent(this.fldTopProdukte, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panExportLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbTopEinsatzbereiche).addComponent(this.fldTopEinsatzbereiche, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panExportLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbTopVerkaeufer).addComponent(this.fldTopVerkaeufer, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panExportLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmdClose).addComponent(this.cmdStart)).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.panExport, "Center");
        this.pack();
    }

    private void cmdCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void cmdStartActionPerformed(ActionEvent evt) {
        try {
            JCheckBox[] cbAuswahl = new JCheckBox[]{this.cbAnfragen, this.cbTopProdukte, this.cbTopEinsatzbereiche, this.cbTopVerkaeufer};
            JTextField[] fldDateinamen = new JTextField[]{this.fldAnfragen, this.fldTopProdukte, this.fldTopEinsatzbereiche, this.fldTopVerkaeufer};
            YEvaluationList[] evListen = new YEvaluationList[]{this.evAnfragen, this.evTopProdukte, this.evTopEinsatzbereiche, this.evTopVerkaeufer};
            if (this.directory.exists()) {
                if (!this.directory.isDirectory()) {
                    JOptionPane.showMessageDialog(this, this.directory.getPath() + " ist kein Verzeichnis.", "Fehler", 0);
                    return;
                }
            } else {
                int a = JOptionPane.showConfirmDialog(this, "Das Verzeichnis " + this.directory.getPath() + " existiert nicht.\n" + "Soll es angelegt werden ?", "Verzeichnis anlegen", 2);
                if (a == 2) {
                    return;
                }
                this.directory.mkdirs();
            }
            for (int i = 0; i < cbAuswahl.length; ++i) {
                int a;
                File csvFile;
                String csvFileName;
                if (!cbAuswahl[i].isSelected() || (csvFileName = fldDateinamen[i].getText()).length() == 0 || (csvFile = new File(this.directory, csvFileName)).exists() && (a = JOptionPane.showConfirmDialog(this, csvFile + " existiert bereits ?\n" + "Datei \u00fcberschreiben ?", "Datei existiert bereits", 0, 3)) == 1) continue;
                FileOutputStream fos = new FileOutputStream(csvFile);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, System.getProperty("file.encoding"));
                evListen[i].fetchAsCSV(osw, ';', '\"', System.getProperty("line.separator"));
                osw.close();
                cbAuswahl[i].setSelected(false);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "I/O-Fehler", 0);
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdDirectoryActionPerformed(ActionEvent evt) {
        int rc = this.fileChooser.showSaveDialog(this);
        if (rc != 0) {
            return;
        }
        this.directory = this.fileChooser.getSelectedFile();
        this.lblDirectory.setText(this.directory.getAbsolutePath());
    }

    private void cbAnfragenActionPerformed(ActionEvent evt) {
        this.fldAnfragen.setEnabled(this.cbAnfragen.isSelected());
    }
}

