/*
 * Decompiled with CFR 0.152.
 */
package popometer.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import popometer.FrmNavigator;
import popometer.YPopometerSession;
import popometer.dbobjects.YROKunde;
import popometer.panels.PanMessung;
import popometer.panels.PanScanImage;
import projektY.base.YException;
import projektY.database.YDatabaseData;
import projektY.swing.YJPanelManager;

public class PanSitzknochen
extends PanMessung {
    private PanScanImage panImage;
    private Image defaultImage;
    private boolean scanned;
    private File scanCmd;
    private ScanThread scanThread;
    private File scanImage;
    private JButton cmdAbstand;
    private JButton cmdMeldung;
    private JButton cmdScannen;
    private JTextField fldAbstand;
    private JPanel jPanel1;
    private JLabel lblCm;
    private JPanel panControl;
    private JPanel panFill;
    private JProgressBar progress;
    private JScrollPane scrlImage;

    public PanSitzknochen(YPopometerSession session, YROKunde kunde, FrmNavigator frmNavigator) throws YException {
        super(session, kunde, frmNavigator);
        if (PanSitzknochen.isWindows()) {
            try {
                this.defaultImage = Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("/popometer/pictures/scanhinweis-windows.jpeg"));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), " Fehler", 0);
            }
        }
        if (!PanSitzknochen.isWindows()) {
            try {
                this.defaultImage = Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("/popometer/pictures/scanhinweis-linux.jpeg"));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), " Fehler", 0);
            }
        }
        this.panImage = new PanScanImage(this, this.defaultImage);
        this.panImage.setPreferredSize(new Dimension(1177, 850));
        this.scanThread = null;
        this.scanned = false;
        this.initComponents();
        YJPanelManager.createPanelManager((JComponent)this.panControl, (YDatabaseData)kunde);
        this.scanCmd = session.createScanCmd();
        this.scanImage = session.createScanImage();
    }

    protected void neuerKunde() throws YException {
        int kundeId = this.kunde.getPkFieldValueAsInt();
        this.scanned = false;
        if (kundeId > 0) {
            String imgPathname = this.session.getConfigFile().findValue("SITIMG_URL").substring(7);
            String imgName = String.format("S%07d.JPEG", kundeId);
            File imgFile = new File(imgPathname, imgName);
            if (imgFile.exists()) {
                Image image = Toolkit.getDefaultToolkit().createImage(imgFile.getPath());
                this.panImage.setImage(image);
                return;
            }
        }
        this.panImage.setImage(this.defaultImage);
    }

    public void copyFile(File in, File out) throws YException {
        FileChannel inChannel = null;
        AbstractInterruptibleChannel outChannel = null;
        try {
            inChannel = new FileInputStream(in).getChannel();
            outChannel = new FileOutputStream(out).getChannel();
            inChannel.transferTo(0L, inChannel.size(), (WritableByteChannel)((Object)outChannel));
        }
        catch (IOException e) {
            throw new YException(e.toString());
        }
        finally {
            try {
                if (inChannel != null) {
                    inChannel.close();
                }
                if (outChannel != null) {
                    outChannel.close();
                }
            }
            catch (IOException e) {}
        }
    }

    protected void afterPost() throws YException {
        if (!this.scanned) {
            return;
        }
        int kundeId = this.kunde.getPkFieldValueAsInt();
        String imgPathname = this.session.getConfigFile().findValue("SITIMG_URL").substring(7);
        String imgName = String.format("S%07d.JPEG", kundeId);
        File imgFile = new File(imgPathname, imgName);
        this.copyFile(this.scanImage, imgFile);
        this.scanned = false;
    }

    public void setAbstand(float abstand) {
        NumberFormat fmt = NumberFormat.getNumberInstance(Locale.getDefault());
        if (fmt instanceof DecimalFormat) {
            String numFormat = "##.#";
            ((DecimalFormat)fmt).applyPattern(numFormat);
        }
        this.fldAbstand.setText(fmt.format(abstand));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.scrlImage = new JScrollPane();
        this.scrlImage.setViewportView(this.panImage);
        this.panControl = new JPanel();
        this.cmdScannen = new JButton();
        this.progress = new JProgressBar();
        this.cmdMeldung = new JButton();
        this.cmdMeldung.setVisible(false);
        this.fldAbstand = new JTextField();
        this.lblCm = new JLabel();
        this.cmdAbstand = new JButton();
        this.panFill = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Me\u00dfbild"));
        this.jPanel1.setLayout(new BorderLayout());
        this.scrlImage.setBackground(new Color(255, 255, 255));
        this.jPanel1.add((Component)this.scrlImage, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.panControl.setBackground(new Color(255, 255, 255));
        this.panControl.setBorder(BorderFactory.createTitledBorder(this.kunde.getLabel("l_sitzknochen")));
        this.panControl.setLayout(new GridBagLayout());
        this.cmdScannen.setText("Scannen");
        this.cmdScannen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanSitzknochen.this.cmdScannenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panControl.add((Component)this.cmdScannen, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panControl.add((Component)this.progress, gridBagConstraints);
        this.cmdMeldung.setText("Fehler ...");
        this.cmdMeldung.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanSitzknochen.this.cmdMeldungActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panControl.add((Component)this.cmdMeldung, gridBagConstraints);
        this.fldAbstand.setMinimumSize(new Dimension(80, 19));
        this.fldAbstand.setName("l_sitzknochen");
        this.fldAbstand.setPreferredSize(new Dimension(80, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.panControl.add((Component)this.fldAbstand, gridBagConstraints);
        this.lblCm.setText("cm");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.panControl.add((Component)this.lblCm, gridBagConstraints);
        this.cmdAbstand.setText("O.K.");
        this.cmdAbstand.setToolTipText("F\u00fcr die Produktauswahl \u00fcbernehmen");
        this.cmdAbstand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanSitzknochen.this.cmdAbstandActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panControl.add((Component)this.cmdAbstand, gridBagConstraints);
        GroupLayout panFillLayout = new GroupLayout(this.panFill);
        this.panFill.setLayout(panFillLayout);
        panFillLayout.setHorizontalGroup(panFillLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 199, Short.MAX_VALUE));
        panFillLayout.setVerticalGroup(panFillLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 230, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.panControl.add((Component)this.panFill, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 11;
        this.add((Component)this.panControl, gridBagConstraints);
    }

    private void cmdScannenActionPerformed(ActionEvent evt) {
        if (!this.scanCmd.exists()) {
            JOptionPane.showMessageDialog(this, "Die Kommandodatei '" + this.scanCmd.getPath() + "' zum Scannen existiert nicht.", "Fehler", 0);
            return;
        }
        if (!this.scanCmd.canExecute()) {
            JOptionPane.showMessageDialog(this, "Die Kommandodatei '" + this.scanCmd.getPath() + "' zum Scannen ist nicht ausf\u00fchrbar.", "Fehler", 0);
            return;
        }
        if (this.session.isWindows()) {
            this.panImage.setImage(this.defaultImage);
        }
        this.cmdScannen.setEnabled(false);
        this.progress.setValue(0);
        this.cmdMeldung.setVisible(false);
        this.fldAbstand.setText("");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PanSitzknochen.this.scanThread = new ScanThread(PanSitzknochen.this.scanCmd.getPath());
                PanSitzknochen.this.scanThread.start();
            }
        });
    }

    private void cmdMeldungActionPerformed(ActionEvent evt) {
        if (this.scanThread == null) {
            return;
        }
        JOptionPane.showMessageDialog(this, this.scanThread.getErrmsg(), "Fehlermeldung", 0);
    }

    private void cmdAbstandActionPerformed(ActionEvent evt) {
        try {
            this.frmNavigator.setEinsteilbereich("sitzknochenabstand", this.parseFloat(this.fldAbstand.getText()));
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    public static boolean isLinux() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("linux") >= 0;
    }

    private class ScanThread
    extends Thread {
        private String scanCmd;
        private Runtime rt;
        private Process proc;
        private BufferedReader procerr;
        private BufferedReader procout;
        private StringBuffer errmsg;
        private boolean error;

        public ScanThread(String scanCmd) {
            this.scanCmd = scanCmd;
            this.errmsg = new StringBuffer(80);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String line;
                this.error = false;
                Cursor hourglassCursor = new Cursor(3);
                PanSitzknochen.this.setCursor(hourglassCursor);
                this.errmsg.setLength(0);
                this.rt = Runtime.getRuntime();
                this.proc = this.rt.exec(this.scanCmd);
                this.procerr = new BufferedReader(new InputStreamReader(this.proc.getErrorStream()));
                if (PanSitzknochen.this.session.isWindows()) {
                    this.procerr = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
                }
                Pattern pattern = Pattern.compile("Progress: ([0-9]+\\.[0-9])%");
                while ((line = this.procerr.readLine()) != null) {
                    Matcher matcher = pattern.matcher(line);
                    if (matcher.matches()) {
                        String strProgress = matcher.group(1);
                        int iProgress = Math.round(Float.parseFloat(strProgress));
                        PanSitzknochen.this.progress.setValue(iProgress);
                        continue;
                    }
                    this.errmsg.append(line + "\n");
                }
                this.proc.waitFor();
                if (this.proc.exitValue() == 0) {
                    if (PanSitzknochen.this.scanImage.exists()) {
                        Image image = Toolkit.getDefaultToolkit().createImage(PanSitzknochen.this.scanImage.getPath());
                        PanSitzknochen.this.panImage.setImage(image);
                        PanSitzknochen.this.scanned = true;
                        PanSitzknochen.this.kunde.setExternalChanges();
                    } else {
                        this.errmsg.append("Das Scannerbild wurde nicht erzeugt\noder unter falschem Namen abgelegt.");
                        this.error = true;
                        PanSitzknochen.this.scanned = false;
                    }
                } else {
                    this.error = true;
                }
            }
            catch (Exception e) {
                this.errmsg.append(e.toString() + "\n");
                this.error = true;
            }
            finally {
                PanSitzknochen.this.cmdMeldung.setVisible(this.error);
                PanSitzknochen.this.cmdScannen.setEnabled(true);
                Cursor defaultCursor = new Cursor(0);
                PanSitzknochen.this.setCursor(defaultCursor);
            }
        }

        public String getErrmsg() {
            if (this.errmsg.length() == 0) {
                return "Keine Meldung vorhanden";
            }
            return this.errmsg.toString();
        }
    }
}

