/*
 * Decompiled with CFR 0.152.
 */
package popometer;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import popometer.SplashScreen;
import popometer.YPopometerDatabase;
import popometer.dbobjects.YEVStyle;
import popometer.dbobjects.YQLBilder;
import popometer.dbobjects.YQLConfig;
import popometer.dbobjects.YRLLaender;
import popometer.dbobjects.YRLSuchproduktarten;
import popometer.dbobjects.YRODbversion;
import popometer.forms.DlgBenutzersuche;
import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YDatabase;
import projektY.database.YSQLQuery;
import projektY.database.YSession;
import projektY.utils.YConfigFile;
import projektY.utils.YLabelProvider;
import projektY.utils.YResourceLabelProvider;

public class YPopometerSession
extends YSession {
    private YConfigFile configFile;
    private final File popometerHome;
    private YPopometerDatabase database;
    private YRODbversion dbversion;
    private YRLLaender laender;
    private YQLConfig dbConfig;
    private YQLBilder bilder;
    private YEVStyle qlStyle;
    private String[] style;
    private boolean isAdmin;
    private boolean checkedAdmin;
    boolean messageLog;
    private int rolle;
    private int funktionen;

    public YPopometerSession(YConfigFile configFile, File popometerHome, YPopometerDatabase database, String yuser, String ypassword, SplashScreen splashScreen) throws YException {
        super((YDatabase)database, yuser, ypassword);
        this.configFile = configFile;
        this.popometerHome = popometerHome;
        this.database = database;
        this.rolle = database.login(null);
        this.checkedAdmin = false;
        this.messageLog = false;
        this.setLabelProvider((YLabelProvider)new YResourceLabelProvider(database.getLocale(), "popometer/resourcen/labels"));
        if (this.rolle == 1) {
            splashScreen.wipeOut();
        }
        while (this.rolle == 1) {
            DlgBenutzersuche dlgBenutzersuche = new DlgBenutzersuche(null, this);
            dlgBenutzersuche.setVisible(true);
            String loginName = dlgBenutzersuche.getUser();
            if (loginName == null) {
                database.disconnect();
                System.exit(0);
            }
            this.rolle = database.login(loginName);
            this.funktionen = 0;
        }
        this.dbConfig = new YQLConfig(this);
        this.dbversion = new YRODbversion(this);
        this.dbversion.fetch();
        this.laender = new YRLLaender(this);
        this.laender.fetch();
        this.bilder = new YQLBilder(this);
        this.bilder.fetch();
        this.addRowObjectList(new YRLSuchproduktarten(this).fetch());
        this.qlStyle = null;
        this.style = null;
    }

    public int getRolle() {
        return this.rolle;
    }

    public int getFunktionen() throws YException {
        if (this.funktionen == 0) {
            this.funktionen = this.database.getFunktionen();
        }
        return this.funktionen;
    }

    public YConfigFile getConfigFile() {
        return this.configFile;
    }

    public File getPopometerHome() {
        return this.popometerHome;
    }

    public String[] getStyle() throws YException {
        if (this.qlStyle == null) {
            this.qlStyle = new YEVStyle(this);
            this.qlStyle.fetch();
            this.style = this.qlStyle.createRules();
        }
        return this.style;
    }

    protected boolean isAdmin() throws YException {
        if (!this.checkedAdmin) {
            YSQLQuery sqlQuery = new YSQLQuery((YDatabase)this.database);
            sqlQuery.execute("SELECT rolname, rolsuper FROM pg_roles WHERE rolname = '" + this.getUser() + "' AND rolsuper = TRUE");
            this.isAdmin = sqlQuery.next();
            this.checkedAdmin = true;
            sqlQuery.close();
        }
        return this.isAdmin;
    }

    public boolean hasPermission(int berechtigung) throws YException {
        if (!this.isAdmin()) {
            // empty if block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterPassword(char[] pwdAlt, char[] pwdNeu) throws YException {
        YPopometerDatabase popometerDatabase = null;
        try {
            popometerDatabase = new YPopometerDatabase(this.database.getDriver(), this.database.getURL(), Locale.getDefault());
            popometerDatabase.connect(this.database.getUser(), new String(pwdAlt));
            popometerDatabase.alterPassword(pwdNeu);
        }
        finally {
            if (popometerDatabase != null && popometerDatabase.isConnected()) {
                popometerDatabase.disconnect();
            }
        }
    }

    public YRODbversion getDbversion() {
        return this.dbversion;
    }

    public YRLLaender getLaender() {
        return this.laender;
    }

    public YQLBilder getBilder() {
        return this.bilder;
    }

    private Image createImage(String imageName, boolean isThumb) throws YException {
        URL url;
        Image image;
        block27: {
            image = null;
            StringBuffer filePathName = new StringBuffer(80);
            boolean mustDownload = false;
            if (imageName.length() == 0) {
                url = ((Object)((Object)this)).getClass().getResource("/popometer/pictures/kein_bild.png");
            } else {
                StringBuffer neturl = new StringBuffer(this.dbConfig.findWert("IMAGEURL"));
                if (!neturl.toString().endsWith("/")) {
                    neturl.append('/');
                }
                if (isThumb) {
                    neturl.append("thumbs/");
                }
                neturl.append(imageName);
                neturl.append(".jpg");
                filePathName.append(this.configFile.findValue("CACHEDIR"));
                if (!filePathName.toString().endsWith("/")) {
                    filePathName.append('/');
                }
                filePathName.append("images/");
                if (isThumb) {
                    filePathName.append("thumbs/");
                }
                filePathName.append(imageName);
                filePathName.append(".jpg");
                File file = new File(filePathName.toString());
                try {
                    url = new URL(neturl.toString());
                }
                catch (MalformedURLException e) {
                    throw new YProgramException((Object)this, "Ung\u00fcltige URL f\u00fcr Bild: " + neturl.toString());
                }
                try {
                    boolean bl = mustDownload = !this.bilder.isAktuell(imageName, isThumb);
                    if (mustDownload && file.exists()) {
                        HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
                        httpUrlConnection.setRequestMethod("HEAD");
                        Map<String, List<String>> headerFields = httpUrlConnection.getHeaderFields();
                        List<String> lastModifiedValues = headerFields.get("Last-Modified");
                        List<String> contentLengthValues = headerFields.get("Content-Length");
                        if (lastModifiedValues == null) {
                            url = ((Object)((Object)this)).getClass().getResource("/popometer/pictures/logo-sq-lab.png");
                            mustDownload = false;
                        } else {
                            String lastModified = lastModifiedValues.get(0).toString();
                            if (contentLengthValues == null) {
                                mustDownload = true;
                            } else {
                                int month;
                                int contentLength = Integer.parseInt(contentLengthValues.get(0).toString());
                                if (!lastModified.matches("^[MTWFS].*GMT$")) {
                                    throw new YException("Ung\u00fcltiges HTML-Datum: " + lastModified);
                                }
                                Calendar calLastModified = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                                String[] dateItems = lastModified.split(" ");
                                String[] hms = dateItems[4].split(":");
                                int year = Integer.parseInt(dateItems[3]);
                                String[] htmlMonth = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
                                for (month = 0; month < htmlMonth.length && !dateItems[2].equals(htmlMonth[month]); ++month) {
                                }
                                if (month >= htmlMonth.length) {
                                    throw new YException("Ung\u00fcltiger HTML-Monat: " + dateItems[2]);
                                }
                                int day = Integer.parseInt(dateItems[1]);
                                int hour = Integer.parseInt(hms[0]);
                                int minutes = Integer.parseInt(hms[1]);
                                int seconds = Integer.parseInt(hms[2]);
                                calLastModified.set(year, month, day, hour, minutes, seconds);
                                mustDownload = calLastModified.getTimeInMillis() > file.lastModified();
                                mustDownload |= (long)contentLength != file.length();
                            }
                        }
                    }
                    if (mustDownload) {
                        int l;
                        if (this.messageLog) {
                            System.out.printf("Bild %s mu\u00df geholt werden.\n", url.toString());
                        }
                        FileOutputStream output = new FileOutputStream(file);
                        InputStream input = url.openStream();
                        byte[] buf = new byte[100];
                        while ((l = input.read(buf)) != -1) {
                            ((OutputStream)output).write(buf, 0, l);
                        }
                        input.close();
                        ((OutputStream)output).close();
                    } else if (!file.exists()) {
                        url = ((Object)((Object)this)).getClass().getResource("/popometer/pictures/logo-sq-lab.png");
                        if (this.messageLog) {
                            System.out.printf("Bild %s ist nicht vorhanden.\n", url.toString());
                        }
                    } else {
                        if (this.messageLog) {
                            System.out.printf("Bild %s ist als %s vorhanden.\n", url.toString(), file.getPath());
                        }
                        url = new URL("file://" + filePathName);
                    }
                    this.bilder.setAktuell(imageName, isThumb);
                }
                catch (IOException e) {
                    if (this.messageLog) {
                        System.out.printf("Bild %s konnte nicht geholt werden.\n", url.toString());
                    }
                    url = ((Object)((Object)this)).getClass().getResource("/popometer/pictures/logo-sq-lab.png");
                    if (!file.exists()) break block27;
                    file.delete();
                }
            }
        }
        image = Toolkit.getDefaultToolkit().createImage(url);
        return image;
    }

    public Image createImage(String imageName) throws YException {
        return this.createImage(imageName, false);
    }

    public Image createThumbImage(String imageName) throws YException {
        return this.createImage(imageName, true);
    }

    public File createScanCmd() {
        if (this.configFile.entryExists("SCANCMD")) {
            return new File(this.configFile.findValue("SCANCMD"));
        }
        return new File(this.popometerHome.getPath() + "/bin/scannen.sh");
    }

    public File createScanImage() {
        if (this.configFile.entryExists("SCANIMAGE")) {
            return new File(this.configFile.findValue("SCANIMAGE"));
        }
        return new File(this.popometerHome.getPath() + "/tmp/scanimage.jpeg");
    }
}

