/*
 * Decompiled with CFR 0.152.
 */
package popometer.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import popometer.YPopometerSession;
import popometer.dbobjects.YEVShophinweise;
import popometer.dbobjects.YQLAusfuehrungen;
import popometer.dbobjects.YRLAnfrageBestellt;
import popometer.dbobjects.YRLBestellungen;
import popometer.dbobjects.YROBestellung;
import popometer.dbobjects.YROHaendler;
import projektY.base.YException;
import projektY.base.YUserException;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDatabaseList;
import projektY.database.YDetailList;
import projektY.swing.YJTableManager;

public class PanBestellungen
extends JPanel {
    private YPopometerSession session;
    private YQLAusfuehrungen ausfuehrungen;
    private JTextField[] fldStueckzahlen;
    private YROBestellung bestellung;
    private YRLBestellungen bestellungen;
    private YRLAnfrageBestellt anfrageBestellt;
    private JCheckBox cbLieferungSofort;
    private JCheckBox cbNichtEingegangen;
    private JButton cmdAbschicken;
    private JButton cmdBerechnen;
    private JButton cmdDieseWoche;
    private JButton cmdDieserMonat;
    private JButton cmdFetch;
    private JButton cmdHeute;
    private JButton cmdHinzufuegen;
    private JButton cmdStatusaenderung;
    private JButton cmdStatuszurueck;
    private JTextField fldDatumAb;
    private JTextField fldDatumBis;
    private JTextField fldLieferdatum;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel lblAb;
    private JLabel lblBis;
    private JLabel lblRabatt;
    private JLabel lblSumme;
    private JLabel lblVersandtext;
    private JLabel lblWaehrung;
    private JPanel panAbgeschickt;
    private JPanel panAnfrageBestellt;
    private JPanel panControl;
    private JPanel panDatumSetzen;
    private JPanel panErledigen;
    private JPanel panErledigenLinks;
    private JPanel panErledigenRechts;
    private JPanel panFilter;
    private JPanel panNeu;
    private JPanel panPositionen;
    private JPanel panViewPortPositionen;
    private JScrollPane scrlAnfrageBestellt;
    private JScrollPane scrlBestellannfragen;
    private JScrollPane scrlBestellpos;
    private JScrollPane scrlBestellungen;
    private JScrollPane scrlMitteilung;
    private JScrollPane scrlPositionen;
    private JSplitPane splitAbgeschickt;
    private JSplitPane splitBestellungen;
    private JTabbedPane tabBestellungen;
    private JTable tblAnfrageBestellt;
    private JTable tblBestellanfragen;
    private JTable tblBestellpos;
    private JTable tblBestellungen;
    private JTextArea txtMitteilung;

    public PanBestellungen(Frame frame, YPopometerSession session, YROHaendler haendler, YEVShophinweise shophinweise) throws YException {
        GridBagConstraints gridBagConstraints;
        int iRow;
        this.initComponents();
        this.session = session;
        this.ausfuehrungen = new YQLAusfuehrungen(session);
        this.ausfuehrungen.fetch();
        this.fldStueckzahlen = new JTextField[this.ausfuehrungen.getRowCount()];
        this.anfrageBestellt = new YRLAnfrageBestellt(session);
        this.anfrageBestellt.setDispFields(new String[]{"datum", "bezeichnung", "bestellen"});
        YJTableManager.createTableManager((JTable)this.tblAnfrageBestellt, (YDatabaseList)this.anfrageBestellt);
        this.anfrageBestellt.fetch();
        JLabel lblAusfuehrung = new JLabel();
        lblAusfuehrung.setFont(new Font("Dialog", 0, 12));
        int maxWidth = 0;
        for (iRow = 0; iRow < this.ausfuehrungen.getRowCount(); ++iRow) {
            lblAusfuehrung.setText(this.ausfuehrungen.getAsString(iRow, "ausfuehrung") + " (" + this.ausfuehrungen.getAsString(iRow, "ausfuehrung") + ")");
            if (lblAusfuehrung.getPreferredSize().getSize().width <= maxWidth) continue;
            maxWidth = lblAusfuehrung.getPreferredSize().getSize().width;
        }
        int height = lblAusfuehrung.getPreferredSize().getSize().height;
        int prodgruppeId0 = 0;
        int produktId0 = 0;
        Container panAusfuehrungen = null;
        int gridProduktY = 0;
        int gridAusfuehrungY = 0;
        for (iRow = 0; iRow < this.ausfuehrungen.getRowCount(); ++iRow) {
            JLabel lblLieferbar;
            int produktId;
            int prodgruppeId = this.ausfuehrungen.getAsInt(iRow, "prodgruppe_id");
            if (prodgruppeId != prodgruppeId0) {
                if (panAusfuehrungen != null) {
                    gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 4;
                    gridBagConstraints.gridy = gridProduktY - 1;
                    gridBagConstraints.anchor = 17;
                    gridBagConstraints.insets = new Insets(4, 4, 4, 4);
                    this.panPositionen.add(panAusfuehrungen, gridBagConstraints);
                    panAusfuehrungen = null;
                }
                JLabel lblGruppe = new JLabel();
                lblGruppe.setText(this.ausfuehrungen.getAsString(iRow, "gruppe"));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = gridProduktY;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(4, 0, 4, 0);
                this.panPositionen.add((Component)lblGruppe, gridBagConstraints);
                JLabel lblGruppeVk = new JLabel();
                lblGruppeVk.setText("VK");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = gridProduktY;
                this.panPositionen.add((Component)lblGruppeVk, gridBagConstraints);
                JLabel lblGruppeEk = new JLabel();
                lblGruppeEk.setText("EK");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = gridProduktY;
                this.panPositionen.add((Component)lblGruppeEk, gridBagConstraints);
                JLabel lblGruppeAusfuehrungen = new JLabel();
                lblGruppeAusfuehrungen.setText("Bestellnummer (Bezeichnung)");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 4;
                gridBagConstraints.gridy = gridProduktY++;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new Insets(4, 8, 4, 4);
                this.panPositionen.add((Component)lblGruppeAusfuehrungen, gridBagConstraints);
                prodgruppeId0 = prodgruppeId;
            }
            if ((produktId = this.ausfuehrungen.getAsInt(iRow, "produkt_id")) != produktId0) {
                if (panAusfuehrungen != null) {
                    gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 4;
                    gridBagConstraints.gridy = gridProduktY - 1;
                    gridBagConstraints.insets = new Insets(4, 8, 4, 4);
                    gridBagConstraints.anchor = 17;
                    this.panPositionen.add(panAusfuehrungen, gridBagConstraints);
                    panAusfuehrungen = null;
                }
                JLabel lblProdukt = new JLabel();
                lblProdukt.setFont(new Font("Dialog", 0, 12));
                lblProdukt.setText(this.ausfuehrungen.getAsString(iRow, "produkt"));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = gridProduktY;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(0, 4, 0, 4);
                this.panPositionen.add((Component)lblProdukt, gridBagConstraints);
                JLabel lblImage = new JLabel();
                Image image = session.createThumbImage(this.ausfuehrungen.getAsString(iRow, "bild"));
                lblImage.setIcon(new ImageIcon(image));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = gridProduktY;
                gridBagConstraints.insets = new Insets(4, 4, 4, 4);
                this.panPositionen.add((Component)lblImage, gridBagConstraints);
                JLabel lblVk = new JLabel();
                lblVk.setFont(new Font("Dialog", 0, 12));
                lblVk.setText(this.ausfuehrungen.getAsString(iRow, "vkbruttopreis"));
                lblVk.setHorizontalTextPosition(4);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = gridProduktY;
                gridBagConstraints.insets = new Insets(0, 4, 0, 4);
                this.panPositionen.add((Component)lblVk, gridBagConstraints);
                JLabel lblEk = new JLabel();
                lblEk.setFont(new Font("Dialog", 0, 12));
                lblEk.setText(this.ausfuehrungen.getAsString(iRow, "ekpreis"));
                lblEk.setHorizontalTextPosition(4);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = gridProduktY++;
                gridBagConstraints.insets = new Insets(0, 4, 0, 4);
                this.panPositionen.add((Component)lblEk, gridBagConstraints);
                gridAusfuehrungY = 0;
                panAusfuehrungen = new JPanel();
                panAusfuehrungen.setLayout(new GridBagLayout());
                JLabel lblStueck = new JLabel();
                lblStueck.setText("St\u00fcck");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = gridAusfuehrungY;
                gridBagConstraints.anchor = 17;
                panAusfuehrungen.add((Component)lblStueck, gridBagConstraints);
                lblLieferbar = new JLabel();
                lblLieferbar.setText("Lieferbar");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = gridAusfuehrungY++;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(4, 4, 4, 0);
                panAusfuehrungen.add((Component)lblLieferbar, gridBagConstraints);
                produktId0 = produktId;
            }
            lblAusfuehrung = new JLabel();
            lblAusfuehrung.setFont(new Font("Dialog", 0, 12));
            lblAusfuehrung.setText(this.ausfuehrungen.getAsString(iRow, "wawinummer") + " (" + this.ausfuehrungen.getAsString(iRow, "ausfuehrung") + ")");
            lblAusfuehrung.setPreferredSize(new Dimension(maxWidth, height));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = gridAusfuehrungY;
            gridBagConstraints.insets = new Insets(0, 0, 0, 4);
            panAusfuehrungen.add((Component)lblAusfuehrung, gridBagConstraints);
            JTextField fldStueck = new JTextField();
            fldStueck.setHorizontalAlignment(4);
            fldStueck.setPreferredSize(new Dimension(40, 19));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = gridAusfuehrungY;
            panAusfuehrungen.add((Component)fldStueck, gridBagConstraints);
            this.fldStueckzahlen[iRow] = fldStueck;
            lblLieferbar = new JLabel();
            lblLieferbar.setText(this.ausfuehrungen.getAsString(iRow, "lieferbar"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = gridAusfuehrungY++;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(4, 4, 4, 0);
            panAusfuehrungen.add((Component)lblLieferbar, gridBagConstraints);
        }
        if (panAusfuehrungen != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = gridProduktY - 1;
            gridBagConstraints.insets = new Insets(4, 8, 4, 4);
            gridBagConstraints.anchor = 17;
            this.panPositionen.add(panAusfuehrungen, gridBagConstraints);
        }
        this.bestellung = new YROBestellung(session);
        this.bestellungen = new YRLBestellungen(session);
        YJTableManager.createTableManager((JTable)this.tblBestellungen, (YDatabaseList)this.bestellungen);
        YJTableManager.createTableManager((JTable)this.tblBestellpos, (YDatabaseList)((YDatabaseList)this.bestellungen.getSubRowList("bestellpos")), (boolean)true);
        YJTableManager.createTableManager((JTable)this.tblBestellanfragen, (YDatabaseList)((YDatabaseList)this.bestellungen.getSubRowList("bestellanfragen")));
        if (shophinweise.getRowCount() > 0 && !shophinweise.getFieldValue(0, "versandtext").isNull()) {
            this.lblVersandtext.setText(shophinweise.getAsString(0, "versandtext"));
        }
        this.lblRabatt.setText(haendler.getAsString("rabatt"));
    }

    private void setLblSumme(int summe) {
        this.lblSumme.setText(String.format("%d.%02d", summe / 100, summe % 100));
    }

    public boolean hasStatusChanged() throws YException {
        return this.bestellungen.hasChanged();
    }

    public boolean hasBestellpos() throws YException {
        for (int iRow = 0; iRow < this.ausfuehrungen.getRowCount(); ++iRow) {
            if (this.fldStueckzahlen[iRow].getText().length() <= 0) continue;
            return true;
        }
        return false;
    }

    public void setSelectedPanel(int iPanel) {
        this.tabBestellungen.setSelectedIndex(iPanel == 0 ? 0 : 1);
    }

    private void initComponents() {
        this.tabBestellungen = new JTabbedPane();
        this.panNeu = new JPanel();
        this.panControl = new JPanel();
        this.jLabel1 = new JLabel();
        this.fldLieferdatum = new JTextField();
        this.cmdBerechnen = new JButton();
        this.lblSumme = new JLabel();
        this.lblWaehrung = new JLabel();
        this.cmdAbschicken = new JButton();
        this.jLabel2 = new JLabel();
        this.scrlMitteilung = new JScrollPane();
        this.txtMitteilung = new JTextArea();
        this.jLabel3 = new JLabel();
        this.lblRabatt = new JLabel();
        this.lblVersandtext = new JLabel();
        this.cbLieferungSofort = new JCheckBox();
        this.panAnfrageBestellt = new JPanel();
        this.scrlAnfrageBestellt = new JScrollPane();
        this.tblAnfrageBestellt = new JTable();
        this.panErledigen = new JPanel();
        this.panErledigenLinks = new JPanel();
        this.panErledigenRechts = new JPanel();
        this.cmdHinzufuegen = new JButton();
        this.scrlPositionen = new JScrollPane();
        this.panViewPortPositionen = new JPanel();
        this.panPositionen = new JPanel();
        this.panAbgeschickt = new JPanel();
        this.panFilter = new JPanel();
        this.lblBis = new JLabel();
        this.fldDatumAb = new JTextField();
        this.cmdFetch = new JButton();
        this.lblAb = new JLabel();
        this.fldDatumBis = new JTextField();
        this.cmdStatusaenderung = new JButton();
        this.cmdStatuszurueck = new JButton();
        this.panDatumSetzen = new JPanel();
        this.cmdHeute = new JButton();
        this.cmdDieseWoche = new JButton();
        this.cmdDieserMonat = new JButton();
        this.cbNichtEingegangen = new JCheckBox();
        this.splitAbgeschickt = new JSplitPane();
        this.splitBestellungen = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.scrlBestellungen = new JScrollPane();
        this.tblBestellungen = new JTable();
        this.jPanel2 = new JPanel();
        this.scrlBestellpos = new JScrollPane();
        this.tblBestellpos = new JTable();
        this.jPanel3 = new JPanel();
        this.scrlBestellannfragen = new JScrollPane();
        this.tblBestellanfragen = new JTable();
        this.setLayout(new BorderLayout());
        this.panNeu.setLayout(new GridBagLayout());
        this.panControl.setBorder(BorderFactory.createTitledBorder(""));
        this.panControl.setLayout(new GridBagLayout());
        this.jLabel1.setText("Gew\u00fcnschter Liefertermin");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        this.panControl.add((Component)this.jLabel1, gridBagConstraints);
        this.fldLieferdatum.setEditable(false);
        this.fldLieferdatum.setMinimumSize(new Dimension(100, 19));
        this.fldLieferdatum.setPreferredSize(new Dimension(100, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panControl.add((Component)this.fldLieferdatum, gridBagConstraints);
        this.cmdBerechnen.setText("Summe:");
        this.cmdBerechnen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanBestellungen.this.cmdBerechnenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 4, 8);
        this.panControl.add((Component)this.cmdBerechnen, gridBagConstraints);
        this.lblSumme.setText("<- Berechnen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.panControl.add((Component)this.lblSumme, gridBagConstraints);
        this.lblWaehrung.setText("\u20ac");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.panControl.add((Component)this.lblWaehrung, gridBagConstraints);
        this.cmdAbschicken.setText("Bestellung abschicken ...");
        this.cmdAbschicken.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanBestellungen.this.cmdAbschickenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.panControl.add((Component)this.cmdAbschicken, gridBagConstraints);
        this.jLabel2.setText("Hinweis an SQlab");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 8);
        this.panControl.add((Component)this.jLabel2, gridBagConstraints);
        this.txtMitteilung.setColumns(20);
        this.txtMitteilung.setRows(5);
        this.scrlMitteilung.setViewportView(this.txtMitteilung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.panControl.add((Component)this.scrlMitteilung, gridBagConstraints);
        this.jLabel3.setText("Ber\u00fccksichtigter Rabatt");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 8);
        this.panControl.add((Component)this.jLabel3, gridBagConstraints);
        this.lblRabatt.setText("(Kundenrabatt)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.panControl.add((Component)this.lblRabatt, gridBagConstraints);
        this.lblVersandtext.setText("(Versandhinweis)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.panControl.add((Component)this.lblVersandtext, gridBagConstraints);
        this.cbLieferungSofort.setSelected(true);
        this.cbLieferungSofort.setText("Lieferung sofort");
        this.cbLieferungSofort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanBestellungen.this.cbLieferungSofortActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.panControl.add((Component)this.cbLieferungSofort, gridBagConstraints);
        this.panAnfrageBestellt.setBorder(BorderFactory.createTitledBorder("Verkaufte Produkte"));
        this.panAnfrageBestellt.setLayout(new BorderLayout());
        this.scrlAnfrageBestellt.setViewportView(this.tblAnfrageBestellt);
        this.panAnfrageBestellt.add((Component)this.scrlAnfrageBestellt, "Center");
        this.panErledigen.setLayout(new GridLayout(1, 0));
        this.panErledigenLinks.setLayout(new FlowLayout(0));
        this.panErledigen.add(this.panErledigenLinks);
        this.cmdHinzufuegen.setText("In die Bestellung eintragen");
        this.cmdHinzufuegen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanBestellungen.this.cmdHinzufuegenActionPerformed(evt);
            }
        });
        this.panErledigenRechts.add(this.cmdHinzufuegen);
        this.panErledigen.add(this.panErledigenRechts);
        this.panAnfrageBestellt.add((Component)this.panErledigen, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.panControl.add((Component)this.panAnfrageBestellt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.panNeu.add((Component)this.panControl, gridBagConstraints);
        this.scrlPositionen.setBackground(new Color(255, 255, 255));
        this.scrlPositionen.setBorder(BorderFactory.createTitledBorder(""));
        this.panViewPortPositionen.setBackground(new Color(255, 255, 255));
        this.panViewPortPositionen.setLayout(new BorderLayout());
        this.panPositionen.setBackground(new Color(255, 255, 255));
        this.panPositionen.setLayout(new GridBagLayout());
        this.panViewPortPositionen.add((Component)this.panPositionen, "North");
        this.scrlPositionen.setViewportView(this.panViewPortPositionen);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panNeu.add((Component)this.scrlPositionen, gridBagConstraints);
        this.tabBestellungen.addTab("Neue Bestellung", this.panNeu);
        this.panAbgeschickt.setLayout(new BorderLayout());
        this.panFilter.setBorder(BorderFactory.createTitledBorder(""));
        this.panFilter.setLayout(new GridBagLayout());
        this.lblBis.setText("... bis:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        this.panFilter.add((Component)this.lblBis, gridBagConstraints);
        this.fldDatumAb.setMinimumSize(new Dimension(100, 19));
        this.fldDatumAb.setPreferredSize(new Dimension(100, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panFilter.add((Component)this.fldDatumAb, gridBagConstraints);
        this.cmdFetch.setText("Aktualisieren");
        this.cmdFetch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanBestellungen.this.cmdFetchActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panFilter.add((Component)this.cmdFetch, gridBagConstraints);
        this.lblAb.setText("Zeitraum ab:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.panFilter.add((Component)this.lblAb, gridBagConstraints);
        this.fldDatumBis.setMinimumSize(new Dimension(100, 19));
        this.fldDatumBis.setPreferredSize(new Dimension(100, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panFilter.add((Component)this.fldDatumBis, gridBagConstraints);
        this.cmdStatusaenderung.setText("Status\u00e4nderungen speichern");
        this.cmdStatusaenderung.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanBestellungen.this.cmdStatusaenderungActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panFilter.add((Component)this.cmdStatusaenderung, gridBagConstraints);
        this.cmdStatuszurueck.setText("Status\u00e4nderungen zur\u00fccknehmen");
        this.cmdStatuszurueck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanBestellungen.this.cmdStatuszurueckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panFilter.add((Component)this.cmdStatuszurueck, gridBagConstraints);
        this.panDatumSetzen.setLayout(new FlowLayout(0));
        this.cmdHeute.setText("Heute");
        this.cmdHeute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanBestellungen.this.cmdHeuteActionPerformed(evt);
            }
        });
        this.panDatumSetzen.add(this.cmdHeute);
        this.cmdDieseWoche.setText("Diese Woche");
        this.cmdDieseWoche.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanBestellungen.this.cmdDieseWocheActionPerformed(evt);
            }
        });
        this.panDatumSetzen.add(this.cmdDieseWoche);
        this.cmdDieserMonat.setText("Dieser Monat");
        this.cmdDieserMonat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanBestellungen.this.cmdDieserMonatActionPerformed(evt);
            }
        });
        this.panDatumSetzen.add(this.cmdDieserMonat);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        this.panFilter.add((Component)this.panDatumSetzen, gridBagConstraints);
        this.cbNichtEingegangen.setSelected(true);
        this.cbNichtEingegangen.setText("Noch nicht eingegangen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.panFilter.add((Component)this.cbNichtEingegangen, gridBagConstraints);
        this.panAbgeschickt.add((Component)this.panFilter, "North");
        this.splitAbgeschickt.setDividerLocation(200);
        this.splitAbgeschickt.setOrientation(0);
        this.splitAbgeschickt.setResizeWeight(0.5);
        this.splitBestellungen.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.splitBestellungen.setResizeWeight(0.4);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Bestellungen"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.scrlBestellungen.setBackground(new Color(255, 255, 255));
        this.scrlBestellungen.setViewportView(this.tblBestellungen);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.scrlBestellungen, gridBagConstraints);
        this.splitBestellungen.setRightComponent(this.jPanel1);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Positionsliste der ausgew\u00e4hlten Bestellung"));
        this.jPanel2.setLayout(new GridBagLayout());
        this.scrlBestellpos.setBackground(new Color(255, 255, 255));
        this.scrlBestellpos.setViewportView(this.tblBestellpos);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.scrlBestellpos, gridBagConstraints);
        this.splitBestellungen.setLeftComponent(this.jPanel2);
        this.splitAbgeschickt.setLeftComponent(this.splitBestellungen);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Verk\u00e4ufe zur ausgew\u00e4hlten Bestellung"));
        this.jPanel3.setLayout(new GridBagLayout());
        this.scrlBestellannfragen.setBackground(new Color(255, 255, 255));
        this.scrlBestellannfragen.setViewportView(this.tblBestellanfragen);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.scrlBestellannfragen, gridBagConstraints);
        this.splitAbgeschickt.setRightComponent(this.jPanel3);
        this.panAbgeschickt.add((Component)this.splitAbgeschickt, "Center");
        this.tabBestellungen.addTab("Abgeschickte Bestellungen", this.panAbgeschickt);
        this.add((Component)this.tabBestellungen, "Center");
    }

    private void cmdBerechnenActionPerformed(ActionEvent evt) {
        try {
            int summe = 0;
            for (int iRow = 0; iRow < this.ausfuehrungen.getRowCount(); ++iRow) {
                int menge;
                String strMenge = this.fldStueckzahlen[iRow].getText();
                if (strMenge.length() == 0) continue;
                try {
                    menge = Integer.parseInt(strMenge);
                }
                catch (NumberFormatException e) {
                    throw new YUserException("Ung\u00fcltige Mengenangabe '" + strMenge + "' f\u00fcr " + this.ausfuehrungen.getAsString(iRow, "ausfuehrung"));
                }
                if (menge <= 0) {
                    throw new YUserException("Ung\u00fcltige Mengenangabe '" + strMenge + "' f\u00fcr " + this.ausfuehrungen.getAsString(iRow, "ausfuehrung"));
                }
                summe += (int)(this.ausfuehrungen.getAsFloat(iRow, "ekpreis") * 100.0f) * menge;
            }
            this.setLblSumme(summe);
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdAbschickenActionPerformed(ActionEvent evt) {
        try {
            int iAusfuehrung;
            this.bestellung.clear();
            YDetailList bestellpos = this.bestellung.getDetailList("bestellpos");
            int summe = 0;
            int iBestellpos = 0;
            for (iAusfuehrung = 0; iAusfuehrung < this.ausfuehrungen.getRowCount(); ++iAusfuehrung) {
                int menge;
                String strMenge = this.fldStueckzahlen[iAusfuehrung].getText();
                if (strMenge.length() == 0) continue;
                try {
                    menge = Integer.parseInt(strMenge);
                }
                catch (NumberFormatException e) {
                    throw new YUserException("Ung\u00fcltige Mengenangabe '" + strMenge + "' f\u00fcr " + this.ausfuehrungen.getAsString(iAusfuehrung, "ausfuehrung"));
                }
                if (menge <= 0) {
                    throw new YUserException("Ung\u00fcltige Mengenangabe '" + strMenge + "' f\u00fcr " + this.ausfuehrungen.getAsString(iAusfuehrung, "ausfuehrung"));
                }
                float ekpreis = this.ausfuehrungen.getAsFloat(iAusfuehrung, "ekpreis");
                bestellpos.setAsInt(iBestellpos, "ausfuehrung_id", this.ausfuehrungen.getAsInt(iAusfuehrung, "ausfuehrung_id"));
                bestellpos.setAsString(iBestellpos, "bezeichnung", this.ausfuehrungen.getAsString(iAusfuehrung, "ausfuehrung"));
                bestellpos.setAsString(iBestellpos, "wawinummer", this.ausfuehrungen.getAsString(iAusfuehrung, "wawinummer"));
                bestellpos.setAsInt(iBestellpos, "menge", menge);
                bestellpos.setAsFloat(iBestellpos, "ekpreis", ekpreis);
                bestellpos.setAsInt(iBestellpos, "preiseinheit", this.ausfuehrungen.getAsInt(iAusfuehrung, "preiseinheit"));
                bestellpos.setAsFloat(iBestellpos, "gesamtpreis", ekpreis * (float)menge);
                summe += (int)(ekpreis * 100.0f) * menge;
                ++iBestellpos;
            }
            this.setLblSumme(summe);
            if (iBestellpos == 0) {
                JOptionPane.showMessageDialog(this, "Sie haben nichts bestellt.");
                return;
            }
            if (!this.cbLieferungSofort.isSelected() && this.fldLieferdatum.getText().length() == 0) {
                JOptionPane.showMessageDialog(this, "Bitte gew\u00fcnschten Liefertermin angeben\noder \"Lieferung sofort\" ausw\u00e4hlen!.");
                return;
            }
            int a = JOptionPane.showConfirmDialog(this, "Ihre Bestellung wird jetzt abgeschickt.", "Hinweis", 2);
            if (a == 2) {
                return;
            }
            this.bestellung.setAsBool("sofort", this.cbLieferungSofort.isSelected());
            if (this.fldLieferdatum.isEditable()) {
                this.bestellung.setAsString("lieferdatum", this.fldLieferdatum.getText());
            } else {
                this.bestellung.modifyToNull("lieferdatum");
            }
            this.bestellung.setAsString("mitteilung", this.txtMitteilung.getText());
            this.bestellung.post();
            int bestellungId = this.bestellung.getPkFieldValueAsInt();
            for (int iRow = 0; iRow < this.anfrageBestellt.getRowCount(); ++iRow) {
                int ausfuehrungId;
                if (!this.anfrageBestellt.getFieldValue(iRow, "bestellung_id").isNull() || !this.anfrageBestellt.getFieldValue(iRow, "bestellen").getValueAsBool() || bestellpos.find(String.valueOf(ausfuehrungId = this.anfrageBestellt.getAsInt(iRow, "ausfuehrung_id")), "ausfuehrung_id") < 0) continue;
                this.anfrageBestellt.setAsInt(iRow, "bestellung_id", bestellungId);
            }
            this.anfrageBestellt.postErledigt();
            for (iAusfuehrung = 0; iAusfuehrung < this.ausfuehrungen.getRowCount(); ++iAusfuehrung) {
                this.fldStueckzahlen[iAusfuehrung].setText("");
            }
            this.fldLieferdatum.setText("");
            this.txtMitteilung.setText("");
            this.lblSumme.setText("<- Berechnen");
            JOptionPane.showMessageDialog(this, "Ihre Bestellung ist bei SQlab eingegangen.\nSie erhalten kein weitere Best\u00e4tigung.");
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdFetchActionPerformed(ActionEvent evt) {
        try {
            this.bestellungen.clearFilterValues();
            String filter = this.fldDatumAb.getText();
            if (filter.length() > 0) {
                this.bestellungen.setFilterValue("datum_ab", filter);
            }
            if ((filter = this.fldDatumBis.getText()).length() > 0) {
                this.bestellungen.setFilterValue("datum_bis", filter);
            }
            if (this.cbNichtEingegangen.isSelected()) {
                this.bestellungen.setFilterValue("nicht_eingegangen", "true");
            }
            this.bestellungen.fetch();
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdHinzufuegenActionPerformed(ActionEvent evt) {
        try {
            int iRow;
            int[] stueckzahlen = new int[this.ausfuehrungen.getRowCount()];
            for (iRow = 0; iRow < this.ausfuehrungen.getRowCount(); ++iRow) {
                String stueckzahl = this.fldStueckzahlen[iRow].getText().trim();
                if (stueckzahl.length() == 0) {
                    stueckzahlen[iRow] = 0;
                    continue;
                }
                try {
                    stueckzahlen[iRow] = Integer.parseInt(stueckzahl);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new YUserException("Ung\u00fcltige Zahlenangabe: " + stueckzahl);
                }
            }
            for (iRow = 0; iRow < this.anfrageBestellt.getRowCount(); ++iRow) {
                if (!this.anfrageBestellt.getAsBool(iRow, "bestellen")) continue;
                int iAusfuehrung = this.ausfuehrungen.find(this.anfrageBestellt.getAsString(iRow, "ausfuehrung_id"), "ausfuehrung_id");
                if (iAusfuehrung < 0) {
                    JOptionPane.showMessageDialog(this, this.anfrageBestellt.getAsString(iRow, "bezeichnung") + " kann nicht bestellt werden.\nBitte kontaktieren Sie SQlab !");
                    this.anfrageBestellt.setAsBool(iRow, "bestellen", false);
                    this.anfrageBestellt.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, iRow, iRow));
                    continue;
                }
                int n = iAusfuehrung;
                stueckzahlen[n] = stueckzahlen[n] + 1;
                this.fldStueckzahlen[iAusfuehrung].setText(String.valueOf(stueckzahlen[iAusfuehrung]));
            }
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdStatusaenderungActionPerformed(ActionEvent evt) {
        try {
            this.bestellungen.post();
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdStatuszurueckActionPerformed(ActionEvent evt) {
        try {
            this.bestellungen.revert();
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cbLieferungSofortActionPerformed(ActionEvent evt) {
        this.fldLieferdatum.setEditable(!this.cbLieferungSofort.isSelected());
    }

    private void cmdHeuteActionPerformed(ActionEvent evt) {
        DateFormat dateFormat = DateFormat.getDateInstance(2, this.session.getLocale());
        GregorianCalendar cal = this.session.getCal();
        Date date = cal.getTime();
        this.fldDatumAb.setText(dateFormat.format(date));
    }

    private void cmdDieseWocheActionPerformed(ActionEvent evt) {
        DateFormat dateFormat = DateFormat.getDateInstance(2, this.session.getLocale());
        GregorianCalendar cal = this.session.getCal();
        cal.set(7, 2);
        Date date = cal.getTime();
        this.fldDatumAb.setText(dateFormat.format(date));
    }

    private void cmdDieserMonatActionPerformed(ActionEvent evt) {
        DateFormat dateFormat = DateFormat.getDateInstance(2, this.session.getLocale());
        GregorianCalendar cal = this.session.getCal();
        cal.set(5, 1);
        Date date = cal.getTime();
        this.fldDatumAb.setText(dateFormat.format(date));
    }
}

