/*
 * Decompiled with CFR 0.152.
 */
package popometer.bikeandfit;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.ImageObserver;
import popometer.bikeandfit.Messpunkte;
import popometer.bikeandfit.Parameter;
import popometer.graphics.Koerperpunkt;
import popometer.graphics.RectScaler;

public class Koerperpunkte {
    final Parameter parameter;
    Koerperpunkt[] koerperpunkte;
    private int[] xPoints;
    private int[] yPoints;
    public boolean abgeleitet;

    public Koerperpunkte(Parameter parameter, RectScaler rectScaler) {
        this.parameter = parameter;
        this.koerperpunkte = new Koerperpunkt[NAMEN.values().length];
        for (NAMEN name : NAMEN.values()) {
            this.koerperpunkte[name.getIndex()] = new Koerperpunkt(rectScaler);
        }
        this.xPoints = new int[NAMEN.values().length];
        this.yPoints = new int[NAMEN.values().length];
        this.abgeleitet = false;
    }

    public void ableiten(Messpunkte messpunkte, float pixelProMeter) {
        float fy = pixelProMeter / 100.0f;
        float fx = fy * (float)(this.parameter.blickrichtungRechts ? 1 : -1);
        this.koerperpunkte[NAMEN.FUSS.getIndex()].x = messpunkte.pedal.x + Math.round(this.parameter.offsetFussX * fx);
        this.koerperpunkte[NAMEN.FUSS.getIndex()].y = messpunkte.pedal.y - Math.round(this.parameter.offsetFussY * fy);
        this.koerperpunkte[NAMEN.SITZ.getIndex()].x = messpunkte.sitz.x + Math.round(this.parameter.offsetSitzX * fx);
        this.koerperpunkte[NAMEN.SITZ.getIndex()].y = messpunkte.sitz.y - Math.round(this.parameter.offsetSitzY * fy);
        this.koerperpunkte[NAMEN.HAND.getIndex()].x = messpunkte.griff.x + Math.round(this.parameter.offsetHandX * fx);
        this.koerperpunkte[NAMEN.HAND.getIndex()].y = messpunkte.griff.y - Math.round(this.parameter.offsetHandY * fy);
        this.koerperpunkte[NAMEN.KNIE.getIndex()].x = messpunkte.knie.x;
        this.koerperpunkte[NAMEN.KNIE.getIndex()].y = messpunkte.knie.y;
        this.koerperpunkte[NAMEN.HUEFTE.getIndex()].x = messpunkte.huefte.x;
        this.koerperpunkte[NAMEN.HUEFTE.getIndex()].y = messpunkte.huefte.y;
        this.koerperpunkte[NAMEN.SCHULTER.getIndex()].x = messpunkte.schulter.x;
        this.koerperpunkte[NAMEN.SCHULTER.getIndex()].y = messpunkte.schulter.y;
        this.koerperpunkte[NAMEN.ARM.getIndex()].x = messpunkte.arm.x;
        this.koerperpunkte[NAMEN.ARM.getIndex()].y = messpunkte.arm.y;
        float dx = (float)this.koerperpunkte[NAMEN.HUEFTE.getIndex()].x / fx;
        float dy = (float)this.koerperpunkte[NAMEN.HUEFTE.getIndex()].y / fy;
        System.out.printf("FUSS: x=%5.1f, y=%5.1f\n", Float.valueOf((float)this.koerperpunkte[NAMEN.FUSS.getIndex()].x / fx - dx), Float.valueOf((float)this.koerperpunkte[NAMEN.FUSS.getIndex()].y / fy - dy));
        System.out.printf("KNIE: x=%5.1f, y=%5.1f\n", Float.valueOf((float)this.koerperpunkte[NAMEN.KNIE.getIndex()].x / fx - dx), Float.valueOf((float)this.koerperpunkte[NAMEN.KNIE.getIndex()].y / fy - dy));
        System.out.printf("SITZ: x=%5.1f, y=%5.1f\n", Float.valueOf((float)this.koerperpunkte[NAMEN.SITZ.getIndex()].x / fx - dx), Float.valueOf((float)this.koerperpunkte[NAMEN.SITZ.getIndex()].y / fy - dy));
        System.out.printf("HUEFTE: x=%5.1f, y=%5.1f\n", Float.valueOf(0.0f), Float.valueOf(0.0f));
        System.out.printf("SCHULTER: x=%5.1f, y=%5.1f\n", Float.valueOf((float)this.koerperpunkte[NAMEN.SCHULTER.getIndex()].x / fx - dx), Float.valueOf((float)this.koerperpunkte[NAMEN.SCHULTER.getIndex()].y / fy - dy));
        System.out.printf("ARM: x=%5.1f, y=%5.1f\n", Float.valueOf((float)this.koerperpunkte[NAMEN.ARM.getIndex()].x / fx - dx), Float.valueOf((float)this.koerperpunkte[NAMEN.ARM.getIndex()].y / fy - dy));
        System.out.printf("HAND: x=%5.1f, y=%5.1f\n", Float.valueOf((float)this.koerperpunkte[NAMEN.HAND.getIndex()].x / fx - dx), Float.valueOf((float)this.koerperpunkte[NAMEN.HAND.getIndex()].y / fy - dy));
        this.abgeleitet = true;
    }

    public Koerperpunkt[] get() {
        return this.koerperpunkte;
    }

    public void paint(Graphics2D g2d, Image image, ImageObserver imageObserver) {
        int i = 0;
        int in = 0;
        for (Koerperpunkt k : this.koerperpunkte) {
            if (in++ == NAMEN.valueOf("SITZ").getIndex()) {
                k.paint(g2d, image, imageObserver);
                continue;
            }
            Point point = k.paint(g2d, image, imageObserver);
            this.xPoints[i] = point.x;
            this.yPoints[i] = point.y;
            ++i;
        }
        g2d.setXORMode(Color.GRAY);
        g2d.drawPolyline(this.xPoints, this.yPoints, this.xPoints.length - 1);
        g2d.setPaintMode();
    }

    public static enum NAMEN {
        FUSS(0),
        KNIE(1),
        SITZ(2),
        HUEFTE(3),
        SCHULTER(4),
        ARM(5),
        HAND(6);

        private int index;

        private NAMEN(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

