/*
 * Decompiled with CFR 0.152.
 */
package popometer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import popometer.YPopometerDatabase;
import popometer.YPopometerSession;
import popometer.dbobjects.YDLAnfrageProdukte;
import popometer.dbobjects.YEVShophinweise;
import popometer.dbobjects.YQLBilder;
import popometer.dbobjects.YRLEinsatzbereiche;
import popometer.dbobjects.YRLSuchproduktarten;
import popometer.dbobjects.YROAnfrage;
import popometer.dbobjects.YROAusfuehrung;
import popometer.dbobjects.YROHaendler;
import popometer.dbobjects.YROKunde;
import popometer.dbobjects.YSRLEinsatzbedingungen;
import popometer.dbobjects.YSRLEinsatzteilbereiche;
import popometer.dbobjects.YSRLEinsbereichprodart;
import popometer.forms.DlgEigenesPasswort;
import popometer.forms.DlgInfo;
import popometer.panels.PanAuswertungen;
import popometer.panels.PanBestellungen;
import popometer.panels.PanEinsatzbereich;
import popometer.panels.PanErgebnis;
import popometer.panels.PanFuss;
import popometer.panels.PanGewicht;
import popometer.panels.PanHand;
import popometer.panels.PanKoerper;
import popometer.panels.PanKunden;
import popometer.panels.PanKundendaten;
import popometer.panels.PanSitzknochen;
import popometer.panels.PanStammdaten;
import popometer.panels.PanVerkaeufer;
import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.base.YUserException;
import projektY.database.YFieldValue;
import projektY.database.YRowObjectList;
import projektY.utils.YConfigFile;

public class FrmNavigator
extends JFrame {
    private YConfigFile configFile;
    private YPopometerSession session;
    private YROHaendler haendler;
    private YEVShophinweise shophinweise;
    private YROKunde kunde;
    private PanKundendaten panKundendaten;
    private JTabbedPane panVermessung;
    private PanSitzknochen panSitzknochen;
    private PanHand panHand;
    private PanFuss panFuss;
    private PanKoerper panKoerper;
    private PanGewicht panGewicht;
    private JTabbedPane panProfiler;
    private JTabbedPane panProdukte;
    private PanAuswertungen panAuswertungen;
    private PanBestellungen panBestellungen;
    private PanStammdaten panStammdaten;
    private PanVerkaeufer panVerkaeufer;
    private PanKunden panKunden;
    private YRLEinsatzbereiche rlEinsatzbereiche;
    private PanEinsatzbereich[] panEinsatzbereich;
    private JCheckBox[] cbSuchproduktarten;
    private PanErgebnis[] panErgebnis;
    private YROAnfrage anfrage;
    private Vector<Integer> einsbedingungIds;
    private int rolle;
    private ProdartEinsbereiche prodartEinsbereiche;
    private JButton cmdAnfrageSpeichern;
    private JButton cmdNeuerKunde;
    private JButton cmdProduktsuche;
    private JSeparator jSeparator1;
    private JLabel lblLogo;
    private JMenuItem mniBeenden;
    private JMenuItem mniClearCache;
    private JMenuItem mniInfo;
    private JMenuItem mniPasswort;
    private JMenuItem mniTimeout;
    private JMenu mnuDatei;
    private JMenu mnuEinrichten;
    private JMenu mnuHilfe;
    private JMenuBar mnuMain;
    private JPanel panControl;
    private JTabbedPane panMain;
    private JPanel panProduktarten;
    private JScrollPane scrlProduktarten;

    public FrmNavigator(YPopometerSession session, YConfigFile configFile) throws YException {
        this.session = session;
        this.initComponents();
        this.configFile = configFile;
        this.rolle = session.getRolle();
        if (this.rolle == 2) {
            int funktionen = session.getFunktionen();
            if (funktionen == 1) {
                Object[] optionen = new Object[]{"H\u00e4ndler", "Verk\u00e4ufer"};
                int o = JOptionPane.showOptionDialog(this, "Bitte w\u00e4hlen Sie die gew\u00fcnschte Art der Anmeldung.", "Anmelden als ...", 1, 3, null, optionen, optionen[0]);
                if (o == -1) {
                    throw new YUserException("Die Anmeldung wurde abgebrochen.");
                }
                this.rolle = 2 + o;
            } else {
                this.rolle = funktionen == 2 ? 2 : 3;
            }
        }
        boolean kontaktdaten = true;
        this.rlEinsatzbereiche = new YRLEinsatzbereiche(session);
        this.rlEinsatzbereiche.fetch();
        if (this.rolle == 2) {
            YFieldValue fvAktionstext;
            this.scrlProduktarten.setVisible(false);
            this.haendler = new YROHaendler(session);
            this.haendler.fetch();
            this.shophinweise = new YEVShophinweise(session);
            this.shophinweise.fetch();
            this.panBestellungen = new PanBestellungen(this, session, this.haendler, this.shophinweise);
            this.panMain.addTab("Bestellungen", this.panBestellungen);
            this.panStammdaten = new PanStammdaten(this, this.haendler);
            this.panMain.addTab("Stammdaten", this.panStammdaten);
            this.panVerkaeufer = new PanVerkaeufer(session, this.haendler);
            this.panMain.addTab("(Weitere) Verk\u00e4ufer", this.panVerkaeufer);
            this.panAuswertungen = new PanAuswertungen(this, session);
            this.panMain.addTab("Auswertungen", this.panAuswertungen);
            this.panKunden = new PanKunden(this, session);
            this.panMain.addTab("Kunden", this.panKunden);
            this.cmdNeuerKunde.setVisible(false);
            this.cmdProduktsuche.setVisible(false);
            this.cmdAnfrageSpeichern.setVisible(false);
            if (this.shophinweise.getRowCount() > 0 && !(fvAktionstext = this.shophinweise.getFieldValue(0, "aktionstext")).isNull()) {
                JLabel label = new JLabel();
                label.setFont(new Font("SansSerif", 1, 14));
                label.setText(fvAktionstext.getValue());
                kontaktdaten = false;
            }
        } else {
            YFieldValue fvMessgroesseBedingung;
            YFieldValue fvMessgroesseTeilbereich;
            int iEinsb;
            this.mnuMain.remove(this.mnuEinrichten);
            this.kunde = new YROKunde(session);
            this.anfrage = new YROAnfrage(session);
            this.panKundendaten = new PanKundendaten(session, this.kunde, this);
            this.panMain.addTab("Kundendaten", this.panKundendaten);
            int nEinsb = this.rlEinsatzbereiche.getRowCount();
            this.panVermessung = new JTabbedPane();
            ImageIcon icBodyscan = new ImageIcon(this.getClass().getResource("/popometer/pictures/messen.gif"));
            for (iEinsb = 0; iEinsb < nEinsb; ++iEinsb) {
                fvMessgroesseTeilbereich = this.rlEinsatzbereiche.getFieldValue(iEinsb, "messgroesse_teilbereich");
                fvMessgroesseBedingung = this.rlEinsatzbereiche.getFieldValue(iEinsb, "messgroesse_bedingung");
                if (fvMessgroesseTeilbereich.isNull() && fvMessgroesseBedingung.isNull()) continue;
                if (fvMessgroesseBedingung.getValue().equals("fusslaenge")) {
                    this.panFuss = new PanFuss(session, this.kunde, this);
                    this.panVermessung.addTab("Fu\u00df", icBodyscan, this.panFuss);
                }
                if (fvMessgroesseTeilbereich.getValue().equals("sitzknochenabstand")) {
                    this.panSitzknochen = new PanSitzknochen(session, this.kunde, this);
                    this.panVermessung.addTab("Sitzknochenabstand", icBodyscan, this.panSitzknochen);
                }
                if (fvMessgroesseBedingung.getValue().equals("griffweite")) {
                    this.panHand = new PanHand(session, this.kunde, this);
                    this.panVermessung.addTab("Griffweite", icBodyscan, this.panHand);
                }
                if (!fvMessgroesseBedingung.getValue().equals("gewicht")) continue;
                this.panGewicht = new PanGewicht(session, this.kunde, this);
                this.panVermessung.addTab("Gewicht", icBodyscan, this.panGewicht);
            }
            this.panKoerper = new PanKoerper(session, this.kunde, this);
            this.panVermessung.addTab("Bike & Fit", icBodyscan, this.panKoerper);
            this.panMain.addTab("Vermessung", icBodyscan, this.panVermessung);
            this.panProfiler = new JTabbedPane();
            this.panEinsatzbereich = new PanEinsatzbereich[nEinsb];
            for (iEinsb = 0; iEinsb < nEinsb; ++iEinsb) {
                int iPan;
                fvMessgroesseTeilbereich = this.rlEinsatzbereiche.getFieldValue(iEinsb, "messgroesse_teilbereich");
                fvMessgroesseBedingung = this.rlEinsatzbereiche.getFieldValue(iEinsb, "messgroesse_bedingung");
                this.panEinsatzbereich[iEinsb] = new PanEinsatzbereich(session, this.rlEinsatzbereiche.getAsInt(iEinsb, "einsbereich_id"), this, this.kunde);
                if (fvMessgroesseTeilbereich.isNull() && fvMessgroesseBedingung.isNull()) {
                    this.panProfiler.addTab(this.rlEinsatzbereiche.getRowValues(iEinsb).toString(), this.panEinsatzbereich[iEinsb]);
                    continue;
                }
                if (fvMessgroesseTeilbereich.getValue().equals("sitzknochenabstand")) {
                    iPan = this.panVermessung.indexOfComponent(this.panSitzknochen) + 1;
                    this.panVermessung.add((Component)this.panEinsatzbereich[iEinsb], iPan);
                    this.panVermessung.setTitleAt(iPan, this.rlEinsatzbereiche.getRowValues(iEinsb).toString());
                    continue;
                }
                if (fvMessgroesseBedingung.getValue().equals("griffweite")) {
                    iPan = this.panVermessung.indexOfComponent(this.panHand) + 1;
                    this.panVermessung.add((Component)this.panEinsatzbereich[iEinsb], iPan);
                    this.panVermessung.setTitleAt(iPan, this.rlEinsatzbereiche.getRowValues(iEinsb).toString());
                    continue;
                }
                if (fvMessgroesseBedingung.getValue().equals("gewicht")) {
                    iPan = this.panVermessung.indexOfComponent(this.panGewicht) + 1;
                    this.panVermessung.add((Component)this.panEinsatzbereich[iEinsb], iPan);
                    this.panVermessung.setTitleAt(iPan, this.rlEinsatzbereiche.getRowValues(iEinsb).toString());
                    continue;
                }
                if (fvMessgroesseBedingung.getValue().equals("fusslaenge")) {
                    iPan = this.panVermessung.indexOfComponent(this.panFuss) + 1;
                    this.panVermessung.add((Component)this.panEinsatzbereich[iEinsb], iPan);
                    this.panVermessung.setTitleAt(iPan, this.rlEinsatzbereiche.getRowValues(iEinsb).toString());
                    continue;
                }
                throw new YProgramException((Object)this, "Unbekannte Me\u00dfgr\u00f6\u00dfe: " + fvMessgroesseTeilbereich + fvMessgroesseBedingung);
            }
            this.panMain.add("Fahrstil", this.panProfiler);
            this.lblLogo.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/logo-sq-lab.png")));
            YRLSuchproduktarten rlSuchproduktarten = (YRLSuchproduktarten)session.getRowObjectList("suchproduktarten");
            int maxWidth = 0;
            if (rlSuchproduktarten.getRowCount() == 0) {
                this.cbSuchproduktarten = null;
            } else {
                this.cbSuchproduktarten = new JCheckBox[rlSuchproduktarten.getRowCount()];
                YSRLEinsbereichprodart einsbereichprodart = (YSRLEinsbereichprodart)rlSuchproduktarten.getSubRowList("einsbereichprodart");
                for (int iRow = 0; iRow < rlSuchproduktarten.getRowCount(); ++iRow) {
                    JCheckBox checkBox = new JCheckBox();
                    checkBox.setSelected(true);
                    checkBox.setEnabled(false);
                    checkBox.setText(rlSuchproduktarten.getAsString(iRow, "produktart"));
                    maxWidth = Math.max(maxWidth, checkBox.getPreferredSize().width);
                    this.panProduktarten.add(checkBox);
                    this.cbSuchproduktarten[iRow] = checkBox;
                }
            }
            this.prodartEinsbereiche = new ProdartEinsbereiche();
            Dimension dimLogo = this.lblLogo.getPreferredSize();
            Dimension dimScrlProduktarten = this.scrlProduktarten.getPreferredSize();
            System.out.printf("Logo bxh: %dx%d\n", (int)dimLogo.getWidth(), (int)dimLogo.getHeight());
            System.out.printf("Produktarten bxh: %dx%d\n", (int)dimScrlProduktarten.getWidth(), (int)dimScrlProduktarten.getHeight());
            this.scrlProduktarten.setPreferredSize(new Dimension(maxWidth + this.scrlProduktarten.getVerticalScrollBar().getPreferredSize().width, dimLogo.height));
            this.cmdProduktsuche.setVisible(true);
            this.einsbedingungIds = new Vector(nEinsb + 20);
            this.panProdukte = new JTabbedPane();
            this.panErgebnis = new PanErgebnis[rlSuchproduktarten.getRowCount()];
            for (int iProdart = 0; iProdart < rlSuchproduktarten.getRowCount(); ++iProdart) {
                this.panErgebnis[iProdart] = new PanErgebnis(session, rlSuchproduktarten.getAsInt(iProdart, "prodart_id"));
                this.panProdukte.add(rlSuchproduktarten.getRowValues(iProdart).toString(), this.panErgebnis[iProdart]);
            }
            this.panMain.add("Produkte", this.panProdukte);
            this.panMain.setEnabledAt(this.panMain.indexOfComponent(this.panProdukte), false);
        }
        if (configFile != null && configFile.findValue("MAXIMIZED").equals("true")) {
            this.setExtendedState(6);
        }
        if (kontaktdaten) {
            // empty if block
        }
        this.pack();
    }

    public void einsatzbedingungGewaehlt(int einsbereichId, boolean gesetzt) {
        try {
            this.prodartEinsbereiche.setzeEinsatzbereich(einsbereichId, gesetzt);
            boolean produktsucheMoeglich = false;
            for (int iCheckbox = 0; iCheckbox < this.cbSuchproduktarten.length; ++iCheckbox) {
                int prodartId = this.session.getRowObjectList("suchproduktarten").getAsInt(iCheckbox, "prodart_id");
                boolean produktartKomplett = this.prodartEinsbereiche.produktartKomplett(prodartId);
                this.cbSuchproduktarten[iCheckbox].setEnabled(produktartKomplett);
                produktsucheMoeglich |= produktartKomplett;
            }
            this.cmdProduktsuche.setEnabled(produktsucheMoeglich);
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void setEinsbedingung(int einsbereichId, int einsteilbereichId, int einsbedingungId) throws YException {
        int nEinsb = this.panEinsatzbereich.length;
        for (int iEinsb = 0; iEinsb < nEinsb; ++iEinsb) {
            if (!this.panEinsatzbereich[iEinsb].setEinsbedingung(einsbereichId, einsteilbereichId, einsbedingungId)) continue;
            this.panVermessung.setSelectedComponent(this.panEinsatzbereich[iEinsb]);
            break;
        }
    }

    public void setEinsteilbereich(String messgroesseTeilbereich, float wert) throws YException {
        int einsteilbereichId = 0;
        int iRow = this.rlEinsatzbereiche.find(messgroesseTeilbereich, "messgroesse_teilbereich");
        if (iRow < 0) {
            throw new YProgramException((Object)this, "Unbekannte Me\u00dfgr\u00f6\u00dfe f\u00fcr Einsatz: " + messgroesseTeilbereich);
        }
        YSRLEinsatzteilbereiche srlEinsatzteilbereiche = (YSRLEinsatzteilbereiche)this.rlEinsatzbereiche.getSubRowList("einsatzteilbereiche");
        this.rlEinsatzbereiche.setActiveRow(iRow);
        for (iRow = 0; iRow < srlEinsatzteilbereiche.getRowCount(); ++iRow) {
            float wertMax;
            YFieldValue fvWertMin = srlEinsatzteilbereiche.getFieldValue(iRow, "wert_min");
            YFieldValue fvWertMax = srlEinsatzteilbereiche.getFieldValue(iRow, "wert_max");
            if (fvWertMin.isNull()) {
                if (fvWertMax.isNull() || !(wert <= (wertMax = srlEinsatzteilbereiche.parseFloat(fvWertMax)))) continue;
                einsteilbereichId = srlEinsatzteilbereiche.getAsInt(iRow, "einsteilbereich_id");
                break;
            }
            float wertMin = srlEinsatzteilbereiche.parseFloat(fvWertMin);
            if (fvWertMax.isNull()) {
                if (!(wert > wertMin)) continue;
                einsteilbereichId = srlEinsatzteilbereiche.getAsInt(iRow, "einsteilbereich_id");
                break;
            }
            wertMax = srlEinsatzteilbereiche.parseFloat(fvWertMax);
            if (!(wertMin < wert) || !(wert <= wertMax)) continue;
            einsteilbereichId = srlEinsatzteilbereiche.getAsInt(iRow, "einsteilbereich_id");
            break;
        }
        if (einsteilbereichId == 0) {
            throw new YUserException("Diesem Me\u00dfwert konnte kein Einsatzfall zugeordnet werden.");
        }
        int einsbereichId = this.rlEinsatzbereiche.getActiveRowValues().getAsInt("einsbereich_id");
        this.setEinsbedingung(einsbereichId, einsteilbereichId, 0);
    }

    public void setEinsbedingung(String messgroesseBedingung, float wert) throws YException {
        int einsbedingungId = 0;
        int iRow = this.rlEinsatzbereiche.find(messgroesseBedingung, "messgroesse_bedingung");
        if (iRow < 0) {
            throw new YProgramException((Object)this, "Unbekannte Me\u00dfgr\u00f6\u00dfe f\u00fcr Einsatzbedingung: " + messgroesseBedingung);
        }
        YSRLEinsatzbedingungen srlEinsatzbedingungen = (YSRLEinsatzbedingungen)this.rlEinsatzbereiche.getSubRowList("einsatzbedingungen");
        this.rlEinsatzbereiche.setActiveRow(iRow);
        for (iRow = 0; iRow < srlEinsatzbedingungen.getRowCount(); ++iRow) {
            float wertMax;
            YFieldValue fvWertMin = srlEinsatzbedingungen.getFieldValue(iRow, "wert_min");
            YFieldValue fvWertMax = srlEinsatzbedingungen.getFieldValue(iRow, "wert_max");
            if (fvWertMin.isNull()) {
                if (fvWertMax.isNull() || !(wert <= (wertMax = srlEinsatzbedingungen.parseFloat(fvWertMax)))) continue;
                einsbedingungId = srlEinsatzbedingungen.getAsInt(iRow, "einsbedingung_id");
                break;
            }
            float wertMin = srlEinsatzbedingungen.parseFloat(fvWertMin);
            if (fvWertMax.isNull()) {
                if (!(wert > wertMin)) continue;
                einsbedingungId = srlEinsatzbedingungen.getAsInt(iRow, "einsbedingung_id");
                break;
            }
            wertMax = srlEinsatzbedingungen.parseFloat(fvWertMax);
            if (!(wertMin < wert) || !(wert <= wertMax)) continue;
            einsbedingungId = srlEinsatzbedingungen.getAsInt(iRow, "einsbedingung_id");
            break;
        }
        if (einsbedingungId == 0) {
            throw new YUserException("Diesem Me\u00dfwert konnte kein Einsatzfall zugeordnet werden.");
        }
        int einsteilbereichId = srlEinsatzbedingungen.getAsInt(iRow, "einsteilbereich_id");
        int einsbereichId = this.rlEinsatzbereiche.getActiveRowValues().getAsInt("einsbereich_id");
        this.setEinsbedingung(einsbereichId, einsteilbereichId, einsbedingungId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitPopometer(boolean force) {
        block29: {
            String hinweis = "\nUm das zu vermeiden, verlassen Sie das Programm\nin Zukunft besser \u00fcber das Men\u00fc mit Datei/Beenden.";
            try {
                int a;
                if (this.rolle == 3) {
                    if (this.panKundendaten.hasChanged()) {
                        if (force) {
                            JOptionPane.showMessageDialog(this, "Kunden- bzw. Profilerdaten gehen verloren." + hinweis, "Ungesicherte \u00c4nderungen", 1);
                        } else {
                            a = JOptionPane.showConfirmDialog(this, "Kunden- bzw. Profilerdaten speichern?", "Ungesicherte \u00c4nderungen", 0, 3);
                            if (a == 0) {
                                this.panMain.setSelectedComponent(this.panKundendaten);
                                return;
                            }
                        }
                    }
                    break block29;
                }
                if (this.panBestellungen.hasBestellpos()) {
                    if (force) {
                        JOptionPane.showMessageDialog(this, "Die Eintr\u00e4ge in der Bestellung gehen verloren." + hinweis, "Ungesicherte \u00c4nderungen", 2);
                    } else {
                        a = JOptionPane.showConfirmDialog(this, "Es gibt nicht abgeschickte Eintr\u00e4ge in der Bestellungen.\nBestellung nochmal anschauen ?", "Ungesicherte \u00c4nderungen", 0, 3);
                        if (a == 0) {
                            this.panMain.setSelectedComponent(this.panBestellungen);
                            this.panBestellungen.setSelectedPanel(0);
                            return;
                        }
                    }
                }
                if (this.panBestellungen.hasStatusChanged()) {
                    if (force) {
                        JOptionPane.showMessageDialog(this, "Die Status\u00e4nderungen bei den Bestellungen gehen verloren." + hinweis, "Ungesicherte \u00c4nderungen", 2);
                    } else {
                        JOptionPane.showMessageDialog(this, "Die Status\u00e4nderungen bei den Bestellungen bitte speichern oder zur\u00fccknehmen.", "Ungesicherte \u00c4nderungen", 1);
                        this.panMain.setSelectedComponent(this.panBestellungen);
                        this.panBestellungen.setSelectedPanel(1);
                        return;
                    }
                }
                if (this.panStammdaten.hasChanged()) {
                    if (force) {
                        JOptionPane.showMessageDialog(this, "Die \u00c4nderungen an den Stammdaten gehen verloren." + hinweis, "Ungesicherte \u00c4nderungen", 2);
                    } else {
                        JOptionPane.showMessageDialog(this, "Die \u00c4nderungen an den Stammdaten bitte speichern oder verwerfen.", "Ungesicherte \u00c4nderungen", 1);
                        this.panMain.setSelectedComponent(this.panStammdaten);
                        return;
                    }
                }
                if (this.panVerkaeufer.hasChanged()) {
                    if (force) {
                        JOptionPane.showMessageDialog(this, "Die \u00c4nderungen bei den Verk\u00e4ufern gehen verloren." + hinweis, "Ungesicherte \u00c4nderungen", 2);
                    } else {
                        JOptionPane.showMessageDialog(this, "Die \u00c4nderungen bei den Verk\u00e4ufern bitte speichern oder verwerfen.", "Ungesicherte \u00c4nderungen", 1);
                        this.panMain.setSelectedComponent(this.panVerkaeufer);
                        return;
                    }
                }
                if (!this.panKunden.hasChanged()) break block29;
                if (force) {
                    JOptionPane.showMessageDialog(this, "Die \u00c4nderungen bei den Kunden gehen verloren." + hinweis, "Ungesicherte \u00c4nderungen", 2);
                    break block29;
                }
                JOptionPane.showMessageDialog(this, "Die \u00c4nderungen bei den Kunden bitte speichern oder verwerfen.", "Ungesicherte \u00c4nderungen", 1);
                this.panMain.setSelectedComponent(this.panKunden);
                return;
            }
            catch (YException e) {
                JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
            }
        }
        try {
            if (this.configFile != null) {
                int extendedState = this.getExtendedState();
                if ((extendedState & 6) == 6) {
                    this.configFile.setEntry("MAXIMIZED", "true");
                } else {
                    this.configFile.setEntry("MAXIMIZED", "false");
                }
                this.configFile.write();
            }
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
        finally {
            this.session.getDatabase().disconnect();
            System.exit(0);
        }
    }

    public void disableProdukte() {
        this.cmdAnfrageSpeichern.setEnabled(false);
        this.cmdProduktsuche.setEnabled(false);
        this.panMain.setEnabledAt(this.panMain.indexOfComponent(this.panProdukte), false);
    }

    private void initComponents() {
        this.panControl = new JPanel();
        this.lblLogo = new JLabel();
        this.cmdNeuerKunde = new JButton();
        this.scrlProduktarten = new JScrollPane();
        this.panProduktarten = new JPanel();
        this.cmdProduktsuche = new JButton();
        this.cmdAnfrageSpeichern = new JButton();
        this.panMain = new JTabbedPane();
        this.mnuMain = new JMenuBar();
        this.mnuDatei = new JMenu();
        this.mniPasswort = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.mniBeenden = new JMenuItem();
        this.mnuEinrichten = new JMenu();
        this.mniTimeout = new JMenuItem();
        this.mniClearCache = new JMenuItem();
        this.mnuHilfe = new JMenu();
        this.mniInfo = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FrmNavigator.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.panControl.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panControl.add((Component)this.lblLogo, gridBagConstraints);
        this.cmdNeuerKunde.setText("Neuer Kunde");
        this.cmdNeuerKunde.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmNavigator.this.cmdNeuerKundeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panControl.add((Component)this.cmdNeuerKunde, gridBagConstraints);
        this.panProduktarten.setBackground(new Color(255, 255, 255));
        this.panProduktarten.setBorder(BorderFactory.createTitledBorder(""));
        this.panProduktarten.setLayout(new GridLayout(0, 5));
        this.scrlProduktarten.setViewportView(this.panProduktarten);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panControl.add((Component)this.scrlProduktarten, gridBagConstraints);
        this.cmdProduktsuche.setText("Produktsuche");
        this.cmdProduktsuche.setEnabled(false);
        this.cmdProduktsuche.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmNavigator.this.cmdProduktsucheActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panControl.add((Component)this.cmdProduktsuche, gridBagConstraints);
        this.cmdAnfrageSpeichern.setText("Anfrage speichern");
        this.cmdAnfrageSpeichern.setEnabled(false);
        this.cmdAnfrageSpeichern.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmNavigator.this.cmdAnfrageSpeichernActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panControl.add((Component)this.cmdAnfrageSpeichern, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.panControl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.panMain, gridBagConstraints);
        this.mnuDatei.setMnemonic('D');
        this.mnuDatei.setText("Datei");
        this.mniPasswort.setMnemonic('P');
        this.mniPasswort.setText("Passwort \u00e4ndern ...");
        this.mniPasswort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmNavigator.this.mniPasswortActionPerformed(evt);
            }
        });
        this.mnuDatei.add(this.mniPasswort);
        this.mnuDatei.add(this.jSeparator1);
        this.mniBeenden.setAccelerator(KeyStroke.getKeyStroke(69, 8));
        this.mniBeenden.setMnemonic('e');
        this.mniBeenden.setText("Beenden");
        this.mniBeenden.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmNavigator.this.mniBeendenActionPerformed(evt);
            }
        });
        this.mnuDatei.add(this.mniBeenden);
        this.mnuMain.add(this.mnuDatei);
        this.mnuEinrichten.setMnemonic('E');
        this.mnuEinrichten.setText("Einrichten");
        this.mniTimeout.setText("Connection Timeout setzen ...");
        this.mniTimeout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmNavigator.this.mniTimeoutActionPerformed(evt);
            }
        });
        this.mnuEinrichten.add(this.mniTimeout);
        this.mniClearCache.setText("Image Cache l\u00f6schen ...");
        this.mniClearCache.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmNavigator.this.mniClearCacheActionPerformed(evt);
            }
        });
        this.mnuEinrichten.add(this.mniClearCache);
        this.mnuMain.add(this.mnuEinrichten);
        this.mnuHilfe.setMnemonic('?');
        this.mnuHilfe.setText("?");
        this.mniInfo.setMnemonic('n');
        this.mniInfo.setText("Info");
        this.mniInfo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmNavigator.this.mniInfoActionPerformed(evt);
            }
        });
        this.mnuHilfe.add(this.mniInfo);
        this.mnuMain.add(this.mnuHilfe);
        this.setJMenuBar(this.mnuMain);
        this.pack();
    }

    private void mniBeendenActionPerformed(ActionEvent evt) {
        this.exitPopometer(false);
    }

    private void cmdProduktsucheActionPerformed(ActionEvent evt) {
        try {
            int iProdart;
            Vector<Integer> prodartIds = new Vector<Integer>(10);
            YRowObjectList rlSuchproduktarten = this.session.getRowObjectList("suchproduktarten");
            for (iProdart = 0; iProdart < rlSuchproduktarten.getRowCount(); ++iProdart) {
                if (!this.cbSuchproduktarten[iProdart].isEnabled() || !this.cbSuchproduktarten[iProdart].isSelected()) continue;
                prodartIds.add(new Integer(rlSuchproduktarten.getAsInt(iProdart, "prodart_id")));
            }
            if (prodartIds.size() == 0) {
                JOptionPane.showMessageDialog(this, "Sie m\u00fcssen wenigstens eine Produktart ausw\u00e4hlen.", "Hinweis", 1);
                return;
            }
            int iProdart1 = -1;
            for (iProdart = 0; iProdart < rlSuchproduktarten.getRowCount(); ++iProdart) {
                int i;
                int prodartId = rlSuchproduktarten.getAsInt(iProdart, "prodart_id");
                for (i = 0; i < prodartIds.size() && prodartId != (Integer)prodartIds.get(i); ++i) {
                }
                if (i >= prodartIds.size()) {
                    this.panProdukte.setEnabledAt(this.panProdukte.indexOfComponent(this.panErgebnis[iProdart]), false);
                    continue;
                }
                if (iProdart1 < 0) {
                    iProdart1 = iProdart;
                }
                this.einsbedingungIds.clear();
                int nPanEinsatzbereich = this.panEinsatzbereich.length;
                for (int iPanEinsatzbereich = 0; iPanEinsatzbereich < nPanEinsatzbereich; ++iPanEinsatzbereich) {
                    int einsbereichId = this.panEinsatzbereich[iPanEinsatzbereich].getEinsbereichId();
                    if (!this.prodartEinsbereiche.isRelevant(prodartId, einsbereichId) || this.panEinsatzbereich[iPanEinsatzbereich].getEinsbedingungIds(this.einsbedingungIds)) continue;
                    throw new YProgramException((Object)this, "Auswahl f\u00fcr '" + (Object)((Object)this.panEinsatzbereich[iPanEinsatzbereich].getEinsatzbereich()) + "' fehlt.");
                }
                this.panErgebnis[iProdart].holeProdukte(this.einsbedingungIds);
                this.panProdukte.setEnabledAt(this.panProdukte.indexOfComponent(this.panErgebnis[iProdart]), true);
            }
            this.panMain.setEnabledAt(this.panMain.indexOfComponent(this.panProdukte), true);
            this.panMain.setSelectedComponent(this.panProdukte);
            this.panProdukte.setSelectedIndex(iProdart1);
            this.cmdAnfrageSpeichern.setEnabled(true);
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.exitPopometer(true);
    }

    private void mniInfoActionPerformed(ActionEvent evt) {
        DlgInfo dlgInfo = new DlgInfo((Frame)this, this.session);
        dlgInfo.setVisible(true);
    }

    private void cmdAnfrageSpeichernActionPerformed(ActionEvent evt) {
        boolean anonym = false;
        try {
            int i;
            int a;
            this.kunde.requestValuesToStore();
            if (!this.kunde.hasKontaktDaten()) {
                a = JOptionPane.showConfirmDialog(this, "Kontaktdaten erfassen bzw. vervollst\u00e4ndigen ?\n(Telefonnummer oder eMail w\u00fcrde gen\u00fcgen.)", "Kontaktdaten", 0, 3);
                if (a == 0) {
                    this.panMain.setSelectedComponent(this.panKundendaten);
                    return;
                }
                if (this.kunde.getPkFieldValue().isNull()) {
                    a = JOptionPane.showConfirmDialog(this, "Zum Zuordnen der Anfrage wird ein neuer, anonymer Kunde angelegt.", "", 2, 1);
                    if (a == 2) {
                        return;
                    }
                    anonym = true;
                }
            }
            this.anfrage.clear();
            this.anfrage.setAsString("datum", this.session.stringToday());
            YDLAnfrageProdukte anfrageProdukte = (YDLAnfrageProdukte)this.anfrage.getDetailList("vh_anfrageprodukte");
            Vector<YROAusfuehrung> produkte = new Vector<YROAusfuehrung>(20);
            Vector<Boolean> verkauft = new Vector<Boolean>(20);
            for (int iPan = 0; iPan < this.panErgebnis.length; ++iPan) {
                PanErgebnis panErgebnis = this.panErgebnis[iPan];
                if (!panErgebnis.isEnabled()) continue;
                panErgebnis.getVerkauft(produkte, verkauft);
            }
            for (i = 0; i < verkauft.size() && !((Boolean)verkauft.get(i)).booleanValue(); ++i) {
            }
            if (i >= verkauft.size() && (a = JOptionPane.showConfirmDialog(this, "Sie haben kein Produkt als verkauft oder bestellt gekennzeichnet.\nIst das korrekt ?", "Speichern ?", 0)) == 1) {
                return;
            }
            for (int iRow = 0; iRow < produkte.size(); ++iRow) {
                YROAusfuehrung ausfuehrung = produkte.get(iRow);
                anfrageProdukte.setAsInt(iRow, "produkt_id", ausfuehrung.getAsInt("produkt_id"));
                anfrageProdukte.setAsInt(iRow, "ausfuehrung_id", ausfuehrung.getAsInt("ausfuehrung_id"));
                anfrageProdukte.setAsString(iRow, "bezeichnung", ausfuehrung.getAsString("bezeichnung"));
                anfrageProdukte.setAsInt(iRow, "prodart_id", ausfuehrung.getAsInt("prodart_id"));
                anfrageProdukte.setAsBool(iRow, "verkauft", verkauft.get(iRow));
            }
            String strText = anonym ? "f\u00fcr anonymen Kunden" : "f\u00fcr " + this.kunde.toString();
            a = JOptionPane.showConfirmDialog(this, "Anfrage " + strText + " speichern ?", "Speichern ?", 2);
            if (a == 2) {
                return;
            }
            this.kunde.post();
            this.anfrage.setAsInt("kunde_id", this.kunde.getPkFieldValueAsInt());
            this.anfrage.post();
            this.kunde.getDetailList("vh_anfrageprodukte").requery();
            if (anonym) {
                JOptionPane.showMessageDialog(this, "Es wurde ein anonymer Kunde mit der Kundennummer " + this.kunde.getAsString("kundennr") + " angelegt", "Anonymer Kunde", 1);
            }
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void mniPasswortActionPerformed(ActionEvent evt) {
        DlgEigenesPasswort dlgPasswort = new DlgEigenesPasswort((Frame)this, this.session);
        dlgPasswort.setVisible(true);
    }

    private void mniTimeoutActionPerformed(ActionEvent evt) {
        String timeout0 = this.session.getConfigFile().findValue("TIMEOUT");
        String timeout = JOptionPane.showInputDialog(this, "Setzen Sie hier die Zeit (in Minuten), nach der eine Neuanmeldung erforderlich wird.\nBenutzen Sie diese Funktion um das Risiko unberechtigter Zugriffe zu minimieren.", timeout0);
        if (timeout == null) {
            return;
        }
        if (timeout.equals(timeout0)) {
            return;
        }
        try {
            int intTimeout = timeout.length() == 0 ? 0 : Integer.parseInt(timeout);
            ((YPopometerDatabase)this.session.getDatabase()).setTimeout(intTimeout * 60);
            this.session.getConfigFile().setEntry("TIMEOUT", timeout);
            if (intTimeout == 0) {
                JOptionPane.showMessageDialog(this, "Das Timeout wurde ausgeschaltet.");
            } else {
                JOptionPane.showMessageDialog(this, "Das Timeout wurde neu gesetzt.");
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Ung\u00fcltige Zahl: " + timeout, "Fehler", 0);
        }
    }

    private void mniClearCacheActionPerformed(ActionEvent evt) {
        int a = JOptionPane.showConfirmDialog(this, "Nach dem L\u00f6schen werden die Bilder erneut vom Server geholt.\nBenutzen Sie diese Funktion, wenn Bilder nicht oder z.T. verst\u00fcmmelt dargestellt werden.", "Hinweis", 2, 1);
        if (a == 2) {
            return;
        }
        try {
            YQLBilder bilder = this.session.getBilder();
            YConfigFile configFile = this.session.getConfigFile();
            String cacheDir = configFile.findValue("CACHEDIR");
            if (!cacheDir.endsWith("/")) {
                cacheDir = cacheDir + "/";
            }
            String imageDir = cacheDir + "images";
            String thumbDir = imageDir + "/thumbs";
            int nDeleted = 0;
            for (int iRow = 0; iRow < bilder.getRowCount(); ++iRow) {
                bilder.setAsBool(iRow, "aktuell", false);
                bilder.setAsBool(iRow, "aktuell_thumb", false);
                String imageName = bilder.getAsString(iRow, "name") + ".jpg";
                File imageFile = new File(imageDir, imageName);
                if (imageFile.delete()) {
                    ++nDeleted;
                }
                if (!(imageFile = new File(thumbDir, imageName)).delete()) continue;
                ++nDeleted;
            }
            JOptionPane.showMessageDialog(this, nDeleted + " Dateien wurden gel\u00f6scht.");
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdNeuerKundeActionPerformed(ActionEvent evt) {
        try {
            int a;
            if (this.kunde.hasChanged() && (a = JOptionPane.showConfirmDialog(this, "Die \u00c4nderungen f\u00fcr " + this.kunde.toString() + " gehen verloren.", "Warnung", 2, 2)) == 2) {
                return;
            }
            this.kunde.clear();
            this.disableProdukte();
            this.panKundendaten.clearKundenlisteSelection();
            this.panMain.setSelectedComponent(this.panKundendaten);
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private class ProdartEinsbereiche {
        private YRLSuchproduktarten rlSuchproduktarten;
        private YSRLEinsbereichprodart srlEinsbereichprodart;
        int nProduktarten;
        int nEinsatzbereiche;
        private PEWert[][] peWerte;
        private int[] prodartIDs;
        private int[] einsbereichIDs;

        public ProdartEinsbereiche() throws YException {
            int iPart;
            int iEinsb;
            this.rlSuchproduktarten = (YRLSuchproduktarten)FrmNavigator.this.session.getRowObjectList("suchproduktarten");
            this.srlEinsbereichprodart = (YSRLEinsbereichprodart)this.rlSuchproduktarten.getSubRowList("einsbereichprodart");
            this.nEinsatzbereiche = FrmNavigator.this.rlEinsatzbereiche.getRowCount();
            this.einsbereichIDs = new int[this.nEinsatzbereiche];
            for (iEinsb = 0; iEinsb < this.nEinsatzbereiche; ++iEinsb) {
                this.einsbereichIDs[iEinsb] = FrmNavigator.this.rlEinsatzbereiche.getAsInt(iEinsb, "einsbereich_id");
            }
            this.nProduktarten = this.rlSuchproduktarten.getRowCount();
            this.prodartIDs = new int[this.nProduktarten];
            for (iPart = 0; iPart < this.nProduktarten; ++iPart) {
                this.prodartIDs[iPart] = this.rlSuchproduktarten.getAsInt(iPart, "prodart_id");
            }
            this.peWerte = new PEWert[this.nProduktarten][this.nEinsatzbereiche];
            for (iPart = 0; iPart < this.nProduktarten; ++iPart) {
                this.rlSuchproduktarten.setActiveRow(iPart);
                for (iEinsb = 0; iEinsb < this.nEinsatzbereiche; ++iEinsb) {
                    int iRow;
                    int einsbereichId = this.einsbereichIDs[iEinsb];
                    for (iRow = 0; iRow < this.srlEinsbereichprodart.getRowCount(); ++iRow) {
                        if (einsbereichId != this.srlEinsbereichprodart.getAsInt(iRow, "einsbereich_id")) continue;
                        this.peWerte[iPart][iEinsb] = new PEWert(true);
                        break;
                    }
                    if (iRow < this.srlEinsbereichprodart.getRowCount()) continue;
                    this.peWerte[iPart][iEinsb] = new PEWert(false);
                }
            }
        }

        private int findIEinsbereich(int einsbereichId) throws YProgramException {
            for (int iEinsb = 0; iEinsb < this.nEinsatzbereiche; ++iEinsb) {
                if (einsbereichId != this.einsbereichIDs[iEinsb]) continue;
                return iEinsb;
            }
            throw new YProgramException((Object)this, "Unbekannte einsbedingung_id: " + einsbereichId);
        }

        private int findIProdart(int prodartId) throws YProgramException, YException {
            for (int iProdart = 0; iProdart < this.nProduktarten; ++iProdart) {
                if (prodartId != this.rlSuchproduktarten.getAsInt(iProdart, "prodart_id")) continue;
                return iProdart;
            }
            throw new YProgramException((Object)this, "Unbekannte prodart_id: " + prodartId);
        }

        public boolean isRelevant(int prodartId, int einsbereichId) throws YException {
            int iProdart = this.findIProdart(prodartId);
            int iEinsbereich = this.findIEinsbereich(einsbereichId);
            return this.peWerte[iProdart][iEinsbereich].relevant;
        }

        public void setzeEinsatzbereich(int einsbereichId, boolean gesetzt) throws YException {
            int iEinsbed = this.findIEinsbereich(einsbereichId);
            for (int iProdart = 0; iProdart < this.nProduktarten; ++iProdart) {
                this.peWerte[iProdart][iEinsbed].gesetzt = gesetzt && this.peWerte[iProdart][iEinsbed].relevant;
            }
        }

        public boolean produktartKomplett(int prodartId) throws YException {
            int iProdart = this.findIProdart(prodartId);
            for (int iEinsb = 0; iEinsb < this.nEinsatzbereiche; ++iEinsb) {
                if (this.peWerte[iProdart][iEinsb].gesetzt == this.peWerte[iProdart][iEinsb].relevant) continue;
                return false;
            }
            return true;
        }

        private class PEWert {
            public boolean relevant;
            public boolean gesetzt;

            public PEWert(boolean relevant) {
                this.relevant = relevant;
                this.gesetzt = false;
            }
        }
    }
}

