/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import projektY.base.YException;
import projektY.database.YDatabaseList;
import projektY.database.YLookUpColumnDefinition;
import projektY.database.YLookUpFieldValue;
import projektY.database.YRowValues;

public class YLookUpDBColumnDefinition
extends YLookUpColumnDefinition {
    YDatabaseList lookUpList;
    int valueFieldValueIndex;
    String valueFieldName;
    String altFieldName;

    public YLookUpDBColumnDefinition(int fieldValueIndex, String name, YDatabaseList lookUpList, String valueFieldName, String altFieldName) throws YException {
        super(fieldValueIndex, name, lookUpList.getColumnDefinition(valueFieldName).getFieldType());
        this.lookUpList = lookUpList;
        this.valueFieldName = valueFieldName;
        this.valueFieldValueIndex = lookUpList.getFieldValueIndex(valueFieldName);
        this.altFieldName = altFieldName;
    }

    public YLookUpDBColumnDefinition(int fieldValueIndex, String name, YDatabaseList lookUpList, String valueFieldName) throws YException {
        this(fieldValueIndex, name, lookUpList, valueFieldName, null);
    }

    public YDatabaseList getLookUpList() {
        return this.lookUpList;
    }

    public String getValueFieldName() {
        return this.valueFieldName;
    }

    public String getAltFieldName() {
        return this.altFieldName;
    }

    public void modifyLookUpValue(YLookUpFieldValue fieldValue, String lookUpValue) {
        try {
            fieldValue.iLookUpRow = 0;
            while (fieldValue.iLookUpRow < this.lookUpList.getRowCount()) {
                if (this.lookUpList.getRowValues(fieldValue.iLookUpRow).toString().equals(lookUpValue)) {
                    fieldValue.modifyValue(this.lookUpList.getRowValues(fieldValue.iLookUpRow).getFieldValue(this.valueFieldValueIndex).toString());
                    return;
                }
                ++fieldValue.iLookUpRow;
            }
            fieldValue.modifyValue("");
            fieldValue.iLookUpRow = -1;
        }
        catch (YException e) {
            fieldValue.iLookUpRow = -1;
        }
    }

    public String lookUpValue(YLookUpFieldValue fieldValue) {
        try {
            if (fieldValue.iLookUpRow < this.lookUpList.getRowCount()) {
                YRowValues rowValues;
                if (fieldValue.iLookUpRow >= 0 && (rowValues = this.lookUpList.getRowValues(fieldValue.iLookUpRow)).getAsString(this.valueFieldValueIndex).equals(fieldValue.getValue())) {
                    return rowValues.toString();
                }
                fieldValue.iLookUpRow = this.lookUpList.find(fieldValue.getValue(), this.valueFieldName);
                if (fieldValue.iLookUpRow >= 0) {
                    return this.lookUpList.getRowValues(fieldValue.iLookUpRow).toString();
                }
            }
            return "";
        }
        catch (YException e) {
            return "";
        }
    }
}

