/*
 * Decompiled with CFR 0.152.
 */
package projektY.latex;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.base.YUserException;
import projektY.latex.YLaTeXGenerator;

public class YLaTeXParser {
    private LineNumberReader in;
    private PrintStream out;
    private Vector<YLaTeXItem> items = new Vector(50, 20);

    public YLaTeXParser(InputStream vorlage) throws YException {
        this.compile(vorlage);
    }

    private void compile(InputStream vorlage) throws YException {
        this.in = new LineNumberReader(new InputStreamReader(vorlage));
        Pattern patTag = Pattern.compile("%%%/?Y[A-Z]+/?.*?%%%");
        Pattern patAttribut = Pattern.compile("[a-z]+=([^\" ]+|\"[^\"]*\")");
        Stack<YLaTeXTag> latexTags = new Stack<YLaTeXTag>();
        try {
            this.items.clear();
            StringBuffer latexText = new StringBuffer(2000);
            int sampleLevel = 0;
            int iLine = 1;
            while (true) {
                String line;
                if ((line = this.in.readLine()) == null) {
                    if (latexText.length() > 0) {
                        this.items.add(new YLaTeXText(latexText.toString()));
                    }
                    return;
                }
                Matcher matcherTag = patTag.matcher(line);
                if (matcherTag.find()) {
                    boolean isStartTag;
                    String tagAttribute;
                    String tagName;
                    if (latexText.length() > 0) {
                        this.items.add(new YLaTeXText(latexText.toString()));
                        latexText.setLength(0);
                    }
                    String tag = line.substring(matcherTag.start() + 3, matcherTag.end() - 3);
                    tag = tag.replaceAll(" *= *", "=");
                    int iPosLine = (tag = tag.replaceFirst(" *$", "")).indexOf(32);
                    if (iPosLine > 0) {
                        tagName = tag.substring(0, iPosLine);
                        tagAttribute = tag.substring(iPosLine + 1);
                    } else {
                        tagName = tag;
                        tagAttribute = "";
                    }
                    boolean isEndTag = tagName.startsWith("/");
                    boolean bl = isStartTag = !isEndTag;
                    if (isStartTag) {
                        isEndTag = tagName.endsWith("/");
                        if (isEndTag) {
                            tagName = tagName.substring(0, tagName.length() - 1);
                        }
                    } else {
                        tagName = tagName.substring(1);
                    }
                    YLaTeXTagAttributes attributes = new YLaTeXTagAttributes();
                    Matcher matcherAttribut = patAttribut.matcher(tagAttribute);
                    int startScanAttriute = 0;
                    while (startScanAttriute < tagAttribute.length() && matcherAttribut.find(startScanAttriute)) {
                        startScanAttriute = matcherAttribut.end() + 1;
                        String[] attribWert = tagAttribute.substring(matcherAttribut.start(), matcherAttribut.end()).split("=");
                        if (attribWert.length > 2) {
                            for (int i = 2; i < attribWert.length; ++i) {
                                attribWert[1] = attribWert[1] + "=" + attribWert[i];
                            }
                        }
                        attributes.add(new YLaTeXTagAttibute(attribWert[0], attribWert[1]));
                    }
                    YLaTeXTag latexTag = new YLaTeXTag(tagName, isStartTag, isEndTag, this.items.size(), attributes, iLine);
                    boolean isStandardTag = false;
                    if (tagName.equals("YYY") || tagName.equals("YTABLE") || tagName.equals("YTH") || tagName.equals("YTR") || tagName.equals("YOPTION") || tagName.equals("YLOOP")) {
                        if (isStartTag && isEndTag) {
                            throw new YException(this.in.getLineNumber() + ": " + tagName + " kann nicht gleichzeitig Start und Ende sein.");
                        }
                        isStandardTag = true;
                    }
                    if (tagName.equals("YTEXT") || tagName.equals("YTD")) {
                        if (!isStartTag || !isEndTag) {
                            throw new YException(this.in.getLineNumber() + ": " + tagName + " mu\u00df gleichzeitig Start und Ende sein.");
                        }
                        isStandardTag = true;
                    }
                    if (!(isStandardTag || isStartTag && isEndTag)) {
                        throw new YException(this.in.getLineNumber() + ": " + "Nicht-Standard-Tag " + tagName + " mu\u00df gleichzeitig Start und Ende sein.");
                    }
                    if (latexTag.isStartTag() && !latexTag.isEndTag()) {
                        latexTags.push(latexTag);
                    } else if (latexTag.isEndTag() && !latexTag.isStartTag()) {
                        if (latexTags.isEmpty()) {
                            throw new YException(this.in.getLineNumber() + ": Starttag zu " + latexTag.getName() + "/ fehlt.");
                        }
                        YLaTeXTag startTag = (YLaTeXTag)latexTags.pop();
                        if (!startTag.getName().equals(latexTag.getName())) {
                            throw new YException(this.in.getLineNumber() + ": Verschachtelungsfehler: " + latexTag.getName() + "/ pa\u00dft nicht zu " + startTag.getName());
                        }
                        latexTag.setStartItemIndex(startTag.getItemIndex());
                        startTag.setEndItemIndex(latexTag.getItemIndex());
                    }
                    if (isStartTag && tagName.equals("YYY")) {
                        ++sampleLevel;
                    }
                    if (sampleLevel == 0) {
                        this.items.add(latexTag);
                    }
                    if (isEndTag && tagName.equals("YYY")) {
                        --sampleLevel;
                    }
                    latexText.append("%\n");
                } else if (sampleLevel == 0) {
                    latexText.append(line);
                    latexText.append('\n');
                }
                ++iLine;
            }
        }
        catch (IOException e) {
            throw new YException("I/O-Fehler: " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(YLaTeXGenerator generator) throws YException {
        try {
            this.out = new PrintStream(generator.getOutputStream());
            for (int iItem = 0; iItem < this.items.size(); ++iItem) {
                YLaTeXTag tag;
                YLaTeXItem item = this.items.get(iItem);
                if (item.isLaTeXText()) {
                    YLaTeXText text = (YLaTeXText)item;
                    this.out.write(text.getText().getBytes(), 0, text.getText().getBytes().length);
                    continue;
                }
                generator.runTag = tag = (YLaTeXTag)item;
                String tagName = tag.getName();
                YLaTeXTagAttributes attributes = tag.getAttributes();
                if (tagName.equals("YTEXT")) {
                    generator.insertText(attributes);
                    continue;
                }
                if (tagName.equals("YTABLE")) {
                    if (tag.isStartTag()) {
                        if (generator.startTable(attributes)) continue;
                        iItem = tag.getEndItemIndex();
                        continue;
                    }
                    if (!tag.isEndTag()) continue;
                    generator.endTable();
                    continue;
                }
                if (tagName.equals("YTH")) {
                    if (tag.isStartTag()) {
                        if (generator.startTH(attributes)) continue;
                        iItem = tag.getEndItemIndex();
                        continue;
                    }
                    if (!tag.isEndTag) continue;
                    generator.endTH();
                    continue;
                }
                if (tagName.equals("YTR")) {
                    if (tag.isStartTag()) {
                        if (generator.nextRow(attributes)) continue;
                        iItem = tag.getEndItemIndex();
                        continue;
                    }
                    if (!tag.isEndTag()) continue;
                    iItem = tag.getStartItemIndex() - 1;
                    continue;
                }
                if (tagName.equals("YTD")) {
                    generator.insertTD(attributes);
                    continue;
                }
                if (tagName.equals("YOPTION")) {
                    if (generator.checkOption(attributes)) continue;
                    iItem = tag.getEndItemIndex();
                    continue;
                }
                if (tagName.equals("YLOOP")) {
                    if (tag.isStartTag()) {
                        if (generator.nextLoop(attributes)) continue;
                        iItem = tag.getEndItemIndex();
                        continue;
                    }
                    if (!tag.isEndTag()) continue;
                    iItem = tag.getStartItemIndex() - 1;
                    continue;
                }
                generator.handleTag(tag);
            }
        }
        finally {
            generator.runTag = null;
        }
    }

    class YLaTeXText
    extends YLaTeXItem {
        private String text;

        private YLaTeXText(String text) throws YException {
            this.text = text;
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) <= '\u007f') continue;
                throw new YUserException("Ung\u00fcltiges LaTeX-Zeichen '" + text.charAt(i) + "' in der LaTeX-Vorlage.");
            }
        }

        final boolean isLaTeXTag() {
            return false;
        }

        final boolean isLaTeXText() {
            return true;
        }

        private String getText() {
            return this.text;
        }
    }

    public class YLaTeXTag
    extends YLaTeXItem {
        private String name;
        private boolean isStartTag;
        private boolean isEndTag;
        private int itemIndex;
        private int startItemIndex;
        private int endItemIndex;
        private YLaTeXTagAttributes attributes;
        private int iLine;

        private YLaTeXTag(String name, boolean isStartTag, boolean isEndTag, int itemIndex, YLaTeXTagAttributes attributes, int iLine) throws YProgramException {
            this.name = name;
            this.isStartTag = isStartTag;
            this.isEndTag = isEndTag;
            if (!isStartTag && !isEndTag) {
                throw new YProgramException(this, "YLaTeXTag ist weder Start- noch Endtag.");
            }
            this.itemIndex = itemIndex;
            this.startItemIndex = -1;
            this.endItemIndex = -1;
            this.attributes = attributes;
            this.iLine = iLine;
        }

        final boolean isLaTeXTag() {
            return true;
        }

        final boolean isLaTeXText() {
            return false;
        }

        public final String getName() {
            return this.name;
        }

        public final boolean isStartTag() {
            return this.isStartTag;
        }

        public final boolean isEndTag() {
            return this.isEndTag;
        }

        private int getItemIndex() {
            return this.itemIndex;
        }

        private void setStartItemIndex(int startItemIndex) throws YProgramException {
            if (this.isStartTag) {
                throw new YProgramException(this, "Ein Starttag kann keinen Index f\u00fcr ein zugeh\u00f6riges Starttag haben.");
            }
            if (!this.isEndTag) {
                throw new YProgramException(this, "Nur ein Endtag kann einen Index f\u00fcr ein zugeh\u00f6riges Starttag haben.");
            }
            this.startItemIndex = startItemIndex;
        }

        private int getStartItemIndex() throws YProgramException {
            if (this.startItemIndex == -1) {
                throw new YProgramException(this, "Abruf eines nicht definierten startItemIndex");
            }
            return this.startItemIndex;
        }

        private void setEndItemIndex(int endItemIndex) throws YProgramException {
            if (this.isEndTag) {
                throw new YProgramException(this, "Ein Endtag kann keinen Index f\u00fcr ein zugeh\u00f6riges Endtag haben.");
            }
            if (!this.isStartTag) {
                throw new YProgramException(this, "Nur ein Starttag kann einen Index f\u00fcr ein zugeh\u00f6riges Endtag haben.");
            }
            this.endItemIndex = endItemIndex;
        }

        private int getEndItemIndex() throws YProgramException {
            if (this.endItemIndex == -1) {
                throw new YProgramException(this, YLaTeXParser.this.in.getLineNumber() + ": Abruf eines nicht definierten endItemIndex");
            }
            return this.endItemIndex;
        }

        public final YLaTeXTagAttributes getAttributes() {
            return this.attributes;
        }

        public final int getILine() {
            return this.iLine;
        }

        public final String getAttributeValue(String name) throws YException {
            String attribute = this.attributes.getAttributeValue(name);
            if (attribute == null) {
                throw new YException("Zeile " + this.iLine + ", " + this.name + ": Fehlendes Attribut '" + name + "'.");
            }
            return attribute;
        }
    }

    public class YLaTeXTagAttributes {
        private Vector<YLaTeXTagAttibute> attributes = new Vector(10);

        private YLaTeXTagAttributes() {
        }

        private void add(YLaTeXTagAttibute attribute) {
            this.attributes.add(attribute);
        }

        public final int getCount() {
            return this.attributes.size();
        }

        public final String getAttributeValue(String name) {
            for (int iAttr = 0; iAttr < this.attributes.size(); ++iAttr) {
                if (!this.attributes.get(iAttr).getName().equals(name)) continue;
                return this.attributes.get(iAttr).getValue();
            }
            return null;
        }
    }

    public class YLaTeXTagAttibute {
        private String name;
        private String value;

        private YLaTeXTagAttibute(String name, String value) {
            this.name = name;
            this.value = value.length() >= 2 && value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value;
        }

        public final String getName() {
            return this.name;
        }

        public final String getValue() {
            return this.value;
        }
    }

    public abstract class YLaTeXItem {
        abstract boolean isLaTeXTag();

        abstract boolean isLaTeXText();
    }
}

