/*
 * Decompiled with CFR 0.152.
 */
package projektY.swing;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDBOChangeEventListener;
import projektY.database.YDBORowRequestListener;
import projektY.database.YDatabaseObject;
import projektY.database.YDetailList;
import projektY.database.YFieldValue;
import projektY.database.YLookUpColumnDefinition;
import projektY.database.YLookUpDBColumnDefinition;
import projektY.database.YLookUpDomainColumnDefinition;
import projektY.database.YRowDefinition;
import projektY.database.YRowObject;
import projektY.database.YRowValues;
import projektY.swing.YComboBoxModel;
import projektY.swing.YJTableManager;

public class YJPanelManager
implements YDBOChangeEventListener,
YDBORowRequestListener {
    private JPanel panel;
    private YDatabaseObject databaseObject;
    private YRowDefinition rowDefinition;
    private YRowValues rowValues;
    private int iLastRow;

    private void initComp(Component comp, YDatabaseObject databaseObject) throws YException {
        String compName = comp.getName();
        if (compName == null) {
            if (!(comp instanceof JLabel)) {
                return;
            }
            JLabel label = (JLabel)comp;
            Component labeling = ((JLabel)comp).getLabelFor();
            if (labeling == null) {
                return;
            }
            String labeledName = labeling.getName();
            if (labeledName == null) {
                return;
            }
            if (!(labeling instanceof JTable)) {
                if (!(databaseObject instanceof YRowObject)) {
                    return;
                }
                label.setText(databaseObject.getColumnLabel(labeledName) + ":");
            }
            return;
        }
        if (comp instanceof JTable) {
            if (!(databaseObject instanceof YRowObject)) {
                throw new YProgramException(this, "Das Datenbankobjekt " + databaseObject.getName() + " ist kein Zeilenobjekt und kann deshalb " + compName + " nicht als Detailliste enthalten.");
            }
            YRowObject rowObject = (YRowObject)databaseObject;
            YDetailList detailList = rowObject.getDetailList(compName);
            YJTableManager.createTableManager((JTable)comp, detailList);
            return;
        }
        YColumnDefinition columnDefinition = databaseObject.getColumnDefinition(compName);
        YColumnDefinition rootColumnDefinition = columnDefinition.getRootDefinition();
        if (comp instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)comp;
            if (comp instanceof JTextField) {
                JTextField textField = (JTextField)comp;
                if (rootColumnDefinition.isANum()) {
                    textField.setHorizontalAlignment(4);
                }
            }
            if (columnDefinition.isReadOnly()) {
                textComponent.setEditable(false);
            }
        } else if (comp instanceof JComboBox) {
            if (rootColumnDefinition.isLookUp()) {
                YLookUpColumnDefinition lookUpColumnDefinition = (YLookUpColumnDefinition)rootColumnDefinition;
                JComboBox comboBox = (JComboBox)comp;
                if (lookUpColumnDefinition instanceof YLookUpDBColumnDefinition) {
                    YLookUpDBColumnDefinition lookUpDBColumnDefinition = (YLookUpDBColumnDefinition)lookUpColumnDefinition;
                    comboBox.setModel(new YComboBoxModel(lookUpDBColumnDefinition.getLookUpList(), false));
                } else if (lookUpColumnDefinition instanceof YLookUpDomainColumnDefinition) {
                    YLookUpDomainColumnDefinition lookUpDomainColumnDefinition = (YLookUpDomainColumnDefinition)rootColumnDefinition;
                    comboBox.setModel(new YComboBoxModel(lookUpDomainColumnDefinition.getLookUpDomain(), false));
                }
            }
        } else if (comp instanceof JCheckBox) {
            JCheckBox checkBox = (JCheckBox)comp;
            checkBox.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    JCheckBox checkBox = (JCheckBox)evt.getComponent();
                    if (!checkBox.isEnabled()) {
                        checkBox.setEnabled(YJPanelManager.this.rowValues != null);
                    }
                }
            });
        } else if (comp instanceof JLabel) {
            JLabel label = (JLabel)comp;
            label.setText(rootColumnDefinition.getLabel());
        }
    }

    private boolean initContainer(Component container, YDatabaseObject databaseObject) throws YException {
        if (container instanceof JPanel) {
            JPanel panel = (JPanel)container;
            int nComps = panel.getComponentCount();
            for (int iComp = 0; iComp < nComps; ++iComp) {
                Component comp = panel.getComponent(iComp);
                if (this.initContainer(comp, databaseObject)) continue;
                this.initComp(comp, databaseObject);
            }
        } else if (container instanceof JSplitPane) {
            JSplitPane splitPane = (JSplitPane)container;
            Component comp = splitPane.getTopComponent();
            if (!this.initContainer(comp, databaseObject)) {
                this.initComp(comp, databaseObject);
            }
            if (!this.initContainer(comp = splitPane.getBottomComponent(), databaseObject)) {
                this.initComp(comp, databaseObject);
            }
        } else if (container instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)container;
            int nComps = tabbedPane.getTabCount();
            for (int iComp = 0; iComp < nComps; ++iComp) {
                Component comp = tabbedPane.getComponentAt(iComp);
                if (this.initContainer(comp, databaseObject)) continue;
                this.initComp(comp, databaseObject);
            }
        } else if (container instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)container;
            Component comp = scrollPane.getViewport().getView();
            if (comp != null && !this.initContainer(comp, databaseObject)) {
                this.initComp(comp, databaseObject);
            }
        } else {
            return false;
        }
        return true;
    }

    protected YJPanelManager(JPanel panel, YDatabaseObject databaseObject, boolean active) throws YException {
        this.panel = panel;
        this.databaseObject = databaseObject;
        this.rowDefinition = databaseObject.getRowDefinition();
        this.initContainer(panel, databaseObject);
        this.rowValues = databaseObject instanceof YRowObject ? ((YRowObject)databaseObject).getRowValues() : null;
        if (active) {
            databaseObject.addChangeEventListener(this);
            databaseObject.addRowRequestListener(this);
        }
    }

    protected YJPanelManager(JPanel panel, YDatabaseObject databaseObject) throws YException {
        this(panel, databaseObject, true);
    }

    public static YJPanelManager createPanelManager(JPanel panel, YDatabaseObject databaseObject) throws YException {
        return new YJPanelManager(panel, databaseObject);
    }

    public static YJPanelManager createPassivePanelManager(JPanel panel, YDatabaseObject databaseObject) throws YException {
        return new YJPanelManager(panel, databaseObject, false);
    }

    private void rowValuesChangedComp(Component comp, YRowValues rowValues) throws YException {
        boolean isCheckBox = false;
        String compName = comp.getName();
        compName = comp.getName();
        if (compName == null) {
            return;
        }
        if (comp instanceof JTextComponent) {
            JTextComponent textComp = (JTextComponent)comp;
            if (rowValues == null) {
                textComp.setText("");
            } else {
                textComp.setText(rowValues.getAsString(compName));
            }
        } else if (comp instanceof JLabel) {
            JLabel label = (JLabel)comp;
            if (rowValues == null) {
                label.setText("");
            } else {
                YFieldValue fieldValue = rowValues.getFieldValue(compName);
                YColumnDefinition columnDefinition = fieldValue.getColumnDefinition();
                if (columnDefinition instanceof YLookUpColumnDefinition) {
                    if (columnDefinition instanceof YLookUpDomainColumnDefinition) {
                        YLookUpDomainColumnDefinition lookUpDomainColumnDefinition = (YLookUpDomainColumnDefinition)columnDefinition;
                        label.setText(lookUpDomainColumnDefinition.getLookUpDomain().lookUp(fieldValue.getValue()));
                    } else {
                        label.setText(rowValues.getAsString(compName));
                    }
                } else {
                    label.setText(rowValues.getAsString(compName));
                }
            }
        } else if (comp instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)comp;
            YColumnDefinition columnDefinition = this.rowDefinition.getColumnDefinition(compName).getRootDefinition();
            if (columnDefinition.isLookUp()) {
                YLookUpColumnDefinition lookUpColumnDefinition = (YLookUpColumnDefinition)columnDefinition;
                if (lookUpColumnDefinition instanceof YLookUpDBColumnDefinition) {
                    YLookUpDBColumnDefinition lookUpDBColumnDefinition = (YLookUpDBColumnDefinition)lookUpColumnDefinition;
                    if (rowValues == null) {
                        comboBox.setSelectedItem(null);
                    } else {
                        comboBox.setSelectedItem(lookUpDBColumnDefinition.getLookUpList().findRow(rowValues.getAsString(compName), lookUpDBColumnDefinition.getValueFieldName()));
                    }
                } else if (lookUpColumnDefinition instanceof YLookUpDomainColumnDefinition) {
                    YLookUpDomainColumnDefinition lookUpDomainColumnDefinition = (YLookUpDomainColumnDefinition)lookUpColumnDefinition;
                    if (rowValues == null) {
                        comboBox.setSelectedItem(null);
                    } else {
                        comboBox.setSelectedItem(lookUpDomainColumnDefinition.getLookUpDomain().lookUpObject(rowValues.getAsString(compName)));
                    }
                }
            }
        } else if (comp instanceof JCheckBox) {
            JCheckBox checkBox = (JCheckBox)comp;
            isCheckBox = true;
            if (rowValues == null) {
                checkBox.setSelected(false);
                checkBox.setEnabled(false);
            } else {
                YFieldValue fieldValue = rowValues.getFieldValue(compName);
                checkBox.setSelected(fieldValue.getValueAsBool(false));
                checkBox.setEnabled(!fieldValue.isNull());
            }
        }
        if (!isCheckBox) {
            comp.setEnabled(rowValues != null);
        }
    }

    private boolean rowValuesChangedContainer(Component container, YRowValues rowValues) throws YException {
        if (container instanceof JPanel) {
            JPanel panel = (JPanel)container;
            int nComps = panel.getComponentCount();
            for (int iComp = 0; iComp < nComps; ++iComp) {
                Component comp = panel.getComponent(iComp);
                if (this.rowValuesChangedContainer(comp, rowValues)) continue;
                this.rowValuesChangedComp(comp, rowValues);
            }
        } else if (container instanceof JSplitPane) {
            JSplitPane splitPane = (JSplitPane)container;
            Component comp = splitPane.getTopComponent();
            if (!this.rowValuesChangedContainer(comp, rowValues)) {
                this.rowValuesChangedComp(comp, rowValues);
            }
            if (!this.rowValuesChangedContainer(comp = splitPane.getBottomComponent(), rowValues)) {
                this.rowValuesChangedComp(comp, rowValues);
            }
        } else if (container instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)container;
            int nComps = tabbedPane.getTabCount();
            for (int iComp = 0; iComp < nComps; ++iComp) {
                Component comp = tabbedPane.getComponentAt(iComp);
                if (this.rowValuesChangedContainer(comp, rowValues)) continue;
                this.rowValuesChangedComp(comp, rowValues);
            }
        } else if (container instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)container;
            Component comp = scrollPane.getViewport().getView();
            if (comp != null && !this.rowValuesChangedContainer(comp, rowValues)) {
                this.rowValuesChangedComp(comp, rowValues);
            }
        } else {
            return false;
        }
        return true;
    }

    private void rowValuesChanged(int iRow, YRowValues rowValues) throws YException {
        this.rowValuesChangedContainer(this.panel, rowValues);
        this.rowValues = rowValues;
        this.iLastRow = rowValues == null ? -1 : iRow;
    }

    private void requestRowValuesComp(Component comp, YRowValues rowValues) throws YException {
        String compName = comp.getName();
        if (compName == null) {
            return;
        }
        if (comp instanceof JPasswordField) {
            JPasswordField passwordField = (JPasswordField)comp;
            YFieldValue fieldValue = rowValues.getFieldValue(compName);
            if (!fieldValue.getColumnDefinition().isReadOnly()) {
                this.databaseObject.getSession().modifyPasswdField(fieldValue, passwordField.getPassword());
            }
        } else if (comp instanceof JTextComponent) {
            JTextComponent textComp = (JTextComponent)comp;
            YFieldValue fieldValue = rowValues.getFieldValue(compName);
            if (!fieldValue.getColumnDefinition().isReadOnly()) {
                fieldValue.modifyValue(textComp.getText());
            }
        } else if (comp instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)comp;
            YColumnDefinition columnDefinition = this.rowDefinition.getColumnDefinition(compName).getRootDefinition();
            if (columnDefinition.isLookUp()) {
                YLookUpColumnDefinition lookUpColumnDefinition = (YLookUpColumnDefinition)columnDefinition;
                String lookUpColumnClass = lookUpColumnDefinition.getClass().getName();
                Object selectedItem = comboBox.getSelectedItem();
                if (lookUpColumnClass.endsWith("YLookUpDBColumnDefinition")) {
                    YLookUpDBColumnDefinition lookUpDBColumnDefinition = (YLookUpDBColumnDefinition)lookUpColumnDefinition;
                    rowValues.setFromRow(compName, selectedItem, lookUpDBColumnDefinition.getValueFieldName());
                } else if (lookUpColumnClass.endsWith("YLookUpDomainColumnDefinition")) {
                    rowValues.setFromLookUpValue(compName, selectedItem);
                }
            }
        } else if (comp instanceof JCheckBox) {
            JCheckBox checkBox = (JCheckBox)comp;
            if (checkBox.isEnabled()) {
                rowValues.setAsBool(compName, checkBox.isSelected());
            } else {
                rowValues.getFieldValue(compName).modifyToNull();
            }
        }
    }

    private boolean requestRowValuesContainer(Component container, YRowValues rowValues) throws YException {
        if (container instanceof JPanel) {
            JPanel panel = (JPanel)container;
            int nComps = panel.getComponentCount();
            for (int iComp = 0; iComp < nComps; ++iComp) {
                Component comp = panel.getComponent(iComp);
                if (this.requestRowValuesContainer(comp, rowValues)) continue;
                this.requestRowValuesComp(comp, rowValues);
            }
        } else if (container instanceof JSplitPane) {
            JSplitPane splitPane = (JSplitPane)container;
            Component comp = splitPane.getTopComponent();
            if (!this.requestRowValuesContainer(comp, rowValues)) {
                this.requestRowValuesComp(comp, rowValues);
            }
            if (!this.requestRowValuesContainer(comp = splitPane.getBottomComponent(), rowValues)) {
                this.requestRowValuesComp(comp, rowValues);
            }
        } else if (container instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)container;
            int nComps = tabbedPane.getTabCount();
            for (int iComp = 0; iComp < nComps; ++iComp) {
                Component comp = tabbedPane.getComponentAt(iComp);
                if (this.requestRowValuesContainer(comp, rowValues)) continue;
                this.requestRowValuesComp(comp, rowValues);
            }
        } else if (container instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)container;
            Component comp = scrollPane.getViewport().getView();
            if (comp != null && !this.requestRowValuesContainer(comp, rowValues)) {
                this.requestRowValuesComp(comp, rowValues);
            }
        } else {
            return false;
        }
        return true;
    }

    public void requestRowValues(YRowValues rowValues) throws YException {
        this.requestRowValuesContainer(this.panel, rowValues);
    }

    public void storeFields() throws YException {
        if (this.rowValues == null) {
            throw new YProgramException(this, "storeFields() vor erstem rowValuesChanged() aufgerufen");
        }
        this.requestRowValues(this.rowValues);
    }

    public void loadFields() throws YException {
        if (this.rowValues == null) {
            throw new YProgramException(this, "loadFields() vor erstem rowValuesChanged() aufgerufen");
        }
        this.rowValuesChanged(this.iLastRow, this.rowValues);
    }

    public void loadFields(Component comp) throws YException {
        if (this.rowValues == null) {
            throw new YProgramException(this, "loadFields() vor erstem rowValuesChanged() aufgerufen");
        }
        if (comp instanceof JPanel || comp instanceof JSplitPane || comp instanceof JTabbedPane || comp instanceof JScrollPane) {
            this.rowValuesChangedContainer(comp, this.rowValues);
        } else {
            this.rowValuesChangedComp(comp, this.rowValues);
        }
    }

    public YRowValues getRowValues() {
        return this.rowValues;
    }

    public void revert() throws YException {
        if (this.rowValues != null) {
            this.rowValues.revert();
            this.loadFields();
        }
    }

    public void modifyToNull() throws YException {
        if (this.rowValues != null) {
            this.rowValues.modifyToNull();
            this.loadFields();
        }
    }

    public void DBObjectChanged(YDBOChangeEvent evt) throws YException {
        if (evt.getType() == YDBOChangeEvent.ChangeEventType.DELETE) {
            this.rowValuesChanged(-1, null);
        } else {
            this.rowValuesChanged(evt.getIRow0(), evt.getRowValues());
        }
    }
}

