/*
 * Decompiled with CFR 0.152.
 */
package projektY.swing;

import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import projektY.base.YException;
import projektY.base.YLookUpDomain;
import projektY.database.YColumnDefinition;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDBOChangeEventListener;
import projektY.database.YDatabaseList;
import projektY.database.YLookUpColumnDefinition;
import projektY.database.YLookUpDBColumnDefinition;
import projektY.database.YLookUpDomainColumnDefinition;
import projektY.database.YRowValues;
import projektY.swing.YComboBoxModel;
import projektY.swing.YTableModel;

public class YJTableManager
implements YDBOChangeEventListener {
    private YDatabaseList databaseList;
    private JTable table;
    private YTableModel tableModel;
    private boolean settingSelection;
    Vector<ComboBoxDefinition> comboBoxDefinitions;

    protected YJTableManager(JTable table, YDatabaseList databaseList, boolean readOnly) throws YException {
        AlignRightCellRenderer alignRightCellRenderer = null;
        this.databaseList = databaseList;
        this.table = table;
        this.tableModel = new YTableModel(databaseList, readOnly);
        table.setModel(this.tableModel);
        this.comboBoxDefinitions = new Vector(20);
        for (int iCol = 0; iCol < databaseList.getDispColCount(); ++iCol) {
            YColumnDefinition columnDefinition = databaseList.getDispColumnDefinition(iCol);
            if (columnDefinition.isLookUp()) {
                YComboBoxModel comboBoxModel;
                if (columnDefinition.isDomain()) {
                    YLookUpDomain lookUpDomain = ((YLookUpDomainColumnDefinition)columnDefinition).getLookUpDomain();
                    comboBoxModel = new YComboBoxModel(lookUpDomain, columnDefinition.isNotNull());
                } else {
                    YDatabaseList lookUpList = ((YLookUpDBColumnDefinition)columnDefinition).getLookUpList();
                    comboBoxModel = new YComboBoxModel(lookUpList, columnDefinition.isNotNull());
                }
                JComboBox comboBox = new JComboBox(comboBoxModel);
                table.getColumnModel().getColumn(iCol).setCellEditor(new DefaultCellEditor(comboBox));
                this.comboBoxDefinitions.add(new ComboBoxDefinition(comboBox, columnDefinition));
                continue;
            }
            if (!columnDefinition.isANum()) continue;
            if (alignRightCellRenderer == null) {
                alignRightCellRenderer = new AlignRightCellRenderer();
            }
            table.getColumnModel().getColumn(iCol).setCellRenderer(alignRightCellRenderer);
        }
        this.settingSelection = false;
        table.getSelectionModel().setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(ListSelectionEvent evt) {
                try {
                    if (YJTableManager.this.settingSelection) {
                        return;
                    }
                    int iRow = YJTableManager.this.table.getSelectedRow();
                    YJTableManager.this.settingSelection = true;
                    YJTableManager.this.databaseList.setActiveRow(iRow);
                }
                catch (YException e) {
                    JOptionPane.showMessageDialog(null, e.toString(), "Fehler", 0);
                }
                finally {
                    YJTableManager.this.settingSelection = false;
                }
            }
        });
        databaseList.addChangeEventListener(this);
    }

    protected YJTableManager(JTable table, YDatabaseList databaseList) throws YException {
        this(table, databaseList, false);
    }

    public static YJTableManager createTableManager(JTable table, YDatabaseList databaseList, boolean readOnly) throws YException {
        return new YJTableManager(table, databaseList, readOnly);
    }

    public static YJTableManager createTableManager(JTable table, YDatabaseList databaseList) throws YException {
        return new YJTableManager(table, databaseList);
    }

    public YTableModel getTableModel() {
        return this.tableModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DBObjectChanged(YDBOChangeEvent evt) throws YException {
        try {
            if (evt.getType() == YDBOChangeEvent.ChangeEventType.ROWSELECTED || evt.getType() == YDBOChangeEvent.ChangeEventType.INSERT) {
                for (int iComboBox = 0; iComboBox < this.comboBoxDefinitions.size(); ++iComboBox) {
                    ComboBoxDefinition comboBoxDefinition = this.comboBoxDefinitions.get(iComboBox);
                    JComboBox comboBox = comboBoxDefinition.comboBox;
                    YLookUpColumnDefinition lookUpColumnDefinition = (YLookUpColumnDefinition)comboBoxDefinition.columnDefinition;
                    YRowValues rowValues = evt.getRowValues();
                    if (lookUpColumnDefinition instanceof YLookUpDBColumnDefinition) {
                        YLookUpDBColumnDefinition lookUpDBColumnDefinition = (YLookUpDBColumnDefinition)lookUpColumnDefinition;
                        if (rowValues == null) {
                            comboBox.setSelectedItem(null);
                            continue;
                        }
                        comboBox.setSelectedItem(lookUpDBColumnDefinition.getLookUpList().findRow(rowValues.getAsString(lookUpColumnDefinition.getFieldValueIndex()), lookUpDBColumnDefinition.getValueFieldName()));
                        continue;
                    }
                    if (!(lookUpColumnDefinition instanceof YLookUpDomainColumnDefinition)) continue;
                    YLookUpDomainColumnDefinition lookUpDomainColumnDefinition = (YLookUpDomainColumnDefinition)lookUpColumnDefinition;
                    if (rowValues == null) {
                        comboBox.setSelectedItem(null);
                        continue;
                    }
                    comboBox.setSelectedItem(lookUpDomainColumnDefinition.getLookUpDomain().lookUpObject(rowValues.getAsString(lookUpColumnDefinition.getFieldValueIndex())));
                }
                if (this.settingSelection) {
                    return;
                }
                this.settingSelection = true;
                int iRow = evt.getIRow0();
                this.table.getSelectionModel().setSelectionInterval(iRow, iRow);
            }
        }
        finally {
            this.settingSelection = false;
        }
    }

    public static class AlignRightCellRenderer
    extends DefaultTableCellRenderer {
        public AlignRightCellRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    private class ComboBoxDefinition {
        JComboBox comboBox;
        YColumnDefinition columnDefinition;

        ComboBoxDefinition(JComboBox comboBox, YColumnDefinition columnDefinition) {
            this.comboBox = comboBox;
            this.columnDefinition = columnDefinition;
        }
    }
}

