/*
 * Decompiled with CFR 0.152.
 */
package popometer.bikeandfit;

import popometer.bikeandfit.Koerpermasse;
import popometer.bikeandfit.Koerperpunkte;
import popometer.bikeandfit.MagischesDreieck;
import popometer.bikeandfit.Messpunkte;
import popometer.bikeandfit.Parameter;
import popometer.graphics.Koerperpunkt;
import popometer.graphics.Messpunkt;
import popometer.graphics.RectScaler;

public class Koerperberechnung {
    private float pixelProMeter;
    private final Parameter parameter;
    public RectScaler rectScaler;
    public Messpunkte messpunkte;
    public Koerperpunkte koerperpunkte;
    public MagischesDreieck magischesDreieck;
    private Koerpermasse koerpermasse;

    public Koerperberechnung(Parameter parameter) {
        this.parameter = parameter;
        this.rectScaler = new RectScaler();
        this.messpunkte = new Messpunkte(this.rectScaler);
        this.koerperpunkte = new Koerperpunkte(parameter, this.rectScaler);
        this.koerpermasse = new Koerpermasse();
        this.magischesDreieck = new MagischesDreieck(parameter);
        this.pixelProMeter = -1.0f;
    }

    public boolean kalibrieren() {
        Messpunkt calibStart = this.messpunkte.kalibrierung1;
        Messpunkt calibEnd = this.messpunkte.kalibrierung2;
        assert (calibStart != null && calibEnd != null);
        float dist = calibStart.distanceTo(calibEnd);
        this.pixelProMeter = dist * 100.0f / this.parameter.abstandSitzGriff;
        return true;
    }

    public void koerperpunkteAbleiten() {
        this.koerperpunkte.ableiten(this.messpunkte, this.pixelProMeter);
    }

    public Koerpermasse berechneKoerpermasse() {
        if (this.pixelProMeter < 0.0f) {
            this.koerpermasse.ua = 0.0f;
            this.koerpermasse.oa = 0.0f;
            this.koerpermasse.ok = 0.0f;
            this.koerpermasse.os = 0.0f;
            this.koerpermasse.usf = 0.0f;
        } else {
            float k = 100.0f / this.pixelProMeter;
            Koerperpunkt[] aKP = this.koerperpunkte.koerperpunkte;
            this.koerpermasse.ua = aKP[Koerperpunkte.NAMEN.HAND.getIndex()].distanceTo(aKP[Koerperpunkte.NAMEN.ARM.getIndex()]) * k;
            this.koerpermasse.oa = aKP[Koerperpunkte.NAMEN.ARM.getIndex()].distanceTo(aKP[Koerperpunkte.NAMEN.SCHULTER.getIndex()]) * k;
            this.koerpermasse.ok = aKP[Koerperpunkte.NAMEN.SCHULTER.getIndex()].distanceTo(aKP[Koerperpunkte.NAMEN.HUEFTE.getIndex()]) * k;
            this.koerpermasse.os = aKP[Koerperpunkte.NAMEN.HUEFTE.getIndex()].distanceTo(aKP[Koerperpunkte.NAMEN.KNIE.getIndex()]) * k;
            this.koerpermasse.usf = aKP[Koerperpunkte.NAMEN.KNIE.getIndex()].distanceTo(aKP[Koerperpunkte.NAMEN.FUSS.getIndex()]) * k;
        }
        return this.koerpermasse;
    }
}

