/*
 * Decompiled with CFR 0.152.
 */
package SQlabLookAndFeel;

import SQlabLookAndFeel.SQlabGraphicsUtils;
import SQlabLookAndFeel.SQlabScrollButton;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;

public class SQlabScrollBarUI
extends MetalScrollBarUI {
    private static final BufferedImage BACKGROUND_ENABLED = SQlabGraphicsUtils.loadImage("scroll_enabled.png");
    private static final BufferedImage BACKGROUND_DISABLED = SQlabGraphicsUtils.loadImage("scroll_disabled.png");
    private static final BufferedImage SCROLL_DEC_NORMAL = SQlabGraphicsUtils.loadImage("scroll_dec_normal.png");
    private static final BufferedImage SCROLL_DEC_OVER = SQlabGraphicsUtils.loadImage("scroll_dec_over.png");
    private static final BufferedImage SCROLL_DEC_PRESSED = SQlabGraphicsUtils.loadImage("scroll_dec_pressed.png");
    private static final BufferedImage SCROLL_INC_NORMAL = SQlabGraphicsUtils.loadImage("scroll_inc_normal.png");
    private static final BufferedImage SCROLL_INC_OVER = SQlabGraphicsUtils.loadImage("scroll_inc_over.png");
    private static final BufferedImage SCROLL_INC_PRESSED = SQlabGraphicsUtils.loadImage("scroll_inc_pressed.png");
    private static final BufferedImage SCROLL_THUMB_NORMAL = SQlabGraphicsUtils.loadImage("scroll_thumb_normal.png");
    private static final BufferedImage SCROLL_THUMB_OVER = SQlabGraphicsUtils.loadImage("scroll_thumb_over.png");
    private static final BufferedImage SCROLL_THUMB_PRESSED = SQlabGraphicsUtils.loadImage("scroll_thumb_pressed.png");
    private boolean incBtnMouseOver;
    private boolean incBtnMousePressed;
    private boolean decBtnMouseOver;
    private boolean decBtnMousePressed;
    private boolean thumbMousePressed;

    public static ComponentUI createUI(JComponent c) {
        return new SQlabScrollBarUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(true);
        c.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (SQlabScrollBarUI.this.isThumbRollover()) {
                    SQlabScrollBarUI.this.thumbMousePressed = true;
                    SQlabScrollBarUI.this.scrollbar.repaint();
                }
            }

            public void mouseReleased(MouseEvent e) {
                SQlabScrollBarUI.this.thumbMousePressed = false;
            }
        });
    }

    protected Dimension getMinimumThumbSize() {
        return new Dimension(29, 29);
    }

    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = new SQlabScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        this.decreaseButton.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                SQlabScrollBarUI.this.decBtnMouseOver = true;
            }

            public void mouseExited(MouseEvent e) {
                SQlabScrollBarUI.this.decBtnMouseOver = false;
            }

            public void mousePressed(MouseEvent e) {
                SQlabScrollBarUI.this.decBtnMousePressed = true;
            }

            public void mouseReleased(MouseEvent e) {
                SQlabScrollBarUI.this.decBtnMousePressed = false;
            }
        });
        return this.decreaseButton;
    }

    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = new SQlabScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        this.increaseButton.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                SQlabScrollBarUI.this.incBtnMouseOver = true;
            }

            public void mouseExited(MouseEvent e) {
                SQlabScrollBarUI.this.incBtnMouseOver = false;
            }

            public void mousePressed(MouseEvent e) {
                SQlabScrollBarUI.this.incBtnMousePressed = true;
            }

            public void mouseReleased(MouseEvent e) {
                SQlabScrollBarUI.this.incBtnMousePressed = false;
            }
        });
        return this.increaseButton;
    }

    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        BufferedImage decImg;
        BufferedImage bufferedImage = this.decBtnMousePressed ? SCROLL_DEC_PRESSED : (decImg = this.decBtnMouseOver ? SCROLL_DEC_OVER : SCROLL_DEC_NORMAL);
        BufferedImage incImg = this.incBtnMousePressed ? SCROLL_INC_PRESSED : (this.incBtnMouseOver ? SCROLL_INC_OVER : SCROLL_INC_NORMAL);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform origTransform = g2.getTransform();
        int scrollWidth = this.scrollbar.getWidth();
        if (this.scrollbar.getOrientation() == 1) {
            scrollWidth = this.scrollbar.getHeight();
            g2.scale(1.0, -1.0);
            g2.rotate(-1.5707963267948966, 0.0, 0.0);
        }
        if (this.scrollbar.isEnabled()) {
            g.drawImage(decImg, 0, 0, this.scrollbar);
            g.drawImage(BACKGROUND_ENABLED, 27, 0, scrollWidth - 27, 15, 0, 0, 1, 15, this.scrollbar);
            g.drawImage(incImg, scrollWidth - 27, 0, this.scrollbar);
        } else {
            g.drawImage(BACKGROUND_DISABLED, 0, 0, scrollWidth, 15, 0, 0, 1, 15, this.scrollbar);
        }
        g2.setTransform(origTransform);
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (this.scrollbar.isEnabled()) {
            BufferedImage thumbImg = this.thumbMousePressed ? SCROLL_THUMB_PRESSED : (this.isThumbRollover() ? SCROLL_THUMB_OVER : SCROLL_THUMB_NORMAL);
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform origTransform = g2.getTransform();
            Rectangle b = thumbBounds;
            if (this.scrollbar.getOrientation() == 1) {
                b = new Rectangle(thumbBounds.y, thumbBounds.x, thumbBounds.height, thumbBounds.width);
                g2.scale(1.0, -1.0);
                g2.rotate(-1.5707963267948966, 0.0, 0.0);
            }
            g.drawImage(thumbImg, b.x, b.y, b.x + 14, b.y + 15, 0, 0, 14, 15, this.scrollbar);
            g.drawImage(thumbImg, b.x + 14, b.y, b.x + b.width - 14, b.y + 15, 16, 0, 17, 15, this.scrollbar);
            g.drawImage(thumbImg, b.x + b.width - 14, b.y, b.x + b.width, b.y + 15, 24, 0, 38, 15, this.scrollbar);
            g2.setTransform(origTransform);
        }
    }
}

