/*
 * Decompiled with CFR 0.152.
 */
package popometer.panels;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import popometer.FrmNavigator;
import popometer.YPopometerSession;
import popometer.dbobjects.YDLKundeneinsbed;
import popometer.dbobjects.YPDLEinsatzteilbereiche;
import popometer.dbobjects.YRLSuchproduktarten;
import popometer.dbobjects.YROEinsatzbereich;
import popometer.dbobjects.YROKunde;
import popometer.dbobjects.YSPDLEinsatzbedingungen;
import popometer.dbobjects.YSRLEinsbereichprodart;
import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDBOChangeEventListener;
import projektY.database.YDBORowRequestListener;
import projektY.database.YRowValues;

public class PanEinsatzbereich
extends JPanel
implements HyperlinkListener {
    private int einsbereichId;
    private YROEinsatzbereich einsatzbereich;
    private boolean eindeutig;
    private FrmNavigator navigator;
    private YROKunde kunde;
    private YPDLEinsatzteilbereiche einsatzteilbereiche;
    private JPanel panEinsatzteilbereiche;
    private ButtonGroup bgrpEinsatzteilbereiche;
    int nTeilbereiche;
    private JRadioButton[] rbEinsatzteilbereiche;
    private YSPDLEinsatzbedingungen einsatzbedingungen;
    private JPanel panEinsbedContainer;
    private ButtonGroup bgrpEinsatzbedingungen;
    private JRadioButton rbNichts;
    private JToggleButton[] tbEinsatzbedingungen;
    private int[] einsbedingungIds;
    private static int gettingEinsbedingungen = 0;
    private JPanel panSpace;
    private ToggleListener toggleListener;
    private JEditorPane edpanHtml;
    private JPanel panAuswahl;
    private JPanel panErlaeuterung;
    private JPanel panRelevant;
    private JScrollPane scrlAuswahl;
    private JScrollPane scrlHtml;
    private JScrollPane scrlPlain;
    private JTextArea txtPlain;

    public PanEinsatzbereich(YPopometerSession session, int einsbereichId, FrmNavigator navigator, final YROKunde kunde) throws YException {
        GridBagConstraints gridBagConstraints;
        int iRow;
        int nRows;
        this.initComponents();
        this.einsbereichId = einsbereichId;
        this.navigator = navigator;
        this.kunde = kunde;
        this.einsatzbereich = new YROEinsatzbereich(session);
        this.einsatzbereich.fetch(einsbereichId);
        this.eindeutig = this.einsatzbereich.getAsBool("eindeutig");
        String erlaeuterung = this.einsatzbereich.getAsString("erlaeuterung");
        if (erlaeuterung.startsWith("<HTML>") || erlaeuterung.startsWith("<html>")) {
            StyleSheet styleSheet = ((HTMLEditorKit)this.edpanHtml.getEditorKit()).getStyleSheet();
            styleSheet.addRule("body {background-color: white}");
            String[] style = session.getStyle();
            if (style != null) {
                for (int iRule = 0; iRule < style.length; ++iRule) {
                    styleSheet.addRule(style[iRule]);
                }
            }
            this.edpanHtml.addHyperlinkListener(this);
            this.edpanHtml.setText(erlaeuterung);
            this.edpanHtml.setCaretPosition(0);
            ((CardLayout)this.panErlaeuterung.getLayout()).show(this.panErlaeuterung, "cardHtml");
        } else {
            this.txtPlain.setText(erlaeuterung);
            this.txtPlain.setCaretPosition(0);
            ((CardLayout)this.panErlaeuterung.getLayout()).show(this.panErlaeuterung, "cardPlain");
        }
        this.einsatzteilbereiche = this.einsatzbereich.getEinsatzteilbereiche();
        this.einsatzbedingungen = this.einsatzteilbereiche.getEinsatzbedingungen();
        this.rbEinsatzteilbereiche = new JRadioButton[this.einsatzteilbereiche.getRowCount()];
        this.tbEinsatzbedingungen = new JToggleButton[this.einsatzbedingungen.getAbsRowCount()];
        this.einsbedingungIds = new int[this.einsatzbedingungen.getAbsRowCount()];
        this.nTeilbereiche = this.einsatzteilbereiche.getRowCount();
        int gridyPanel = 0;
        int iTb = 0;
        if (this.nTeilbereiche > 1) {
            this.panEinsatzteilbereiche = new JPanel();
            this.panEinsatzteilbereiche.setBorder(BorderFactory.createTitledBorder(this.einsatzbereich.getAsString("teilbereich")));
            this.panEinsatzteilbereiche.setLayout(new GridBagLayout());
            nRows = this.einsatzteilbereiche.getRowCount();
            this.bgrpEinsatzteilbereiche = new ButtonGroup();
            ActionListener listenEinsatzteilbereiche = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanEinsatzbereich.this.einsatzteilbereichActionPerformed(e);
                }
            };
            iRow = 0;
            while (iRow < nRows) {
                JRadioButton radioButton = new JRadioButton(this.einsatzteilbereiche.getRowValues(iRow).toString());
                radioButton.addActionListener(listenEinsatzteilbereiche);
                this.bgrpEinsatzteilbereiche.add(radioButton);
                this.rbEinsatzteilbereiche[iRow] = radioButton;
                if (iRow == 0) {
                    radioButton.setSelected(true);
                }
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = iRow++;
                gridBagConstraints.anchor = 17;
                this.panEinsatzteilbereiche.add((Component)radioButton, gridBagConstraints);
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = gridyPanel++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            this.panAuswahl.add((Component)this.panEinsatzteilbereiche, gridBagConstraints);
        }
        this.toggleListener = new ToggleListener();
        this.panEinsbedContainer = new JPanel();
        this.panEinsbedContainer.setLayout(new CardLayout());
        if (this.eindeutig) {
            this.bgrpEinsatzbedingungen = new ButtonGroup();
            this.rbNichts = new JRadioButton();
            this.rbNichts.setSelected(true);
            this.rbNichts.setVisible(false);
            this.rbNichts.addItemListener(this.toggleListener);
            this.bgrpEinsatzbedingungen.add(this.rbNichts);
        } else {
            this.rbNichts = null;
        }
        for (int iTeilbereich = 0; iTeilbereich < this.nTeilbereiche; ++iTeilbereich) {
            JPanel panEinsatzbedingungen = new JPanel();
            panEinsatzbedingungen.setBorder(BorderFactory.createTitledBorder(this.einsatzteilbereiche.getRowValues(iTeilbereich).toString()));
            panEinsatzbedingungen.setLayout(new GridBagLayout());
            this.einsatzbedingungen.setSubWindow(this.einsatzteilbereiche.getRowId(iTeilbereich));
            nRows = this.einsatzbedingungen.getRowCount();
            iRow = 0;
            while (iRow < nRows) {
                JToggleButton toggleButton;
                if (this.eindeutig) {
                    toggleButton = new JRadioButton(this.einsatzbedingungen.getRowValues(iRow).toString());
                    this.bgrpEinsatzbedingungen.add(toggleButton);
                } else {
                    toggleButton = new JCheckBox(this.einsatzbedingungen.getRowValues(iRow).toString());
                }
                this.einsbedingungIds[iTb] = this.einsatzbedingungen.getRowValues(iRow).getPkFieldValue().getValueAsInt();
                this.tbEinsatzbedingungen[iTb++] = toggleButton;
                toggleButton.addItemListener(this.toggleListener);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = iRow++;
                gridBagConstraints.anchor = 17;
                panEinsatzbedingungen.add((Component)toggleButton, gridBagConstraints);
            }
            this.panEinsbedContainer.add((Component)panEinsatzbedingungen, this.einsatzteilbereiche.getRowValues(iTeilbereich).toString());
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridyPanel++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panAuswahl.add((Component)this.panEinsbedContainer, gridBagConstraints);
        this.panSpace = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridyPanel;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panAuswahl.add((Component)this.panSpace, gridBagConstraints);
        YRLSuchproduktarten suchproduktarten = (YRLSuchproduktarten)session.getRowObjectList("suchproduktarten");
        YSRLEinsbereichprodart einsbereichprodart = (YSRLEinsbereichprodart)suchproduktarten.getSubRowList("einsbereichprodart");
        nRows = suchproduktarten.getRowCount();
        for (iRow = 0; iRow < nRows; ++iRow) {
            suchproduktarten.setActiveRow(iRow);
            boolean zutreffend = false;
            int nEb = einsbereichprodart.getRowCount();
            for (int iEb = 0; iEb < nEb; ++iEb) {
                if (einsbereichprodart.getAsInt(iEb, "einsbereich_id") != einsbereichId) continue;
                zutreffend = true;
                break;
            }
            JLabel lblProduktart = new JLabel(suchproduktarten.getAsString(iRow, "produktart"));
            lblProduktart.setEnabled(zutreffend);
            this.panRelevant.add(lblProduktart);
        }
        kunde.getDetailList("vh_kundeneinsbed").addChangeEventListener(new YDBOChangeEventListener(){

            public void DBObjectChanged(YDBOChangeEvent evt) throws YException {
                YDLKundeneinsbed kundeneinsbed = (YDLKundeneinsbed)kunde.getDetailList("vh_kundeneinsbed");
                PanEinsatzbereich.this.setEinsbedingungen(kundeneinsbed);
            }
        });
        kunde.addRowRequestListener(new YDBORowRequestListener(){

            public void requestRowValues(YRowValues rowValues) throws YException {
                YDLKundeneinsbed kundeneinsbed = (YDLKundeneinsbed)kunde.getDetailList("vh_kundeneinsbed");
                PanEinsatzbereich.this.getEinsbedingungen(kundeneinsbed);
            }
        });
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL url = event.getURL();
            if (url == null) {
                String ref = event.getDescription();
                if (ref != null && ref.length() > 0 && ref.getBytes()[0] == 35) {
                    this.edpanHtml.scrollToReference(ref.substring(1));
                }
            } else {
                JOptionPane.showMessageDialog(this, "Externe Verkn\u00fcpfung " + url.toString() + " wird nicht verfolgt.", "Hinweis", 0);
            }
        }
    }

    private void einsatzteilbereichActionPerformed(ActionEvent e) {
        JRadioButton radioButton = (JRadioButton)e.getSource();
        try {
            int nRows = this.rbEinsatzteilbereiche.length;
            for (int iRow = 0; iRow < nRows; ++iRow) {
                if (this.rbEinsatzteilbereiche[iRow] != radioButton) continue;
                String einsatzteilbereich = this.einsatzteilbereiche.getAsString(iRow, "bezeichnung");
                ((CardLayout)this.panEinsbedContainer.getLayout()).show(this.panEinsbedContainer, einsatzteilbereich);
                return;
            }
        }
        catch (YException ex) {
            JOptionPane.showMessageDialog(null, ex.toString(), "Fehler", 0);
        }
    }

    public int getEinsbereichId() {
        return this.einsbereichId;
    }

    public YROEinsatzbereich getEinsatzbereich() {
        return this.einsatzbereich;
    }

    public boolean getEinsbedingungIds(Vector<Integer> einsbedingungIds) throws YException {
        int nEb = this.tbEinsatzbedingungen.length;
        if (this.eindeutig) {
            for (int iEb = 0; iEb < nEb; ++iEb) {
                if (!this.tbEinsatzbedingungen[iEb].isSelected()) continue;
                einsbedingungIds.add(this.einsbedingungIds[iEb]);
                return true;
            }
            return false;
        }
        for (int iEb = 0; iEb < nEb; ++iEb) {
            if (!this.tbEinsatzbedingungen[iEb].isSelected()) continue;
            einsbedingungIds.add(this.einsbedingungIds[iEb]);
        }
        return true;
    }

    public boolean setEinsbedingung(int einsbereichId, int einsteilbereichId, int einsbedingungId) throws YException {
        int iEb;
        int nEb = this.tbEinsatzbedingungen.length;
        if (einsbereichId != this.einsatzbereich.getPkFieldValueAsInt()) {
            return false;
        }
        if (einsteilbereichId == 0) {
            if (einsbedingungId == 0) {
                return true;
            }
            if (this.nTeilbereiche > 1) {
                throw new YProgramException((Object)this, "setEinsbedingung(): Teilbereich nicht angegeben und noch nicht gesetzt");
            }
        }
        for (iEb = 0; iEb < nEb; ++iEb) {
            this.tbEinsatzbedingungen[iEb].setSelected(false);
        }
        if (einsteilbereichId > 0) {
            int iRow = this.einsatzteilbereiche.find(String.valueOf(einsteilbereichId), "einsteilbereich_id");
            if (iRow < 0) {
                throw new YProgramException((Object)this, "einsteilbereich_id " + einsteilbereichId + " existiert nicht f\u00fcr " + this.einsatzbereich.toString());
            }
            if (this.nTeilbereiche > 1) {
                this.rbEinsatzteilbereiche[iRow].setSelected(true);
                String strEinsatzteilbereich = this.einsatzteilbereiche.getAsString(iRow, "bezeichnung");
                ((CardLayout)this.panEinsbedContainer.getLayout()).show(this.panEinsbedContainer, strEinsatzteilbereich);
            }
        }
        if (einsbedingungId > 0) {
            for (iEb = 0; iEb < nEb; ++iEb) {
                if (this.einsbedingungIds[iEb] != einsbedingungId) continue;
                this.tbEinsatzbedingungen[iEb].setSelected(true);
                break;
            }
            if (iEb >= nEb) {
                throw new YProgramException((Object)this, "setEinsbedingung(): einsbedingung_id " + einsbedingungId + " geh\u00f6rt nicht zu einsbereich_id " + einsbereichId);
            }
        }
        return true;
    }

    private boolean setEinsbedingungen(YDLKundeneinsbed kundeneinsbed) throws YException {
        int iRow;
        int iEb;
        if (gettingEinsbedingungen > 0) {
            return false;
        }
        int nRows = kundeneinsbed.getRowCount();
        int nEb = this.tbEinsatzbedingungen.length;
        boolean alleGefunden = true;
        if (this.eindeutig) {
            this.rbNichts.setSelected(true);
        } else {
            for (iEb = 0; iEb < nEb; ++iEb) {
                this.tbEinsatzbedingungen[iEb].setSelected(false);
            }
        }
        for (iRow = 0; iRow < nRows; ++iRow) {
            if (kundeneinsbed.getAsInt(iRow, "einsbereich_id", 0) != this.einsbereichId) continue;
            int einsbedingungId = kundeneinsbed.getAsInt(iRow, "einsbedingung_id");
            String strEinsatzbedingung = kundeneinsbed.getAsString(iRow, "bedingung");
            for (iEb = 0; iEb < nEb; ++iEb) {
                if (this.einsbedingungIds[iEb] != einsbedingungId) continue;
                if (this.tbEinsatzbedingungen[iEb].getText().equals(strEinsatzbedingung)) {
                    this.tbEinsatzbedingungen[iEb].setSelected(true);
                    continue;
                }
                alleGefunden = false;
            }
            if (this.nTeilbereiche > 1 && (iRow = this.einsatzbedingungen.find(String.valueOf(einsbedingungId), "einsbedingung_id")) >= 0) {
                int einsteilbereichId = this.einsatzbedingungen.getAbsRowValues(iRow).getAsInt("einsteilbereich_id");
                iRow = this.einsatzteilbereiche.find(String.valueOf(einsteilbereichId), "einsteilbereich_id");
                this.rbEinsatzteilbereiche[iRow].setSelected(true);
                String strEinsatzteilbereich = this.einsatzteilbereiche.getAsString(iRow, "bezeichnung");
                ((CardLayout)this.panEinsbedContainer.getLayout()).show(this.panEinsbedContainer, strEinsatzteilbereich);
            }
            if (this.eindeutig) break;
        }
        return (iRow < nRows || !this.eindeutig) && alleGefunden;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getEinsbedingungen(YDLKundeneinsbed kundeneinsbed) throws YException {
        int einsbedingungId = 0;
        try {
            ++gettingEinsbedingungen;
            int nRows = kundeneinsbed.getRowCount();
            int nEb = this.tbEinsatzbedingungen.length;
            if (this.eindeutig) {
                int iEb;
                int iRow;
                for (iRow = 0; iRow < nRows && kundeneinsbed.getAsInt(iRow, "einsbereich_id", 0) != this.einsbereichId; ++iRow) {
                }
                if (iRow < nRows) {
                    einsbedingungId = kundeneinsbed.getAsInt(iRow, "einsbedingung_id");
                } else {
                    iRow = -1;
                }
                if (this.rbNichts.isSelected()) {
                    if (iRow >= 0) {
                        kundeneinsbed.clearDispValues(iRow);
                    }
                    return;
                }
                for (iEb = 0; iEb < nEb && !this.tbEinsatzbedingungen[iEb].isSelected(); ++iEb) {
                }
                assert (iEb < nEb);
                if (iRow >= 0) {
                    if (this.einsbedingungIds[iEb] != einsbedingungId) {
                        kundeneinsbed.setAsInt(iRow, "einsbedingung_id", this.einsbedingungIds[iEb]);
                        kundeneinsbed.setAsString(iRow, "bedingung", this.tbEinsatzbedingungen[iEb].getText());
                    }
                } else {
                    kundeneinsbed.setAsInt(nRows, "kunde_id", this.kunde.getPkFieldValueAsInt());
                    kundeneinsbed.setAsInt(nRows, "einsbereich_id", this.einsbereichId);
                    kundeneinsbed.setAsString(nRows, "einsatzbereich", this.einsatzbereich.getAsString("bezeichnung"));
                    kundeneinsbed.setAsInt(nRows, "einsbedingung_id", this.einsbedingungIds[iEb]);
                    kundeneinsbed.setAsString(nRows, "bedingung", this.tbEinsatzbedingungen[iEb].getText());
                }
            } else {
                block6: for (int iEb = 0; iEb < nEb; ++iEb) {
                    int iRow;
                    if (this.tbEinsatzbedingungen[iEb].isSelected()) {
                        for (iRow = 0; iRow < nRows && (kundeneinsbed.getAsInt(iRow, "einsbereich_id", 0) != this.einsbereichId || kundeneinsbed.getAsInt(iRow, "einsbedingung_id", 0) != this.einsbedingungIds[iEb]); ++iRow) {
                        }
                        if (iRow < nRows) continue;
                        kundeneinsbed.setAsInt(nRows, "kunde_id", this.kunde.getPkFieldValueAsInt());
                        kundeneinsbed.setAsInt(nRows, "einsbereich_id", this.einsbereichId);
                        kundeneinsbed.setAsString(nRows, "einsatzbereich", this.einsatzbereich.getAsString("bezeichnung"));
                        kundeneinsbed.setAsInt(nRows, "einsbedingung_id", this.einsbedingungIds[iEb]);
                        kundeneinsbed.setAsString(nRows, "bedingung", this.tbEinsatzbedingungen[iEb].getText());
                        ++nRows;
                        continue;
                    }
                    for (iRow = 0; iRow < nRows; ++iRow) {
                        if (kundeneinsbed.getAsInt(iRow, "einsbereich_id", 0) != this.einsbereichId || kundeneinsbed.getAsInt(iRow, "einsbedingung_id", 0) != this.einsbedingungIds[iEb]) continue;
                        kundeneinsbed.clearDispValues(iRow);
                        continue block6;
                    }
                }
            }
        }
        finally {
            --gettingEinsbedingungen;
        }
    }

    private void initComponents() {
        this.scrlAuswahl = new JScrollPane();
        this.panAuswahl = new JPanel();
        this.panRelevant = new JPanel();
        this.panErlaeuterung = new JPanel();
        this.scrlPlain = new JScrollPane();
        this.txtPlain = new JTextArea();
        this.scrlHtml = new JScrollPane();
        this.edpanHtml = new JEditorPane();
        this.setLayout(new GridBagLayout());
        this.panAuswahl.setLayout(new GridBagLayout());
        this.scrlAuswahl.setViewportView(this.panAuswahl);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scrlAuswahl, gridBagConstraints);
        this.panRelevant.setBorder(BorderFactory.createTitledBorder("Ben\u00f6tigt f\u00fcr ..."));
        this.panRelevant.setLayout(new FlowLayout(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.4;
        this.add((Component)this.panRelevant, gridBagConstraints);
        this.panErlaeuterung.setBorder(BorderFactory.createTitledBorder("Erl\u00e4uterung"));
        this.panErlaeuterung.setLayout(new CardLayout());
        this.txtPlain.setColumns(20);
        this.txtPlain.setEditable(false);
        this.txtPlain.setLineWrap(true);
        this.txtPlain.setRows(5);
        this.txtPlain.setWrapStyleWord(true);
        this.scrlPlain.setViewportView(this.txtPlain);
        this.panErlaeuterung.add((Component)this.scrlPlain, "cardPlain");
        this.edpanHtml.setContentType("text/html");
        this.edpanHtml.setEditable(false);
        this.scrlHtml.setViewportView(this.edpanHtml);
        this.panErlaeuterung.add((Component)this.scrlHtml, "cardHtml");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.6;
        this.add((Component)this.panErlaeuterung, gridBagConstraints);
    }

    private class ToggleListener
    implements ItemListener {
        private ToggleListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (e.getSource() == PanEinsatzbereich.this.rbNichts) {
                    PanEinsatzbereich.this.navigator.einsatzbedingungGewaehlt(PanEinsatzbereich.this.einsbereichId, false);
                } else {
                    PanEinsatzbereich.this.navigator.einsatzbedingungGewaehlt(PanEinsatzbereich.this.einsbereichId, true);
                }
            }
        }
    }
}

