/*
 * Decompiled with CFR 0.152.
 */
package popometer.panels;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import popometer.FrmNavigator;
import popometer.YPopometerSession;
import popometer.dbobjects.YROKunde;
import popometer.graphics.GraphObject;
import popometer.graphics.SimpleMarker;
import popometer.panels.PanFotoImage;
import popometer.panels.PanMessung;
import projektY.base.YException;
import projektY.database.YDatabaseData;
import projektY.swing.YJPanelManager;

public class PanKoerper
extends PanMessung {
    private PanFotoImage panFotoImage;
    private Messpunkt pedal;
    private Messpunkt knie;
    private Messpunkt sitz;
    private Messpunkt schulter;
    private Messpunkt arm;
    private Messpunkt griff;
    private Messpunkt[] messpunkte;
    private JButton cmdMagischesDreieck;
    private JTextField fldLOberarm;
    private JTextField fldLOberkoerper;
    private JTextField fldLOberschenkel;
    private JTextField fldLUnterarm;
    private JTextField fldLUnterschenkel;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JLabel lblDreieck;
    private JLabel lblDreieckLinks;
    private JLabel lblDreieckOben;
    private JLabel lblDreieckRechts;
    private JPanel panDreieck;
    private JPanel panFill;
    private JPanel panKoerperMasse;
    private JScrollPane scrlImage;

    public PanKoerper(YPopometerSession session, YROKunde kunde, FrmNavigator frmNavigator) throws YException {
        super(session, kunde, frmNavigator);
        URL imageUrl = this.getClass().getResource("/popometer/pictures/fotobeispiel.jpg");
        Image demoImage = Toolkit.getDefaultToolkit().createImage(imageUrl);
        this.pedal = new Messpunkt(482, 581, 80);
        this.knie = new Messpunkt(519, 368, 60);
        this.sitz = new Messpunkt(348, 316, 50);
        this.schulter = new Messpunkt(511, 155, 50);
        this.arm = new Messpunkt(566, 272, 45);
        this.griff = new Messpunkt(672, 347, 50);
        this.messpunkte = new Messpunkt[]{this.pedal, this.knie, this.sitz, this.schulter, this.arm, this.griff};
        this.panFotoImage = new PanFotoImage(demoImage, this.messpunkte);
        this.panFotoImage.setPreferredSize(new Dimension(1024, 675));
        this.panFotoImage.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PanKoerper.this.fotoMouseClicked(evt);
            }
        });
        this.initComponents();
        YJPanelManager.createPanelManager((JComponent)this.panKoerperMasse, (YDatabaseData)kunde);
    }

    private void fotoMouseClicked(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        boolean ok = false;
        float k = 3.267f;
        for (int i = 0; i < this.messpunkte.length; ++i) {
            ok = this.messpunkte[i].set(x, y);
            if (!ok) continue;
            this.panFotoImage.repaint();
            break;
        }
        if (ok) {
            float f;
            float f2;
            float f3;
            float f4;
            float f5;
            float l = this.griff.distanceTo(this.arm);
            if (f5 > 0.0f) {
                this.fldLUnterarm.setText(String.format("%4.1f", Float.valueOf(l / 3.267f)));
            }
            l = this.arm.distanceTo(this.schulter);
            if (f4 > 0.0f) {
                this.fldLOberarm.setText(String.format("%4.1f", Float.valueOf(l / 3.267f)));
            }
            l = this.schulter.distanceTo(this.sitz);
            if (f3 > 0.0f) {
                this.fldLOberkoerper.setText(String.format("%4.1f", Float.valueOf(l / 3.267f)));
            }
            l = this.sitz.distanceTo(this.knie);
            if (f2 > 0.0f) {
                this.fldLOberschenkel.setText(String.format("%4.1f", Float.valueOf(l / 3.267f)));
            }
            l = this.knie.distanceTo(this.pedal);
            if (f > 0.0f) {
                this.fldLUnterschenkel.setText(String.format("%4.1f", Float.valueOf(l / 3.267f)));
            }
            boolean komplett = true;
            komplett &= this.fldLUnterarm.getText().length() > 0;
            komplett &= this.fldLOberarm.getText().length() > 0;
            komplett &= this.fldLOberkoerper.getText().length() > 0;
            komplett &= this.fldLOberschenkel.getText().length() > 0;
            if (komplett &= this.fldLUnterschenkel.getText().length() > 0) {
                this.lblDreieckOben.setVisible(true);
                this.lblDreieckLinks.setVisible(true);
                this.lblDreieckRechts.setVisible(true);
                this.cmdMagischesDreieck.setEnabled(true);
            }
        }
    }

    @Override
    protected void neuerKunde() throws YException {
        for (int i = this.messpunkte.length - 1; i >= 0; --i) {
            this.messpunkte[i].moveTo(0, 0);
        }
        this.lblDreieckOben.setVisible(false);
        this.lblDreieckLinks.setVisible(false);
        this.lblDreieckRechts.setVisible(false);
        this.cmdMagischesDreieck.setEnabled(false);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.scrlImage = new JScrollPane();
        this.scrlImage.setViewportView(this.panFotoImage);
        this.panKoerperMasse = new JPanel();
        this.jLabel2 = new JLabel();
        this.fldLUnterarm = new JTextField();
        this.jLabel3 = new JLabel();
        this.fldLOberarm = new JTextField();
        this.jLabel4 = new JLabel();
        this.fldLOberkoerper = new JTextField();
        this.jLabel5 = new JLabel();
        this.fldLOberschenkel = new JTextField();
        this.jLabel6 = new JLabel();
        this.fldLUnterschenkel = new JTextField();
        this.panDreieck = new JPanel();
        this.lblDreieck = new JLabel();
        this.lblDreieckOben = new JLabel();
        this.lblDreieckOben.setVisible(false);
        this.lblDreieckLinks = new JLabel();
        this.lblDreieckLinks.setVisible(false);
        this.lblDreieckRechts = new JLabel();
        this.lblDreieckRechts.setVisible(false);
        this.panFill = new JPanel();
        this.cmdMagischesDreieck = new JButton();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Me\u00dfbild"));
        this.jPanel1.setLayout(new BorderLayout());
        this.scrlImage.setBackground(new Color(255, 255, 255));
        this.jPanel1.add((Component)this.scrlImage, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.panKoerperMasse.setBackground(new Color(255, 255, 255));
        this.panKoerperMasse.setBorder(BorderFactory.createTitledBorder("L\u00e4ngen (cm):"));
        this.panKoerperMasse.setLayout(new GridBagLayout());
        this.jLabel2.setLabelFor(this.fldLUnterarm);
        this.jLabel2.setText("Unterarm:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 2, 0);
        this.panKoerperMasse.add((Component)this.jLabel2, gridBagConstraints);
        this.fldLUnterarm.setHorizontalAlignment(4);
        this.fldLUnterarm.setMinimumSize(new Dimension(80, 19));
        this.fldLUnterarm.setName("l_unterarm");
        this.fldLUnterarm.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.panKoerperMasse.add((Component)this.fldLUnterarm, gridBagConstraints);
        this.jLabel3.setLabelFor(this.fldLOberarm);
        this.jLabel3.setText("Oberarm:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 2, 0);
        this.panKoerperMasse.add((Component)this.jLabel3, gridBagConstraints);
        this.fldLOberarm.setHorizontalAlignment(4);
        this.fldLOberarm.setName("l_oberarm");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.panKoerperMasse.add((Component)this.fldLOberarm, gridBagConstraints);
        this.jLabel4.setLabelFor(this.fldLOberkoerper);
        this.jLabel4.setText("Oberk\u00f6rper+Sitz:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 2, 0);
        this.panKoerperMasse.add((Component)this.jLabel4, gridBagConstraints);
        this.fldLOberkoerper.setHorizontalAlignment(4);
        this.fldLOberkoerper.setName("l_oberkoerper");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.panKoerperMasse.add((Component)this.fldLOberkoerper, gridBagConstraints);
        this.jLabel5.setLabelFor(this.fldLOberschenkel);
        this.jLabel5.setText("Oberschenkel:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 2, 0);
        this.panKoerperMasse.add((Component)this.jLabel5, gridBagConstraints);
        this.fldLOberschenkel.setHorizontalAlignment(4);
        this.fldLOberschenkel.setName("l_oberschenkel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.panKoerperMasse.add((Component)this.fldLOberschenkel, gridBagConstraints);
        this.jLabel6.setLabelFor(this.fldLUnterschenkel);
        this.jLabel6.setText("Unterschenkel+Ferse:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.panKoerperMasse.add((Component)this.jLabel6, gridBagConstraints);
        this.fldLUnterschenkel.setHorizontalAlignment(4);
        this.fldLUnterschenkel.setName("l_unterschenkel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.panKoerperMasse.add((Component)this.fldLUnterschenkel, gridBagConstraints);
        this.panDreieck.setPreferredSize(new Dimension(208, 213));
        this.panDreieck.setLayout((LayoutManager)new AbsoluteLayout());
        this.lblDreieck.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/magischesDreieck.gif")));
        this.panDreieck.add((Component)this.lblDreieck, new AbsoluteConstraints(0, 0, 208, 213));
        this.lblDreieckOben.setText("77");
        this.panDreieck.add((Component)this.lblDreieckOben, new AbsoluteConstraints(80, 30, -1, -1));
        this.lblDreieckLinks.setText("97");
        this.panDreieck.add((Component)this.lblDreieckLinks, new AbsoluteConstraints(10, 110, -1, -1));
        this.lblDreieckRechts.setText("84");
        this.panDreieck.add((Component)this.lblDreieckRechts, new AbsoluteConstraints(150, 110, -1, -1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.panKoerperMasse.add((Component)this.panDreieck, gridBagConstraints);
        GroupLayout panFillLayout = new GroupLayout(this.panFill);
        this.panFill.setLayout(panFillLayout);
        panFillLayout.setHorizontalGroup(panFillLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 227, Short.MAX_VALUE));
        panFillLayout.setVerticalGroup(panFillLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1015, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panKoerperMasse.add((Component)this.panFill, gridBagConstraints);
        this.cmdMagischesDreieck.setText("O.K.");
        this.cmdMagischesDreieck.setToolTipText("Rahmen ermitteln");
        this.cmdMagischesDreieck.setEnabled(false);
        this.cmdMagischesDreieck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKoerper.this.cmdMagischesDreieckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panKoerperMasse.add((Component)this.cmdMagischesDreieck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 11;
        this.add((Component)this.panKoerperMasse, gridBagConstraints);
    }

    private void cmdMagischesDreieckActionPerformed(ActionEvent evt) {
        try {
            this.frmNavigator.setEinsbedingung("koerpermasse", 2.0f);
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    class Messpunkt
    extends GraphObject {
        private int x0;
        private int y0;
        private int r;
        private SimpleMarker marker;

        public Messpunkt(int x0, int y0, int r) {
            this.x0 = x0;
            this.y0 = y0;
            this.r = r;
            this.marker = new SimpleMarker(12);
        }

        public boolean set(int x, int y) {
            int dy;
            int dx = Math.abs(x - this.x0);
            if ((int)Math.sqrt(dx * dx + (dy = Math.abs(y - this.y0)) * dy) <= this.r) {
                this.moveTo(x, y);
                this.marker.moveTo(x, y);
                return true;
            }
            return false;
        }

        @Override
        public void draw(Graphics2D g2d) {
            Color color0 = g2d.getColor();
            Stroke stroke0 = g2d.getStroke();
            float[] dash = new float[]{1.0f, 1.0f};
            BasicStroke stroke = new BasicStroke(1.0f, 0, 0, 1.0f, dash, 0.0f);
            g2d.setStroke(stroke);
            g2d.setColor(Color.WHITE);
            g2d.drawOval(this.x0 - this.r, this.y0 - this.r, 2 * this.r, 2 * this.r);
            g2d.setColor(color0);
            g2d.setStroke(stroke0);
            if (this.getX() > 0 && this.getY() > 0) {
                this.marker.draw(g2d);
            }
        }

        public float distanceTo(Messpunkt messpunkt2) {
            if (this.getX() == 0 || this.getY() == 0) {
                return 0.0f;
            }
            if (messpunkt2.getX() == 0 || messpunkt2.getY() == 0) {
                return 0.0f;
            }
            int a = Math.abs(this.getX() - messpunkt2.getX());
            int b = Math.abs(this.getY() - messpunkt2.getY());
            return (float)Math.sqrt(a * a + b * b);
        }
    }
}

