/*
 * Decompiled with CFR 0.152.
 */
package popometer.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import popometer.FrmNavigator;
import popometer.YPopometerSession;
import popometer.dbobjects.YROKunde;
import projektY.base.YException;
import projektY.database.YColumnDefinition;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDatabaseData;
import projektY.database.YDatabaseList;
import projektY.database.YEvaluationList;
import projektY.database.YFieldValue;
import projektY.database.YSession;
import projektY.swing.YJPanelManager;
import projektY.swing.YJTableManager;

public class PanKundendaten
extends JPanel {
    private YPopometerSession session;
    private FrmNavigator navigator;
    private YEvaluationList evKundenliste;
    private YROKunde kunde;
    private int iRowKundeSelected;
    private JComboBox cmbLand;
    private JButton cmdKundeCancel;
    private JButton cmdKundeClear;
    private JButton cmdKundeDelete;
    private JButton cmdKundePost;
    private JButton cmdSuchen;
    private JTextField fldEmail;
    private JTextField fldKundennr;
    private JTextField fldName;
    private JTextField fldOrt;
    private JTextField fldPlz;
    private JTextField fldStrNr;
    private JTextField fldSucheKundennr;
    private JTextField fldSucheName;
    private JTextField fldSucheVorname;
    private JTextField fldTelefon;
    private JTextField fldVorname;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JLabel lblKundenNr;
    private JLabel lblMoreResults;
    private JLabel lblNachname;
    private JLabel lblVorname;
    private JPanel panGefKunden;
    private JPanel panKundendatenControl;
    private JPanel panKundensuche;
    private JPanel panLinks;
    private JPanel panRechts;
    private JScrollPane scrlAnfragen;
    private JScrollPane scrlBemerkungen;
    private JScrollPane scrlKundenliste;
    private JTable tblAnfragen;
    private JTable tblKundenliste;
    private JTextArea txtBemerkungen;

    public PanKundendaten(YPopometerSession session, YROKunde kunde, FrmNavigator navigator) throws YException {
        this.session = session;
        this.navigator = navigator;
        this.initComponents();
        this.evKundenliste = new YEvaluationList((YSession)session, 5, 50);
        this.evKundenliste.addDBField("kunde_id", YColumnDefinition.FieldType.INT);
        this.evKundenliste.addDBField("kundennr", YColumnDefinition.FieldType.STRING);
        this.evKundenliste.addDBField("name", YColumnDefinition.FieldType.STRING);
        this.evKundenliste.addDBField("vorname", YColumnDefinition.FieldType.STRING);
        this.evKundenliste.addDBField("ort", YColumnDefinition.FieldType.STRING);
        this.evKundenliste.setLabels("kundensuche");
        this.evKundenliste.setSQLSelect("SELECT kunde_id, kundennr, vorname, name, ort FROM vh_kunden");
        this.evKundenliste.setOrder(new String[]{"name", "vorname", "kundennr"});
        this.evKundenliste.addFilter("name", "lower(name) LIKE :value:||'%'", YColumnDefinition.FieldType.STRING);
        this.evKundenliste.addFilter("vorname", "lower(vorname) LIKE :value:||'%'", YColumnDefinition.FieldType.STRING);
        this.evKundenliste.addFilter("kundennr", "kundennr=:value:", YColumnDefinition.FieldType.STRING);
        this.evKundenliste.setDispFields(new String[]{"kundennr", "vorname", "name", "ort"});
        this.evKundenliste.finalize();
        this.evKundenliste.setMaxRows(50);
        this.kunde = kunde;
        YJPanelManager.createPanelManager((JComponent)this.panRechts, (YDatabaseData)kunde);
        this.lblKundenNr.setText(kunde.getColumnLabel("kundennr") + ":");
        this.lblNachname.setText(kunde.getColumnLabel("name") + ":");
        this.lblVorname.setText(kunde.getColumnLabel("vorname") + ":");
        YJTableManager.createTableManager((JTable)this.tblKundenliste, (YDatabaseList)this.evKundenliste, (boolean)true);
        this.tblKundenliste.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PanKundendaten.this.tblKundenlisteSelectionChanged(e);
            }
        });
        this.lblMoreResults.setVisible(false);
    }

    public boolean hasChanged() throws YException {
        return this.kunde.hasChanged();
    }

    public void clearKundenlisteSelection() throws YException {
        this.evKundenliste.unsetActiveRow();
        this.tblKundenliste.clearSelection();
    }

    private void tblKundenlisteSelectionChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        try {
            int a;
            int iRow = this.evKundenliste.getActiveRow();
            if (iRow < 0) {
                this.iRowKundeSelected = -1;
                return;
            }
            if (this.kunde.hasChanged() && (a = JOptionPane.showConfirmDialog(this, "\u00c4nderungen an '" + this.kunde.toString() + "' speichern ?\n" + "(" + this.kunde.getLastHasChanged() + ")", "\u00c4nderungen", 0)) == 0) {
                this.kunde.post();
                if (this.iRowKundeSelected >= 0 && this.evKundenliste.getAsInt(this.iRowKundeSelected, "kunde_id") == this.kunde.getPkFieldValueAsInt()) {
                    this.evKundenliste.setAsString(this.iRowKundeSelected, "vorname", this.kunde.getAsString("vorname"));
                    this.evKundenliste.setAsString(this.iRowKundeSelected, "name", this.kunde.getAsString("name"));
                    this.evKundenliste.setAsString(this.iRowKundeSelected, "ort", this.kunde.getAsString("ort"));
                    this.evKundenliste.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, this.iRowKundeSelected, this.iRowKundeSelected));
                }
            }
            int kundeId = this.evKundenliste.getAsInt(iRow, "kunde_id");
            this.kunde.fetch(kundeId);
            this.iRowKundeSelected = iRow;
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.panLinks = new JPanel();
        this.panKundensuche = new JPanel();
        this.jLabel13 = new JLabel();
        this.lblKundenNr = new JLabel();
        this.lblVorname = new JLabel();
        this.lblNachname = new JLabel();
        this.fldSucheKundennr = new JTextField();
        this.fldSucheVorname = new JTextField();
        this.fldSucheName = new JTextField();
        this.cmdSuchen = new JButton();
        this.jLabel12 = new JLabel();
        this.lblMoreResults = new JLabel();
        this.panGefKunden = new JPanel();
        this.scrlKundenliste = new JScrollPane();
        this.tblKundenliste = new JTable();
        this.jLabel14 = new JLabel();
        this.panRechts = new JPanel();
        this.cmdKundeClear = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel1 = new JLabel();
        this.fldKundennr = new JTextField();
        this.fldVorname = new JTextField();
        this.fldName = new JTextField();
        this.fldTelefon = new JTextField();
        this.fldEmail = new JTextField();
        this.fldStrNr = new JTextField();
        this.fldPlz = new JTextField();
        this.fldOrt = new JTextField();
        this.cmbLand = new JComboBox();
        this.scrlBemerkungen = new JScrollPane();
        this.txtBemerkungen = new JTextArea();
        this.scrlAnfragen = new JScrollPane();
        this.tblAnfragen = new JTable();
        this.panKundendatenControl = new JPanel();
        this.cmdKundeDelete = new JButton();
        this.cmdKundePost = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel11 = new JLabel();
        this.cmdKundeCancel = new JButton();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.panLinks.setBorder(BorderFactory.createTitledBorder(""));
        this.panLinks.setLayout(new GridBagLayout());
        this.panKundensuche.setLayout(new GridBagLayout());
        this.jLabel13.setFont(new Font("Dialog", 1, 14));
        this.jLabel13.setForeground(new Color(255, 67, 33));
        this.jLabel13.setText("Kundensuche");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 20, 0);
        this.panKundensuche.add((Component)this.jLabel13, gridBagConstraints);
        this.lblKundenNr.setText("Kundennummer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundensuche.add((Component)this.lblKundenNr, gridBagConstraints);
        this.lblVorname.setText("Vorname:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundensuche.add((Component)this.lblVorname, gridBagConstraints);
        this.lblNachname.setText("Nachname:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundensuche.add((Component)this.lblNachname, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundensuche.add((Component)this.fldSucheKundennr, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundensuche.add((Component)this.fldSucheVorname, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panKundensuche.add((Component)this.fldSucheName, gridBagConstraints);
        this.cmdSuchen.setText("Suchen");
        this.cmdSuchen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKundendaten.this.cmdSuchenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panKundensuche.add((Component)this.cmdSuchen, gridBagConstraints);
        this.jLabel12.setText("(max. 50 Treffer)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panKundensuche.add((Component)this.jLabel12, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.panLinks.add((Component)this.panKundensuche, gridBagConstraints);
        this.lblMoreResults.setText("Es wurden noch mehr Kunden gefunden.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.panLinks.add((Component)this.lblMoreResults, gridBagConstraints);
        this.panGefKunden.setPreferredSize(new Dimension(460, 280));
        this.panGefKunden.setLayout(new GridBagLayout());
        this.scrlKundenliste.setBackground(new Color(255, 255, 255));
        this.scrlKundenliste.setBorder(null);
        this.tblKundenliste.getSelectionModel().setSelectionMode(0);
        this.scrlKundenliste.setViewportView(this.tblKundenliste);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panGefKunden.add((Component)this.scrlKundenliste, gridBagConstraints);
        this.jLabel14.setFont(new Font("Dialog", 1, 14));
        this.jLabel14.setForeground(new Color(255, 67, 33));
        this.jLabel14.setText("Ergebnissliste");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(20, 5, 20, 0);
        this.panGefKunden.add((Component)this.jLabel14, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.panLinks.add((Component)this.panGefKunden, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.panLinks, gridBagConstraints);
        this.panRechts.setBorder(BorderFactory.createTitledBorder(""));
        this.panRechts.setLayout(new GridBagLayout());
        this.cmdKundeClear.setIcon(new ImageIcon(this.getClass().getResource("/popometer/pictures/new.gif")));
        this.cmdKundeClear.setToolTipText("Neuer Kunde");
        this.cmdKundeClear.setFocusable(false);
        this.cmdKundeClear.setHorizontalTextPosition(0);
        this.cmdKundeClear.setVerticalTextPosition(3);
        this.cmdKundeClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKundendaten.this.cmdKundeClearActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panRechts.add((Component)this.cmdKundeClear, gridBagConstraints);
        this.jLabel2.setLabelFor(this.fldKundennr);
        this.jLabel2.setText("Kundennummer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panRechts.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setLabelFor(this.fldVorname);
        this.jLabel3.setText("Vorname:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panRechts.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setLabelFor(this.fldName);
        this.jLabel4.setText("Nachname:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panRechts.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setLabelFor(this.fldTelefon);
        this.jLabel5.setText("Telefon:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panRechts.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setLabelFor(this.fldEmail);
        this.jLabel6.setText("E-Mail:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panRechts.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setLabelFor(this.fldStrNr);
        this.jLabel7.setText("Stra\u00dfe/Nr:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panRechts.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel8.setLabelFor(this.fldPlz);
        this.jLabel8.setText("Postleitzahl:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panRechts.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel9.setLabelFor(this.fldOrt);
        this.jLabel9.setText("Ort:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panRechts.add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel10.setLabelFor(this.cmbLand);
        this.jLabel10.setText("Land:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panRechts.add((Component)this.jLabel10, gridBagConstraints);
        this.jLabel1.setText("Bemerkungen:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.panRechts.add((Component)this.jLabel1, gridBagConstraints);
        this.fldKundennr.setFont(new Font("SansSerif", 0, 12));
        this.fldKundennr.setName("kundennr");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panRechts.add((Component)this.fldKundennr, gridBagConstraints);
        this.fldVorname.setFont(new Font("SansSerif", 0, 12));
        this.fldVorname.setName("vorname");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panRechts.add((Component)this.fldVorname, gridBagConstraints);
        this.fldName.setFont(new Font("SansSerif", 0, 12));
        this.fldName.setName("name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panRechts.add((Component)this.fldName, gridBagConstraints);
        this.fldTelefon.setFont(new Font("SansSerif", 0, 12));
        this.fldTelefon.setName("telefon");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panRechts.add((Component)this.fldTelefon, gridBagConstraints);
        this.fldEmail.setFont(new Font("SansSerif", 0, 12));
        this.fldEmail.setName("email");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panRechts.add((Component)this.fldEmail, gridBagConstraints);
        this.fldStrNr.setFont(new Font("SansSerif", 0, 12));
        this.fldStrNr.setName("str_nr");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panRechts.add((Component)this.fldStrNr, gridBagConstraints);
        this.fldPlz.setFont(new Font("SansSerif", 0, 12));
        this.fldPlz.setName("plz");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panRechts.add((Component)this.fldPlz, gridBagConstraints);
        this.fldOrt.setFont(new Font("SansSerif", 0, 12));
        this.fldOrt.setName("ort");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panRechts.add((Component)this.fldOrt, gridBagConstraints);
        this.cmbLand.setFont(this.cmbLand.getFont());
        this.cmbLand.setName("land_kz");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panRechts.add((Component)this.cmbLand, gridBagConstraints);
        this.txtBemerkungen.setColumns(20);
        this.txtBemerkungen.setRows(5);
        this.txtBemerkungen.setName("bemerkungen");
        this.scrlBemerkungen.setViewportView(this.txtBemerkungen);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.panRechts.add((Component)this.scrlBemerkungen, gridBagConstraints);
        this.scrlAnfragen.setBackground(new Color(255, 255, 255));
        this.scrlAnfragen.setBorder(null);
        this.tblAnfragen.setModel(new DefaultTableModel(new Object[][]{{"13451345", "345235", "234523"}, {"3245234523", "45234", "5252334"}, {null, "52345", "45234523"}}, new String[]{"Titel 1", "Titel 2", "Titel 3"}));
        this.tblAnfragen.setName("vh_anfrageprodukte");
        this.scrlAnfragen.setViewportView(this.tblAnfragen);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panRechts.add((Component)this.scrlAnfragen, gridBagConstraints);
        this.panKundendatenControl.setLayout(new GridBagLayout());
        this.cmdKundeDelete.setText("l\u00f6schen");
        this.cmdKundeDelete.setToolTipText("Kundendaten l\u00f6schen");
        this.cmdKundeDelete.setFocusable(false);
        this.cmdKundeDelete.setHorizontalTextPosition(0);
        this.cmdKundeDelete.setVerticalTextPosition(3);
        this.cmdKundeDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKundendaten.this.cmdKundeDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(0, 2, 4, 0);
        this.panKundendatenControl.add((Component)this.cmdKundeDelete, gridBagConstraints);
        this.cmdKundePost.setText("speichern");
        this.cmdKundePost.setToolTipText("Kundendaten speichern");
        this.cmdKundePost.setFocusable(false);
        this.cmdKundePost.setHorizontalTextPosition(0);
        this.cmdKundePost.setVerticalTextPosition(3);
        this.cmdKundePost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKundendaten.this.cmdKundePostActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.panKundendatenControl.add((Component)this.cmdKundePost, gridBagConstraints);
        this.jPanel4.add(this.jLabel11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panKundendatenControl.add((Component)this.jPanel4, gridBagConstraints);
        this.cmdKundeCancel.setText("verwerfen");
        this.cmdKundeCancel.setToolTipText("Verwerfen");
        this.cmdKundeCancel.setFocusable(false);
        this.cmdKundeCancel.setHorizontalTextPosition(0);
        this.cmdKundeCancel.setVerticalTextPosition(3);
        this.cmdKundeCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanKundendaten.this.cmdKundeCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.panKundendatenControl.add((Component)this.cmdKundeCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.panRechts.add((Component)this.panKundendatenControl, gridBagConstraints);
        this.jLabel15.setFont(new Font("Dialog", 1, 14));
        this.jLabel15.setForeground(new Color(255, 67, 33));
        this.jLabel15.setText("Kundendaten");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 20, 0);
        this.panRechts.add((Component)this.jLabel15, gridBagConstraints);
        this.jLabel16.setFont(new Font("Dialog", 1, 14));
        this.jLabel16.setForeground(new Color(255, 67, 33));
        this.jLabel16.setText("letzte Anfragen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.insets = new Insets(20, 5, 20, 0);
        this.panRechts.add((Component)this.jLabel16, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.panRechts, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void cmdSuchenActionPerformed(ActionEvent evt) {
        try {
            this.evKundenliste.clearFilterValues();
            if (this.fldSucheKundennr.getText().length() > 0) {
                this.evKundenliste.setFilterValue("kundennr", this.fldSucheKundennr.getText().toLowerCase(this.session.getLocale()));
            }
            if (this.fldSucheName.getText().length() > 0) {
                this.evKundenliste.setFilterValue("name", this.fldSucheName.getText().toLowerCase(this.session.getLocale()));
            }
            if (this.fldSucheVorname.getText().length() > 0) {
                this.evKundenliste.setFilterValue("vorname", this.fldSucheVorname.getText().toLowerCase(this.session.getLocale()));
            }
            this.lblMoreResults.setVisible(false);
            this.evKundenliste.fetch();
            this.lblMoreResults.setVisible(this.evKundenliste.hasMoreRows());
            this.navigator.disableProdukte();
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdKundeClearActionPerformed(ActionEvent evt) {
        try {
            if (this.kunde.hasChanged()) {
                JOptionPane.showMessageDialog(this, "\u00c4nderungen an '" + this.kunde.toString() + "' bitte vorher speichern oder verwerfen.", "Ungesicherte \u00c4nderungen", 0);
                return;
            }
            this.kunde.clear();
            this.iRowKundeSelected = -1;
            this.tblKundenliste.clearSelection();
            this.navigator.disableProdukte();
            this.clearKundenlisteSelection();
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdKundeDeleteActionPerformed(ActionEvent evt) {
        try {
            YFieldValue fieldValue = this.kunde.getPkFieldValue();
            if (fieldValue.wasNull()) {
                this.kunde.clear();
            } else {
                int a = JOptionPane.showConfirmDialog(this, this.kunde.toString() + " l\u00f6schen ?", "Best\u00e4tigung", 0);
                if (a == 1) {
                    return;
                }
                this.kunde.delete();
            }
            if (this.iRowKundeSelected >= 0) {
                int iRow = this.iRowKundeSelected;
                this.evKundenliste.removeRow(iRow);
            }
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdKundeCancelActionPerformed(ActionEvent evt) {
        try {
            this.kunde.revert();
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdKundePostActionPerformed(ActionEvent evt) {
        int iRow = this.tblKundenliste.getSelectedRow();
        try {
            int a;
            if (!this.kunde.hasKontaktDaten() && (a = JOptionPane.showConfirmDialog(this, "Kunden ohne oder mit unvollst\u00e4ndigen Kontakdaten speichern?\n(Telefonnummer oder eMail-Adresse w\u00fcrde ausreichen.))", "Fehlende Kontaktdaten", 0, 3)) == 1) {
                return;
            }
            this.kunde.post();
            if (iRow < 0) {
                return;
            }
            if (this.kunde.getPkFieldValueAsInt() != this.evKundenliste.getAsInt(iRow, "kunde_id")) {
                return;
            }
            this.evKundenliste.setAsString(iRow, "vorname", this.kunde.getAsString("vorname"));
            this.evKundenliste.setAsString(iRow, "name", this.kunde.getAsString("name"));
            this.evKundenliste.setAsString(iRow, "ort", this.kunde.getAsString("ort"));
            this.evKundenliste.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, iRow, iRow));
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }
}

