/*
 * Decompiled with CFR 0.152.
 */
package popometer.bikeandfit;

import popometer.bikeandfit.Einstellrad;
import popometer.bikeandfit.Koerpermasse;
import popometer.bikeandfit.Parameter;
import popometer.math.Polygonzug;
import projektY.base.YException;
import projektY.base.YUserException;

public class MagischesDreieck {
    private Parameter parameter;
    private double oben;
    private double hinten;
    private double vorn;
    private double neigungswinkel;
    private double rahmenwinkel;
    private Winkelsatz[] winkelsaetze;
    Polygonzug.Punkt K;
    Polygonzug.Punkt L;
    Polygonzug.Punkt S;

    public MagischesDreieck(Parameter parameter) {
        this.parameter = parameter;
        this.winkelsaetze = new Winkelsatz[]{new Winkelsatz(1, "komfort", 100.0, 50.0, 165.0, 117.0, 161.0, 0.0, 7.0), new Winkelsatz(2, "aufrecht", 110.0, 65.0, 165.0, 109.0, 161.0, 1.0, 5.5), new Winkelsatz(3, "leicht gebeugt", 120.0, 75.0, 175.0, 109.0, 161.0, 3.0, 6.0), new Winkelsatz(4, "moderat", 130.0, 85.0, 175.0, 109.0, 161.0, 2.0, 6.0), new Winkelsatz(5, "gestreckt", 134.0, 85.0, 175.0, 109.0, 161.0, 0.0, 0.0), new Winkelsatz(6, "Triathlon", 157.0, 68.0, 90.0, 111.0, 153.0, 4.0, 5.0)};
        this.K = new Polygonzug.Punkt();
        this.L = new Polygonzug.Punkt();
        this.S = new Polygonzug.Punkt();
        this.oben = 0.0;
        this.hinten = 0.0;
        this.vorn = 0.0;
        this.neigungswinkel = 0.0;
        this.rahmenwinkel = 0.0;
    }

    public void set(double oben, double hinten, double vorn, double neigungswinkel) throws YUserException {
        System.out.format("MagDreieck.set: oben=%5.1f hinten=%5.1f vorn=%5.1f neigungswinkel=%5.1f\n", oben, hinten, vorn, neigungswinkel);
        this.oben = oben;
        this.hinten = hinten;
        this.vorn = vorn;
        this.neigungswinkel = neigungswinkel;
        this.S.x = 0.0;
        this.S.y = 0.0;
        this.S.a = 0.0;
        this.L.x = Math.cos(Polygonzug.VektorSumme.degToRad(neigungswinkel)) * oben;
        this.L.y = Math.sin(Polygonzug.VektorSumme.degToRad(neigungswinkel)) * oben;
        this.L.a = oben;
        this.K.a = hinten;
        double p = hinten * hinten;
        double a = 2.0 * this.L.x;
        double b = 2.0 * this.L.y;
        double q = this.L.x * this.L.x + this.L.y * this.L.y + hinten * hinten - vorn * vorn;
        System.out.format("Zwischenergebnis 1: p=%5.1f a=%5.1f b=%5.1f q=%5.1f\n", p, a, b, q);
        double A = -(b * b) / (a * a) + 1.0;
        double B = -(2.0 * q * b) / (a * a);
        double C = q * q / (a * a) - p;
        System.out.format("Zwischenergebnis 2: A=%5.1f B=%5.1f C=%5.1f\n", A, B, C);
        A = 1.0;
        double D = (B /= A) / 2.0 * (B / 2.0) - (C /= A);
        System.out.format("Zwischenergebnis 3: A=%5.1f B=%5.1f C=%5.1f D=%5.1f\n", A, B, C, D);
        if (!(D >= 0.0)) {
            throw new YUserException("Ung\u00fcltiges Magisches Dreieck.\nKoordinaten k\u00f6nnen nicht berechnet werden.");
        }
        double y1 = -(B / 2.0) + Math.sqrt(D);
        double y2 = -(B / 2.0) - Math.sqrt(D);
        System.out.format("y1=%5.1f y2=%5.1f\n", y1, y2);
        this.K.y = y1 < this.L.y ? y1 : y2;
        this.K.x = (q - b * this.K.y) / a;
        System.out.format("MagDreieckskoordinaten: K(%2.1f,%2.1f) S(%2.1f,%2.1f) L(%2.1f,%2.1f)\n", this.K.x, this.K.y, this.S.x, this.S.y, this.L.x, this.L.y);
    }

    public void berechnen(int winkelsatzId, Koerpermasse koerpermasse) throws YException {
        Winkelsatz winkelsatz = null;
        for (Winkelsatz ws : this.winkelsaetze) {
            if (ws.id != winkelsatzId) continue;
            winkelsatz = ws;
            break;
        }
        if (winkelsatz == null) {
            throw new YException("Ung\u00fcltige winkelsatzId: " + winkelsatzId);
        }
        Polygonzug pzOK = new Polygonzug();
        Polygonzug pzBein = new Polygonzug();
        pzOK.append(winkelsatz.rw, false, koerpermasse.ok);
        pzOK.append(winkelsatz.sw, true, koerpermasse.oa);
        pzOK.append(winkelsatz.ew, false, koerpermasse.ua);
        pzBein.append(winkelsatz.bw, true, koerpermasse.os);
        pzBein.append(winkelsatz.kw, true, koerpermasse.usf);
        pzBein.endPunkt(this.K);
        pzOK.endPunkt(this.L);
        this.S.x = -winkelsatz.vxHK;
        this.S.y = -winkelsatz.vyHK;
        double f = (this.K.a - (double)this.parameter.kurbellaenge) / this.K.a;
        this.K.x *= f;
        this.K.y *= f;
        this.K.a -= (double)this.parameter.kurbellaenge;
        System.out.format("MagDreieckskoordinaten: K(%2.1f,%2.1f) S(%2.1f,%2.1f) L(%2.1f,%2.1f)\n", this.K.x, this.K.y, this.S.x, this.S.y, this.L.x, this.L.y);
        System.out.format("     ... transformiert: K(%2.1f,%2.1f) S(%2.1f,%2.1f) L(%2.1f,%2.1f)\n", this.K.x - this.S.x, this.K.y - this.S.y, Float.valueOf(0.0f), Float.valueOf(0.0f), this.L.x - this.S.x, this.L.y - this.S.y);
        this.oben = this.L.abstand(this.S);
        this.hinten = this.S.abstand(this.K);
        this.vorn = this.K.abstand(this.L);
        this.neigungswinkel = Polygonzug.VektorSumme.radToDeg(Math.asin((this.L.y - this.S.y) / this.L.abstand(this.S)));
        System.out.format("MagDreieck.berechnet: oben=%5.1f hinten=%5.1f vorn=%5.1f neigungswinkel=%5.1f\n", this.oben, this.hinten, this.vorn, this.neigungswinkel);
        this.rahmenwinkel = 90.0 - Polygonzug.VektorSumme.radToDeg(Math.asin((this.K.x - this.S.x) / this.K.abstand(this.S)));
    }

    public void berechnen(Einstellrad einstellrad) {
        double dx = -einstellrad.S.x;
        double dy = -einstellrad.S.y;
        this.S.x = 0.0;
        this.S.y = 0.0;
        this.hinten = einstellrad.S.a;
        this.L.x = einstellrad.L.x + dx;
        this.L.y = einstellrad.L.y + dy;
        this.vorn = einstellrad.L.a;
        this.K.x = dx;
        this.K.y = dy;
        this.oben = this.S.abstand(this.L);
        this.neigungswinkel = Polygonzug.VektorSumme.radToDeg(Math.asin(this.L.y / this.L.abstand(this.S)));
        this.rahmenwinkel = 90.0 - Polygonzug.VektorSumme.radToDeg(Math.asin((this.K.x - this.S.x) / this.K.abstand(this.S)));
    }

    public double getOben() {
        return this.oben;
    }

    public double getHinten() {
        return this.hinten;
    }

    public double getVorn() {
        return this.vorn;
    }

    public double getNeigungswinkel() {
        return this.neigungswinkel;
    }

    public double getRahmenwinkel() {
        return this.rahmenwinkel;
    }

    public String toString() {
        return String.format("A%s B%s C%s: oben=%2.1f hinten=%2.1f vorn=%2.1f neigungswinkel=%2.1f rahmenwinkel=%2.1f", this.K.toString(), this.L.toString(), this.S.toString(), this.oben, this.hinten, this.vorn, this.neigungswinkel, this.rahmenwinkel);
    }

    public static class Winkelsatz {
        private int id;
        private String name;
        private double rw;
        private double sw;
        private double ew;
        private double bw;
        private double kw;
        private double vxHK;
        private double vyHK;

        public Winkelsatz(int id, String name, double rw, double sw, double ew, double bw, double kw, double vxHK, double vyHK) {
            this.id = id;
            this.name = name;
            this.rw = rw;
            this.sw = sw;
            this.ew = ew;
            this.bw = bw;
            this.kw = kw;
            this.vxHK = vxHK;
            this.vyHK = vyHK;
        }
    }
}

