/*
 * Decompiled with CFR 0.152.
 */
package popometer.forms;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import popometer.YPopometerSession;
import popometer.dbobjects.YEVBenutzer;
import projektY.base.YException;
import projektY.database.YDatabaseList;
import projektY.database.YRowValues;
import projektY.swing.Utils;
import projektY.swing.YJTableManager;

public class DlgBenutzersuche
extends JDialog {
    YPopometerSession session;
    YEVBenutzer benutzer;
    private String user;
    private String locale;
    private JComboBox cmbLocale;
    private JButton cmdCancel;
    private JButton cmdFetch;
    private JButton cmdLogin;
    private JTextField fldFirma;
    private JTextField fldPlz;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel lblUeberschrift;
    private JPanel panBenutzersuche;
    private JPanel panControl;
    private JPanel panFilter;
    private JScrollPane scrlBenutzer;
    private JTable tblBenutzer;

    public DlgBenutzersuche(Frame parent, YPopometerSession session) throws YException {
        super(parent, true);
        this.initComponents();
        this.session = session;
        this.benutzer = new YEVBenutzer(session);
        this.benutzer.setDispFields(new String[]{"firma", "rolle", "vorname", "name"});
        YJTableManager.createTableManager((JTable)this.tblBenutzer, (YDatabaseList)this.benutzer, (boolean)true);
        this.user = null;
        this.locale = session.getLocale().getLanguage() + "_" + session.getLocale().getCountry();
        this.cmbLocale.setSelectedItem(this.locale);
        Utils.centerWindow((Window)this);
    }

    public String getUser() {
        return this.user;
    }

    private void initComponents() {
        this.panBenutzersuche = new JPanel();
        this.panFilter = new JPanel();
        this.jLabel1 = new JLabel();
        this.cmdFetch = new JButton();
        this.jLabel2 = new JLabel();
        this.fldFirma = new JTextField();
        this.fldPlz = new JTextField();
        this.scrlBenutzer = new JScrollPane();
        this.tblBenutzer = new JTable();
        this.panControl = new JPanel();
        this.cmbLocale = new JComboBox();
        this.cmdLogin = new JButton();
        this.cmdCancel = new JButton();
        this.lblUeberschrift = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Benutzersuche");
        this.getContentPane().setLayout(new GridBagLayout());
        this.panBenutzersuche.setBorder(BorderFactory.createTitledBorder(""));
        this.panBenutzersuche.setLayout(new GridBagLayout());
        this.panFilter.setLayout(new GridBagLayout());
        this.jLabel1.setText("H\u00e4ndler:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 4);
        this.panFilter.add((Component)this.jLabel1, gridBagConstraints);
        this.cmdFetch.setText("Suchen !");
        this.cmdFetch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgBenutzersuche.this.cmdFetchActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panFilter.add((Component)this.cmdFetch, gridBagConstraints);
        this.jLabel2.setText("PLZ:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 4);
        this.panFilter.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 5, 4);
        this.panFilter.add((Component)this.fldFirma, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panFilter.add((Component)this.fldPlz, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panBenutzersuche.add((Component)this.panFilter, gridBagConstraints);
        this.scrlBenutzer.setViewportView(this.tblBenutzer);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panBenutzersuche.add((Component)this.scrlBenutzer, gridBagConstraints);
        this.panControl.setLayout(new FlowLayout(2));
        this.cmbLocale.setModel(new DefaultComboBoxModel<String>(new String[]{"en_US", "de_DE", "nl_NL", "it_IT"}));
        this.panControl.add(this.cmbLocale);
        this.cmdLogin.setText("Anmelden");
        this.cmdLogin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgBenutzersuche.this.cmdLoginActionPerformed(evt);
            }
        });
        this.panControl.add(this.cmdLogin);
        this.cmdCancel.setText("Abbruch");
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgBenutzersuche.this.cmdCancelActionPerformed(evt);
            }
        });
        this.panControl.add(this.cmdCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 22;
        this.panBenutzersuche.add((Component)this.panControl, gridBagConstraints);
        this.lblUeberschrift.setForeground(new Color(212, 55, 28));
        this.lblUeberschrift.setText("Benutzersuche");
        this.lblUeberschrift.setName("headline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 17, 0);
        this.panBenutzersuche.add((Component)this.lblUeberschrift, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.panBenutzersuche, gridBagConstraints);
        this.pack();
    }

    private void cmdFetchActionPerformed(ActionEvent evt) {
        try {
            this.benutzer.clearFilterValues();
            String s = this.fldFirma.getText();
            if (s.length() > 0) {
                this.benutzer.setFilterValue("firma", s);
            }
            if ((s = this.fldPlz.getText()).length() > 0) {
                this.benutzer.setFilterValue("plz", s);
            }
            this.benutzer.setMaxRows(20);
            this.benutzer.fetch();
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdLoginActionPerformed(ActionEvent evt) {
        try {
            YRowValues rowValues = this.benutzer.getActiveRowValues();
            if (rowValues == null) {
                JOptionPane.showMessageDialog(this, "Bitte erst einen Benutzer ausw\u00e4hlen !", "Hinweis", 1);
                return;
            }
            if (!this.locale.equals(this.cmbLocale.getSelectedItem().toString())) {
                this.locale = this.cmbLocale.getSelectedItem().toString();
                this.session.setLocale(this.locale);
            }
            this.user = rowValues.getAsString("user");
            this.setVisible(false);
        }
        catch (YException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Fehler", 0);
        }
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.user = null;
        this.setVisible(false);
    }
}

