#!/bin/bash
# Scannen des Sitzknochenabstandes und Konvertieren des Bildes

# S/W od. Farbbild einstellen (Gray/Color)
MODE=Gray
# Bildformat (breitexhöhe)
# FORMAT=1389x546
PPMHOME=`dirname \`dirname \\\`echo $0\\\`\`` # Skriptname und /bin wegnehmen
TEMPDIR=${PPMHOME}/tmp
SCANOPTS="-l 0 -t 0 -x 216 -y 299"

# Scannen
scanimage -d `scanimage -L | grep -o 'genesys:libusb:[0-9][0-9][0-9]:[0-9][0-9][0-9]'` -p --resolution 100 --mode=${MODE} --format tiff > ${TEMPDIR}/scanimage.tiff
if [ $? -ne 0 ] ; then
	echo "Scanner angeschlossen ?" 1>&2
	exit 1
fi

# TIFF in JPG wandeln und drehen
# convert -rotate 90 outfile.tiff -resize $FORMAT poppes.jpg 2>&1
convert -rotate 90 ${TEMPDIR}/scanimage.tiff ${TEMPDIR}/scanimage0.jpeg 2>&1
if [ $? -ne 0 ] ; then
	echo "Bildkonvertierung fehlgeschlagen" 1>&2
	exit 1
fi
wrjpgcom -comment "SitAndFit_Scan: $SCANOPTS" ${TEMPDIR}/scanimage0.jpeg > ${TEMPDIR}/scanimage.jpeg

# Temporäre Dateien löschen
#??? rm -f ${TEMPDIR}/scanimage.tiff ${TEMPDIR}/scanimage0.jpeg
