/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import projektY.base.YException;
import projektY.base.YLookUpDomain;
import projektY.database.YColumnDefinition;
import projektY.database.YLookUpColumnDefinition;
import projektY.database.YLookUpFieldValue;

public class YLookUpDomainColumnDefinition
extends YLookUpColumnDefinition {
    YLookUpDomain lookUpDomain;

    public YLookUpDomainColumnDefinition(int fieldValueIndex, String name, YColumnDefinition.FieldType valueFieldType, YLookUpDomain lookUpDomain) throws YException {
        super(fieldValueIndex, name, valueFieldType);
        this.lookUpDomain = lookUpDomain;
    }

    public YLookUpDomainColumnDefinition(int fieldValueIndex, String name, YLookUpDomain lookUpDomain) throws YException {
        super(fieldValueIndex, name);
        this.lookUpDomain = lookUpDomain;
    }

    @Override
    public boolean isDomain() {
        return true;
    }

    public YLookUpDomain getLookUpDomain() {
        return this.lookUpDomain;
    }

    @Override
    public void modifyLookUpValue(YLookUpFieldValue fieldValue, String lookUpValue) {
        try {
            fieldValue.iLookUpRow = 0;
            while (fieldValue.iLookUpRow < this.lookUpDomain.getValueCount()) {
                if (this.lookUpDomain.getLookUpValue(fieldValue.iLookUpRow).toString().equals(lookUpValue)) {
                    fieldValue.modifyValue(this.lookUpDomain.getValue(fieldValue.iLookUpRow));
                    return;
                }
                ++fieldValue.iLookUpRow;
            }
            fieldValue.modifyValue("");
            fieldValue.iLookUpRow = -1;
        }
        catch (YException e) {
            fieldValue.iLookUpRow = -1;
        }
    }

    @Override
    public String lookUpValue(YLookUpFieldValue fieldValue) {
        try {
            for (int i = 0; i < this.lookUpDomain.getValueCount(); ++i) {
                if (!this.lookUpDomain.getValue(i).equals(fieldValue.getValue())) continue;
                return this.lookUpDomain.getLookUpValue(i);
            }
            return "";
        }
        catch (YException e) {
            return "";
        }
    }
}

