/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;
import projektY.database.YFieldValue;
import projektY.database.YRowDefinition;
import projektY.database.YRowValues;

public class YMatrixRowDefinition
extends YRowDefinition {
    YColumnDefinition matrixColumnDefinition;
    private int nListColumns;
    boolean used;

    public YMatrixRowDefinition(YRowDefinition rowDefinition, YColumnDefinition matrixColumnDefinition, int nMoreColumns) throws YException {
        super(rowDefinition, nMoreColumns);
        this.matrixColumnDefinition = this.removeColumnDefinition(matrixColumnDefinition);
        this.nListColumns = this.getNColumns();
    }

    protected YColumnDefinition removeColumnDefinition(YColumnDefinition columnDefinition) throws YProgramException {
        if (this.columnDefinitions.remove(columnDefinition)) {
            return columnDefinition;
        }
        throw new YProgramException(this, "Die angegebene Spaltendefinition existiert nicht in dieser Zeilendefinition.");
    }

    public int getNListColumns() {
        return this.nListColumns;
    }

    public YRowValues createRowValues(YRowValues listRowValues, int rowId) throws YException {
        int nToStringColumns;
        int iCol;
        int nColumns = listRowValues.rowDefinition.getNColumns();
        YRowValues matrixRowValues = new YRowValues(this, rowId);
        for (iCol = 0; iCol < nColumns; ++iCol) {
            int fieldValueIndex;
            YFieldValue fieldValue = listRowValues.getFieldValue(iCol);
            if (fieldValue.getColumnDefinition() == this.matrixColumnDefinition) {
                fieldValueIndex = this.getColumnDefinition(fieldValue.getColumnDefinition().getName() + "+0").getFieldValueIndex();
                continue;
            }
            fieldValueIndex = this.getColumnDefinition(fieldValue.getColumnDefinition().getName()).getFieldValueIndex();
            matrixRowValues.fieldValues[fieldValueIndex] = fieldValue;
        }
        int n = nToStringColumns = this.toStringColumns == null ? 0 : this.toStringColumns.length;
        if (nToStringColumns > 0) {
            matrixRowValues.toStringValues = new YFieldValue[nToStringColumns];
            for (iCol = 0; iCol < nToStringColumns; ++iCol) {
                matrixRowValues.toStringValues[iCol] = matrixRowValues.getFieldValue(this.toStringColumns[iCol]);
            }
        }
        return matrixRowValues;
    }

    public void mapFieldValue(YRowValues rowValues, YFieldValue matrixFieldValue, YColumnDefinition matrixColumnDefinition) {
        matrixFieldValue.columnDefinition = matrixColumnDefinition;
        rowValues.fieldValues[matrixColumnDefinition.getFieldValueIndex()] = matrixFieldValue;
    }

    void setUsed() {
        this.used = true;
    }

    boolean isUsed() {
        return this.used;
    }
}

