/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;
import projektY.database.YFieldValue;
import projektY.database.YRowObjectList;
import projektY.database.YRowValues;

public class YPosRowListManager {
    YRowObjectList detailList;
    YColumnDefinition posDefinition;

    public YPosRowListManager(YRowObjectList detailList) {
        this.detailList = detailList;
    }

    YColumnDefinition addPosField(String fieldName) throws YException {
        this.posDefinition = this.detailList.addDBField(fieldName, YColumnDefinition.FieldType.SHORT);
        return this.posDefinition;
    }

    void checkFinalized() throws YProgramException {
        if (this.posDefinition == null) {
            throw new YProgramException(this, "addPosField() wurde nicht aufgerufen.");
        }
    }

    public YColumnDefinition getPosDefinition() {
        return this.posDefinition;
    }

    void renumber() throws YException {
        int iPos = this.posDefinition.getFieldValueIndex();
        int posNr = 1;
        for (int iRow = 0; iRow < this.detailList.getRowCount(); ++iRow) {
            YRowValues row = this.detailList.getRowValues(iRow);
            if (!this.detailList.hasValuesToStore(row)) continue;
            YFieldValue fvPosNr = row.getFieldValue(iPos);
            if (fvPosNr.getValueAsInt(0) != posNr) {
                fvPosNr.modifyValue(posNr);
            }
            ++posNr;
        }
    }

    void exchangePosUp(int iRow) throws YException {
        assert (iRow >= 0);
        if (iRow == 0) {
            return;
        }
        YRowValues row = this.detailList.getRowValues(iRow);
        YFieldValue posValue = row.getFieldValue(this.posDefinition);
        String posNr = posValue.getValue();
        YFieldValue posValue2 = this.detailList.getRowValues(iRow - 1).getFieldValue(this.posDefinition);
        posValue.modifyValue(posValue2.getValue());
        posValue2.modifyValue(posNr);
    }

    void exchangePosDown(int iRow) throws YException {
        assert (iRow >= 0);
        assert (iRow < this.detailList.getRowCount());
        if (iRow == this.detailList.getRowCount() - 1) {
            return;
        }
        YRowValues row = this.detailList.getRowValues(iRow);
        YFieldValue posValue = row.getFieldValue(this.posDefinition);
        String posNr = posValue.getValue();
        YFieldValue posValue2 = this.detailList.getRowValues(iRow + 1).getFieldValue(this.posDefinition);
        posValue.modifyValue(posValue2.getValue());
        posValue2.modifyValue(posNr);
    }

    void reSort() throws YException {
        try {
            boolean sorted;
            int nRows = this.detailList.getRowCount();
            if (nRows < 2) {
                return;
            }
            do {
                sorted = true;
                YRowValues row = this.detailList.getRowValues(0);
                int pos1 = row.getFieldValue(this.posDefinition).getValueAsInt();
                for (int iRow = 1; iRow < nRows; ++iRow) {
                    row = this.detailList.getRowValues(iRow);
                    int pos2 = Integer.valueOf(row.getAsString(this.posDefinition.getFieldValueIndex()));
                    if (pos2 < pos1) {
                        this.detailList.moveUp(iRow);
                        this.exchangePosUp(iRow);
                        sorted = false;
                        continue;
                    }
                    pos1 = pos2;
                }
            } while (!sorted);
        }
        catch (YException e) {
            assert (false);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new YProgramException(this, e.getMessage());
        }
    }
}

