/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import java.sql.SQLException;
import java.sql.Statement;
import projektY.base.YException;
import projektY.database.YDatabase;
import projektY.database.YFKException;
import projektY.database.YUniqueException;

public class YSQLDml {
    protected YDatabase database;
    protected Statement stmt;
    protected int rowsAffected;

    public YSQLDml(YDatabase database) {
        this.database = database;
        this.rowsAffected = 0;
    }

    public void execute(String sqlDml) throws YException {
        try {
            if (this.database.ensureConnection(this.stmt == null ? null : this.stmt.getConnection())) {
                this.stmt = null;
            }
            if (this.database.initializedTransaction) {
                this.database.initializedTransaction = false;
                this.database.begin();
            }
            if (this.database.sqlLog) {
                System.out.println(sqlDml + ";");
            }
            if (this.stmt == null) {
                this.stmt = this.database.getConnection().createStatement();
            }
            this.rowsAffected = this.stmt.executeUpdate(sqlDml);
        }
        catch (SQLException e) {
            String msg = "SQL-Fehler " + e.getSQLState() + ":\n" + sqlDml + "\n" + e.getMessage();
            if (this.database.isFkViolation(e)) {
                throw new YFKException(msg);
            }
            if (this.database.isUniqueViolation(e)) {
                throw new YUniqueException(msg);
            }
            throw new YException(msg);
        }
    }

    public int getRowsAffected() {
        return this.rowsAffected;
    }
}

