/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;
import projektY.database.YPosRowListManager;
import projektY.database.YRowObjectList;
import projektY.database.YSession;
import projektY.database.YSubRowList;

public class YSubPosRowList
extends YSubRowList {
    protected YPosRowListManager posRowListManager;
    protected YRowObjectList rowList;

    public YSubPosRowList(YSession session, int maxColumns, YRowObjectList rowList) throws YException {
        super(session, maxColumns, rowList);
        this.rowList = rowList;
        this.posRowListManager = new YPosRowListManager(this);
    }

    public YSubPosRowList(int maxColumns, YRowObjectList rowList) throws YException {
        super(rowList.getSession(), maxColumns, rowList);
        this.rowList = rowList;
        this.posRowListManager = new YPosRowListManager(this);
    }

    protected YColumnDefinition addPosField(String fieldName) throws YException {
        return this.posRowListManager.addPosField(fieldName);
    }

    @Override
    protected void checkFinalized() throws YProgramException {
        super.checkFinalized();
        this.posRowListManager.checkFinalized();
        String masterFkName = this.getMasterFkDefinition().getName();
        this.setOrder(new String[]{masterFkName, this.posRowListManager.posDefinition.getName()});
    }

    @Override
    public void setOrder(String[] order, boolean desc) throws YProgramException {
        if (this.finalized) {
            throw new YProgramException(this, "Die Sortierung bei YSubPosList wird automatisch gesetzt und darf nicht ge\u00e4ndert werden.");
        }
        super.setOrder(order, desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void post() throws YException {
        int rowListRowId = this.getRowListRowId();
        try {
            ++this.changeLevel;
            int nRows = this.rowList.getRowCount();
            for (int iRow = 0; iRow < nRows; ++iRow) {
                this.setSubWindow(this.rowList.getRowId(iRow));
                this.posRowListManager.renumber();
            }
        }
        finally {
            if (rowListRowId > 0) {
                this.setSubWindow(rowListRowId);
            }
            --this.changeLevel;
        }
        super.post();
    }

    @Override
    public int moveUp(int iRow) throws YException {
        this.posRowListManager.exchangePosUp(iRow);
        return super.moveUp(iRow);
    }

    @Override
    public int moveDown(int iRow) throws YException {
        this.posRowListManager.exchangePosDown(iRow);
        return super.moveDown(iRow);
    }

    @Override
    public void revert() throws YException {
        super.revert();
        if (this.hasSubWindow()) {
            int rowListId = this.getRowListRowId();
            int nRows = this.rowList.getRowCount();
            for (int iRow = 0; iRow < nRows; ++iRow) {
                this.setSubWindow(this.rowList.getRowValues(iRow).getRowId());
                this.posRowListManager.reSort();
            }
            this.setSubWindow(rowListId);
        }
    }
}

