/*
 * Decompiled with CFR 0.152.
 */
package projektY.database.jLibY;

import java.util.Vector;
import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;
import projektY.database.YDatabaseData;
import projektY.database.YFieldValue;
import projektY.database.YNullValueException;
import projektY.database.YRowValues;
import projektY.database.YSession;
import projektY.database.jLibY.YAliasColumnDefinition;
import projektY.database.jLibY.YFkEmbeddedColumnDefinition;
import projektY.database.jLibY.YLinkRowDefinition;
import projektY.database.jLibY.YPostableRowDefinition;
import projektY.database.jLibY.YStandardRowDefinition;

public class YRowForwarder {
    private static boolean DEBUG = true;
    private YSession session;
    private YDatabaseData databaseData;
    private YPostableRowDefinition postableRowDefinition;
    private TableRowDefinition tableRowDefinition;

    private void show(String prefix, TableRowDefinition tableRowDefinition) throws YProgramException {
        if (DEBUG) {
            int nCols = tableRowDefinition.getNColumns();
            String tableName = tableRowDefinition.getTableName();
            for (int iCol = 0; iCol < nCols; ++iCol) {
                TableColumnDefinition tableColumnDefinition = tableRowDefinition.getTableColumnDefinition(iCol);
                String columnName = tableName + "." + tableColumnDefinition.getColumnName() + "(" + tableColumnDefinition.fieldValueIndex + ")";
                if (tableColumnDefinition.isEmbedded()) {
                    System.out.println(prefix + columnName + " -> " + tableColumnDefinition.embedded.rowDefinition.getTableName() + " ");
                    this.show(prefix + " ", tableColumnDefinition.embedded);
                    continue;
                }
                System.out.println(prefix + columnName);
            }
        }
    }

    private void createTableRowDefinition(YPostableRowDefinition rowDefinition) throws YProgramException {
        YColumnDefinition columnDefinition;
        int iCol;
        this.tableRowDefinition = new TableRowDefinition();
        this.tableRowDefinition.rowDefinition = rowDefinition;
        int nCols = rowDefinition.getNColumns();
        for (iCol = 0; iCol < nCols; ++iCol) {
            columnDefinition = rowDefinition.getColumnDefinition(iCol);
            if (columnDefinition.isAlias()) continue;
            this.tableRowDefinition.tableColumnDefinitions.add(new TableColumnDefinition(columnDefinition));
        }
        for (iCol = 0; iCol < nCols; ++iCol) {
            columnDefinition = rowDefinition.getColumnDefinition(iCol);
            if (!columnDefinition.isAlias() || !(columnDefinition instanceof YAliasColumnDefinition)) continue;
            this.tableRowDefinition.addAlias((YAliasColumnDefinition)columnDefinition);
        }
        if (DEBUG) {
            System.out.println("YRowForwarder f\u00fcr " + rowDefinition.getTableName());
            this.show("", this.tableRowDefinition);
        }
        this.tableRowDefinition.checkComplete();
    }

    public YRowForwarder(YDatabaseData databaseData) throws YProgramException {
        this.session = databaseData.getSession();
        this.databaseData = databaseData;
        this.postableRowDefinition = databaseData.getPostableRowDefinition();
        this.createTableRowDefinition(this.postableRowDefinition);
    }

    private int hasVisibleNotNullValues(TableRowDefinition tableRowDefinition, YRowValues rowValues) throws YProgramException {
        int nCols = tableRowDefinition.getNColumns();
        boolean allInvisible = true;
        for (int iCol = 0; iCol < nCols; ++iCol) {
            TableColumnDefinition tableColumnDefinition = tableRowDefinition.getTableColumnDefinition(iCol);
            if (tableColumnDefinition.isEmbedded()) {
                switch (this.hasVisibleNotNullValues(tableColumnDefinition.embedded, rowValues)) {
                    case 0: {
                        allInvisible = false;
                        break;
                    }
                    case 1: {
                        return 1;
                    }
                }
                continue;
            }
            if (!tableColumnDefinition.isVisible()) continue;
            allInvisible = false;
            YFieldValue fieldValue = rowValues.getFieldValue(tableColumnDefinition.fieldValueIndex);
            if (fieldValue.isNull()) continue;
            return 1;
        }
        return allInvisible ? 2 : 0;
    }

    private void deleteRow(TableRowDefinition tableRowDefinition, YFieldValue idFieldValue, YRowValues rowValuesToStore) throws YException {
        int nCols = tableRowDefinition.getNColumns();
        if (idFieldValue.wasNull()) {
            return;
        }
        String sql = "DELETE FROM " + tableRowDefinition.getTableName() + " WHERE " + tableRowDefinition.getIdColumnName() + "=" + idFieldValue.getValue0();
        if (tableRowDefinition.rowDefinition instanceof YLinkRowDefinition) {
            YColumnDefinition lfkDefinition = tableRowDefinition.rowDefinition.getObjDepColumnDefinition();
            sql = sql + " AND " + lfkDefinition.getName() + "=" + rowValuesToStore.getAsInt(lfkDefinition.getName());
        }
        int rowsDeleted = this.databaseData.executeDml(sql);
        if (DEBUG) {
            System.out.println(rowsDeleted + " Zeilen gel\u00f6scht.");
        }
        if (rowsDeleted != 1) {
            // empty if block
        }
        rowValuesToStore.setDeleteMark();
        for (int iCol = 0; iCol < nCols; ++iCol) {
            TableColumnDefinition tableColumnDefinition = tableRowDefinition.getTableColumnDefinition(iCol);
            if (!tableColumnDefinition.isEmbedded() || !tableColumnDefinition.embedded.rowDefinition.isImplicitDependent()) continue;
            this.deleteRow(tableColumnDefinition.embedded, rowValuesToStore.getFieldValue(tableColumnDefinition.fieldValueIndex), rowValuesToStore);
        }
    }

    private int postRow(TableRowDefinition tableRowDefinition, YRowValues rowValuesToStore, YFieldValue idFieldValue, boolean postAllNull) throws YException {
        int id;
        int iCol;
        int nCols = tableRowDefinition.getNColumns();
        boolean allNull = true;
        String[] columnNames = new String[tableRowDefinition.getNColumns()];
        String[] columnValues = new String[tableRowDefinition.getNColumns()];
        int nChanges = 0;
        for (iCol = 0; iCol < nCols; ++iCol) {
            TableColumnDefinition tableColumnDefinition = tableRowDefinition.getTableColumnDefinition(iCol);
            YColumnDefinition columnDefinition = tableColumnDefinition.columnDefinition;
            YFieldValue fieldValue = rowValuesToStore.getFieldValue(tableColumnDefinition.fieldValueIndex);
            if (tableColumnDefinition.isEmbedded()) {
                if (tableColumnDefinition.columnDefinition.isPrimaryKey()) {
                    id = this.postRow(tableColumnDefinition.embedded, rowValuesToStore, fieldValue, true);
                    fieldValue.modifyValue(id);
                    allNull = false;
                } else {
                    int visibility = this.hasVisibleNotNullValues(tableColumnDefinition.embedded, rowValuesToStore);
                    switch (visibility) {
                        case 0: {
                            if (tableColumnDefinition.embedded.rowDefinition.isImplicitDependent()) {
                                this.deleteRow(tableColumnDefinition.embedded, fieldValue, rowValuesToStore);
                            }
                            fieldValue.modifyToNull();
                            break;
                        }
                        case 1: {
                            id = this.postRow(tableColumnDefinition.embedded, rowValuesToStore, fieldValue, false);
                            fieldValue.modifyValue(id);
                            allNull = false;
                            break;
                        }
                        case 2: {
                            allNull &= fieldValue.isNull();
                        }
                    }
                }
            } else if (tableColumnDefinition.isVisible()) {
                allNull &= fieldValue.isNull();
            }
            if (fieldValue == idFieldValue || !fieldValue.hasChanged()) continue;
            columnNames[nChanges] = columnDefinition.getName();
            columnValues[nChanges] = this.databaseData.sqlValue(fieldValue);
            ++nChanges;
        }
        if (allNull && !postAllNull) {
            if (tableRowDefinition.rowDefinition.isImplicitDependent()) {
                this.deleteRow(tableRowDefinition, idFieldValue, rowValuesToStore);
            }
            return 0;
        }
        StringBuffer sql = new StringBuffer(200);
        if (idFieldValue.wasNull()) {
            if (idFieldValue.isNull()) {
                id = this.session.getDatabase().nextId(tableRowDefinition.getTableName());
                if (DEBUG) {
                    System.out.println("nextId(" + tableRowDefinition.getTableName() + ") = " + id);
                }
                idFieldValue.setAutoId(id);
            }
            sql.append("INSERT INTO " + tableRowDefinition.getTableName() + " (");
            sql.append(tableRowDefinition.rowDefinition.getIdColumnDefinition().getName());
            for (iCol = 0; iCol < nChanges; ++iCol) {
                sql.append(", " + columnNames[iCol]);
            }
            sql.append(") VALUES (");
            sql.append(this.databaseData.sqlValue(idFieldValue));
            for (iCol = 0; iCol < nChanges; ++iCol) {
                sql.append(", " + columnValues[iCol]);
            }
            sql.append(")");
        } else {
            if (nChanges == 0) {
                return idFieldValue.getValueAsInt();
            }
            sql.append("UPDATE " + tableRowDefinition.getTableName() + " SET ");
            for (iCol = 0; iCol < nChanges; ++iCol) {
                if (iCol > 0) {
                    sql.append(", ");
                }
                sql.append(columnNames[iCol] + "=" + columnValues[iCol]);
            }
            sql.append(" WHERE " + tableRowDefinition.rowDefinition.getIdColumnDefinition().getName() + "=" + idFieldValue.getValue());
        }
        int rowsAffected = this.databaseData.executeDml(sql.toString());
        if (DEBUG) {
            System.out.println(rowsAffected + " Zeilen eingef\u00fcgt bzw. aktualisiert.");
        }
        if (rowsAffected != 1) {
            // empty if block
        }
        rowValuesToStore.setPostMark();
        return idFieldValue.getValueAsInt();
    }

    private boolean setDefaults(YRowValues rowValuesToStore) throws YException {
        int nCols = this.postableRowDefinition.getNColumns();
        boolean defaultsSet = false;
        for (int iCol = 0; iCol < nCols; ++iCol) {
            YFieldValue fieldValue = rowValuesToStore.getFieldValue(iCol);
            defaultsSet |= fieldValue.setDefaultIfNull();
        }
        return defaultsSet;
    }

    private boolean checkNotNull(String objLabel, TableRowDefinition tableRowDefinition, YRowValues rowValuesToStore) throws YNullValueException, YProgramException {
        int nCols = tableRowDefinition.getNColumns();
        boolean allNull = true;
        for (int iCol = 0; iCol < nCols; ++iCol) {
            TableColumnDefinition tableColumnDefinition = tableRowDefinition.getTableColumnDefinition(iCol);
            YColumnDefinition columnDefinition = tableColumnDefinition.columnDefinition;
            YFieldValue fieldValue = rowValuesToStore.getFieldValue(tableColumnDefinition.fieldValueIndex);
            if (tableColumnDefinition.isEmbedded()) {
                boolean embeddedAllNull = this.checkNotNull(objLabel, tableColumnDefinition.embedded, rowValuesToStore);
                if (columnDefinition.isNotNull() && embeddedAllNull) {
                    throw new YNullValueException(objLabel, this.postableRowDefinition.getLabel(columnDefinition));
                }
                allNull &= embeddedAllNull;
                continue;
            }
            if (fieldValue.isNull()) {
                if (!columnDefinition.isNotNull()) continue;
                throw new YNullValueException(objLabel, this.postableRowDefinition.getLabel(columnDefinition));
            }
            allNull = false;
        }
        return allNull;
    }

    boolean prepareRow(String objLabel, YRowValues rowValuesToStore) throws YException {
        if (!rowValuesToStore.isRowDefinitionEqualTo(this.postableRowDefinition)) {
            throw new YProgramException(this, "Die Zeile hat eine andere Zeilendefinition.");
        }
        boolean changes = false;
        YFieldValue idFieldValue = rowValuesToStore.getFieldValue(this.postableRowDefinition.getIdColumnDefinition().getFieldValueIndex());
        if (idFieldValue.wasNull() && rowValuesToStore.hasVisibleNotNullValues()) {
            changes = this.setDefaults(rowValuesToStore);
            this.checkNotNull(objLabel, this.tableRowDefinition, rowValuesToStore);
        }
        return changes;
    }

    public int postRow(YRowValues rowValuesToStore) throws YException {
        int id;
        if (DEBUG) {
            System.out.println("postRow(" + rowValuesToStore.toString() + ")");
        }
        if (!rowValuesToStore.isRowDefinitionEqualTo(this.postableRowDefinition)) {
            throw new YProgramException(this, "Die Zeile hat eine andere Zeilendefinition.");
        }
        if (this.postableRowDefinition.isExplicitDependent() && rowValuesToStore.getFieldValue(this.postableRowDefinition.objDepColdef).isNull()) {
            throw new YProgramException(this, "postRow() ben\u00f6tigt bei expliziter Abh\u00e4ngigkeit die masterId.");
        }
        if (rowValuesToStore.hasAnyChanged()) {
            if (rowValuesToStore.hasVisibleNotNullValues()) {
                id = this.postRow(this.tableRowDefinition, rowValuesToStore, rowValuesToStore.getPkFieldValue(), false);
            } else {
                this.deleteRow(this.tableRowDefinition, rowValuesToStore.getPkFieldValue(), rowValuesToStore);
                id = 0;
            }
        } else {
            if (DEBUG) {
                System.out.println("Keine \u00c4nderungen");
            }
            id = rowValuesToStore.getAsInt(this.postableRowDefinition.getIdColumnDefinition().getName(), 0);
        }
        return id;
    }

    public int postRow(YRowValues rowValuesToStore, int masterId) throws YException {
        if (!this.postableRowDefinition.isExplicitDependent()) {
            throw new YProgramException(this, "Aufruf von postRow() mit masterId in nicht explizit abh\u00e4ngigem Objekt.");
        }
        rowValuesToStore.getFieldValue(this.postableRowDefinition.objDepColdef).modifyValue(masterId);
        return this.postRow(rowValuesToStore);
    }

    protected class TableRowDefinition {
        YPostableRowDefinition rowDefinition;
        Vector<TableColumnDefinition> tableColumnDefinitions = new Vector(30, 20);

        private TableRowDefinition() {
        }

        private TableRowDefinition(YPostableRowDefinition rowDefinition) throws YProgramException {
            this();
            int nCols = rowDefinition.getNColumns();
            this.rowDefinition = rowDefinition;
            if (DEBUG) {
                System.out.println("Embedded(" + rowDefinition.getTableName() + "):");
            }
            for (int iCol = 0; iCol < nCols; ++iCol) {
                YFkEmbeddedColumnDefinition embeddedColumnDefinition;
                YColumnDefinition columnDefinition = rowDefinition.getColumnDefinition(iCol);
                if (columnDefinition instanceof YFkEmbeddedColumnDefinition && (embeddedColumnDefinition = (YFkEmbeddedColumnDefinition)columnDefinition).isEmbeddingUsed()) {
                    TableColumnDefinition tableColumnDefinition = yRowForwarder.new TableColumnDefinition(columnDefinition);
                    tableColumnDefinition.fieldValueIndex = -1;
                    this.tableColumnDefinitions.add(tableColumnDefinition);
                    continue;
                }
                if (!columnDefinition.isNotNull()) continue;
                TableColumnDefinition tableColumnDefinition = yRowForwarder.new TableColumnDefinition(columnDefinition);
                tableColumnDefinition.fieldValueIndex = -1;
                this.tableColumnDefinitions.add(tableColumnDefinition);
            }
            if (DEBUG) {
                System.out.println("Ende: " + rowDefinition.getTableName());
            }
        }

        private int getNColumns() {
            return this.tableColumnDefinitions.size();
        }

        private TableColumnDefinition getTableColumnDefinition(int iIdx) throws YProgramException {
            try {
                return this.tableColumnDefinitions.get(iIdx);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new YProgramException(this, e.getMessage());
            }
        }

        private TableColumnDefinition getTableColumnDefinition(String name) {
            int nCols = this.tableColumnDefinitions.size();
            for (int iCol = 0; iCol < nCols; ++iCol) {
                TableColumnDefinition tableColumnDefinition = this.tableColumnDefinitions.get(iCol);
                if (!tableColumnDefinition.columnDefinition.getName().equals(name)) continue;
                return tableColumnDefinition;
            }
            return null;
        }

        private void add(TableColumnDefinition newTableColumnDefinition) throws YProgramException {
            String newColumnName = newTableColumnDefinition.getColumnName();
            TableColumnDefinition existingTableColumnDefinition = this.getTableColumnDefinition(newColumnName);
            if (existingTableColumnDefinition == null) {
                this.tableColumnDefinitions.add(newTableColumnDefinition);
                return;
            }
            if (existingTableColumnDefinition.fieldValueIndex == -1) {
                existingTableColumnDefinition.fieldValueIndex = newTableColumnDefinition.fieldValueIndex;
                return;
            }
            throw new YProgramException(this, this.rowDefinition.getTableName() + "." + newColumnName + " ist doppelt.");
        }

        private boolean addAlias(YAliasColumnDefinition aliasColumnDefinition) throws YProgramException {
            YStandardRowDefinition rootRowDefinition = (YStandardRowDefinition)aliasColumnDefinition.getRootRowDefinition();
            for (int iIdx = 0; iIdx < this.tableColumnDefinitions.size(); ++iIdx) {
                TableColumnDefinition tableColumnDefinition = this.tableColumnDefinitions.get(iIdx);
                if (!tableColumnDefinition.isEmbedded()) continue;
                if (tableColumnDefinition.embedded.rowDefinition == rootRowDefinition) {
                    tableColumnDefinition.embedded.add(new TableColumnDefinition(aliasColumnDefinition));
                    return true;
                }
                if (!tableColumnDefinition.embedded.addAlias(aliasColumnDefinition)) continue;
                return true;
            }
            return false;
        }

        private void checkComplete() throws YProgramException {
            int nCols = this.tableColumnDefinitions.size();
            for (int iCol = 0; iCol < nCols; ++iCol) {
                TableColumnDefinition tableColumnDefinition = this.tableColumnDefinitions.get(iCol);
                if (tableColumnDefinition.fieldValueIndex < 0) {
                    throw new YProgramException(this, "Fehlende Aliasdefinition f\u00fcr " + (tableColumnDefinition.columnDefinition.isNotNull() ? "NOT NULL Spalte " : "") + this.rowDefinition.getTableName() + "." + tableColumnDefinition.getColumnName());
                }
                if (!tableColumnDefinition.isEmbedded()) continue;
                tableColumnDefinition.embedded.checkComplete();
            }
        }

        private String getTableName() {
            return this.rowDefinition.getTableName();
        }

        private String getIdColumnName() {
            return this.rowDefinition.getIdColumnDefinition().getName();
        }
    }

    private class TableColumnDefinition {
        YColumnDefinition columnDefinition;
        int fieldValueIndex;
        YAliasColumnDefinition aliasColumnDefinition;
        TableRowDefinition embedded;

        private TableColumnDefinition(YColumnDefinition columnDefinition) throws YProgramException {
            this.fieldValueIndex = columnDefinition.getFieldValueIndex();
            this.columnDefinition = columnDefinition;
            this.aliasColumnDefinition = null;
            if (columnDefinition instanceof YFkEmbeddedColumnDefinition) {
                YFkEmbeddedColumnDefinition embeddedColumnDefinition = (YFkEmbeddedColumnDefinition)columnDefinition;
                if (embeddedColumnDefinition.isEmbeddingUsed()) {
                    YStandardRowDefinition rowDefinition = embeddedColumnDefinition.getEmbeddedRowDefinition();
                    this.embedded = new TableRowDefinition(rowDefinition);
                } else {
                    this.embedded = embeddedColumnDefinition.isPrimaryKey() ? null : null;
                }
            } else if (columnDefinition instanceof YAliasColumnDefinition) {
                this.aliasColumnDefinition = (YAliasColumnDefinition)columnDefinition;
                this.columnDefinition = this.aliasColumnDefinition.getRootDefinition();
                this.embedded = null;
            } else {
                this.embedded = null;
            }
            if (DEBUG) {
                System.out.print("TableColumnDefinition: " + columnDefinition.getName() + "(" + this.fieldValueIndex + ")");
                System.out.println();
            }
        }

        private boolean isVisible() {
            if (this.aliasColumnDefinition == null) {
                return this.columnDefinition.isVisible();
            }
            return this.aliasColumnDefinition.isVisible();
        }

        private boolean isEmbedded() {
            return this.embedded != null;
        }

        private String getColumnName() {
            return this.columnDefinition.getName();
        }
    }
}

