/*
 * Decompiled with CFR 0.152.
 */
package projektY.database;

import projektY.base.YException;
import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;
import projektY.database.YFieldValue;

public class YDBFieldValue
extends YFieldValue {
    private String value0 = "";
    private String value = "";
    private boolean setAsDefault = false;
    private boolean setAsAutoId = false;

    public YDBFieldValue(YColumnDefinition columnDefinition) {
        super(columnDefinition);
    }

    @Override
    boolean isAlias() {
        return this.columnDefinition.isAlias();
    }

    @Override
    boolean isLookUp() {
        return false;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public float getValueAsFloat() throws YException {
        try {
            float asFloat = Float.parseFloat(this.value);
            return asFloat;
        }
        catch (NumberFormatException e) {
            throw new YProgramException(this, "'" + this.value + "' ist kein g\u00fcltiger Gleitkomma-Wert.");
        }
    }

    @Override
    public String getValue0() {
        return this.value0;
    }

    @Override
    void gotValue(String value) {
        this.value0 = value;
        this.value = value;
        this.setAsDefault = false;
        this.setAsAutoId = false;
    }

    @Override
    public void setROValue(String value) throws YException {
        if (!this.columnDefinition.isReadOnly()) {
            throw new YProgramException(this, "Das Feld " + this.columnDefinition.getName() + " ist nicht schreibgesch\u00fctzt.");
        }
        this.value = value == null ? "" : value;
        this.setAsDefault = false;
        this.setAsAutoId = false;
    }

    @Override
    public void gotROValue(String value) throws YException {
        if (!this.columnDefinition.isReadOnly()) {
            throw new YProgramException(this, "Das Feld " + this.columnDefinition.getName() + " ist nicht schreibgesch\u00fctzt.");
        }
        if (value == null) {
            this.value0 = "";
            this.value = "";
        } else {
            this.value0 = value;
            this.value = value;
        }
        this.setAsDefault = false;
        this.setAsAutoId = false;
    }

    @Override
    public void modifyValue(String value) throws YException {
        if (this.columnDefinition.isReadOnly()) {
            throw new YException("Das Feld " + this.columnDefinition.getName() + " ist schreibgesch\u00fctzt.");
        }
        if (this.columnDefinition.isPrimaryKey() && this.value0.length() != 0 && value.length() != 0 && !value.equals(this.value) && !this.value0.equals(value)) {
            throw new YException("Der Wert des Prim\u00e4rschl\u00fcssels kann nicht ge\u00e4ndert werden.");
        }
        this.value = value == null ? "" : value;
        this.setAsDefault = false;
        this.setAsAutoId = false;
    }

    @Override
    boolean setPosted() {
        boolean defaultSet = !this.value.equals(this.value0) && this.setAsDefault;
        this.value0 = this.value;
        this.setAsDefault = false;
        this.setAsAutoId = false;
        return defaultSet;
    }

    @Override
    public void revert() throws YException {
        this.value = this.value0;
        this.setAsDefault = false;
        this.setAsAutoId = false;
    }

    @Override
    public boolean hasChanged() {
        return !this.value.equals(this.value0);
    }

    @Override
    public void setNull() throws YException {
        this.modifyToNull();
    }

    @Override
    public void modifyToNull() throws YException {
        if (this.columnDefinition.isReadOnly()) {
            throw new YException("Das Feld " + this.columnDefinition.getName() + " ist schreibgesch\u00fctzt.");
        }
        this.value = "";
        this.setAsDefault = false;
        this.setAsAutoId = false;
    }

    void setDefault(String dflt) {
        this.value = dflt;
        this.setAsDefault = true;
        this.setAsAutoId = false;
    }

    @Override
    public boolean setDefaultIfNull() throws YException {
        if (this.isNull() && this.wasNull() && this.columnDefinition.getDefault() != null) {
            this.setDefault(this.columnDefinition.getDefault());
            return true;
        }
        return false;
    }

    @Override
    public void setAutoId(int nextId) throws YException {
        this.value = String.valueOf(nextId);
        this.setAsAutoId = true;
        this.setAsDefault = false;
    }

    @Override
    void revertAuto() throws YException {
        if (this.setAsDefault || this.setAsAutoId) {
            this.revert();
        }
    }

    @Override
    void cloneFrom(YFieldValue source) throws YException {
        this.value0 = source.getValue0();
        this.value = source.getValue();
        if (source instanceof YDBFieldValue) {
            this.setAsDefault = ((YDBFieldValue)source).isSetAsDefault();
            this.setAsAutoId = ((YDBFieldValue)source).isSetAsAutoId();
        }
    }

    @Override
    public boolean isNull() {
        return this.value.length() == 0;
    }

    @Override
    public boolean wasNull() {
        return this.value0.length() == 0;
    }

    boolean isSetAsDefault() {
        return this.setAsDefault;
    }

    boolean isSetAsAutoId() {
        return this.setAsAutoId;
    }
}

