/*
 * Decompiled with CFR 0.152.
 */
package projektY.database.jLibY;

import projektY.base.YException;
import projektY.base.YNotFoundException;
import projektY.base.YProgramException;
import projektY.database.YColumnDefinition;
import projektY.database.YDBOChangeEvent;
import projektY.database.YDatabase;
import projektY.database.YDatabaseData;
import projektY.database.YFieldValue;
import projektY.database.YRowDefinition;
import projektY.database.YRowValues;
import projektY.database.YSession;
import projektY.database.jLibY.YAliasColumnDefinition;
import projektY.database.jLibY.YExtensionRowDefinition;
import projektY.database.jLibY.YLinkRowDefinition;
import projektY.database.jLibY.YPostableRowDefinition;
import projektY.database.jLibY.YRowForwarder;
import projektY.database.jLibY.YStandardRowDefinition;

public class YRowObject
extends YDatabaseData {
    private YPostableRowDefinition postableRowDefinition;
    YRowValues rowValues;
    YRowForwarder rowForwarder;
    private int masterId;

    protected void construct() throws YProgramException {
    }

    protected YRowObject(YSession session, YPostableRowDefinition rowDefinition, int masterId) throws YProgramException {
        super(session);
        this.rowDefinition = rowDefinition;
        this.postableRowDefinition = rowDefinition;
        this.masterId = masterId;
        this.rowValues = null;
        this.setTableName(rowDefinition.getTableName());
        this.rowForwarder = null;
        this.construct();
        this.finalizeDefinition();
    }

    protected YRowObject(YSession session, YPostableRowDefinition rowDefinition) throws YProgramException {
        this(session, rowDefinition, 0);
    }

    protected YAliasColumnDefinition addAliasDefinition(String aliasName, YPostableRowDefinition rootRowDefinition, String rootColumnName) throws YProgramException {
        if (this.isFinalized()) {
            throw new YProgramException(this, "Hinzuf\u00fcgen von Alias '" + aliasName + "' nach finalizeDefinition() ist nicht m\u00f6glich.");
        }
        if (rootRowDefinition.objDepColdef == null || rootRowDefinition.objDepColdef.getName().equals(rootColumnName)) {
            // empty if block
        }
        return this.postableRowDefinition.addAliasDefinition(aliasName, rootRowDefinition, rootColumnName);
    }

    protected YAliasColumnDefinition addFkEmbeddedAliasDefinition(String aliasName, String fkName, String rootColumnName) throws YProgramException {
        return this.addAliasDefinition(aliasName, this.getFkEmbeddedRowDefinition(fkName), rootColumnName);
    }

    protected YAliasColumnDefinition addExtensionAliasDefinition(String aliasName, String extensionName, String rootColumnName) throws YProgramException {
        return this.addAliasDefinition(aliasName, this.getExtensionRowDefinition(extensionName), rootColumnName);
    }

    protected YAliasColumnDefinition addExtendedAliasDefinition(String aliasName, String rootTableName, String rootColumnName) throws YProgramException {
        return this.addAliasDefinition(aliasName, this.getExtendedRowDefinition(rootTableName), rootColumnName);
    }

    protected YAliasColumnDefinition addExtendedAliasDefinition(String aliasName, String rootColumnName) throws YProgramException {
        return this.addAliasDefinition(aliasName, this.getExtendedRowDefinition(), rootColumnName);
    }

    public void setMasterId(int masterId) throws YProgramException {
        this.masterId = masterId;
    }

    @Override
    protected void checkFinalized() throws YProgramException {
        super.checkFinalized();
        try {
            this.rowValues = this.postableRowDefinition.createRowValues(0);
            this.rowForwarder = new YRowForwarder(this);
        }
        catch (YException e) {
            throw new YProgramException(this, e.getMessage());
        }
    }

    @Override
    protected String generateSqlSelect() throws YProgramException {
        String sqlSelect = this.postableRowDefinition.createParamSelect();
        this.setParamSelect(sqlSelect);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchThis(int objId, int masterId) throws YException {
        block7: {
            try {
                this.paramSelect.setParamValue("id", String.valueOf(objId));
                if (this.postableRowDefinition instanceof YLinkRowDefinition) {
                    if (masterId == 0) {
                        throw new YProgramException(objId, "Wert des linken Fremdschl\u00fcssels fehlt in " + this.getName());
                    }
                    this.paramSelect.setParamValue("mid", String.valueOf(masterId));
                }
                String sql = this.paramSelect.createSQL(this);
                this.sqlQuery.execute(sql);
                if (this.sqlQuery.next()) {
                    for (int iCol = 0; iCol < this.postableRowDefinition.getNColumns(); ++iCol) {
                        this.getQueryResult_jlY(this.rowValues.getFieldValue(iCol));
                    }
                    break block7;
                }
                throw new YNotFoundException("Das Objekt '" + this.getName() + (masterId == 0 ? "" : ", mid=" + Integer.toString(masterId)) + "', id=" + Integer.toString(objId) + " existiert nicht.");
            }
            finally {
                this.sqlQuery.close();
            }
        }
    }

    protected void fireUpdate() throws YException {
        this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, 0, this.rowValues));
    }

    public void fetch(int objId) throws YException {
        this.fetchThis(objId, this.masterId);
        this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, 0, this.rowValues));
    }

    public void fetch(int objId, int masterId) throws YException {
        this.fetchThis(objId, masterId);
        this.masterId = masterId;
        this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, 0, this.rowValues));
    }

    public YFieldValue getFieldValue(String fieldName) throws YException {
        return this.rowValues.getFieldValue(fieldName);
    }

    public String getAsString(String fieldName) throws YException {
        return this.rowValues.getAsString(fieldName);
    }

    public int getAsInt(String fieldName) throws YException {
        return this.rowValues.getAsInt(fieldName);
    }

    public int getAsInt(String fieldName, int ifNull) throws YException {
        return this.rowValues.getAsInt(fieldName, ifNull);
    }

    public boolean getAsBool(String fieldName) throws YException {
        return this.rowValues.getAsBool(fieldName);
    }

    public boolean getAsBool(String fieldName, boolean ifNull) throws YException {
        return this.rowValues.getAsBool(fieldName, ifNull);
    }

    public float getAsFloat(String fieldName) throws YException {
        YFieldValue fv = this.getFieldValue(fieldName);
        try {
            return this.parseFloat(fv);
        }
        catch (NumberFormatException e) {
            throw new YProgramException(this, "'" + fv.getValue() + "' ist kein g\u00fcltiger Gleitkommawert.");
        }
    }

    public float getAsFloat(String fieldName, float ifNull) throws YException {
        YFieldValue fv = this.getFieldValue(fieldName);
        if (fv.isNull()) {
            return ifNull;
        }
        try {
            return this.parseFloat(fv);
        }
        catch (NumberFormatException e) {
            throw new YProgramException(this, "'" + fv.getValue() + "' ist kein g\u00fcltiger Gleitkommawert.");
        }
    }

    protected YPostableRowDefinition getFkEmbeddedRowDefinition(String fkFieldName) throws YProgramException {
        return this.postableRowDefinition.getFkEmbeddedDefinition(fkFieldName).getEmbeddedRowDefinition();
    }

    protected YExtensionRowDefinition getExtensionRowDefinition(String extensionName) throws YProgramException {
        return this.getStandardRowDefinition().getExtension(extensionName).getRowDefinition();
    }

    protected YStandardRowDefinition getExtendedRowDefinition() throws YProgramException {
        if (this.postableRowDefinition instanceof YExtensionRowDefinition) {
            return ((YExtensionRowDefinition)this.postableRowDefinition).getExtendedRowDefinition();
        }
        if (this.postableRowDefinition instanceof YLinkRowDefinition) {
            return ((YLinkRowDefinition)this.postableRowDefinition).getRFkDefinition().getEmbeddedRowDefinition();
        }
        throw new YProgramException(this, this.postableRowDefinition.getTableName() + " ist keine Erweiterung");
    }

    protected YStandardRowDefinition getExtendedRowDefinition(String tableName) throws YProgramException {
        YStandardRowDefinition extendedRowDefinition = this.getStandardRowDefinition();
        do {
            if (!(extendedRowDefinition = ((YExtensionRowDefinition)extendedRowDefinition).getExtendedRowDefinition()).getTableName().equals(tableName)) continue;
            return extendedRowDefinition;
        } while (extendedRowDefinition instanceof YExtensionRowDefinition);
        throw new YProgramException(this, tableName + " geh\u00f6rt nicht zu den erweiterten Tabellen dieser Erweiterung.");
    }

    protected YColumnDefinition getObjDepColumnDefinition() throws YProgramException {
        YColumnDefinition objDepColdef = this.postableRowDefinition.getObjDepColumnDefinition();
        if (objDepColdef == null) {
            throw new YProgramException(this, this.postableRowDefinition.getTableName() + " besitzt keine Abh\u00e4ngigkeistdefinition.");
        }
        return objDepColdef;
    }

    @Override
    public YPostableRowDefinition getPostableRowDefinition() throws YProgramException {
        return this.postableRowDefinition;
    }

    @Override
    public YRowDefinition getRowDefinition() {
        return this.postableRowDefinition;
    }

    public YStandardRowDefinition getStandardRowDefinition() throws YProgramException {
        try {
            return (YStandardRowDefinition)this.postableRowDefinition;
        }
        catch (ClassCastException e) {
            throw new YProgramException(this, "Das Zeilenobjekt basiert auf keiner Standardtabelle.");
        }
    }

    @Override
    public YColumnDefinition getColumnDefinition(String columnName) throws YProgramException {
        return this.postableRowDefinition.getColumnDefinition(columnName);
    }

    public YRowValues getRowValues() throws YProgramException {
        if (this.rowValues == null) {
            throw new YProgramException(this, "Aufruf von getRowValues() vor finalizeDefinition()");
        }
        return this.rowValues;
    }

    protected int postThis() throws YException {
        YFieldValue fvMasterId;
        YColumnDefinition objDepColdef = this.postableRowDefinition.getObjDepColumnDefinition();
        if (objDepColdef != null && (fvMasterId = this.getFieldValue(objDepColdef.getName())).isNull()) {
            if (this.masterId == 0) {
                throw new YProgramException(this, "Wert f\u00fcr " + objDepColdef.getName() + " fehlt in " + this.getName());
            }
            return this.rowForwarder.postRow(this.rowValues, this.masterId);
        }
        return this.rowForwarder.postRow(this.rowValues);
    }

    public void post() throws YException {
        try {
            assert (this.isFinalized()) : "Aufruf von post() bei nicht v\u00f6llst\u00e4ndig konstruiertem Objekt.";
        }
        catch (AssertionError e) {
            throw new YProgramException(this, ((Throwable)((Object)e)).toString());
        }
        if (this.rowForwarder == null) {
            throw new YProgramException(this, "Aufruf von post() vor finalizeDefinition()");
        }
        this.requestRowValues(this.rowValues);
        YDatabase database = this.session.getDatabase();
        boolean wasInTransaction = database.isInTransaction();
        boolean changes = !wasInTransaction ? this.rowForwarder.prepareRow(this.getLabel(), this.rowValues) : false;
        try {
            int id;
            if (!database.isInTransaction()) {
                database.startTransaction();
            }
            if ((id = this.postThis()) > 0) {
                // empty if block
            }
            if (!wasInTransaction && database.isInTransaction()) {
                database.commit();
                this.getRowValues().setPosted(true);
                if (changes) {
                    this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, 0, this.rowValues));
                }
            }
        }
        catch (YException e) {
            if (!wasInTransaction && database.isInTransaction()) {
                database.rollback();
                this.rowValues.resetMarks();
            }
            throw e;
        }
    }

    public void clear() throws YException {
        this.rowValues.clear();
        this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, 0, this.rowValues));
    }

    public boolean hasChanged() throws YException {
        this.requestRowValues(this.rowValues);
        return this.rowValues.hasAnyChanged();
    }

    public void revert() throws YException {
        this.rowValues.revert();
        this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, 0, this.rowValues));
    }

    public void modifyToNull() throws YException {
        this.rowValues.modifyToNull();
        this.fireChanged(new YDBOChangeEvent(YDBOChangeEvent.ChangeEventType.UPDATE, 0, this.rowValues));
    }
}

