/*
 * Decompiled with CFR 0.152.
 */
package projektY.utils;

import projektY.base.YException;

public class YDayTime {
    int std;
    int min;
    int sec;

    private void checkTime(int std, int min, int sec) throws YException {
        if (std < 0 || std > 24 || min < 0 || min > 59 || sec < 0 || sec > 59 || std == 24 && (min > 0 || sec > 0)) {
            throw new YException("Ung\u00fcltige Uhrzeit: '" + String.format("%02d:%02d:%02d", std, min, sec) + "'");
        }
    }

    private void checkTime() throws YException {
        this.checkTime(this.std, this.min, this.sec);
    }

    public YDayTime() {
        this.std = 0;
        this.min = 0;
        this.sec = 0;
    }

    public YDayTime(int std, int min, int sec) throws YException {
        this.std = std;
        this.min = min;
        this.sec = sec;
        this.checkTime();
    }

    public YDayTime(String uhrzeit) throws YException {
        String[] stdMinSec = uhrzeit.split(":", 4);
        if (stdMinSec.length < 1 || stdMinSec.length > 3) {
            throw new YException("Ung\u00fcltige Uhrzeit: '" + uhrzeit + "'");
        }
        try {
            this.std = Integer.parseInt(stdMinSec[0]);
            this.min = stdMinSec.length > 1 ? Integer.parseInt(stdMinSec[1]) : 0;
            this.sec = stdMinSec.length > 2 ? Integer.parseInt(stdMinSec[2]) : 0;
        }
        catch (NumberFormatException e) {
            throw new YException("Ung\u00fcltige Uhrzeit: '" + uhrzeit + "'");
        }
        this.checkTime();
    }

    public void setDayTime(int std, int min, int sec) throws YException {
        this.checkTime(std, min, sec);
        this.std = std;
        this.min = min;
        this.sec = sec;
    }

    public void setDayTime(String uhrzeit) throws YException {
        int sec;
        int min;
        int std;
        String[] stdMinSec = uhrzeit.split(":", 4);
        if (stdMinSec.length < 1 || stdMinSec.length > 3) {
            throw new YException("Ung\u00fcltige Uhrzeit: '" + uhrzeit + "'");
        }
        try {
            std = Integer.parseInt(stdMinSec[0]);
            min = stdMinSec.length > 1 ? Integer.parseInt(stdMinSec[1]) : 0;
            sec = stdMinSec.length > 2 ? Integer.parseInt(stdMinSec[2]) : 0;
        }
        catch (NumberFormatException e) {
            throw new YException("Ung\u00fcltige Uhrzeit: '" + uhrzeit + "'");
        }
        this.setDayTime(std, min, sec);
    }

    public YDayTime clone() {
        YDayTime dayTime2 = new YDayTime();
        dayTime2.std = this.std;
        dayTime2.min = this.min;
        dayTime2.sec = this.sec;
        return dayTime2;
    }

    public String toString() {
        return String.format("%02d:%02d", this.std, this.min);
    }

    public int getStd() {
        return this.std;
    }

    public int getMin() {
        return this.min;
    }

    public int getSec() {
        return this.sec;
    }

    public int compare(YDayTime dayTime2) {
        if (this.std > dayTime2.std) {
            return 1;
        }
        if (this.std < dayTime2.std) {
            return -1;
        }
        if (this.min > dayTime2.min) {
            return 1;
        }
        if (this.min < dayTime2.min) {
            return -1;
        }
        if (this.sec > dayTime2.sec) {
            return 1;
        }
        if (this.sec < dayTime2.sec) {
            return -1;
        }
        return 0;
    }

    public boolean isGt(YDayTime dayTime2) {
        return this.compare(dayTime2) > 0;
    }

    public boolean isGe(YDayTime dayTime2) {
        return this.compare(dayTime2) >= 0;
    }

    public boolean sub(YDayTime dayTime2) {
        int uebertrag;
        if (this.sec >= dayTime2.sec) {
            uebertrag = 0;
        } else {
            this.sec += 60;
            uebertrag = 1;
        }
        this.sec -= dayTime2.sec;
        if (this.min >= dayTime2.min + uebertrag) {
            this.min -= dayTime2.min + uebertrag;
            uebertrag = 0;
        } else {
            this.min += 60;
            this.min -= dayTime2.min + uebertrag;
            uebertrag = 1;
        }
        if (this.std >= dayTime2.std + uebertrag) {
            this.std -= dayTime2.std + uebertrag;
            uebertrag = 0;
        } else {
            this.std += 24;
            this.std -= dayTime2.std + uebertrag;
            uebertrag = 1;
        }
        return uebertrag > 0;
    }

    public YDayTime absDiff(YDayTime dayTime2) {
        YDayTime diffTime;
        int compareResult = this.compare(dayTime2);
        if (compareResult >= 0) {
            diffTime = this.clone();
            if (compareResult > 0) {
                diffTime.sub(dayTime2);
            }
        } else {
            diffTime = dayTime2.clone();
            diffTime.sub(this);
        }
        return diffTime;
    }

    public float absDiffFloat(YDayTime dayTime2) {
        YDayTime diffTime;
        int compareResult = this.compare(dayTime2);
        if (compareResult >= 0) {
            diffTime = this.clone();
            if (compareResult > 0) {
                diffTime.sub(dayTime2);
            }
        } else {
            diffTime = dayTime2.clone();
            diffTime.sub(this);
        }
        float diffTimeFloat = diffTime.std;
        diffTimeFloat += (float)diffTime.min / 60.0f;
        return diffTimeFloat += (float)diffTime.sec / 3600.0f;
    }
}

