/*
 * Decompiled with CFR 0.152.
 */
package popometer.bikeandfit;

import popometer.bikeandfit.MagischesDreieck;
import popometer.bikeandfit.Parameter;
import popometer.math.Polygonzug;

public class Einstellrad {
    private Parameter parameter;
    private double rwRad;
    Polygonzug.Punkt L;
    Polygonzug.Punkt S;
    private double sitzhoehe;
    private double sitzversatz;
    private double lenkerhoehe;
    private double lenkerversatz;

    public Einstellrad(Parameter parameter) {
        this.parameter = parameter;
        this.rwRad = Polygonzug.VektorSumme.degToRad(parameter.rahmenwinkel);
        this.L = new Polygonzug.Punkt();
        this.S = new Polygonzug.Punkt();
    }

    public void set(double sitzhoehe, double sitzversatz, double lenkerhoehe, double lenkerversatz) {
        this.sitzhoehe = sitzhoehe;
        this.sitzversatz = sitzversatz;
        this.lenkerhoehe = lenkerhoehe;
        this.lenkerversatz = lenkerversatz;
        this.S.x = -Math.cos(this.rwRad) * sitzhoehe + sitzversatz;
        this.S.y = Math.sin(this.rwRad) * sitzhoehe;
        this.S.a = Math.sqrt(this.S.x * this.S.x + this.S.y * this.S.y);
        this.L.x = lenkerversatz + (double)this.parameter.abstandLenksaeule;
        this.L.y = lenkerhoehe;
        this.L.a = Math.sqrt(this.L.x * this.L.x + this.L.y * this.L.y);
    }

    public double getRwRad() {
        return this.rwRad;
    }

    public void berechnen(MagischesDreieck magischesDreieck) {
        double dx = -magischesDreieck.K.x;
        double dy = -magischesDreieck.K.y;
        this.S.x = magischesDreieck.S.x + dx;
        this.S.y = magischesDreieck.S.y + dy;
        this.S.a = magischesDreieck.S.abstand(magischesDreieck.K);
        this.L.x = magischesDreieck.L.x + dx;
        this.L.y = magischesDreieck.L.y + dy;
        this.L.a = magischesDreieck.L.abstand(magischesDreieck.K);
        System.out.format("MagDreieckskoordinaten: K(%2.1f,%2.1f) S(%2.1f,%2.1f) L(%2.1f,%2.1f)\n", Float.valueOf(0.0f), Float.valueOf(0.0f), this.S.x, this.S.y, this.L.x, this.L.y);
        System.out.printf("Sattel: x=%2.1f y=%2.1f\n", this.S.x, this.S.y);
        System.out.printf("Lenker: x=%2.1f y=%2.1f\n", this.L.x, this.L.y);
        this.sitzhoehe = this.S.y / Math.sin(this.rwRad);
        double x = -Math.cos(this.rwRad) * this.sitzhoehe - (double)this.parameter.abstandSitzknochenposition;
        this.sitzversatz = x - this.S.x;
        this.lenkerhoehe = this.L.y;
        this.lenkerversatz = this.L.x - (double)this.parameter.abstandLenksaeule;
    }

    public double getSitzhoehe() {
        return this.sitzhoehe;
    }

    public double getSitzversatz() {
        return this.sitzversatz;
    }

    public double getLenkerhoehe() {
        return this.lenkerhoehe;
    }

    public double getLenkerversatz() {
        return this.lenkerversatz;
    }
}

