/*
 * Decompiled with CFR 0.152.
 */
package popometer.bikeandfit;

import popometer.bikeandfit.Einstellrad;
import popometer.bikeandfit.Koerpermasse;
import popometer.bikeandfit.Koerperpunkte;
import popometer.bikeandfit.MagischesDreieck;
import popometer.bikeandfit.Messpunkte;
import popometer.bikeandfit.Parameter;
import popometer.graphics.Koerperpunkt;
import popometer.graphics.Messpunkt;
import popometer.graphics.RectScaler;
import popometer.math.Polygonzug;

public class Koerperberechnung {
    private float pixelProMeter;
    private final Parameter parameter;
    public RectScaler rectScaler;
    public Messpunkte messpunkte;
    public Koerperpunkte koerperpunkte;
    public MagischesDreieck magischesDreieck;
    public Einstellrad einstellrad;
    private Koerpermasse koerpermasse;

    public Koerperberechnung(Parameter parameter) {
        this.parameter = parameter;
        this.rectScaler = new RectScaler();
        this.messpunkte = new Messpunkte(this.rectScaler);
        this.koerperpunkte = new Koerperpunkte(parameter, this.rectScaler);
        this.koerpermasse = new Koerpermasse();
        this.magischesDreieck = new MagischesDreieck(parameter);
        this.einstellrad = new Einstellrad(parameter);
        this.pixelProMeter = -1.0f;
    }

    public boolean kalibrieren() {
        Messpunkt calibStart = this.messpunkte.kalibrierung1;
        Messpunkt calibEnd = this.messpunkte.kalibrierung2;
        assert (calibStart != null && calibEnd != null);
        float dist = calibStart.distanceTo(calibEnd);
        this.pixelProMeter = dist * 100.0f / this.parameter.abstandKalibrierungspunkte;
        return true;
    }

    public void koerperpunkteAbleiten() {
        this.koerperpunkte.ableiten(this.messpunkte, this.pixelProMeter);
    }

    public Koerpermasse berechneKoerpermasse() {
        if (this.pixelProMeter < 0.0f) {
            this.koerpermasse.ua = 0.0f;
            this.koerpermasse.oa = 0.0f;
            this.koerpermasse.ok = 0.0f;
            this.koerpermasse.os = 0.0f;
            this.koerpermasse.usf = 0.0f;
        } else {
            float k = 100.0f / this.pixelProMeter;
            Koerperpunkt[] aKP = this.koerperpunkte.koerperpunkte;
            this.koerpermasse.ua = aKP[Koerperpunkte.NAMEN.HAND.getIndex()].distanceTo(aKP[Koerperpunkte.NAMEN.ARM.getIndex()]) * k;
            this.koerpermasse.oa = aKP[Koerperpunkte.NAMEN.ARM.getIndex()].distanceTo(aKP[Koerperpunkte.NAMEN.SCHULTER.getIndex()]) * k;
            this.koerpermasse.ok = aKP[Koerperpunkte.NAMEN.SCHULTER.getIndex()].distanceTo(aKP[Koerperpunkte.NAMEN.HUEFTE.getIndex()]) * k;
            this.koerpermasse.os = aKP[Koerperpunkte.NAMEN.HUEFTE.getIndex()].distanceTo(aKP[Koerperpunkte.NAMEN.KNIE.getIndex()]) * k;
            this.koerpermasse.usf = aKP[Koerperpunkte.NAMEN.KNIE.getIndex()].distanceTo(aKP[Koerperpunkte.NAMEN.FUSS.getIndex()]) * k;
            this.koerpermasse.vxHK = (float)Math.abs(aKP[Koerperpunkte.NAMEN.HUEFTE.getIndex()].x - aKP[Koerperpunkte.NAMEN.SITZ.getIndex()].x) * k;
            this.koerpermasse.vyHK = (float)Math.abs(aKP[Koerperpunkte.NAMEN.HUEFTE.getIndex()].y - aKP[Koerperpunkte.NAMEN.SITZ.getIndex()].y) * k;
            Polygonzug.Punkt K1 = new Polygonzug.Punkt();
            Polygonzug.Punkt K2 = new Polygonzug.Punkt();
            Polygonzug.Punkt S = new Polygonzug.Punkt();
            Polygonzug.Punkt H = new Polygonzug.Punkt();
            K1.x = this.messpunkte.kalibrierung1.x;
            K1.y = this.messpunkte.kalibrierung1.y;
            K2.x = this.messpunkte.kalibrierung2.x;
            K2.y = this.messpunkte.kalibrierung2.y;
            S.x = this.messpunkte.schulter.x;
            S.y = this.messpunkte.schulter.y;
            H.x = this.messpunkte.huefte.x;
            H.y = this.messpunkte.huefte.y;
            K2.x -= K1.x;
            K2.y -= K1.y;
            S.x -= K1.x;
            S.y -= K1.y;
            H.x -= K1.x;
            H.y -= K1.y;
            double phid = Math.asin(K2.y / Math.sqrt(K2.x * K2.x + K2.y * K2.y));
            double a = Math.sqrt(S.x * S.x + S.y * S.y);
            double phi = Math.asin(S.y / Math.sqrt(S.x * S.x + S.y * S.y));
            S.x = a * Math.cos(phi -= phid) * Math.signum(phi);
            S.y = a * Math.sin(phi);
            a = Math.sqrt(H.x * H.x + H.y * H.y);
            phi = Math.asin(H.y / Math.sqrt(H.x * H.x + H.y * H.y));
            H.x = a * Math.cos(phi -= phid) * Math.signum(phi);
            H.y = a * Math.sin(phi);
            S.x -= H.x;
            S.y -= H.y;
            phi = Math.asin(S.y / Math.sqrt(S.x * S.x + S.y * S.y));
            this.koerpermasse.rwhs = (float)(180.0 - Math.abs(Polygonzug.VektorSumme.radToDeg(phi)));
        }
        return this.koerpermasse;
    }
}

